/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.core.dto.demandas.CreateDemandaDTO;
import br.gov.antt.sgctt.core.dto.demandas.EncerrarDemandaDTO;
import br.gov.antt.sgctt.core.dto.demandas.FindDemandasDTO;
import br.gov.antt.sgctt.core.dto.demandas.ReabrirDemandaDTO;
import br.gov.antt.sgctt.core.dto.demandas.UpdateDemandaDTO;
import br.gov.antt.sgctt.core.dto.demandas.area.CreateDemandaAreaDTO;
import br.gov.antt.sgctt.core.dto.demandas.area.UpdateDemandaAreaDTO;
import br.gov.antt.sgctt.core.dto.demandas.faleConosco.SaveFaleConoscoDTO;
import br.gov.antt.sgctt.core.dto.demandas.historico.CreateDemandaHistoricoDTO;
import br.gov.antt.sgctt.core.dto.demandas.historico.SaveHistoricoRespostaDTO;
import br.gov.antt.sgctt.core.dto.demandas.historico.UpdatePesoDTO;
import br.gov.antt.sgctt.core.dto.demandas.indice.CreateIndiceDTO;
import br.gov.antt.sgctt.core.dto.demandas.indice.UpdateIndiceDTO;
import br.gov.antt.sgctt.core.dto.demandas.objetivo.SaveObjetivoDTO;
import br.gov.antt.sgctt.core.dto.demandas.perguntaFrequente.CreatePerguntaFrequenteDTO;
import br.gov.antt.sgctt.core.dto.demandas.perguntaFrequente.UpdatePerguntaFrequenteDTO;
import br.gov.antt.sgctt.core.dto.demandas.peso.CreatePesoDTO;
import br.gov.antt.sgctt.core.dto.demandas.responsavel.SaveDemandaResponsavelDTO;
import br.gov.antt.sgctt.core.dto.demandas.status.SaveStatusDTO;
import br.gov.antt.sgctt.core.dto.demandas.tipo.CreateDemandaTipoDTO;
import br.gov.antt.sgctt.core.dto.demandas.tipo.UpdateDemandaTipoDTO;
import br.gov.antt.sgctt.demandas.Demanda;
import br.gov.antt.sgctt.demandas.DemandaAnexo;
import br.gov.antt.sgctt.demandas.DemandaArea;
import br.gov.antt.sgctt.demandas.DemandaControleTerceiro;
import br.gov.antt.sgctt.demandas.DemandaHistorico;
import br.gov.antt.sgctt.demandas.DemandaObjetivo;
import br.gov.antt.sgctt.demandas.DemandaResponsavel;
import br.gov.antt.sgctt.demandas.DemandaStatus;
import br.gov.antt.sgctt.demandas.DemandaTipo;
import br.gov.antt.sgctt.demandas.FaleConosco;
import br.gov.antt.sgctt.demandas.IndicePriorizacao;
import br.gov.antt.sgctt.demandas.PerguntaFrequente;
import br.gov.antt.sgctt.demandas.PesoPriorizacao;
import br.gov.antt.sgctt.services.DemandaService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="demandas v1", description="REST Services para Demandas v1")
@Validated
@RestController
@RequestMapping(value={"/api/v1/demandas"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\rH\u0017J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J1\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0012\u001a\u00020\u00192\u0010\b\u0001\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0017\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010 \u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J8\u0010!\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J8\u0010#\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J8\u0010%\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J=\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\n\b\u0001\u0010)\u001a\u0004\u0018\u00010*2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010+J:\u0010,\u001a\u00020(2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020-2\n\b\u0001\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J0\u0010/\u001a\u00020(2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u00100\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u000201H\u0017J0\u00102\u001a\u00020\u001f2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u00100\u001a\u00020\r2\b\b\u0001\u00103\u001a\u00020\rH\u0017J\u0012\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\rH\u0017J?\u00107\u001a\b\u0012\u0004\u0012\u0002050\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010;J\u001a\u0010<\u001a\u0002052\b\b\u0001\u0010\u0012\u001a\u00020=2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010>\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020=2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010?\u001a\u00020\u001f2\b\b\u0001\u00106\u001a\u00020\rH\u0017J.\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010B\u001a\u00020A2\b\b\u0001\u0010C\u001a\u00020\rH\u0017J\u001a\u0010D\u001a\u00020A2\b\b\u0001\u0010\u0012\u001a\u00020E2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010F\u001a\u00020A2\b\b\u0001\u0010G\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020H2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010I\u001a\u00020\u001f2\b\b\u0001\u0010C\u001a\u00020\rH\u0017J.\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u0010L\u001a\u0004\u0018\u0001092\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010M\u001a\u00020K2\b\b\u0001\u0010N\u001a\u00020\rH\u0017J\u001a\u0010O\u001a\u00020K2\b\b\u0001\u0010\u0012\u001a\u00020P2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010Q\u001a\u00020K2\b\b\u0001\u0010R\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020S2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010T\u001a\u00020\u001f2\b\b\u0001\u0010N\u001a\u00020\rH\u0017J,\u0010U\u001a\b\u0012\u0004\u0012\u00020V0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010W\u001a\u00020V2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010 \u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020X2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J.\u0010Y\u001a\u00020\u001f2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010Z\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u001e\u0010[\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\r0\\2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J.\u0010]\u001a\b\u0012\u0004\u0012\u00020^0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010_\u001a\u00020^2\b\b\u0001\u0010`\u001a\u00020\rH\u0017J\u001a\u0010a\u001a\u00020^2\b\b\u0001\u0010\u0012\u001a\u00020b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010c\u001a\u00020^2\b\b\u0001\u0010`\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010e\u001a\u00020\u001f2\b\b\u0001\u0010`\u001a\u00020\rH\u0017J.\u0010f\u001a\b\u0012\u0004\u0012\u00020g0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010h\u001a\u00020g2\b\b\u0001\u0010i\u001a\u00020\rH\u0017J\u001a\u0010j\u001a\u00020g2\b\b\u0001\u0010\u0012\u001a\u00020k2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010l\u001a\u00020g2\b\b\u0001\u0010m\u001a\u00020\r2\b\b\u0001\u0010\u0012\u001a\u00020k2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010n\u001a\u00020\u001f2\b\b\u0001\u0010i\u001a\u00020\rH\u0017J7\u0010o\u001a\u00020p2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010q\u001a\u00020\r2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0002\u0010rJ,\u0010s\u001a\b\u0012\u0004\u0012\u00020p0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J8\u0010t\u001a\u00020p2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010u\u001a\u0002092\b\b\u0001\u0010.\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J?\u0010v\u001a\u00020\u001f2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010q\u001a\u00020\r2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010wJ8\u0010x\u001a\b\u0012\u0004\u0012\u00020p0\u00112\u000e\b\u0001\u0010y\u001a\b\u0012\u0004\u0012\u00020\r0z2\u000e\b\u0001\u0010{\u001a\b\u0012\u0004\u0012\u0002090z2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J,\u0010|\u001a\b\u0012\u0004\u0012\u00020}0\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010~\u001a\u00020}2\b\b\u0001\u0010\u007f\u001a\u00020}2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0015\u0010\u0080\u0001\u001a\u00030\u0081\u00012\t\b\u0001\u0010\u0082\u0001\u001a\u00020\rH\u0017JC\u0010\u0083\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\u000b\b\u0001\u0010\u0084\u0001\u001a\u0004\u0018\u00010*2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0003\u0010\u0085\u0001J\u001d\u0010\u0086\u0001\u001a\u00030\u0081\u00012\t\b\u0001\u0010\u0012\u001a\u00030\u0087\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J(\u0010\u0088\u0001\u001a\u00030\u0081\u00012\t\b\u0001\u0010\u0082\u0001\u001a\u00020\r2\t\b\u0001\u0010\u0012\u001a\u00030\u0087\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0014\u0010\u0089\u0001\u001a\u00020\u001f2\t\b\u0001\u0010\u0082\u0001\u001a\u00020\rH\u0017J@\u0010\u008a\u0001\u001a\t\u0012\u0005\u0012\u00030\u008b\u00010\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00106\u001a\u0004\u0018\u00010\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0003\u0010\u008c\u0001J\u0015\u0010\u008d\u0001\u001a\u00030\u008b\u00012\t\b\u0001\u0010\u008e\u0001\u001a\u00020\rH\u0017J\u001d\u0010\u008f\u0001\u001a\u00030\u008b\u00012\t\b\u0001\u0010\u0012\u001a\u00030\u0090\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J(\u0010\u0091\u0001\u001a\u00030\u008b\u00012\t\b\u0001\u0010\u0092\u0001\u001a\u00020\r2\t\b\u0001\u0010\u0012\u001a\u00030\u0093\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0014\u0010\u0094\u0001\u001a\u00020\u001f2\t\b\u0001\u0010\u008e\u0001\u001a\u00020\rH\u0017J.\u0010\u0095\u0001\u001a\t\u0012\u0005\u0012\u00030\u0096\u00010\u00112\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0015\u0010\u0097\u0001\u001a\u00030\u0096\u00012\t\b\u0001\u0010\u0098\u0001\u001a\u00020\rH\u0017J\u001d\u0010\u0099\u0001\u001a\u00030\u0096\u00012\t\b\u0001\u0010\u0012\u001a\u00030\u009a\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J(\u0010\u009b\u0001\u001a\u00030\u0096\u00012\t\b\u0001\u0010\u009c\u0001\u001a\u00020\r2\t\b\u0001\u0010\u0012\u001a\u00030\u009d\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0014\u0010\u009e\u0001\u001a\u00020\u001f2\t\b\u0001\u0010\u0098\u0001\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009f\u0001"}, d2={"Lbr/gov/antt/sgctt/apis/DemandasRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "demandasService", "Lbr/gov/antt/sgctt/services/DemandaService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/DemandaService;)V", "LOGGER", "Lorg/slf4j/Logger;", "getDemandaById", "Lbr/gov/antt/sgctt/demandas/Demanda;", "idEmpresa", "", "idDemanda", "versao", "findDemandas", "Lorg/springframework/data/domain/Page;", "dto", "Lbr/gov/antt/sgctt/core/dto/demandas/FindDemandasDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "createDemanda", "request", "Ljakarta/servlet/http/HttpServletRequest;", "Lbr/gov/antt/sgctt/core/dto/demandas/CreateDemandaDTO;", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljakarta/servlet/http/HttpServletRequest;Lbr/gov/antt/sgctt/core/dto/demandas/CreateDemandaDTO;[Lorg/springframework/web/multipart/MultipartFile;)Lbr/gov/antt/sgctt/demandas/Demanda;", "deleteDemanda", "", "demandaId", "updateDemanda", "Lbr/gov/antt/sgctt/core/dto/demandas/UpdateDemandaDTO;", "encerrarDemanda", "Lbr/gov/antt/sgctt/core/dto/demandas/EncerrarDemandaDTO;", "reabrirDemanda", "Lbr/gov/antt/sgctt/core/dto/demandas/ReabrirDemandaDTO;", "findHistoricosByDemanda", "Lbr/gov/antt/sgctt/demandas/DemandaHistorico;", "acessoHistorico", "", "(IILjava/lang/Character;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "createHistorico", "Lbr/gov/antt/sgctt/core/dto/demandas/historico/CreateDemandaHistoricoDTO;", "file", "saveHistoricoResposta", "seqHistorico", "Lbr/gov/antt/sgctt/core/dto/demandas/historico/SaveHistoricoRespostaDTO;", "removeAnexoHistorico", "idAnexo", "findObjetivoById", "Lbr/gov/antt/sgctt/demandas/DemandaObjetivo;", "idObjetivo", "findObjetivos", "search", "", "grupo", "(ILjava/lang/String;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "createObjetivo", "Lbr/gov/antt/sgctt/core/dto/demandas/objetivo/SaveObjetivoDTO;", "updateObjetivo", "deleteObjetivo", "findIndices", "Lbr/gov/antt/sgctt/demandas/IndicePriorizacao;", "findIndiceById", "idIndice", "createIndice", "Lbr/gov/antt/sgctt/core/dto/demandas/indice/CreateIndiceDTO;", "updateIndice", "indiceId", "Lbr/gov/antt/sgctt/core/dto/demandas/indice/UpdateIndiceDTO;", "deleteIndice", "findPesos", "Lbr/gov/antt/sgctt/demandas/PesoPriorizacao;", "tipo", "findPesoById", "idPeso", "createPeso", "Lbr/gov/antt/sgctt/core/dto/demandas/peso/CreatePesoDTO;", "updatePeso", "pesoId", "Lbr/gov/antt/sgctt/core/dto/demandas/historico/UpdatePesoDTO;", "deletePeso", "findResponsaveisByDemanda", "Lbr/gov/antt/sgctt/demandas/DemandaResponsavel;", "createDemandaResponsavel", "Lbr/gov/antt/sgctt/core/dto/demandas/responsavel/SaveDemandaResponsavelDTO;", "deleteDemandaResponsavelById", "sequencia", "findResumoDemandasByStatus", "", "findPerguntasFrequentes", "Lbr/gov/antt/sgctt/demandas/PerguntaFrequente;", "findPerguntaFrequenteById", "perguntaId", "createPerguntaFrequente", "Lbr/gov/antt/sgctt/core/dto/demandas/perguntaFrequente/CreatePerguntaFrequenteDTO;", "updatePerguntaFrequente", "Lbr/gov/antt/sgctt/core/dto/demandas/perguntaFrequente/UpdatePerguntaFrequenteDTO;", "deletePerguntaFrequente", "findFaleConosco", "Lbr/gov/antt/sgctt/demandas/FaleConosco;", "findFaleConoscoById", "idFaleConosco", "createFaleConosco", "Lbr/gov/antt/sgctt/core/dto/demandas/faleConosco/SaveFaleConoscoDTO;", "updateFaleConosco", "faleConoscoId", "deleteFaleConosco", "findAnexoById", "Lbr/gov/antt/sgctt/demandas/DemandaAnexo;", "seqAnexo", "(IIILjava/lang/Integer;)Lbr/gov/antt/sgctt/demandas/DemandaAnexo;", "findAnexosByDemandaId", "createAnexo", "tipoAnexo", "deleteAnexo", "(IIILjava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)V", "findAnexosByTipo", "empresas", "", "tiposAnexo", "findControlesTerceirosByDemandaId", "Lbr/gov/antt/sgctt/demandas/DemandaControleTerceiro;", "saveControleTerceiro", "controle", "findStatusById", "Lbr/gov/antt/sgctt/demandas/DemandaStatus;", "id", "findStatus", "status", "(ILjava/lang/String;Ljava/lang/Character;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "createStatus", "Lbr/gov/antt/sgctt/core/dto/demandas/status/SaveStatusDTO;", "updateStatus", "deleteStatus", "findTipos", "Lbr/gov/antt/sgctt/demandas/DemandaTipo;", "(ILjava/lang/Integer;Ljava/lang/String;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findTipoById", "tipoId", "createTipo", "Lbr/gov/antt/sgctt/core/dto/demandas/tipo/CreateDemandaTipoDTO;", "updateTipo", "idTipo", "Lbr/gov/antt/sgctt/core/dto/demandas/tipo/UpdateDemandaTipoDTO;", "deleteTipoById", "findAreas", "Lbr/gov/antt/sgctt/demandas/DemandaArea;", "findAreaById", "areaId", "createArea", "Lbr/gov/antt/sgctt/core/dto/demandas/area/CreateDemandaAreaDTO;", "updateArea", "idArea", "Lbr/gov/antt/sgctt/core/dto/demandas/area/UpdateDemandaAreaDTO;", "deleteAreaById", "server"})
public class DemandasRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final DemandaService demandasService;
    @NotNull
    private final Logger LOGGER;

    public DemandasRestServices(@NotNull SegurancaService segurancaService, @NotNull DemandaService demandasService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)demandasService, (String)"demandasService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.demandasService = demandasService;
        Logger logger = LoggerFactory.getLogger(DemandasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @Operation(summary="Busca uma demanda pelo ID", description="Retorna uma demanda espec\u00edfica baseada no ID da empresa, ID da demanda e vers\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Demanda encontrada com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/{versao}"})
    @NotNull
    public Demanda getDemandaById(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Vers\u00e3o da demanda") @PathVariable(value="versao") int versao) {
        Demanda demanda = this.demandasService.getDemandaById(idEmpresa, idDemanda, Integer.valueOf(versao));
        Intrinsics.checkNotNullExpressionValue((Object)demanda, (String)"getDemandaById(...)");
        return demanda;
    }

    @Operation(summary="Lista todas as demandas", description="Retorna uma lista paginada de todas as demandas")
    @ApiResponses(value={@ApiResponse(description="Lista de demandas retornada com sucesso", responseCode="200")})
    @GetMapping
    @NotNull
    public Page<Demanda> findDemandas(@Parameter(description="Par\u00e2metros de filtro") @ParameterObject @Valid @NotNull FindDemandasDTO dto, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findDemandas(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDemandas(...)");
        return page;
    }

    @Operation(summary="Cria uma nova demanda", description="Cria uma nova demanda com os dados fornecidos e arquivos anexados")
    @ApiResponses(value={@ApiResponse(description="Demanda criada com sucesso", responseCode="201"), @ApiResponse(description="Recurso relacionado n\u00e3o encontrado", responseCode="404")})
    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public Demanda createDemanda(@NotNull HttpServletRequest request, @RequestBody(description="Dados da demanda", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=CreateDemandaDTO.class))}, required=true) @Parameter(description="Dados da demanda") @Valid @RequestPart(value="dto") @NotNull CreateDemandaDTO dto, @Parameter(description="Arquivos anexados") @RequestPart(value="files", required=false) @Nullable MultipartFile[] files) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Demanda demanda = this.demandasService.createDemanda(dto, files, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)demanda, (String)"createDemanda(...)");
        return demanda;
    }

    @Operation(summary="Exclui uma demanda", description="Remove uma demanda espec\u00edfica e todas suas vers\u00f5es")
    @ApiResponses(value={@ApiResponse(description="Demanda exclu\u00edda com sucesso", responseCode="204"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/{idEmpresa}/{demandaId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="demandaId") int demandaId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.demandasService.deleteAllDemandas(idEmpresa, demandaId, ((Number)n).intValue());
    }

    @Operation(summary="Atualiza uma demanda existente", description="Modifica os dados de uma demanda espec\u00edfica baseada na vers\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Demanda atualizada com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PutMapping(value={"/{idEmpresa}/{demandaId}/{versao}"})
    @NotNull
    public Demanda updateDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="demandaId") int demandaId, @Parameter(description="Vers\u00e3o da demanda") @PathVariable(value="versao") int versao, @Parameter(description="Dados atualizados da demanda") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull UpdateDemandaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Demanda demanda = this.demandasService.updateDemanda(idEmpresa, demandaId, versao, dto, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)demanda, (String)"updateDemanda(...)");
        return demanda;
    }

    @Operation(summary="Encerra uma demanda existente", description="Encerra uma demanda existente com o status informado")
    @ApiResponses(value={@ApiResponse(description="Demanda encerrada com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PostMapping(value={"/{idEmpresa}/{demandaId}/{versao}/encerrar"})
    @NotNull
    public Demanda encerrarDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="demandaId") int demandaId, @Parameter(description="Vers\u00e3o da demanda") @PathVariable(value="versao") int versao, @Parameter(description="Dados para o encerramento") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull EncerrarDemandaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Demanda demanda = this.demandasService.encerrarDemanda(idEmpresa, demandaId, versao, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demanda, (String)"encerrarDemanda(...)");
        return demanda;
    }

    @Operation(summary="Re-abre uma demanda existente", description="Re-abre uma demanda existente com o status informado")
    @ApiResponses(value={@ApiResponse(description="Demanda re-aberta com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PostMapping(value={"/{idEmpresa}/{demandaId}/{versao}/reabrir"})
    @NotNull
    public Demanda reabrirDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="demandaId") int demandaId, @Parameter(description="Vers\u00e3o da demanda") @PathVariable(value="versao") int versao, @Parameter(description="Dados para o re-abertura") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull ReabrirDemandaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Demanda demanda = this.demandasService.reabrirDemanda(idEmpresa, demandaId, versao, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demanda, (String)"reabrirDemanda(...)");
        return demanda;
    }

    @Operation(summary="Lista hist\u00f3ricos de uma demanda", description="Retorna uma lista paginada de hist\u00f3ricos associados a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos retornados com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/historicos"})
    @NotNull
    public Page<DemandaHistorico> findHistoricosByDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Tipo de acesso ao hist\u00f3rico") @RequestParam(value="acessoHistorico", required=false) @Nullable Character acessoHistorico, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findHistoricosByDemanda(idDemanda, idEmpresa, acessoHistorico, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findHistoricosByDemanda(...)");
        return page;
    }

    @Operation(summary="Cria um novo hist\u00f3rico para uma demanda", description="Adiciona um novo registro de hist\u00f3rico a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico criado com sucesso", responseCode="201"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PostMapping(value={"/{idEmpresa}/{idDemanda}/historicos"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public DemandaHistorico createHistorico(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Dados do hist\u00f3rico") @Valid @RequestPart(value="historico") @NotNull CreateDemandaHistoricoDTO dto, @Parameter(description="Arquivo anexado (opcional)") @RequestPart(value="file", required=false) @Nullable MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = idEmpresa;
        Integer n2 = idDemanda;
        Integer n3 = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getId(...)");
        DemandaHistorico demandaHistorico = this.demandasService.createHistorico(n, n2, dto, file, ((Number)n3).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaHistorico, (String)"createHistorico(...)");
        return demandaHistorico;
    }

    @Operation(summary="Salva a resposta para um hist\u00f3rico", description="Adiciona ou atualiza a resposta para um registro de hist\u00f3rico espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Resposta salva com sucesso", responseCode="200"), @ApiResponse(description="Hist\u00f3rico n\u00e3o encontrado", responseCode="404")})
    @PutMapping(value={"/{idEmpresa}/{idDemanda}/historicos/{seqHistorico}/resposta"})
    @NotNull
    public DemandaHistorico saveHistoricoResposta(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Sequencial do hist\u00f3rico") @PathVariable(value="seqHistorico") int seqHistorico, @Parameter(description="Dados da resposta") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveHistoricoRespostaDTO dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        DemandaHistorico demandaHistorico = this.demandasService.saveHistoricoResposta(idEmpresa, idDemanda, seqHistorico, dto);
        Intrinsics.checkNotNullExpressionValue((Object)demandaHistorico, (String)"saveHistoricoResposta(...)");
        return demandaHistorico;
    }

    @Operation(summary="Remove um anexo de um hist\u00f3rico", description="Exclui um arquivo anexado a um registro de hist\u00f3rico espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Anexo removido com sucesso", responseCode="204"), @ApiResponse(description="Hist\u00f3rico ou anexo n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/{idEmpresa}/{idDemanda}/historicos/{seqHistorico}/anexos/{idAnexo}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAnexoHistorico(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Sequencial do hist\u00f3rico") @PathVariable(value="seqHistorico") int seqHistorico, @Parameter(description="ID do anexo") @PathVariable(value="idAnexo") int idAnexo) {
        this.demandasService.removeAnexoHistorico(idEmpresa, idDemanda, seqHistorico, idAnexo);
    }

    @Operation(summary="Busca um objetivo por ID", description="Retorna um objetivo estrat\u00e9gico espec\u00edfico pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="Objetivo encontrado com sucesso", responseCode="200"), @ApiResponse(description="Objetivo n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/objetivos/{idObjetivo}"})
    @NotNull
    public DemandaObjetivo findObjetivoById(@Parameter(description="ID do objetivo") @PathVariable(value="idObjetivo") int idObjetivo) {
        DemandaObjetivo demandaObjetivo = this.demandasService.findObjetivoById(idObjetivo);
        Intrinsics.checkNotNullExpressionValue((Object)demandaObjetivo, (String)"findObjetivoById(...)");
        return demandaObjetivo;
    }

    @Operation(summary="Lista objetivos estrat\u00e9gicos", description="Retorna uma lista paginada de objetivos estrat\u00e9gicos com filtros opcionais")
    @ApiResponses(value={@ApiResponse(description="Objetivos listados com sucesso", responseCode="200")})
    @GetMapping(value={"/objetivos"})
    @NotNull
    public Page<DemandaObjetivo> findObjetivos(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="Termo de busca") @RequestParam(required=false) @Nullable String search, @Parameter(description="ID do grupo") @RequestParam(required=false) @Nullable Integer grupo, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findObjetivos(idEmpresa, search, grupo, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findObjetivos(...)");
        return page;
    }

    @Operation(summary="Cria um novo objetivo estrat\u00e9gico", description="Registra um novo objetivo estrat\u00e9gico no sistema")
    @ApiResponses(value={@ApiResponse(description="Objetivo criado com sucesso", responseCode="201")})
    @PostMapping(value={"/objetivos"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public DemandaObjetivo createObjetivo(@Parameter(description="Dados do objetivo") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveObjetivoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaObjetivo demandaObjetivo = this.demandasService.createObjetivo(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaObjetivo, (String)"createObjetivo(...)");
        return demandaObjetivo;
    }

    @Operation(summary="Atualiza um objetivo estrat\u00e9gico", description="Modifica os dados de um objetivo estrat\u00e9gico existente")
    @ApiResponses(value={@ApiResponse(description="Objetivo atualizado com sucesso", responseCode="200"), @ApiResponse(description="Objetivo n\u00e3o encontrado", responseCode="404")})
    @PutMapping(value={"/objetivos/{idObjetivo}"})
    @NotNull
    public DemandaObjetivo updateObjetivo(@Parameter(description="ID do objetivo") @PathVariable(value="idObjetivo") int idObjetivo, @Parameter(description="Dados atualizados do objetivo") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveObjetivoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaObjetivo demandaObjetivo = this.demandasService.updateObjetivo(idObjetivo, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaObjetivo, (String)"updateObjetivo(...)");
        return demandaObjetivo;
    }

    @Operation(summary="Remove um objetivo estrat\u00e9gico", description="Exclui permanentemente um objetivo estrat\u00e9gico do sistema")
    @ApiResponses(value={@ApiResponse(description="Objetivo exclu\u00eddo com sucesso", responseCode="204"), @ApiResponse(description="Objetivo n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/objetivos/{idObjetivo}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteObjetivo(@Parameter(description="ID do objetivo") @PathVariable(value="idObjetivo") int idObjetivo) {
        this.demandasService.deleteObjetivo(idObjetivo);
    }

    @Operation(summary="Lista \u00edndices de prioriza\u00e7\u00e3o", description="Retorna uma lista paginada de \u00edndices de prioriza\u00e7\u00e3o com filtro opcional")
    @ApiResponses(value={@ApiResponse(description="\u00cdndices listados com sucesso", responseCode="200")})
    @GetMapping(value={"/indices"})
    @NotNull
    public Page<IndicePriorizacao> findIndices(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="Termo de busca") @RequestParam(required=false) @Nullable String search, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findIndices(idEmpresa, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findIndices(...)");
        return page;
    }

    @Operation(summary="Busca um \u00edndice por ID", description="Retorna um \u00edndice de prioriza\u00e7\u00e3o espec\u00edfico pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="\u00cdndice encontrado com sucesso", responseCode="200"), @ApiResponse(description="\u00cdndice n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/indices/{idIndice}"})
    @NotNull
    public IndicePriorizacao findIndiceById(@Parameter(description="ID do \u00edndice") @PathVariable(value="idIndice") int idIndice) {
        IndicePriorizacao indicePriorizacao = this.demandasService.findIndiceById(idIndice);
        Intrinsics.checkNotNullExpressionValue((Object)indicePriorizacao, (String)"findIndiceById(...)");
        return indicePriorizacao;
    }

    @Operation(summary="Cria um novo \u00edndice de prioriza\u00e7\u00e3o", description="Registra um novo \u00edndice de prioriza\u00e7\u00e3o no sistema")
    @ApiResponses(value={@ApiResponse(description="\u00cdndice criado com sucesso", responseCode="201")})
    @PostMapping(value={"/indices"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public IndicePriorizacao createIndice(@Parameter(description="Dados do \u00edndice") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull CreateIndiceDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        IndicePriorizacao indicePriorizacao = this.demandasService.createIndice(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)indicePriorizacao, (String)"createIndice(...)");
        return indicePriorizacao;
    }

    @Operation(summary="Atualiza um \u00edndice de prioriza\u00e7\u00e3o", description="Modifica os dados de um \u00edndice de prioriza\u00e7\u00e3o existente")
    @ApiResponses(value={@ApiResponse(description="\u00cdndice atualizado com sucesso", responseCode="200"), @ApiResponse(description="\u00cdndice n\u00e3o encontrado", responseCode="404")})
    @PutMapping(value={"/indices/{indiceId}"})
    @NotNull
    public IndicePriorizacao updateIndice(@Parameter(description="ID do \u00edndice") @PathVariable(value="indiceId") int indiceId, @Parameter(description="Dados atualizados do \u00edndice") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull UpdateIndiceDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        IndicePriorizacao indicePriorizacao = this.demandasService.updateIndice(indiceId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)indicePriorizacao, (String)"updateIndice(...)");
        return indicePriorizacao;
    }

    @Operation(summary="Remove um \u00edndice de prioriza\u00e7\u00e3o", description="Exclui permanentemente um \u00edndice de prioriza\u00e7\u00e3o do sistema")
    @ApiResponses(value={@ApiResponse(description="\u00cdndice exclu\u00eddo com sucesso", responseCode="204"), @ApiResponse(description="\u00cdndice n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/indices/{idIndice}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteIndice(@Parameter(description="ID do \u00edndice") @PathVariable(value="idIndice") int idIndice) {
        this.demandasService.deleteIndice(idIndice);
    }

    @Operation(summary="Lista pesos de prioriza\u00e7\u00e3o", description="Retorna uma lista paginada de pesos de prioriza\u00e7\u00e3o com filtro opcional por tipo")
    @ApiResponses(value={@ApiResponse(description="Pesos listados com sucesso", responseCode="200")})
    @GetMapping(value={"/pesos"})
    @NotNull
    public Page<PesoPriorizacao> findPesos(@Parameter(description="ID da empresa") @RequestParam int idEmpresa, @Parameter(description="Tipo do peso") @RequestParam(required=false) @Nullable String tipo, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findPesos(idEmpresa, tipo, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPesos(...)");
        return page;
    }

    @Operation(summary="Busca um peso por ID", description="Retorna um peso de prioriza\u00e7\u00e3o espec\u00edfico pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="Peso encontrado com sucesso", responseCode="200"), @ApiResponse(description="Peso n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/pesos/{idPeso}"})
    @NotNull
    public PesoPriorizacao findPesoById(@Parameter(description="ID do peso") @PathVariable(value="idPeso") int idPeso) {
        PesoPriorizacao pesoPriorizacao = this.demandasService.findPesoById(idPeso);
        Intrinsics.checkNotNullExpressionValue((Object)pesoPriorizacao, (String)"findPesoById(...)");
        return pesoPriorizacao;
    }

    @Operation(summary="Cria um novo peso de prioriza\u00e7\u00e3o", description="Registra um novo peso de prioriza\u00e7\u00e3o no sistema")
    @ApiResponses(value={@ApiResponse(description="Peso criado com sucesso", responseCode="201")})
    @PostMapping(value={"/pesos"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public PesoPriorizacao createPeso(@Parameter(description="Dados do peso") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull CreatePesoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PesoPriorizacao pesoPriorizacao = this.demandasService.createPeso(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pesoPriorizacao, (String)"createPeso(...)");
        return pesoPriorizacao;
    }

    @Operation(summary="Atualiza um peso de prioriza\u00e7\u00e3o", description="Modifica os dados de um peso de prioriza\u00e7\u00e3o existente")
    @ApiResponses(value={@ApiResponse(description="Peso atualizado com sucesso", responseCode="200"), @ApiResponse(description="Peso n\u00e3o encontrado", responseCode="404")})
    @PutMapping(value={"/pesos/{pesoId}"})
    @NotNull
    public PesoPriorizacao updatePeso(@Parameter(description="ID do peso") @PathVariable(value="pesoId") int pesoId, @Parameter(description="Dados atualizados do peso") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull UpdatePesoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PesoPriorizacao pesoPriorizacao = this.demandasService.updatePeso(pesoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pesoPriorizacao, (String)"updatePeso(...)");
        return pesoPriorizacao;
    }

    @Operation(summary="Remove um peso de prioriza\u00e7\u00e3o", description="Exclui permanentemente um peso de prioriza\u00e7\u00e3o do sistema")
    @ApiResponses(value={@ApiResponse(description="Peso exclu\u00eddo com sucesso", responseCode="204"), @ApiResponse(description="Peso n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/pesos/{idPeso}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deletePeso(@Parameter(description="ID do peso") @PathVariable(value="idPeso") int idPeso) {
        this.demandasService.deletePeso(idPeso);
    }

    @Operation(summary="Lista respons\u00e1veis de uma demanda", description="Retorna uma lista paginada de respons\u00e1veis associados a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1veis listados com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/responsavel"})
    @NotNull
    public Page<DemandaResponsavel> findResponsaveisByDemanda(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findResponsaveisByDemanda(idEmpresa, idDemanda, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findResponsaveisByDemanda(...)");
        return page;
    }

    @Operation(summary="Adiciona um respons\u00e1vel a uma demanda", description="Registra um novo respons\u00e1vel associado a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel adicionado com sucesso", responseCode="201"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PostMapping(value={"/{idEmpresa}/{demandaId}/responsavel"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public DemandaResponsavel createDemandaResponsavel(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="demandaId") int demandaId, @Parameter(description="Dados do respons\u00e1vel") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveDemandaResponsavelDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaResponsavel demandaResponsavel = this.demandasService.createDemandaResponsavel(idEmpresa, demandaId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaResponsavel, (String)"createDemandaResponsavel(...)");
        return demandaResponsavel;
    }

    @Operation(summary="Remove um respons\u00e1vel de uma demanda", description="Desassocia um respons\u00e1vel espec\u00edfico de uma demanda")
    @ApiResponses(value={@ApiResponse(description="Respons\u00e1vel removido com sucesso", responseCode="204"), @ApiResponse(description="Demanda ou respons\u00e1vel n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/{idEmpresa}/{idDemanda}/responsavel/{sequencia}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDemandaResponsavelById(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Sequencial do respons\u00e1vel") @PathVariable(value="sequencia") int sequencia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.demandasService.deleteDemandaResponsavelById(idEmpresa, idDemanda, sequencia, ((Number)n).intValue());
    }

    @Operation(summary="Obt\u00e9m resumo de demandas por status", description="Retorna um mapa com a contagem de demandas por status para uma empresa espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Resumo obtido com sucesso", responseCode="200")})
    @GetMapping(value={"/resumo/status"})
    @NotNull
    public Map<String, Integer> findResumoDemandasByStatus(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa) {
        Map map = this.demandasService.findResumoDemandasByStatus(idEmpresa);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"findResumoDemandasByStatus(...)");
        return map;
    }

    @Operation(summary="Lista perguntas frequentes", description="Retorna uma lista paginada de perguntas frequentes com filtro opcional")
    @ApiResponses(value={@ApiResponse(description="Perguntas frequentes listadas com sucesso", responseCode="200")})
    @GetMapping(value={"/perguntas-frequentes"})
    @NotNull
    public Page<PerguntaFrequente> findPerguntasFrequentes(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="Termo de busca") @RequestParam(required=false) @Nullable String search, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findPerguntasFrequentes(idEmpresa, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPerguntasFrequentes(...)");
        return page;
    }

    @Operation(summary="Busca uma pergunta frequente por ID", description="Retorna uma pergunta frequente espec\u00edfica pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="Pergunta frequente encontrada com sucesso", responseCode="200"), @ApiResponse(description="Pergunta frequente n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/perguntas-frequentes/{perguntaId}"})
    @NotNull
    public PerguntaFrequente findPerguntaFrequenteById(@Parameter(description="ID da pergunta frequente") @PathVariable(value="perguntaId") int perguntaId) {
        PerguntaFrequente perguntaFrequente = this.demandasService.findPerguntaFrequenteById(perguntaId);
        Intrinsics.checkNotNullExpressionValue((Object)perguntaFrequente, (String)"findPerguntaFrequenteById(...)");
        return perguntaFrequente;
    }

    @Operation(summary="Cria uma nova pergunta frequente", description="Registra uma nova pergunta frequente no sistema")
    @ApiResponses(value={@ApiResponse(description="Pergunta frequente criada com sucesso", responseCode="201")})
    @PostMapping(value={"/perguntas-frequentes"})
    @NotNull
    public PerguntaFrequente createPerguntaFrequente(@Parameter(description="Dados da pergunta frequente") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull CreatePerguntaFrequenteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PerguntaFrequente perguntaFrequente = this.demandasService.createPerguntaFrequente(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)perguntaFrequente, (String)"createPerguntaFrequente(...)");
        return perguntaFrequente;
    }

    @Operation(summary="Atualiza uma pergunta frequente", description="Modifica os dados de uma pergunta frequente existente")
    @ApiResponses(value={@ApiResponse(description="Pergunta frequente atualizada com sucesso", responseCode="200"), @ApiResponse(description="Pergunta frequente n\u00e3o encontrada", responseCode="404")})
    @PutMapping(value={"/perguntas-frequentes/{perguntaId}"})
    @NotNull
    public PerguntaFrequente updatePerguntaFrequente(@Parameter(description="ID da pergunta frequente") @PathVariable(value="perguntaId") int perguntaId, @Parameter(description="Dados atualizados da pergunta frequente") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull UpdatePerguntaFrequenteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PerguntaFrequente perguntaFrequente = this.demandasService.updatePerguntaFrequente(perguntaId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)perguntaFrequente, (String)"updatePerguntaFrequente(...)");
        return perguntaFrequente;
    }

    @Operation(summary="Remove uma pergunta frequente", description="Exclui permanentemente uma pergunta frequente do sistema")
    @ApiResponses(value={@ApiResponse(description="Pergunta frequente exclu\u00edda com sucesso", responseCode="204"), @ApiResponse(description="Pergunta frequente n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/perguntas-frequentes/{perguntaId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deletePerguntaFrequente(@Parameter(description="ID da pergunta frequente") @PathVariable(value="perguntaId") int perguntaId) {
        this.demandasService.deletePerguntaFrequente(perguntaId);
    }

    @Operation(summary="Lista mensagens de 'Fale Conosco'", description="Retorna uma lista paginada de mensagens enviadas pelo 'Fale Conosco' com filtro opcional")
    @ApiResponses(value={@ApiResponse(description="Mensagens listadas com sucesso", responseCode="200")})
    @GetMapping(value={"/fale-conosco"})
    @NotNull
    public Page<FaleConosco> findFaleConosco(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="Termo de busca") @RequestParam(required=false) @Nullable String search, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findFaleConosco(idEmpresa, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findFaleConosco(...)");
        return page;
    }

    @Operation(summary="Busca uma mensagem de 'Fale Conosco' por ID", description="Retorna uma mensagem espec\u00edfica enviada pelo 'Fale Conosco' pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="Mensagem encontrada com sucesso", responseCode="200"), @ApiResponse(description="Mensagem n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/fale-conosco/{idFaleConosco}"})
    @NotNull
    public FaleConosco findFaleConoscoById(@Parameter(description="ID da mensagem") @PathVariable(value="idFaleConosco") int idFaleConosco) {
        FaleConosco faleConosco = this.demandasService.findFaleConoscoById(idFaleConosco);
        Intrinsics.checkNotNullExpressionValue((Object)faleConosco, (String)"findFaleConoscoById(...)");
        return faleConosco;
    }

    @Operation(summary="Cria uma nova mensagem de 'Fale Conosco'", description="Registra uma nova mensagem enviada pelo 'Fale Conosco'")
    @ApiResponses(value={@ApiResponse(description="Mensagem criada com sucesso", responseCode="201")})
    @PostMapping(value={"/fale-conosco"})
    @NotNull
    public FaleConosco createFaleConosco(@Parameter(description="Dados da mensagem") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveFaleConoscoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        FaleConosco faleConosco = this.demandasService.createFaleConosco(dto, usuario.getId(), null);
        Intrinsics.checkNotNullExpressionValue((Object)faleConosco, (String)"createFaleConosco(...)");
        return faleConosco;
    }

    @Operation(summary="Atualiza uma mensagem de 'Fale Conosco'", description="Modifica os dados de uma mensagem enviada pelo 'Fale Conosco'")
    @ApiResponses(value={@ApiResponse(description="Mensagem atualizada com sucesso", responseCode="200"), @ApiResponse(description="Mensagem n\u00e3o encontrada", responseCode="404")})
    @PutMapping(value={"/fale-conosco/{faleConoscoId}"})
    @NotNull
    public FaleConosco updateFaleConosco(@Parameter(description="ID da mensagem") @PathVariable(value="faleConoscoId") int faleConoscoId, @Parameter(description="Dados atualizados da mensagem") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveFaleConoscoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        FaleConosco faleConosco = this.demandasService.updateFaleConosco(faleConoscoId, dto, usuario.getId(), null);
        Intrinsics.checkNotNullExpressionValue((Object)faleConosco, (String)"updateFaleConosco(...)");
        return faleConosco;
    }

    @Operation(summary="Remove uma mensagem de 'Fale Conosco'", description="Exclui permanentemente uma mensagem enviada pelo 'Fale Conosco'")
    @ApiResponses(value={@ApiResponse(description="Mensagem exclu\u00edda com sucesso", responseCode="204"), @ApiResponse(description="Mensagem n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/fale-conosco/{idFaleConosco}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFaleConosco(@Parameter(description="ID da mensagem") @PathVariable(value="idFaleConosco") int idFaleConosco) {
        this.demandasService.deleteFaleConosco(idFaleConosco);
    }

    @Operation(summary="Busca um anexo por ID", description="Retorna um anexo espec\u00edfico associado a uma demanda pelo seu ID")
    @ApiResponses(value={@ApiResponse(description="Anexo encontrado com sucesso", responseCode="200"), @ApiResponse(description="Anexo n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/anexos/{seqAnexo}"})
    @NotNull
    public DemandaAnexo findAnexoById(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Sequencia do anexo") @PathVariable(value="seqAnexo") int seqAnexo, @Parameter(description="Vers\u00e3o do anexo") @RequestParam(required=false) @Nullable Integer versao) {
        DemandaAnexo demandaAnexo = this.demandasService.findAnexoById(idEmpresa, idDemanda, seqAnexo, versao);
        Intrinsics.checkNotNullExpressionValue((Object)demandaAnexo, (String)"findAnexoById(...)");
        return demandaAnexo;
    }

    @Operation(summary="Lista anexos de uma demanda", description="Retorna uma lista paginada de anexos associados a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Anexos listados com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/anexos"})
    @NotNull
    public Page<DemandaAnexo> findAnexosByDemandaId(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findAnexosByDemandaId(idEmpresa, idDemanda, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosByDemandaId(...)");
        return page;
    }

    @Operation(summary="Cria um novo anexo para uma demanda", description="Adiciona um novo anexo a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Anexo criado com sucesso", responseCode="201"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @PostMapping(value={"/{idEmpresa}/{idDemanda}/anexos"})
    @NotNull
    public DemandaAnexo createAnexo(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Tipo do anexo") @RequestParam(value="tipoAnexo") @NotNull String tipoAnexo, @Parameter(description="Arquivo anexado") @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAnexo, (String)"tipoAnexo");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaAnexo demandaAnexo = this.demandasService.createAnexo(idEmpresa, idDemanda, tipoAnexo, file, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaAnexo, (String)"createAnexo(...)");
        return demandaAnexo;
    }

    @Operation(summary="Remove um anexo de uma demanda", description="Exclui um anexo espec\u00edfico associado a uma demanda")
    @ApiResponses(value={@ApiResponse(description="Anexo removido com sucesso", responseCode="204"), @ApiResponse(description="Demanda ou anexo n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/{idEmpresa}/{idDemanda}/anexos/{seqAnexo}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnexo(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Sequencial do anexo") @PathVariable(value="seqAnexo") int seqAnexo, @Parameter(description="Vers\u00e3o do anexo") @RequestParam(required=false) @Nullable Integer versao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.demandasService.deleteAnexo(idEmpresa, idDemanda, seqAnexo, versao, ((Number)n).intValue(), null);
    }

    @Operation(summary="Lista anexos por tipo", description="Retorna uma lista paginada de anexos filtrados por tipo e empresas")
    @ApiResponses(value={@ApiResponse(description="Anexos listados com sucesso", responseCode="200")})
    @GetMapping(value={"/anexos"})
    @NotNull
    public Page<DemandaAnexo> findAnexosByTipo(@Parameter(description="Lista de IDs das empresas") @RequestParam(value="empresas") @NotNull List<Integer> empresas, @Parameter(description="Lista de tipos de anexo") @RequestParam(value="tiposAnexo") @NotNull List<String> tiposAnexo, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter(empresas, (String)"empresas");
        Intrinsics.checkNotNullParameter(tiposAnexo, (String)"tiposAnexo");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findAnexosByTipo(empresas, tiposAnexo, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosByTipo(...)");
        return page;
    }

    @Operation(summary="Lista controles de terceiros associados a uma demanda", description="Retorna uma lista paginada de controles de terceiros associados a uma demanda espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Controles de terceiros listados com sucesso", responseCode="200"), @ApiResponse(description="Demanda n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{idEmpresa}/{idDemanda}/controles-terceiros"})
    @NotNull
    public Page<DemandaControleTerceiro> findControlesTerceirosByDemandaId(@Parameter(description="ID da empresa") @PathVariable(value="idEmpresa") int idEmpresa, @Parameter(description="ID da demanda") @PathVariable(value="idDemanda") int idDemanda, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findControlesTerceirosByDemandaId(idEmpresa, idDemanda, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findControlesTerceirosByDemandaId(...)");
        return page;
    }

    @Operation(summary="Salva um controle de terceiro", description="Registra ou atualiza um controle de terceiro associado a uma demanda")
    @ApiResponses(value={@ApiResponse(description="Controle de terceiro salvo com sucesso", responseCode="200")})
    @PostMapping(value={"/controles-terceiros"})
    @NotNull
    public DemandaControleTerceiro saveControleTerceiro(@Parameter(description="Dados do controle de terceiro") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull DemandaControleTerceiro controle, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)controle, (String)"controle");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaControleTerceiro demandaControleTerceiro = this.demandasService.saveControleTerceiro(controle, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaControleTerceiro, (String)"saveControleTerceiro(...)");
        return demandaControleTerceiro;
    }

    @Operation(summary="Busca um status por ID", description="Retorna um status espec\u00edfico pelo seu identificador")
    @ApiResponses(value={@ApiResponse(description="Status encontrado com sucesso", responseCode="200"), @ApiResponse(description="Status n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/status/{id}"})
    @NotNull
    public DemandaStatus findStatusById(@Parameter(description="ID do status") @PathVariable(value="id") int id) {
        DemandaStatus demandaStatus = this.demandasService.findStatusById(id);
        Intrinsics.checkNotNullExpressionValue((Object)demandaStatus, (String)"findStatusById(...)");
        return demandaStatus;
    }

    @Operation(summary="Lista todos os status", description="Retorna uma lista paginada de status com filtro opcional por empresa e termo de busca")
    @ApiResponses(value={@ApiResponse(description="Lista de status retornada com sucesso", responseCode="200")})
    @GetMapping(value={"/status"})
    @NotNull
    public Page<DemandaStatus> findStatus(@Parameter(description="ID da empresa") @RequestParam(value="idEmpresa") int idEmpresa, @Parameter(description="Termo de busca opcional") @RequestParam(value="search", required=false) @Nullable String search, @Parameter(description="C\u00f3digo do status opcional") @RequestParam(value="status", required=false) @Nullable Character status, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findStatus(idEmpresa, search, status, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findStatus(...)");
        return page;
    }

    @Operation(summary="Cria um novo status", description="Registra um novo status no sistema")
    @ApiResponses(value={@ApiResponse(description="Status criado com sucesso", responseCode="201")})
    @PostMapping(value={"/status"})
    @NotNull
    public DemandaStatus createStatus(@Parameter(description="Dados do status a ser criado") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveStatusDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaStatus demandaStatus = this.demandasService.createStatus(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaStatus, (String)"createStatus(...)");
        return demandaStatus;
    }

    @Operation(summary="Atualiza um status", description="Modifica os dados de um status existente")
    @ApiResponses(value={@ApiResponse(description="Status atualizado com sucesso", responseCode="200"), @ApiResponse(description="Status n\u00e3o encontrado", responseCode="404")})
    @PutMapping(value={"/status/{id}"})
    @NotNull
    public DemandaStatus updateStatus(@Parameter(description="ID do status") @PathVariable(value="id") int id, @Parameter(description="Dados atualizados do status") @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SaveStatusDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaStatus demandaStatus = this.demandasService.updateStatus(id, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaStatus, (String)"updateStatus(...)");
        return demandaStatus;
    }

    @Operation(summary="Remove um status", description="Exclui permanentemente um status do sistema")
    @ApiResponses(value={@ApiResponse(description="Status exclu\u00eddo com sucesso", responseCode="204"), @ApiResponse(description="Status n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/status/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteStatus(@Parameter(description="ID do status") @PathVariable(value="id") int id) {
        this.demandasService.deleteStatus(id);
    }

    @GetMapping(value={"/tipos"})
    @NotNull
    public Page<DemandaTipo> findTipos(@RequestParam(value="idEmpresa") int idEmpresa, @RequestParam(value="idObjetivo") @Nullable Integer idObjetivo, @RequestParam(value="idObjetivo") @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findTipos(idEmpresa, idObjetivo, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTipos(...)");
        return page;
    }

    @GetMapping(value={"/tipos/{tipoId}"})
    @NotNull
    public DemandaTipo findTipoById(@PathVariable(value="tipoId") int tipoId) {
        DemandaTipo demandaTipo = this.demandasService.findTipoById(tipoId);
        Intrinsics.checkNotNullExpressionValue((Object)demandaTipo, (String)"findTipoById(...)");
        return demandaTipo;
    }

    @PostMapping(value={"/tipos"})
    @NotNull
    public DemandaTipo createTipo(@org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateDemandaTipoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaTipo demandaTipo = this.demandasService.createTipo(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaTipo, (String)"createTipo(...)");
        return demandaTipo;
    }

    @PutMapping(value={"/tipos/{idTipo}"})
    @NotNull
    public DemandaTipo updateTipo(@PathVariable(value="idTipo") int idTipo, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull UpdateDemandaTipoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaTipo demandaTipo = this.demandasService.updateTipo(idTipo, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaTipo, (String)"updateTipo(...)");
        return demandaTipo;
    }

    @DeleteMapping(value={"/tipos/{tipoId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteTipoById(@PathVariable(value="tipoId") int tipoId) {
        this.demandasService.deleteTipo(tipoId);
    }

    @GetMapping(value={"/areas"})
    @NotNull
    public Page<DemandaArea> findAreas(@RequestParam(value="idEmpresa") int idEmpresa, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.demandasService.findAreas(idEmpresa, search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAreas(...)");
        return page;
    }

    @GetMapping(value={"/areas/{areaId}"})
    @NotNull
    public DemandaArea findAreaById(@PathVariable(value="areaId") int areaId) {
        DemandaArea demandaArea = this.demandasService.findAreaById(areaId);
        Intrinsics.checkNotNullExpressionValue((Object)demandaArea, (String)"findAreaById(...)");
        return demandaArea;
    }

    @PostMapping(value={"/areas"})
    @NotNull
    public DemandaArea createArea(@org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateDemandaAreaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaArea demandaArea = this.demandasService.createArea(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaArea, (String)"createArea(...)");
        return demandaArea;
    }

    @PutMapping(value={"/areas/{idArea}"})
    @NotNull
    public DemandaArea updateArea(@PathVariable(value="idArea") int idArea, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull UpdateDemandaAreaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        DemandaArea demandaArea = this.demandasService.updateArea(idArea, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)demandaArea, (String)"updateArea(...)");
        return demandaArea;
    }

    @Operation(summary="Deleta uma \u00e1rea da demanda", description="Deleta uma \u00e1rea da demanda")
    @ApiResponses(value={@ApiResponse(description="\u00c1rea deletada com sucesso", responseCode="200"), @ApiResponse(description="\u00c1rea n\u00e3o encontrado", responseCode="404")})
    @DeleteMapping(value={"/areas/{areaId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAreaById(@PathVariable(value="areaId") int areaId) {
        this.demandasService.deleteArea(areaId);
    }
}

