/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.geral.TipoModulo;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.licencas.FindLicencasDTO;
import br.gov.antt.sgctt.core.dto.relacoes.FindRegistrosInformacoesDTO;
import br.gov.antt.sgctt.core.dto.relacoes.FindRegistrosReunioesDTO;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.geral.CalendarioEvento;
import br.gov.antt.sgctt.geral.EmpresaArea;
import br.gov.antt.sgctt.geral.LicencaCalendarioEvento;
import br.gov.antt.sgctt.geral.TipoRefCode;
import br.gov.antt.sgctt.licencas.Licenca;
import br.gov.antt.sgctt.obrigacoes.ObrigacaoContratual;
import br.gov.antt.sgctt.obrigacoes.ObrigacaoLancamento;
import br.gov.antt.sgctt.obrigacoes.TipoPeriodicidade;
import br.gov.antt.sgctt.obrigacoes.TipoStatusLancamentoObrigacao;
import br.gov.antt.sgctt.relacoes.RegistroInformacao;
import br.gov.antt.sgctt.relacoes.RegistroReuniao;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.LicencaService;
import br.gov.antt.sgctt.services.ObrigacaoService;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.empresa.EmpresaService;
import br.gov.antt.sgctt.services.relacoes.RelacaoInstitucionalService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="calend\u00e1rios", description="REST Services para calend\u00e1rios")
@RequestMapping(value={"/api/calendarios"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u00b3\u0001\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u00172\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&H\u0017\u00a2\u0006\u0002\u0010'JE\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010)\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u00172\b\u0010$\u001a\u0004\u0018\u00010\u0017H\u0012\u00a2\u0006\u0002\u0010*Je\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\b\u0010-\u001a\u0004\u0018\u00010\u001b2\b\u0010.\u001a\u0004\u0018\u00010\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0017H\u0012\u00a2\u0006\u0002\u0010/J4\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010)\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lbr/gov/antt/sgctt/apis/CalendariosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "obrigacaoService", "Lbr/gov/antt/sgctt/services/ObrigacaoService;", "relacaoInstitucionalService", "Lbr/gov/antt/sgctt/services/relacoes/RelacaoInstitucionalService;", "empresaService", "Lbr/gov/antt/sgctt/services/empresa/EmpresaService;", "licencaService", "Lbr/gov/antt/sgctt/services/LicencaService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/ObrigacaoService;Lbr/gov/antt/sgctt/services/relacoes/RelacaoInstitucionalService;Lbr/gov/antt/sgctt/services/empresa/EmpresaService;Lbr/gov/antt/sgctt/services/LicencaService;)V", "logger", "Lorg/slf4j/Logger;", "findEventosCalendario", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/gov/antt/sgctt/geral/CalendarioEvento;", "modulo", "", "empresa", "areas", "idTipoDocumento", "", "dataInicial", "Ljava/time/LocalDate;", "dataFinal", "entidades", "statusObrigacoes", "periodicidade", "statusLancamentos", "concessionarias", "tipo", "request", "Ljakarta/servlet/http/HttpServletRequest;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "loadEventosLicencas", "idEmpresa", "(Ljava/lang/Integer;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "loadEventosObrigacoes", "areasId", "statusObrigacao", "statusLancamento", "(ILjava/lang/Integer;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "loadEventosRelacoes", "server"})
@SourceDebugExtension(value={"SMAP\nCalendariosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendariosRestServices.kt\nbr/gov/antt/sgctt/apis/CalendariosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,484:1\n739#2,9:485\n774#2:529\n865#2:530\n1557#2:531\n1628#2,3:532\n866#2:535\n739#2,9:536\n37#3:494\n36#3,3:495\n37#3:545\n36#3,3:546\n108#4:498\n80#4,22:499\n108#4:549\n80#4,22:550\n1#5:521\n381#6,7:522\n*S KotlinDebug\n*F\n+ 1 CalendariosRestServices.kt\nbr/gov/antt/sgctt/apis/CalendariosRestServices\n*L\n151#1:485,9\n285#1:529\n285#1:530\n290#1:531\n290#1:532,3\n285#1:535\n402#1:536,9\n151#1:494\n151#1:495,3\n403#1:545\n403#1:546,3\n155#1:498\n155#1:499,22\n403#1:549\n403#1:550,22\n233#1:522,7\n*E\n"})
public class CalendariosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final ObrigacaoService obrigacaoService;
    @NotNull
    private final RelacaoInstitucionalService relacaoInstitucionalService;
    @NotNull
    private final EmpresaService empresaService;
    @NotNull
    private final LicencaService licencaService;
    @NotNull
    private final Logger logger;

    public CalendariosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull ObrigacaoService obrigacaoService, @NotNull RelacaoInstitucionalService relacaoInstitucionalService, @NotNull EmpresaService empresaService, @NotNull LicencaService licencaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)obrigacaoService, (String)"obrigacaoService");
        Intrinsics.checkNotNullParameter((Object)relacaoInstitucionalService, (String)"relacaoInstitucionalService");
        Intrinsics.checkNotNullParameter((Object)empresaService, (String)"empresaService");
        Intrinsics.checkNotNullParameter((Object)licencaService, (String)"licencaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.obrigacaoService = obrigacaoService;
        this.relacaoInstitucionalService = relacaoInstitucionalService;
        this.empresaService = empresaService;
        this.licencaService = licencaService;
        Logger logger = LoggerFactory.getLogger(CalendariosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/eventos/{modulo}"})
    @Operation(summary="Retorna os eventos do(s) m\u00f3dulo(s) selecionado(s).", description="Recupera eventos de calend\u00e1rio filtrados por empresa, m\u00f3dulo e outros crit\u00e9rios opcionais. Permite filtrar por datas, \u00e1reas, tipos de documento, status e outros par\u00e2metros espec\u00edficos de cada m\u00f3dulo. Os eventos s\u00e3o retornados em ordem cronol\u00f3gica e incluem informa\u00e7\u00f5es detalhadas como t\u00edtulo, descri\u00e7\u00e3o, data, status e outras informa\u00e7\u00f5es relevantes para cada tipo de evento.")
    @ApiResponses(value={@ApiResponse(description="Eventos recuperados com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<CalendarioEvento>> findEventosCalendario(@Parameter(description="M\u00f3dulo para filtrar eventos (OBRIGACOES, RELACOES_INSTITUCIONAIS, etc)") @PathVariable(value="modulo") @NotNull String modulo, @Parameter(description="Sigla da empresa para filtrar eventos") @RequestParam(value="empresa", required=false) @Nullable String empresa, @Parameter(description="Lista de IDs de \u00e1reas separados por v\u00edrgula para filtrar eventos") @RequestParam(name="areas", required=false) @Nullable String areas, @Parameter(description="ID do tipo de documento para filtrar eventos") @RequestParam(name="idTipoDocumento", required=false) @Nullable Integer idTipoDocumento, @Parameter(description="Data inicial para filtro de eventos (formato ISO: yyyy-MM-dd)") @RequestParam(name="dataInicial", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Nullable LocalDate dataInicial, @Parameter(description="Data final para filtro de eventos (formato ISO: yyyy-MM-dd)") @RequestParam(name="dataFinal", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Nullable LocalDate dataFinal, @Parameter(description="Lista de IDs de entidades separados por v\u00edrgula para filtrar eventos de rela\u00e7\u00f5es institucionais") @RequestParam(name="entidades", required=false) @Nullable String entidades, @Parameter(description="Status das obriga\u00e7\u00f5es para filtrar eventos") @RequestParam(name="statusObrigacoes", required=false) @Nullable Integer statusObrigacoes, @Parameter(description="Periodicidade das obriga\u00e7\u00f5es (c\u00f3digos conforme TipoPeriodicidade)") @RequestParam(name="periodicidade", required=false) @Nullable String periodicidade, @Parameter(description="Status dos lan\u00e7amentos (P=Pendente, A=Integrado, E=Encerrado)") @RequestParam(name="statusLancamentos", required=false) @Nullable String statusLancamentos, @Parameter(description="Lista de IDs de concession\u00e1rias separados por v\u00edrgula para filtrar eventos") @RequestParam(name="concessionarias", required=false) @Nullable String concessionarias, @Parameter(description="Tipo de evento: LICENCA ou CONDICIONANTE") @RequestParam(name="tipo", required=false) @Nullable String tipo, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)modulo, (String)"modulo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Empresa emp;
            ArrayList eventos = new ArrayList();
            String string = empresa;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v3 = this.coreService.getEmpresaBySigla(it);
                if (v3 == null) {
                    throw new ErrorCodeException(ErrorCode.EMPRESA_NOT_FOUND, new String[0]);
                }
            } else {
                v3 = emp = null;
            }
            if (Intrinsics.areEqual((Object)modulo, (Object)TipoModulo.AMBIENTAL.getSigla())) {
                Empresa empresa2 = emp;
                eventos.addAll(this.loadEventosLicencas(empresa2 != null ? empresa2.getId() : null, dataInicial, dataFinal, concessionarias, tipo));
            }
            if (Intrinsics.areEqual((Object)modulo, (Object)TipoModulo.OBRIGACOES.getSigla())) {
                if (emp == null) {
                    String[] stringArray = new String[]{"%error%", "Empresa n\u00e3o informada ou inv\u00e1lida."};
                    throw new ErrorCodeException(ErrorCode.VALIDATION_ERROR, stringArray);
                }
                ArrayList<Integer> areasId = new ArrayList<Integer>();
                if (areas != null && !(((CharSequence)areas).length() == 0)) {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    Object bl = areas;
                    Regex regex = new Regex(",");
                    int n = 0;
                    bl = regex.split((CharSequence)bl, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] areasTxt = thisCollection$iv.toArray(new String[0]);
                    List areasLst = this.empresaService.findAreasByEmpresa(emp.getId(), Boolean.valueOf(false), null);
                    block3: for (String areaId : areasTxt) {
                        for (EmpresaArea area : areasLst) {
                            String $this$trim$iv = areaId;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = $this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl3 = false;
                                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if (!Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)String.valueOf(area.getId()))) continue;
                            Integer n2 = area.getId();
                            Intrinsics.checkNotNull((Object)n2);
                            areasId.add(n2);
                            continue block3;
                        }
                    }
                }
                Integer n = emp.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
                eventos.addAll(this.loadEventosObrigacoes(((Number)n).intValue(), idTipoDocumento, dataInicial, dataFinal, (List)areasId, statusObrigacoes, statusLancamentos, periodicidade));
            }
            if (Intrinsics.areEqual((Object)modulo, (Object)TipoModulo.RELACOES_INSTITUCIONAIS.getSigla())) {
                if (emp == null) {
                    String[] stringArray = new String[]{"%error%", "Empresa n\u00e3o informada ou inv\u00e1lida."};
                    throw new ErrorCodeException(ErrorCode.VALIDATION_ERROR, stringArray);
                }
                Integer n = emp.getId();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
                eventos.addAll(this.loadEventosRelacoes(((Number)n).intValue(), dataInicial, dataFinal, entidades));
            }
            return new ResponseEntity(eventos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("findEventos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<CalendarioEvento> loadEventosLicencas(Integer idEmpresa, LocalDate dataInicial, LocalDate dataFinal, String concessionarias, String tipo) {
        void $this$filterTo$iv$iv;
        Iterable evento;
        Iterator prazoOpt;
        Object value$iv;
        List list;
        Object idArea = null;
        Object status = null;
        Object idResponsavel = null;
        ArrayList<Iterable> eventos = new ArrayList<Iterable>();
        int DEFAULT_PRAZO_DIAS_AVISO = 150;
        Map prazoDiasAvisoMap = new LinkedHashMap();
        LicencaService licencaService = this.licencaService;
        Integer n = idEmpresa;
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            LicencaService licencaService2 = licencaService;
            boolean bl = false;
            list = CollectionsKt.listOf((Object)((int)it));
            licencaService = licencaService2;
        } else {
            list = null;
        }
        List list2 = null;
        Integer n3 = null;
        Integer n4 = null;
        LocalDate localDate = dataFinal;
        LocalDate localDate2 = dataInicial;
        Integer n5 = null;
        String string = null;
        Integer n6 = null;
        String string2 = null;
        List list3 = list;
        Page licencasDB = licencaService.findLicencas(new FindLicencasDTO(list3, string2, n6, string, n5, localDate2, localDate, n4, n3, list2), Pageable.unpaged());
        if (licencasDB != null) {
            for (Licenca licenca : licencasDB) {
                int n7;
                if (licenca.getDataVencimento() == null) continue;
                Integer n8 = licenca.getIdEmpresa();
                if (n8 != null) {
                    Object object;
                    void $this$getOrPut$iv;
                    int empresaId = ((Number)n8).intValue();
                    boolean bl = false;
                    Map map = prazoDiasAvisoMap;
                    Integer key$iv = empresaId;
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        try {
                            prazoOpt = this.coreService.getRefValueByName(Integer.valueOf(empresaId), TipoRefCode.MEIO_AMBIENTE_PRAZO_DIAS_AVISO, Integer.TYPE);
                            Integer prazo = ((Optional)((Object)prazoOpt)).orElse(DEFAULT_PRAZO_DIAS_AVISO);
                            this.logger.debug("Prazo de aviso para empresa {}: {} dias", (Object)empresaId, (Object)prazo);
                            prazoOpt = prazo;
                        }
                        catch (Exception e) {
                            Object[] objectArray = new Object[]{empresaId, DEFAULT_PRAZO_DIAS_AVISO, e};
                            this.logger.warn("Erro ao buscar prazo de aviso para empresa {}. Usando padr\u00e3o: {} dias", objectArray);
                            prazoOpt = DEFAULT_PRAZO_DIAS_AVISO;
                        }
                        Iterator iterator = prazoOpt;
                        Intrinsics.checkNotNull((Object)iterator);
                        Integer answer$iv = ((Number)((Object)iterator)).intValue();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    n7 = ((Number)object).intValue();
                } else {
                    n7 = DEFAULT_PRAZO_DIAS_AVISO;
                }
                int prazoDiasAviso = n7;
                evento = new LicencaCalendarioEvento();
                evento.setId(licenca.getId().toString());
                evento.setIdEmpresa(licenca.getIdEmpresa());
                evento.setTitulo(licenca.getDescricao());
                evento.setDescricao(licenca.getObservacao());
                evento.setData(licenca.getDataVencimento());
                evento.setDataEmissao(licenca.getDataEmissao());
                evento.setDataVencimento(licenca.getDataVencimento());
                evento.setDataProtocoloRenovacao(licenca.getDataProtocoloRenovacao());
                evento.setDataLimiteRenovacao(licenca.getDataLimiteRenovacao());
                evento.setDataSolicitacao(licenca.getDataSolicitacao());
                evento.setDatHorImportacao(licenca.getDatHorImportacao());
                evento.setDataInsercaoDocumento(licenca.getDataInsercaoDocumento());
                evento.setNroPrazoRenovacao(licenca.getNroPrazoRenovacao());
                evento.setNroLicenca(licenca.getNroLicenca());
                evento.setCondicionantes(licenca.getCondicionantes());
                if (licenca.getResponsavelArea() != null) {
                    evento.setNome(licenca.getResponsavelArea().getResponsavel().getNome());
                }
                evento.setModulo(TipoModulo.AMBIENTAL.getSigla());
                evento.setModuloItem("Licen\u00e7as");
                eventos.add(evento);
            }
        }
        Iterable $this$filter$iv = eventos;
        boolean $i$f$filter = false;
        evento = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CalendarioEvento evento2 = (CalendarioEvento)element$iv$iv;
            boolean bl = false;
            boolean incluir = true;
            if (concessionarias != null && !(((CharSequence)concessionarias).length() == 0)) {
                void $this$mapTo$iv$iv;
                value$iv = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)concessionarias, value$iv, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                prazoOpt = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
                }
                List concessionariasList = (List)destination$iv$iv2;
                boolean bl4 = incluir = concessionariasList.contains(evento2.getIdEmpresa());
            }
            if (tipo != null && !(((CharSequence)tipo).length() == 0)) {
                String string4;
                Intrinsics.checkNotNullExpressionValue((Object)tipo.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
                if (Intrinsics.areEqual((Object)string4, (Object)"LICENCA")) {
                    incluir = incluir && Intrinsics.areEqual((Object)evento2.getModuloItem(), (Object)"Licen\u00e7as");
                } else if (Intrinsics.areEqual((Object)string4, (Object)"CONDICIONANTE")) {
                    boolean bl5 = incluir = incluir && Intrinsics.areEqual((Object)evento2.getModuloItem(), (Object)"Condicionantes");
                }
            }
            if (!incluir) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eventosFiltrados = (List)destination$iv$iv;
        return eventosFiltrados;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<CalendarioEvento> loadEventosObrigacoes(int idEmpresa, Integer idTipoDocumento, LocalDate dataInicial, LocalDate dataFinal, List<Integer> areasId, Integer statusObrigacao, String statusLancamento, String periodicidade) {
        ArrayList<CalendarioEvento> eventos;
        block24: {
            Integer statusObrigacao2 = statusObrigacao;
            List empresasInt = new ArrayList();
            empresasInt.add(idEmpresa);
            LocalDate hoje = LocalDate.now();
            if (statusLancamento != null) {
                int n = -1;
                switch (statusLancamento.hashCode()) {
                    case 80: {
                        if (!statusLancamento.equals("P")) break;
                        n = 1;
                        break;
                    }
                    case 65: {
                        if (!statusLancamento.equals("A")) break;
                        n = 2;
                        break;
                    }
                    case 69: {
                        if (!statusLancamento.equals("E")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.PENDENTE.getCode();
                        break;
                    }
                    case 2: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.INTEGRADO.getCode();
                        break;
                    }
                    case 3: {
                        statusObrigacao2 = TipoStatusLancamentoObrigacao.ENCERRADO.getCode();
                        break;
                    }
                }
            }
            List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, null, areasId, idTipoDocumento, statusObrigacao2, null, null, dataInicial, dataFinal, periodicidade, null, null, Boolean.valueOf(false));
            eventos = new ArrayList<CalendarioEvento>();
            if (obrigacoesDB == null) break block24;
            for (ObrigacaoLancamento lcto : obrigacoesDB) {
                CalendarioEvento evento;
                block23: {
                    block26: {
                        block25: {
                            ObrigacaoContratual obrigacao = lcto.getObrigacao();
                            if (obrigacao.getPeriodicidade().equals((Object)TipoPeriodicidade.EVENTUAL)) continue;
                            evento = new CalendarioEvento();
                            evento.setId(lcto.getId().getIdObrigacao().toString());
                            evento.setIdEmpresa(lcto.getId().getIdEmpresa());
                            evento.setSequencia(lcto.getId().getSequencia());
                            evento.setTitulo(obrigacao.getNome());
                            evento.setDescricao(obrigacao.getDescricao());
                            if (obrigacao.getClassificacao() != null) {
                                evento.setTipoDocumento(obrigacao.getClassificacao().getDescricao());
                            }
                            evento.setData(lcto.getDatObrigacao());
                            if (lcto.getDatEncerramento() != null) {
                                evento.setDatConclusao(lcto.getDatEncerramento().toLocalDate());
                            }
                            evento.setStatus(lcto.getStatus());
                            evento.setStatusDesc(lcto.getStatusDesc());
                            if (lcto.getDatExecucao() == null) {
                                evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(hoje)));
                            } else {
                                evento.setPrazo(Integer.valueOf(lcto.getDatObrigacao().compareTo(lcto.getDatExecucao())));
                            }
                            if (!((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.PENDENTE.getCode())) break block25;
                            Integer n = evento.getPrazo();
                            if (n == null || n != 0) break block25;
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o na data atual");
                            break block23;
                        }
                        if (((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.ENCERRADO.getCode()) || ((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode())) break block26;
                        if (evento.getPrazo() >= 0) {
                            if (((Object)lcto.getStatus()).equals(TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                                evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o inclu\u00edda em correspond\u00eancia");
                                break block23;
                            } else {
                                evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em aberto, pendente");
                            }
                            break block23;
                        } else {
                            evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o em atraso");
                        }
                        break block23;
                    }
                    if (evento.getPrazo() >= 0) {
                        evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada no prazo");
                    } else {
                        evento.setStatusPrazoDesc("Obriga\u00e7\u00e3o encerrada com atraso");
                    }
                }
                if (lcto.getIdCorrespondencia() != null) {
                    evento.setReferencia(lcto.getIdCorrespondencia().toString());
                    evento.setReferenciaDesc(lcto.getCorrespondencia().getAssunto());
                }
                eventos.add(evento);
            }
        }
        return eventos;
    }

    /*
     * WARNING - void declaration
     */
    private List<CalendarioEvento> loadEventosRelacoes(int idEmpresa, LocalDate dataInicial, LocalDate dataFinal, String entidades) {
        Page informacoesDB;
        List empresasInt = new ArrayList();
        empresasInt.add(idEmpresa);
        Integer idArea = null;
        Integer idResponsavel = null;
        List entidadesLst = null;
        if (entidades != null && !(((CharSequence)entidades).length() == 0)) {
            void $this$toTypedArray$iv2;
            List list;
            String it;
            Collection $this$dropLastWhile$iv;
            entidadesLst = new ArrayList();
            Object object = entidades;
            Regex regex = new Regex(",");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            int $i$f$toTypedArray = 0;
            void thisCollection$iv = $this$toTypedArray$iv2;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            $i$f$toTypedArray = stringArray.length;
            for (int $this$toTypedArray$iv2 = 0; $this$toTypedArray$iv2 < $i$f$toTypedArray; ++$this$toTypedArray$iv2) {
                void $this$trim$iv;
                String entidade;
                it = entidade = stringArray[$this$toTypedArray$iv2];
                ArrayList arrayList = (ArrayList)entidadesLst;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                arrayList.add(Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
            }
        }
        ArrayList<CalendarioEvento> eventos = new ArrayList<CalendarioEvento>();
        Page reunioesDB = this.relacaoInstitucionalService.findRegistrosReunioes(new FindRegistrosReunioesDTO(empresasInt, null, idArea, entidadesLst, null, dataInicial, dataFinal, idResponsavel), Pageable.unpaged());
        if (reunioesDB != null) {
            for (RegistroReuniao reuniao : reunioesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(reuniao.getId().getIdRegistro().toString());
                evento.setIdEmpresa(reuniao.getId().getIdEmpresa());
                evento.setTitulo(reuniao.getAssunto());
                evento.setDescricao(reuniao.getObservacao());
                evento.setData(reuniao.getDataInteracao());
                evento.setHoraInicial(reuniao.getInicio());
                evento.setHoraFinal(reuniao.getTermino());
                if (reuniao.getUsuario() != null) {
                    evento.setNome(reuniao.getUsuario().getNome());
                }
                evento.setLocal(reuniao.getLocal());
                evento.setStatus(reuniao.getStatus());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Reuni\u00e3o");
                eventos.add(evento);
            }
        }
        if ((informacoesDB = this.relacaoInstitucionalService.findRegistrosInformacoes(new FindRegistrosInformacoesDTO(empresasInt, null, idArea, entidadesLst, dataInicial, dataFinal, idResponsavel), Pageable.unpaged())) != null) {
            for (RegistroInformacao informacao : informacoesDB) {
                CalendarioEvento evento = new CalendarioEvento();
                evento.setId(informacao.getId().toString());
                evento.setIdEmpresa(informacao.getIdEmpresa());
                evento.setNome(informacao.getNomeStakeholder());
                evento.setTitulo(informacao.getAssunto());
                evento.setDescricao(informacao.getObservacao());
                evento.setData(informacao.getDataInformacao());
                evento.setModulo(TipoModulo.RELACOES_INSTITUCIONAIS.getSigla());
                evento.setModuloItem("Informa\u00e7\u00e3o");
                eventos.add(evento);
            }
        }
        return eventos;
    }
}

