/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.pleitos.assunto.CreateAssuntoPleitoDTO;
import br.gov.antt.sgctt.core.dto.pleitos.enquadramento.CreateEnquadramentoPleitoDTO;
import br.gov.antt.sgctt.core.dto.pleitos.status.SavePleitoStatusDTO;
import br.gov.antt.sgctt.core.dto.pleitos.tipoObra.CreateTipoObraPleitoDTO;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.pleitos.AssuntoPleito;
import br.gov.antt.sgctt.pleitos.EnquadramentoPleito;
import br.gov.antt.sgctt.pleitos.PleitoStatus;
import br.gov.antt.sgctt.pleitos.PrioridadePleito;
import br.gov.antt.sgctt.pleitos.TipoObraPleito;
import br.gov.antt.sgctt.pleitos.TipoPleito;
import br.gov.antt.sgctt.services.CadastrosPleitoService;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="pleitos", description="REST Services para cadastro de informa\u00e7\u00f5es de pleitos")
@Validated
@RequestMapping(value={"/api/cadastros/pleitos"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010#\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J*\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010'\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010)\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010'\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010+\u001a\b\u0012\u0004\u0012\u00020,0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020-H\u0017J(\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0013H\u0017J\u001a\u0010.\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u00100\u001a\u00020\u0016H\u0017J*\u00101\u001a\b\u0012\u0004\u0012\u00020,0\r2\b\b\u0001\u00100\u001a\u00020\u00162\b\b\u0001\u0010 \u001a\u00020-2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u00102\u001a\u0002032\b\b\u0001\u00100\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u00104\u001a\b\u0012\u0004\u0012\u0002050\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u000206H\u0017JB\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000205080\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u00132\u0010\b\u0001\u00109\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000e2\u0006\u0010:\u001a\u00020;H\u0017J \u0010<\u001a\b\u0012\u0004\u0012\u0002050\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010=\u001a\u00020\u0016H\u0017J*\u0010>\u001a\b\u0012\u0004\u0012\u0002050\r2\b\b\u0001\u0010=\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u000206H\u0017J\u001a\u0010?\u001a\u0002032\b\b\u0001\u0010=\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J \u0010@\u001a\b\u0012\u0004\u0012\u00020A0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020BH\u0017J(\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0013H\u0017J \u0010D\u001a\b\u0012\u0004\u0012\u00020A0\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010E\u001a\u00020\u0016H\u0017J*\u0010F\u001a\b\u0012\u0004\u0012\u00020A0\r2\b\b\u0001\u0010E\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020BH\u0017J\u001a\u0010G\u001a\u0002032\b\b\u0001\u0010E\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lbr/gov/antt/sgctt/apis/CadastrosPleitosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "cadastrosPleitoService", "Lbr/gov/antt/sgctt/services/CadastrosPleitoService;", "<init>", "(Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CadastrosPleitoService;)V", "logger", "Lorg/slf4j/Logger;", "findTiposPleito", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/gov/antt/sgctt/pleitos/TipoPleito;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "getTipoPleitoById", "idTipoPleito", "", "saveTiposPleito", "pleito", "deleteTipoPleito", "", "findStatusPleito", "Lbr/gov/antt/sgctt/pleitos/PleitoStatus;", "getStatusPleitoById", "idStatusPleito", "saveStatusPleito", "dto", "Lbr/gov/antt/sgctt/core/dto/pleitos/status/SavePleitoStatusDTO;", "deleteStatusPleito", "idStatus", "findPrioridadesPleito", "Lbr/gov/antt/sgctt/pleitos/PrioridadePleito;", "getPrioridadePleitoById", "idPrioridade", "savePrioridadePleito", "prioridade", "deletePrioridadePleito", "saveAssuntoPleito", "Lbr/gov/antt/sgctt/pleitos/AssuntoPleito;", "Lbr/gov/antt/sgctt/core/dto/pleitos/assunto/CreateAssuntoPleitoDTO;", "findAssuntoPleito", "search", "idAssunto", "editAssuntoPleito", "deleteAssuntoPleito", "", "saveEnquadramentoPleito", "Lbr/gov/antt/sgctt/pleitos/EnquadramentoPleito;", "Lbr/gov/antt/sgctt/core/dto/pleitos/enquadramento/CreateEnquadramentoPleitoDTO;", "findEnquadramentosPleito", "Lorg/springframework/data/domain/Page;", "idCoordenacao", "pageable", "Lorg/springframework/data/domain/Pageable;", "findEnquadramentoPleitoById", "idEnquadramento", "editEnquadramentoPleito", "deleteEnquadramentoPleito", "saveTipoObraPleito", "Lbr/gov/antt/sgctt/pleitos/TipoObraPleito;", "Lbr/gov/antt/sgctt/core/dto/pleitos/tipoObra/CreateTipoObraPleitoDTO;", "findTiposObraPleito", "findTipoObraPleitoById", "idTipoObra", "editTipoObraPleito", "deleteTipoObraPleito", "server"})
@SourceDebugExtension(value={"SMAP\nCadastrosPleitosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CadastrosPleitosRestServices.kt\nbr/gov/antt/sgctt/apis/CadastrosPleitosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,887:1\n2642#2:888\n2642#2:890\n1863#2,2:892\n1#3:889\n1#3:891\n*S KotlinDebug\n*F\n+ 1 CadastrosPleitosRestServices.kt\nbr/gov/antt/sgctt/apis/CadastrosPleitosRestServices\n*L\n71#1:888\n196#1:890\n323#1:892,2\n71#1:889\n196#1:891\n*E\n"})
public class CadastrosPleitosRestServices
extends BaseRestService {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CadastrosPleitoService cadastrosPleitoService;
    @NotNull
    private final Logger logger;

    public CadastrosPleitosRestServices(@NotNull CoreService coreService, @NotNull SegurancaService segurancaService, @NotNull CadastrosPleitoService cadastrosPleitoService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)cadastrosPleitoService, (String)"cadastrosPleitoService");
        super(segurancaService);
        this.coreService = coreService;
        this.segurancaService = segurancaService;
        this.cadastrosPleitoService = cadastrosPleitoService;
        Logger logger = LoggerFactory.getLogger(CadastrosPleitosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @GetMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Retorna os tipos de pleitos", description="Busca todos os tipos de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Tipos de pleitos encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<TipoPleito>> findTiposPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findTiposPleito(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findTiposPleitos(search, Boolean.valueOf(true));
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                TipoPleito it = (TipoPleito)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List tipos = (List)iterable;
            responseEntity = new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idTipoPleito}/tipoPleito"})
    @Operation(summary="Busca o tipo do pleito conforme seu identificador.", description="Retorna os detalhes de um tipo de pleito espec\u00edfico com base no seu ID.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<TipoPleito> getTipoPleitoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do tipo de pleito") @PathVariable(name="idTipoPleito") int idTipoPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getTipoPleitoById({}, {})", (Object)empresa, (Object)idTipoPleito);
            responseEntity = ResponseEntity.ok((Object)this.cadastrosPleitoService.getTipoPleitoById(Integer.valueOf(idTipoPleito)));
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getStatusAgenciaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Salva os tipos de pleito a partir de seu payload", description="Cria ou atualiza um tipo de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoPleito> saveTiposPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do tipo de pleito a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull TipoPleito pleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)pleito, (String)"pleito");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveTiposPleito({}, {})", (Object)empresa, (Object)pleito);
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoPleito(pleito, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idTipoPleito}/tipos"})
    @Operation(summary="Exclui o tipo de pleito de acordo com seu ID.", description="Remove permanentemente um tipo de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Tipo de pleito exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteTipoPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do tipo de pleito a ser exclu\u00eddo") @PathVariable int idTipoPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteTipoPleito({}, {})", (Object)empresa, (Object)idTipoPleito);
            this.cadastrosPleitoService.deleteTipoPleito(Integer.valueOf(idTipoPleito));
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteTipoPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/status"})
    @Operation(summary="Retorna os status de pleitos", description="Busca todos os status de pleitos dispon\u00edveis, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Status de pleitos encontrados com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PleitoStatus>> findStatusPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findStatusPleito(emp={})...", (Object)empresa);
        try {
            Iterable iterable;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Empresa empresaDB = empresa2;
            String search = request.getParameter("search");
            Iterable $this$onEach$iv = this.cadastrosPleitoService.findStatusPleito(empresaDB.getId(), search);
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                PleitoStatus it = (PleitoStatus)element$iv;
                boolean bl2 = false;
                it.setDatHorCadastro(null);
                it.setIdUsuarioIns(null);
                it.setDatHorAlteracao(null);
                it.setIdUsuarioUpd(null);
            }
            List status = (List)iterable;
            responseEntity = new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findStatusPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/{idStatusPleito}/status"})
    @Operation(summary="Busca o status de pleito conforme seu identificador.", description="Retorna os detalhes do status de pleito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito encontrado com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PleitoStatus> getStatusPleitoById(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do status de pleito") @PathVariable int idStatusPleito, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("getStatusPleitoById({})", (Object)idStatusPleito);
            responseEntity = ResponseEntity.ok((Object)this.cadastrosPleitoService.getStatusPleitoById(Integer.valueOf(idStatusPleito)));
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getStatusPleitoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @PostMapping(value={"/{empresa}/status"})
    @Operation(summary="Salva os status de pleito a partir de seu payload", description="Cria ou atualiza um status de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PleitoStatus> saveStatusPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @RequestBody(description="Dados do status de pleito a ser salvo", required=true) @Valid @org.springframework.web.bind.annotation.RequestBody @NotNull SavePleitoStatusDTO dto, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("saveStatusPleito({})", (Object)dto);
            Integer n = usr.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            responseEntity = new ResponseEntity((Object)this.cadastrosPleitoService.saveStatusPleito(empresa, dto, ((Number)n).intValue()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{empresa}/{idStatus}/status"})
    @Operation(summary="Exclui o status de pleito de acordo com seu ID.", description="Remove permanentemente um status de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Status de pleito exclu\u00eddo com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deleteStatusPleito(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @Parameter(description="Identificador do status de pleito a ser exclu\u00eddo") @PathVariable int idStatus, @NotNull HttpServletRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            this.logger.debug("deleteStatusPleito({}, {})", (Object)empresa, (Object)idStatus);
            this.cadastrosPleitoService.deleteStatusPleito(Integer.valueOf(idStatus));
            responseEntity = new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deleteStatusPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        return responseEntity;
    }

    @GetMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Localiza as prioridades de pleito de acordo com a empresa", description="Busca todas as prioridades de pleito dispon\u00edveis para uma empresa, com op\u00e7\u00e3o de filtro por texto.")
    @ApiResponses(value={@ApiResponse(description="Prioridades de pleito encontradas com sucesso.", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PrioridadePleito>> findPrioridadesPleito(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.logger.debug("API findPrioridades(emp={})...", (Object)empresa);
        String search = request.getParameter("search");
        try {
            List prioridades;
            Empresa empresa2 = this.coreService.getEmpresaBySigla(empresa);
            if (empresa2 == null) {
                throw new ErrorCodeException(ErrorCode.EMPRESA_NOT_FOUND, new String[0]);
            }
            Empresa emp = empresa2;
            List list = prioridades = this.cadastrosPleitoService.findPrioridadesPleitos(emp.getId(), search);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PrioridadePleito prioridade = (PrioridadePleito)element$iv;
                    boolean bl = false;
                    prioridade.setDatHorCadastro(null);
                    prioridade.setIdUsuarioIns(null);
                    prioridade.setDatHorAlteracao(null);
                    prioridade.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)prioridades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findTiposPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exception.findTiposPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idPrioridade}/prioridadePleito"})
    @Operation(summary="Busca a prioridade do pleito conforme seu identificador.", description="Retorna os detalhes da prioridade de pleito com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito encontrada com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<PrioridadePleito> getPrioridadePleitoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da prioridade de pleito") @PathVariable(name="idPrioridade") int idPrioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("getPrioridadeById({}, {})", (Object)empresa, (Object)idPrioridade);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.cadastrosPleitoService.getPrioridadePleitoById(Integer.valueOf(idPrioridade)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getPrioridadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/prioridades"})
    @Operation(summary="Salva as prioridades de pleito a partir de seu payload", description="Cria ou atualiza uma prioridade de pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito criada com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<PrioridadePleito> savePrioridadePleito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @RequestBody(description="Dados da prioridade de pleito a ser salva", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull PrioridadePleito prioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)prioridade, (String)"prioridade");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.logger.debug("savePrioridadePleito({}, {})", (Object)empresa, (Object)prioridade);
            return new ResponseEntity((Object)this.cadastrosPleitoService.savePrioridadePleito(prioridade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.savePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idPrioridade}/prioridades"})
    @Operation(summary="Exclui a prioridade do pleito de acordo com seu ID.", description="Remove permanentemente uma prioridade de pleito do sistema utilizando seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Prioridade de pleito exclu\u00edda com sucesso.", responseCode="200")})
    @NotNull
    public ResponseEntity<Boolean> deletePrioridadePleito(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador da prioridade de pleito a ser exclu\u00edda") @PathVariable(name="idPrioridade") int idPrioridade, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.logger.debug("deleteNivelAgencia({}, {})", (Object)empresa, (Object)idPrioridade);
            this.cadastrosPleitoService.deletePrioridadePleito(Integer.valueOf(idPrioridade));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.deletePrioridadePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/assunto"})
    @Operation(summary="Salva um assunto pleito a partir de seu payload", description="Cria ou atualiza um assunto pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Assunto pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<AssuntoPleito> saveAssuntoPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateAssuntoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveAssuntoPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/assunto"})
    @Operation(summary="Lista todos Assunto Pleito", description="Lista todos Assunto Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<List<AssuntoPleito>> findAssuntoPleito(@NotNull HttpServletRequest request, @RequestParam(required=false) @Nullable String search) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findAssuntosPleito(search), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Lista Assunto Pleito de acordo com identificador informado.", description="Lista Assunto Pleito de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public AssuntoPleito findAssuntoPleito(@NotNull HttpServletRequest request, @PathVariable int idAssunto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            AssuntoPleito assuntoPleito = this.cadastrosPleitoService.findAssuntoPleitoById(Integer.valueOf(idAssunto));
            Intrinsics.checkNotNullExpressionValue((Object)assuntoPleito, (String)"findAssuntoPleitoById(...)");
            return assuntoPleito;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Edi\u00e7\u00e3o de assunto pleito via identificador.", description="Edi\u00e7\u00e3o de assunto pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<AssuntoPleito> editAssuntoPleito(@RequestBody(description="ID do Assunto Pleito \u00e0 ser editado.", required=true) @PathVariable int idAssunto, @RequestBody(description="ID do Assunto Pleito \u00e0 ser editado.", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull CreateAssuntoPleitoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editAssuntoPleito(Integer.valueOf(idAssunto), dto, usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/assunto/{idAssunto}"})
    @Operation(summary="Dele\u00e7\u00e3o de assunto pleito via identificador.", description="Dele\u00e7\u00e3o de assunto pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteAssuntoPleito(@RequestBody(description="ID do Assunto Pleito \u00e0 ser deletado.", required=true) @PathVariable int idAssunto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteAssuntoPleito(Integer.valueOf(idAssunto));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/enquadramento"})
    @Operation(summary="Salva um enquadramento pleito a partir de seu payload", description="Cria ou atualiza um enquadramento pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Enquadramento pleito criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> saveEnquadramentoPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateEnquadramentoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveEnquadramentoPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/enquadramento"})
    @Operation(summary="Lista todos Enquadramento Pleito", description="Lista todos Enquadramento Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<Page<EnquadramentoPleito>> findEnquadramentosPleito(@NotNull HttpServletRequest request, @RequestParam(name="search", required=false) @Nullable String search, @RequestParam(name="idCoordenacao", required=false) @Nullable List<Integer> idCoordenacao, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findEnquadramentosPleito(search, idCoordenacao, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Lista todos Enquadramento Pleito", description="Lista todos Enquadramento Pleito.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> findEnquadramentoPleitoById(@NotNull HttpServletRequest request, @PathVariable int idEnquadramento) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findEnquadramentoPleitoById(Integer.valueOf(idEnquadramento)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Edi\u00e7\u00e3o de enquadramento pleito via identificador.", description="Edi\u00e7\u00e3o de enquadramento pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<EnquadramentoPleito> editEnquadramentoPleito(@RequestBody(description="ID do Enquadramento Pleito \u00e0 ser editado.", required=true) @PathVariable int idEnquadramento, @NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateEnquadramentoPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editEnquadramentoPleito(dto, Integer.valueOf(idEnquadramento), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/enquadramento/{idEnquadramento}"})
    @Operation(summary="Dele\u00e7\u00e3o de enquadramento pleito via identificador.", description="Dele\u00e7\u00e3o de enquadramento pleito via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteEnquadramentoPleito(@RequestBody(description="ID do Enquadramento Pleito \u00e0 ser deletado.", required=true) @PathVariable int idEnquadramento, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteEnquadramentoPleito(Integer.valueOf(idEnquadramento));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tipoObra"})
    @Operation(summary="Salva um tipo de obra do pleito a partir de seu payload", description="Cria ou atualiza um tipo de obra do pleito com os dados fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Tipo de obra criado com sucesso.", responseCode="201")})
    @NotNull
    public ResponseEntity<TipoObraPleito> saveTipoObraPleito(@NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateTipoObraPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.saveTipoObraPleito(dto, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipoObra"})
    @Operation(summary="Lista todos Tipos de Obra", description="Lista todos Tipos de Obra.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<List<TipoObraPleito>> findTiposObraPleito(@NotNull HttpServletRequest request, @RequestParam(required=false) @Nullable String search) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findTiposObraPleito(search), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Retorna um Tipos de Obra de acordo com seu identificador", description="Retorna um Tipos de Obra de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<TipoObraPleito> findTipoObraPleitoById(@NotNull HttpServletRequest request, @PathVariable int idTipoObra) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.findTipoObraPleitoById(Integer.valueOf(idTipoObra)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Edi\u00e7\u00e3o de Tipos de Obra via identificador.", description="Edi\u00e7\u00e3o de Tipos de Obra via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @NotNull
    public ResponseEntity<TipoObraPleito> editTipoObraPleito(@RequestBody(description="ID do Tipo Obra Pleito \u00e0 ser editado.", required=true) @PathVariable int idTipoObra, @NotNull HttpServletRequest request, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull CreateTipoObraPleitoDTO dto) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.cadastrosPleitoService.editTipoObraPleito(dto, Integer.valueOf(idTipoObra), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tipoObra/{idTipoObra}"})
    @Operation(summary="Dele\u00e7\u00e3o de Tipos de Obra via identificador.", description="Dele\u00e7\u00e3o de Tipos de Obra via identificador.")
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    public void deleteTipoObraPleito(@RequestBody(description="ID do Tipo de Obra \u00e0 ser deletado.", required=true) @PathVariable int idTipoObra, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.cadastrosPleitoService.deleteTipoObraPleito(Integer.valueOf(idTipoObra));
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveFaixaValor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

