/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.seguranca.UsuarioSessao;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0004J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lbr/gov/antt/sgctt/apis/BaseRestService;", "", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;)V", "LOCALHOST_IPV4", "", "LOCALHOST_IPV6", "AUTHORIZATION_PROPERTY", "AUTHENTICATION_SCHEME", "logger", "Lorg/slf4j/Logger;", "getUsuarioByJWT", "Lbr/gov/antt/sgctt/core/beans/seguranca/PublicUser;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "getPrivateUsuarioByJWT", "Lbr/gov/antt/sgctt/core/beans/seguranca/Usuario;", "getToken", "getUsuarioByToken", "bearerToken", "getSessaoUsuarioByToken", "Lbr/gov/antt/sgctt/seguranca/UsuarioSessao;", "getIpExterno", "server"})
@SourceDebugExtension(value={"SMAP\nBaseRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseRestServices.kt\nbr/gov/antt/sgctt/apis/BaseRestService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public class BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final String LOCALHOST_IPV4;
    @NotNull
    private final String LOCALHOST_IPV6;
    @NotNull
    private final String AUTHORIZATION_PROPERTY;
    @NotNull
    private final String AUTHENTICATION_SCHEME;
    @NotNull
    private final Logger logger;

    public BaseRestService(@NotNull SegurancaService segurancaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        this.segurancaService = segurancaService;
        this.LOCALHOST_IPV4 = "127.0.0.1";
        this.LOCALHOST_IPV6 = "0:0:0:0:0:0:0:1";
        this.AUTHORIZATION_PROPERTY = "Authorization";
        this.AUTHENTICATION_SCHEME = "Bearer";
        Logger logger = LoggerFactory.getLogger(BaseRestService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Nullable
    protected final PublicUser getUsuarioByJWT(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof UsernamePasswordAuthenticationToken && ((UsernamePasswordAuthenticationToken)authentication).getPrincipal() instanceof Usuario) {
            Object object = ((UsernamePasswordAuthenticationToken)authentication).getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type br.gov.antt.sgctt.core.beans.seguranca.Usuario");
            return new PublicUser((Usuario)object);
        }
        String bearerToken = this.getToken(request);
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        return new PublicUser(sessao.getUsuario());
    }

    @Nullable
    protected final Usuario getPrivateUsuarioByJWT(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof UsernamePasswordAuthenticationToken && ((UsernamePasswordAuthenticationToken)authentication).getPrincipal() instanceof Usuario) {
            Object object = ((UsernamePasswordAuthenticationToken)authentication).getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type br.gov.antt.sgctt.core.beans.seguranca.Usuario");
            return (Usuario)object;
        }
        String bearerToken = this.getToken(request);
        return this.segurancaService.getSessaoUsuarioByToken(bearerToken).getUsuario();
    }

    @NotNull
    protected final String getToken(@NotNull HttpServletRequest request) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                String string3 = request.getHeader("Authorization");
                if (string3 == null) break block2;
                String it = string = string3;
                boolean bl = false;
                String string4 = string2 = StringsKt.startsWith$default((String)it, (String)"Bearer ", (boolean)false, (int)2, null) ? string : null;
                if (string2 == null) break block2;
                String string5 = string2.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string = string5;
                if (string != null) break block3;
            }
            throw new ErrorCodeException(ErrorCode.INVALID_USER_TOKEN, new String[0]);
        }
        return string;
    }

    @Nullable
    protected final PublicUser getUsuarioByToken(@Nullable String bearerToken) {
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        return new PublicUser(sessao.getUsuario());
    }

    @Nullable
    protected final UsuarioSessao getSessaoUsuarioByToken(@Nullable String bearerToken) {
        return this.segurancaService.getSessaoUsuarioByToken(bearerToken);
    }

    @Nullable
    public final String getIpExterno(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (!StringUtils.hasText((String)ipAddress) || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (!StringUtils.hasText((String)ipAddress) || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((!StringUtils.hasText((String)ipAddress) || StringsKt.equals((String)"unknown", (String)ipAddress, (boolean)true)) && (Intrinsics.areEqual((Object)this.LOCALHOST_IPV4, (Object)(ipAddress = request.getRemoteAddr())) || Intrinsics.areEqual((Object)this.LOCALHOST_IPV6, (Object)ipAddress))) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLocalHost(...)");
                InetAddress inetAddress2 = inetAddress;
                ipAddress = inetAddress2.getHostAddress();
            }
            catch (UnknownHostException uheExc) {
                this.logger.error("UHExc", (Throwable)uheExc);
            }
        }
        if (StringUtils.hasText((String)ipAddress) && ipAddress.length() > 15) {
            String string = ipAddress;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.indexOf$default((CharSequence)string, (String)",", (int)0, (boolean)false, (int)6, null) > 0) {
                string = ipAddress;
                Intrinsics.checkNotNull((Object)string);
                int n = 0;
                String string2 = ipAddress;
                Intrinsics.checkNotNull((Object)string2);
                int n2 = StringsKt.indexOf$default((CharSequence)string2, (String)",", (int)0, (boolean)false, (int)6, null);
                String string3 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                ipAddress = string3;
            }
        }
        return ipAddress;
    }
}

