/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.beans.geral.Empresa;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

/*
 * Exception performing whole class analysis ignored.
 */
public class TokenAuthenticationService {
    private static Logger logger = LoggerFactory.getLogger(TokenAuthenticationService.class);
    static final long EXPIRATION_TIME_TOKEN = 36000000L;
    static final long EXPIRATION_TIME_REFRESH = 172800000L;
    static final String SECRET = "G3scon#21";
    static final String TOKEN_PREFIX = "Bearer";
    static final String HEADER_STRING = "Authorization";

    static String addAuthentication(HttpServletResponse response, String username, List<Empresa> empresas, String tipoDemanda) throws IOException {
        String jwt = TokenAuthenticationService.createToken((String)username);
        LinkedHashMap<String, Object> tokenData = new LinkedHashMap<String, Object>();
        tokenData.put("token", jwt);
        tokenData.put("refresh_token", TokenAuthenticationService.createRefreshToken((String)username));
        if (empresas != null && !empresas.isEmpty()) {
            tokenData.put("empresas", empresas);
        }
        tokenData.put("tipo", tipoDemanda);
        response.addHeader("Authorization", "Bearer " + jwt);
        response.setContentType("application/json;charset=UTF-8");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String responseData = mapper.writeValueAsString(tokenData);
            response.getWriter().write(responseData);
        }
        catch (JsonProcessingException jsonExc) {
            logger.error("jsonExc:", (Throwable)jsonExc);
            response.getWriter().write(jsonExc.getMessage());
        }
        response.getWriter().flush();
        response.getWriter().close();
        return jwt;
    }

    public static String createToken(String userName) {
        String jwt = Jwts.builder().setSubject(userName).setExpiration(new Date(System.currentTimeMillis() + 36000000L)).signWith(SignatureAlgorithm.HS512, "G3scon#21").compact();
        return jwt;
    }

    static String createRefreshToken(String userName) {
        String jwt = Jwts.builder().setSubject(userName).setExpiration(new Date(System.currentTimeMillis() + 172800000L)).signWith(SignatureAlgorithm.HS512, "G3scon#21").compact();
        return jwt;
    }

    static Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null && token.contains("Bearer")) {
            try {
                String user = ((Claims)Jwts.parser().setSigningKey("G3scon#21").parseClaimsJws(token.replace("Bearer", "")).getBody()).getSubject();
                if (user != null) {
                    return new UsernamePasswordAuthenticationToken((Object)user, null, Collections.emptyList());
                }
            }
            catch (SignatureException sigExc) {
                return null;
            }
            catch (ExpiredJwtException sigExc) {
                logger.debug("token expirado: {}", (Object)token);
                return null;
            }
        }
        return null;
    }
}

