/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.TipoEventoAuditoria;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSessao;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.spring.security.CustomRestAuthenticationFailureHandler;
import br.com.oti.gesconsys.spring.security.TokenAuthenticationService;
import br.com.oti.gesconsys.validators.CNPJValidator;
import br.com.oti.gesconsys.validators.CPFValidator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JwtLoginFilter
extends AbstractAuthenticationProcessingFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(JwtLoginFilter.class);
    private SegurancaService segurancaService;
    private CadastroService cadastroService;
    private CoreService coreService;
    private Usuario usuario = null;
    private List<UsuarioEmpresa> empresasUser = null;
    private String tipoDemanda = null;
    private List<String> modulosAtivos = null;

    public JwtLoginFilter(String url, AuthenticationManager authManager, CadastroService cadastroService, CoreService coreService, SegurancaService segurancaService) {
        super((RequestMatcher)new AntPathRequestMatcher(url));
        this.setAuthenticationManager(authManager);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new CustomRestAuthenticationFailureHandler());
        this.cadastroService = cadastroService;
        this.coreService = coreService;
        this.segurancaService = segurancaService;
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        AuthLogin credentials = (AuthLogin)new ObjectMapper().readValue((InputStream)request.getInputStream(), AuthLogin.class);
        if (credentials == null || credentials.getUserName() == null || credentials.getPassword() == null) {
            throw new AuthenticationCredentialsNotFoundException("Usu\u00e1rio/Senha inv\u00e1lidos.");
        }
        try {
            String microservice = request.getHeader("X-FROM-MICROSERVICE");
            if (microservice != null && !microservice.isEmpty()) {
                if (microservice.equals("SCHEDULER") || microservice.equals("EXTRACTOR")) {
                    String userApi = (String)this.coreService.getRefValueByName(null, TipoRefCode.SCHEDULER_USUARIO_API);
                    if (userApi != null && userApi.equals(credentials.getUserName())) {
                        PublicUser usuario = this.segurancaService.getUsuarioByLogin(credentials.getUserName());
                        UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usuario.getId());
                        credentials.setPassword(perfil.getSenha());
                    }
                } else if (microservice.equals("SSO-SAML2")) {
                    LOG.debug("Autenticando via SSO, usu\u00e1rio: {}", (Object)credentials.getUserName());
                    PublicUser usuario = this.segurancaService.getUsuarioByLogin(credentials.getUserName());
                    UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usuario.getId());
                    credentials.setPassword(perfil.getSenha());
                }
            }
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)credentials, (Object)credentials.getPassword(), Collections.emptyList());
            Authentication authObj = this.getAuthenticationManager().authenticate((Authentication)token);
            this.postLogin(authObj, request);
            return authObj;
        }
        catch (BadCredentialsException badExc) {
            throw new AuthenticationCredentialsNotFoundException("Verifique o usu\u00e1rio e/ou senha informada.");
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Authentication auth) throws IOException, ServletException {
        String agenteLow;
        ArrayList<Empresa> empresas = null;
        if (this.empresasUser != null && !this.empresasUser.isEmpty()) {
            empresas = new ArrayList<Empresa>();
            for (UsuarioEmpresa empUser : this.empresasUser) {
                Empresa emp = new Empresa();
                emp.setId(empUser.getId().getIdEmpresa());
                emp.setRazaoSocial(empUser.getEmpresa().getRazaoSocial());
                emp.setNomeFantasia(empUser.getEmpresa().getNomeFantasia());
                emp.setSigla(empUser.getEmpresa().getSigla());
                emp.setSiglaAdicional(empUser.getEmpresa().getSiglaAdicional());
                empresas.add(emp);
            }
        }
        String tokenJwt = TokenAuthenticationService.addAuthentication((HttpServletResponse)response, (String)this.usuario.getLogin(), empresas, (String)this.tipoDemanda);
        UsuarioSessao sessao = new UsuarioSessao();
        String agente = request.getHeader("User-Agent");
        sessao.setUserAgent(agente);
        sessao.setIpAcesso(request.getRemoteAddr());
        sessao.setSessionApi(tokenJwt);
        sessao.getId().setIdUsuario(this.usuario.getId());
        sessao.setDatHorLogin(new Date(System.currentTimeMillis()));
        sessao.setCanal("W");
        if (agente != null && ((agenteLow = agente.toLowerCase().trim()).contains("reactornetty/") || agenteLow.contains("dart/"))) {
            sessao.setCanal("M");
        }
        this.segurancaService.registraSessao(sessao, this.usuario.getId());
    }

    public Boolean postLogin(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        try {
            Integer tipoDocto;
            String userName = null;
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                userName = ((UsernamePasswordAuthenticationToken)authentication).getPrincipal().toString();
            } else if (authentication instanceof AuthLogin) {
                userName = ((AuthLogin)authentication).getUserName();
            } else if (authentication.getPrincipal() instanceof AuthLogin) {
                userName = ((AuthLogin)authentication.getPrincipal()).getUserName();
            }
            if (userName == null || userName.isEmpty()) {
                throw new AuthenticationCredentialsNotFoundException("Usu\u00e1rio n\u00e3o informado.");
            }
            this.usuario = this.segurancaService.getUsuarioByLoginOrMail(userName);
            if (this.usuario == null) {
                throw new AuthenticationCredentialsNotFoundException("Usu\u00e1rio informado n\u00e3o foi encontrado.");
            }
            if (!this.segurancaService.validaUsuario(this.usuario.getId()).booleanValue()) {
                throw new AuthenticationCredentialsNotFoundException("Usu\u00e1rio inv\u00e1lido, verifique dados de acesso.");
            }
            this.empresasUser = this.segurancaService.findEmpresasByUsuario(this.usuario.getId());
            if (this.empresasUser == null || this.empresasUser.isEmpty()) {
                throw new AuthenticationCredentialsNotFoundException("Usu\u00e1rio n\u00e3o est\u00e1 associado a nenhuma empresa.");
            }
            Integer selEmpresa = ((UsuarioEmpresa)this.empresasUser.get(0)).getId().getIdEmpresa();
            Empresa empresa = this.cadastroService.getEmpresaById(selEmpresa);
            if (empresa == null) {
                throw new AuthenticationCredentialsNotFoundException("Empresa informada n\u00e3o foi encontrada.");
            }
            String[] empresaUser = null;
            Iterator iterator = this.empresasUser.iterator();
            if (iterator.hasNext()) {
                String[] usrEmp = (String[])iterator.next();
                if (usrEmp.getEmpresa().getTipoEmpresa() == 2) {
                    if (empresaUser == null) {
                        empresaUser = usrEmp;
                    }
                } else if (empresaUser == null) {
                    empresaUser = usrEmp;
                }
            }
            this.modulosAtivos = new ArrayList();
            String rawModulos = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_MODULOS_ATIVOS);
            if (rawModulos != null && !rawModulos.isEmpty()) {
                for (String rawMod : rawModulos.split(";")) {
                    TipoModulo modulo = TipoModulo.fromSigla((String)rawMod);
                    if (modulo == null) continue;
                    this.modulosAtivos.add(modulo.getSigla());
                }
            }
            this.tipoDemanda = this.usuario.getSubTipo();
            if (this.tipoDemanda == null || this.tipoDemanda.isEmpty()) {
                this.tipoDemanda = "DM";
            }
            if ((this.usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || this.usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) && this.tipoDemanda.contains("DM") && (tipoDocto = (Integer)this.coreService.getRefValueByName(empresa.getId(), TipoRefCode.SISDEMANDA_PERMITIR_CPFCNPJ)) != null) {
                Boolean cnpjValid;
                if (tipoDocto.equals(1)) {
                    Boolean cpfValid = CPFValidator.isValid((String)this.usuario.getLogin());
                    if (!cpfValid.booleanValue()) {
                        throw new AuthenticationCredentialsNotFoundException("CPF do usu\u00e1rio \u00e9 inv\u00e1lido.");
                    }
                } else if (tipoDocto.equals(2) && !(cnpjValid = Boolean.valueOf(CNPJValidator.isValid((String)this.usuario.getLogin()))).booleanValue()) {
                    throw new AuthenticationCredentialsNotFoundException("CNPJ do usu\u00e1rio \u00e9 inv\u00e1lido.");
                }
            }
            this.segurancaService.registraAuditoria(empresaUser.getId().getIdEmpresa(), String.format("Login Mobile com sucesso, usu\u00e1rio '%s'", this.usuario.getLogin()), this.usuario.getId(), TipoEventoAuditoria.EVENTO_LOGIN.getCode(), request.getRemoteAddr());
            this.segurancaService.registraUltimoLogin(this.usuario);
        }
        catch (BusinessException bizExc) {
            this.logger.error((Object)"BizExc:", (Throwable)bizExc);
            throw new AuthenticationCredentialsNotFoundException(bizExc.getMessage());
        }
        return true;
    }
}

