/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSsoLogin;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.server.helpers.LdapSearchRepoImpl;
import br.com.oti.gesconsys.utils.MD5Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static Logger LOG = LoggerFactory.getLogger(CustomAuthenticationProvider.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String plainPass;
        String userName;
        Authentication auth = authentication;
        String dominioLdap = null;
        if (auth instanceof AuthLogin) {
            principal = (AuthLogin)auth;
            if (auth.getPrincipal() == null) {
                throw new InternalAuthenticationServiceException(String.format("Usu\u00e1rio/Senha inv\u00e1lidos.", new Object[0]));
            }
            userName = principal.getUserName();
            plainPass = principal.getPassword();
            if (principal.getEmpresa() != null) {
                dominioLdap = principal.getEmpresa();
            }
        } else if (auth.getPrincipal() instanceof AuthLogin) {
            principal = (AuthLogin)auth.getPrincipal();
            userName = principal.getUserName();
            plainPass = principal.getPassword();
            if (principal.getEmpresa() != null) {
                dominioLdap = principal.getEmpresa();
            }
        } else if (auth instanceof UsernamePasswordAuthenticationToken) {
            principal = (UsernamePasswordAuthenticationToken)auth;
            userName = principal.getPrincipal().toString();
            plainPass = principal.getCredentials().toString();
        } else {
            userName = auth.getPrincipal().toString();
            plainPass = auth.getCredentials().toString();
        }
        Usuario user = null;
        UsuarioPerfil perfil = null;
        PublicUser ssoUser = this.handleSsoPreAuth(authentication);
        if (ssoUser != null) {
            LOG.debug("Encontrado Usu\u00e1rio SSO '{}", (Object)ssoUser.getLogin());
            perfil = this.segurancaService.getExtensaoPerfilByUsuario(ssoUser.getId());
            user = this.segurancaService.getUsuarioById(ssoUser.getId());
        }
        try {
            if (user == null) {
                user = this.segurancaService.getUsuarioByLoginOrMail(userName);
            }
        }
        catch (BusinessException bizExc) {
            throw new InternalAuthenticationServiceException("Usu\u00e1rio/Senha inv\u00e1lidos.");
        }
        if (user == null) {
            throw new InternalAuthenticationServiceException(String.format("Usu\u00e1rio/Senha inv\u00e1lidos.", userName));
        }
        if (user.getTipo().equals(TipoUsuario.ACESSO_EXTERNO_AD.getCode())) {
            String siglaEmpresa;
            Empresa emp;
            String domainName = null;
            String ldapUrl = null;
            String rootDn = null;
            String searchFilter = null;
            if (dominioLdap != null && !dominioLdap.isEmpty() && (emp = this.cadastroService.getEmpresaBySigla(siglaEmpresa = dominioLdap.toString().trim())) != null) {
                domainName = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_AD_DOMAIN);
                ldapUrl = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_AD_URL);
                rootDn = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_AD_DOMAIN_LDAP);
                searchFilter = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_AD_SEARCH);
            }
            if (domainName == null) {
                domainName = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_DOMAIN);
            }
            if (ldapUrl == null) {
                ldapUrl = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_URL);
            }
            if (rootDn == null) {
                rootDn = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_DOMAIN_LDAP);
            }
            if (searchFilter == null) {
                searchFilter = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_SEARCH);
            }
            if (ldapUrl == null) {
                throw new InternalAuthenticationServiceException("Configura\u00e7\u00f5es do AD n\u00e3o foram definidas, verifique.");
            }
            String adminUser = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_ADMIN_USER);
            String adminPwd = (String)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_AD_ADMIN_PASSWORD);
            if (adminUser != null && adminPwd != null) {
                LdapSearchRepoImpl searchRepo = new LdapSearchRepoImpl();
                Map userCn = searchRepo.getUserCommonName(ldapUrl, rootDn, domainName, userName, adminUser, adminPwd);
                if (userCn == null || userCn.isEmpty()) {
                    throw new InternalAuthenticationServiceException(String.format("Usu\u00e1rio/Senha inv\u00e1lidos.", userName));
                }
                if (userCn.containsKey("userPrincipalName")) {
                    userName = (String)userCn.get("userPrincipalName");
                    domainName = null;
                }
                if (userCn.containsKey("searchDn")) {
                    rootDn = (String)userCn.get("searchDn");
                }
                searchFilter = null;
            }
            try {
                LOG.trace("Auth.LDAP = {}, {}, {}, {}, {}", new Object[]{domainName, ldapUrl, rootDn, userName, plainPass});
                ActiveDirectoryLdapAuthenticationProvider adProvider = new ActiveDirectoryLdapAuthenticationProvider(domainName, ldapUrl, rootDn);
                adProvider.setConvertSubErrorCodesToExceptions(true);
                adProvider.setUseAuthenticationRequestCredentials(true);
                if (searchFilter != null) {
                    adProvider.setSearchFilter(searchFilter);
                }
                UsernamePasswordAuthenticationToken plainUser = UsernamePasswordAuthenticationToken.authenticated((Object)userName, (Object)plainPass, null);
                adProvider.authenticate((Authentication)plainUser);
            }
            catch (AuthenticationException authExc) {
                LOG.error("LDAP AuthenticadionExc: {}", (Throwable)authExc);
                throw new InternalAuthenticationServiceException(authExc.getMessage());
            }
            catch (Exception exc) {
                LOG.error("LDAP Error: {}", (Object)exc.toString());
                throw new InternalAuthenticationServiceException(exc.getMessage());
            }
        } else {
            List sessoes;
            LOG.debug("Autenticando pelo m\u00f3dulo de seguran\u00e7a [NORMAL]...");
            if (perfil == null) {
                String passwdMD5 = plainPass;
                if (!this.isValidMD5(plainPass)) {
                    passwdMD5 = MD5Utils.transformToMD5((String)plainPass);
                }
                if ((perfil = this.segurancaService.getUsuarioByAuth(user.getLogin(), passwdMD5)) == null) {
                    this.segurancaService.saveFalhasLogin(user.getId(), Integer.valueOf(1), null);
                    throw new InternalAuthenticationServiceException("Usu\u00e1rio/Senha inv\u00e1lidos.");
                }
            }
            if (perfil.isInativoFlag().booleanValue()) {
                throw new InternalAuthenticationServiceException("Usu\u00e1rio com acesso inativo.");
            }
            Boolean loginMultiplo = (Boolean)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_LOGIN_MULTIPLO);
            if (!loginMultiplo.booleanValue() && (sessoes = this.segurancaService.findSessoesByUsuario(user.getId(), Boolean.valueOf(true))) != null && sessoes.size() > 0) {
                throw new InternalAuthenticationServiceException("H\u00e1 sess\u00f5es ativas do usu\u00e1rio, imposs\u00edvel realizar nova autentica\u00e7\u00e3o.");
            }
            this.segurancaService.saveFalhasLogin(user.getId(), Integer.valueOf(0), null);
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("authenticated"));
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken((Object)userName, (Object)plainPass, authorities);
        if (ssoUser != null) {
            LOG.debug("cookies.session => {}", (Object)this.request.getRequestedSessionId());
            LOG.debug("session => {}", (Object)this.request.getSession(false));
            CompositeSessionAuthenticationStrategy sessionStrategy = new CompositeSessionAuthenticationStrategy(List.of(new ChangeSessionIdAuthenticationStrategy()));
            sessionStrategy.onAuthentication((Authentication)newAuth, this.request, this.response);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        return newAuth;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public boolean isValidMD5(String md5Txt) {
        Pattern pattern = Pattern.compile("^[a-fA-F0-9]{32}$");
        return pattern.matcher(md5Txt).matches();
    }

    private PublicUser handleSsoPreAuth(Authentication auth) {
        block15: {
            String userName;
            AuthLogin authLogin;
            block14: {
                this.segurancaService.cleanupSsoLogins();
                UsuarioSsoLogin loginSso = this.segurancaService.getLastSsoLogin(auth.getPrincipal().toString());
                if (loginSso == null) {
                    LOG.debug("N\u00e3o foi encontrado registro de SSO nos \u00faltimos 2 minutos.");
                    return null;
                }
                String tokenSso = loginSso.getTokenData();
                if (tokenSso == null) {
                    return null;
                }
                ObjectMapper mapper = new ObjectMapper();
                authLogin = null;
                ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
                try {
                    authLogin = (AuthLogin)mapper.readValue(tokenSso, AuthLogin.class);
                    if (authLogin == null) {
                        return null;
                    }
                    if (authLogin.getGroups() != null) {
                        for (String grupo : authLogin.getGroups()) {
                            authorities.add(new SimpleGrantedAuthority(grupo));
                        }
                        break block14;
                    }
                    return null;
                }
                catch (JsonMappingException jsonExc) {
                    LOG.error("JsonM Exc", (Throwable)jsonExc);
                    return null;
                }
                catch (JsonProcessingException jspExc) {
                    LOG.error("JsonP Exc", (Throwable)jspExc);
                    return null;
                }
            }
            if (auth.getPrincipal() instanceof AuthLogin) {
                AuthLogin authLoginSso = (AuthLogin)auth.getPrincipal();
                userName = authLoginSso.getUserName();
            } else {
                userName = auth.getPrincipal().toString();
            }
            if (userName.equals(authLogin.getUserName())) {
                try {
                    PublicUser userDB = this.segurancaService.getUsuarioByLogin(authLogin.getUserName());
                    if (userDB != null) {
                        return userDB;
                    }
                    break block15;
                }
                catch (BusinessException bizExc) {
                    LOG.error("Erro login: {}", (Throwable)bizExc);
                    return null;
                }
            }
            LOG.error("Usu\u00e1rio SSO '{}', n\u00e3o \u00e9 o mesmo que o login '{}'.", (Object)userName, (Object)authLogin.getUserName());
        }
        return null;
    }
}

