/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.servlets;

import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/*
 * Exception performing whole class analysis ignored.
 */
@WebServlet(value={"/viewFile"})
public class ViewFileServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(ViewFileServlet.class);
    private static final long serialVersionUID = -7198977235262211663L;
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    @Autowired
    private GedService gedService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String normalPath;
        File file;
        response.reset();
        BufferedOutputStream output = null;
        String path = request.getParameter("src");
        String uuid = request.getParameter("uuid");
        String idEmpresaTxt = request.getParameter("idEmpresa");
        String userName = request.getParameter("usuario");
        if (path != null && uuid == null && (file = this.loadFileFromPath(normalPath = path.replaceAll(":\\*:", "\\/").replaceAll(":\\*\\*:", "\\\\"))) != null) {
            try {
                response.setBufferSize(10240);
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Content-Disposition", String.format("inline;filename=\"%s\"", file.getName()));
                response.setContentLength(Long.valueOf(file.length()).intValue());
                response.setContentType(Files.probeContentType(file.toPath()));
                output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
                byte[] imgDataBa = new byte[(int)file.length()];
                DataInputStream dataIs = new DataInputStream(new FileInputStream(file));
                dataIs.readFully(imgDataBa);
                output.write(imgDataBa);
                dataIs.close();
            }
            catch (IOException ioExc) {
                logger.error("IOExc", (Throwable)ioExc);
                return;
            }
        }
        logger.debug("idEmpresa={}, uuid={}", (Object)idEmpresaTxt, (Object)uuid);
        if (idEmpresaTxt != null && uuid != null && !uuid.isEmpty()) {
            Integer idEmpresa = Integer.valueOf(idEmpresaTxt);
            UploadedFileInfo fileRepo = this.loadFromRepo(idEmpresa, uuid, userName);
            logger.debug("fileRepo.name={}", (Object)(fileRepo != null ? fileRepo.getFileName() : "null"));
            if (fileRepo != null) {
                try {
                    response.setHeader("Cache-Control", "no-cache");
                    response.setHeader("Content-Disposition", String.format("inline;filename=\"%s\"", fileRepo.getFileName()));
                    byte[] dataBytes = IOUtils.toByteArray((InputStream)fileRepo.getInputStream());
                    response.setContentLength(dataBytes.length);
                    response.setContentType(fileRepo.getContentType());
                    output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    output.write(dataBytes);
                    output.flush();
                    if (fileRepo.getInputStream() != null) {
                        fileRepo.getInputStream().close();
                    }
                }
                catch (IOException ioExc) {
                    logger.error("IOExc", (Throwable)ioExc);
                    return;
                }
            }
        }
        ViewFileServlet.close(output);
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException ioExc) {
                logger.error("IOExc", (Throwable)ioExc);
            }
        }
    }

    private File loadFileFromPath(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        logger.error(String.format("Arquivo '%s', n\u00e3o foi encontrado.", filePath));
        return null;
    }

    private UploadedFileInfo loadFromRepo(Integer idEmpresa, String nodeUuid, String usuario) {
        if (idEmpresa == null) {
            return null;
        }
        if (nodeUuid == null || nodeUuid.isEmpty()) {
            return null;
        }
        UploadedFileInfo stream = this.gedService.getFileInfoByUuid(idEmpresa, nodeUuid, Boolean.valueOf(true));
        if (usuario != null) {
            this.gedService.criarHistorico(idEmpresa, null, nodeUuid, "Visualiza\u00e7\u00e3o/Download de arquivo", usuario);
        }
        return stream;
    }
}

