/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.servlets;

import com.octo.captcha.engine.image.gimpy.DefaultGimpyEngine;
import com.octo.captcha.engine.image.utils.ImageToFile;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.service.CaptchaServiceException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/captcha"})
public class ImageCaptchaServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(ImageCaptchaServlet.class);
    private static final long serialVersionUID = 3060022914782258501L;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        byte[] captchaChallengeAsJpeg = null;
        try {
            try {
                DefaultGimpyEngine bge = new DefaultGimpyEngine();
                ImageCaptchaFactory factory = bge.getImageCaptchaFactory();
                ImageCaptcha pixCaptcha = factory.getImageCaptcha();
                request.getSession(true).setAttribute("textCaptcha", (Object)pixCaptcha.getTextChallenge());
                logger.debug(pixCaptcha.getTextChallenge());
                BufferedImage bi = pixCaptcha.getImageChallenge();
                StringBuilder captchaFileName = new StringBuilder();
                captchaFileName.append(System.getProperty("java.io.tmpdir")).append(File.separator);
                captchaFileName.append("captcha.jpg");
                File f = new File(captchaFileName.toString());
                ImageToFile.serialize((BufferedImage)bi, (File)f);
                FileInputStream bais = new FileInputStream(f);
                captchaChallengeAsJpeg = bais.readAllBytes();
                bais.close();
                response.setHeader("Cache-Control", "no-store");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", 0L);
                response.setContentType("image/jpeg");
                ServletOutputStream responseOutputStream = response.getOutputStream();
                responseOutputStream.write(captchaChallengeAsJpeg);
                responseOutputStream.flush();
                responseOutputStream.close();
            }
            catch (IllegalArgumentException argExc) {
                logger.error("ArgExc", (Throwable)argExc);
                response.sendError(404);
                return;
            }
            catch (CaptchaServiceException cptExc) {
                logger.error("CaptchaExc", (Throwable)cptExc);
                response.sendError(500);
                return;
            }
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
            return;
        }
    }
}

