/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.sigaco;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.sigaco.pla.PlanoAcaoElemento;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.business.services.SigacoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Planos de A\u00e7\u00e3o/Inspe\u00e7\u00f5es dos ativos", name="ativos")
@RequestMapping(value={"/api/sigaco/planosAcoes"})
public class PlanosAcoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(PlanosAcoesRestServices.class);
    @Autowired
    private SigacoService sigacoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/{tipoAtivo}/{idFase}"})
    public ResponseEntity<List<PlanoAcaoElemento>> findPlanosAcao(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idFase") Integer idFase, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_PLANOS_ACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_PLANOS_ACAO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findPlanosAcao({}, {}, {})", new Object[]{empresa, tipoAtivo, idFase});
            Integer elemento = null;
            String param = request.getParameter("elemento");
            if (param != null) {
                elemento = Integer.valueOf(param);
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.findPlanosAcao(empresa, tipoAtivo, idFase, elemento));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPlanosAcao", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/{idFase}/{sequencia}"})
    public ResponseEntity<PlanoAcaoElemento> getPlanoAcaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idFase") Integer idFase, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_PLANO_ACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_PLANO_ACAO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getPlanoAcaoById({}, {}, {}, {})", new Object[]{empresa, tipoAtivo, idFase, sequencia});
            return ResponseEntity.ok().body((Object)this.sigacoService.getPlanoAcaoById(empresa, idFase, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPlanoAcaoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

