/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.lab;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.lab.RelatorioMensalPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para relat\u00f3rio mensal", name="laboratorio")
@RequestMapping(value={"/api/relatorios"})
public class RelatoriosRestServices
extends BaseRestService {
    private static Logger LOG = LoggerFactory.getLogger(RelatoriosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private RelatorioMensalPdf relatorioMensalPdf;

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/mensal"})
    @Operation(summary="Exporta o relat\u00f3rio mensal em formato PDF")
    public ResponseEntity<byte[]> exportRelatorioMensal(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="unidades", required=false) List<String> unidades, @RequestParam(name="datInicial", defaultValue="", required=true) String datInicial, @RequestParam(name="datFinal", defaultValue="", required=true) String datFinal, @RequestParam(name="fornecedor", defaultValue="", required=true) Integer fornecedor, @RequestParam(name="contrato", defaultValue="", required=true) String contrato, @RequestParam(name="rodovias", required=false) List<Integer> rodovias) {
        LOG.debug("Executando exportRelatorioMensal(emp={})...", (Object)empresa);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_RELATORIO_MENSAL");
            if (!permissao.booleanValue()) {
                LOG.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_RELATORIO_MENSAL");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            LOG.debug("{} - exportRelatorioMensal (emp={};datIni={};datFim={};forn={},ctr={}))", new Object[]{usuario.getLogin(), empresa, datInicial, datFinal, fornecedor, contrato});
            if (datInicial == null || datInicial.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Data inicial n\u00e3o foi informada.");
            }
            if (datFinal == null || datFinal.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Data final n\u00e3o foi informada.");
            }
            if (fornecedor == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Fornecedor n\u00e3o foi informado.");
            }
            if (contrato == null || contrato.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Contrato n\u00e3o foi informado.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            if (multipartReq == null || multipartReq.getFileMap() == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 gr\u00e1ficos enviados.");
            }
            Map files = multipartReq.getFileMap();
            ArrayList<InputStream> graficos = new ArrayList<InputStream>();
            for (String fileName : files.keySet()) {
                graficos.add(((MultipartFile)files.get(fileName)).getInputStream());
            }
            if (graficos == null || graficos.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Gr\u00e1ficos de Ensaios Executados e Servi\u00e7os n\u00e3o foram enviados.");
            }
            byte[] bytes = this.relatorioMensalPdf.executePDF(emp, datInicial, datFinal, fornecedor, contrato, rodovias, graficos, usuario.getNome());
            if (bytes == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            LOG.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"relatorioMensal.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (BusinessException | IOException bizoExc) {
            LOG.error("bizExc", bizoExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizoExc.getMessage());
        }
    }
}

