/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.conserva;

import br.com.oti.gesconsys.beans.conserva.Contrato;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.Trecho;
import br.com.oti.gesconsys.beans.shared.Equipe;
import br.com.oti.gesconsys.beans.shared.GrupoServico;
import br.com.oti.gesconsys.beans.shared.Servico;
import br.com.oti.gesconsys.beans.shared.TipoAprovacao;
import br.com.oti.gesconsys.beans.solicitacao.OrdemServico;
import br.com.oti.gesconsys.beans.solicitacao.OrdemServicoItem;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Ordens de Servi\u00e7os", name="ordens-servicos")
@RequestMapping(value={"/api/ordensServico"})
public class OrdensServicosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(OrdensServicosRestServices.class);
    DateTimeFormatter sdfDataReq = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private ConservaService conservaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista as Ordens de servi\u00e7o agendadas, de acordo com os filtros (datInicial, datFinal, rodovia, trecho, equipe)")
    @ResponseBody
    public ResponseEntity<List<OrdemServico>> findOrdensServico(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        logger.debug("API search (empresa={})...", (Object)empresa);
        LocalDateTime datInicial = null;
        LocalDateTime datFinal = null;
        String rodovia = null;
        String trecho = null;
        String equipe = null;
        String parmVal = null;
        Rodovia rdv = new Rodovia();
        Trecho trc = new Trecho();
        Equipe eqp = new Equipe();
        Long lastUpdateVal = null;
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            parmVal = request.getParameter("datInicial");
            if (parmVal != null) {
                datInicial = LocalDateTime.parse(parmVal, this.sdfDataReq);
            }
            if ((parmVal = request.getParameter("datFinal")) != null) {
                datFinal = LocalDateTime.parse(parmVal, this.sdfDataReq);
            }
            if ((parmVal = request.getParameter("rodovia")) != null) {
                rodovia = parmVal;
                rdv = this.cadastroService.getRodoviaByReferencia(emp.getId(), rodovia);
            }
            if ((parmVal = request.getParameter("equipe")) != null) {
                equipe = parmVal;
                eqp = this.cadastroService.getEquipeByReferencia(equipe);
            }
            if ((parmVal = request.getParameter("trecho")) != null) {
                trecho = parmVal;
                trc = this.cadastroService.getTrechoByReferencia(trecho);
            }
            if ((parmVal = request.getParameter("lastUpdate")) != null) {
                lastUpdateVal = Long.valueOf(request.getParameter("lastUpdate"));
            }
            LocalDateTime lastUpdt = null;
            if (lastUpdateVal != null) {
                lastUpdt = Instant.ofEpochMilli(lastUpdateVal).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            List ordens = this.conservaService.findOrdensServico(emp.getId(), datInicial, datFinal, rdv.getId(), trc.getId(), eqp.getId(), TipoAprovacao.APROVADO, lastUpdt);
            for (OrdemServico svc : ordens) {
                Contrato ctr;
                svc.setDatHorCadastro(null);
                svc.setIdUsuarioIns(null);
                svc.setDatHorAlteracao(null);
                svc.setIdUsuarioUpd(null);
                eqp = svc.getEquipe();
                if (eqp != null) {
                    eqp.setDatHorCadastro(null);
                    eqp.setIdUsuarioIns(null);
                    eqp.setDatHorAlteracao(null);
                    eqp.setIdUsuarioUpd(null);
                }
                if ((ctr = svc.getContrato()) != null) {
                    ctr.setContratada(null);
                    ctr.setGestor(null);
                    ctr.setCoordenador(null);
                    ctr.setGerente(null);
                    ctr.setDiretor1(null);
                    ctr.setDiretor2(null);
                    ctr.setServicos(null);
                    ctr.setEquipes(null);
                    ctr.setDatHorCadastro(null);
                    eqp.setIdUsuarioIns(null);
                    ctr.setDatHorAlteracao(null);
                    ctr.setIdUsuarioUpd(null);
                }
                if (svc.getFornecedor() != null) {
                    svc.getFornecedor().setCidade(null);
                }
                if ((rdv = svc.getRodovia()) != null) {
                    rdv.setEmpresa(null);
                    rdv.setDatHorAlteracao(null);
                    rdv.setDatHorAlteracao(null);
                }
                List itens = this.conservaService.findOrdensServicoItem(svc.getId().getIdEmpresa(), svc.getId().getIdOrdemServico());
                svc.setItens(itens);
                for (OrdemServicoItem item : itens) {
                    GrupoServico grp;
                    item.setDatHorCadastro(null);
                    item.setIdUsuarioIns(null);
                    item.setDatHorAlteracao(null);
                    item.setIdUsuarioUpd(null);
                    Servico servico = item.getServico();
                    if (servico != null) {
                        servico.setDatHorCadastro(null);
                        servico.setIdUsuarioIns(null);
                        servico.setDatHorAlteracao(null);
                        servico.setIdUsuarioUpd(null);
                        servico.setUnidade(null);
                        servico.setUnidadeProducao(null);
                        servico.setGrupoServico(null);
                        servico.setParametros(null);
                    }
                    if ((grp = item.getGrupoServico()) != null) {
                        grp.setIdEmpresa(null);
                        grp.setDatHorCadastro(null);
                        grp.setIdUsuarioIns(null);
                        grp.setDatHorAlteracao(null);
                        grp.setIdUsuarioUpd(null);
                    }
                    if ((trc = item.getTrecho()) == null) continue;
                    trc.setRodovia(null);
                    trc.setDatHorCadastro(null);
                    trc.setIdUsuarioIns(null);
                    trc.setDatHorAlteracao(null);
                    trc.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)ordens, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.searchProgramadas", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.searchProgramadas", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

