/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ativos;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Parametro;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para par\u00e2metros (Servi\u00e7os, Ensaios, Elementos)", name="shared")
@RequestMapping(value={"/api/parametros"})
public class ParametrosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ParametrosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping
    @Operation(summary="Lista os par\u00e2metros")
    public ResponseEntity<List<Parametro>> findParametros(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findParametros...");
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_PARAMETROS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_PARAMETROS");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findParametros", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroService.findParametros(null, searchTxt), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findParametrosServicos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idParametro}"})
    @Operation(summary="Carrega o par\u00e2metros pelo seu ID")
    public ResponseEntity<Parametro> getParametroById(@PathVariable(name="idParametro") Integer idParametro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getParametroById({})", (Object)idParametro);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_PARAMETRO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getParametroById(idParametro), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getParametroById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Persiste o par\u00e2metro")
    public ResponseEntity<Parametro> saveParametro(@RequestBody Parametro parametro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveParametro({})", (Object)parametro);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_PARAMETRO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveParametro(parametro, usuario.getLogin()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveParametro", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idParametro}"})
    @Operation(summary="Exclui um par\u00e2metro atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteParametro(@PathVariable(name="idParametro") Integer idParametro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteParametro({})", (Object)idParametro);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_PARAMETRO");
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteParametro(idParametro), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteParametro", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

