/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSessao;
import br.com.oti.gesconsys.business.services.SegurancaService;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class BaseRestService {
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Bearer";
    private static Logger logger = LoggerFactory.getLogger(BaseRestService.class);
    private final String LOCALHOST_IPV4 = "127.0.0.1";
    private final String LOCALHOST_IPV6 = "0:0:0:0:0:0:0:1";
    @Autowired
    private SegurancaService segurancaService;

    protected String getToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(AUTHORIZATION_PROPERTY);
        if (headers == null || !headers.hasMoreElements()) {
            logger.error("No Header AuthProperty ");
            return null;
        }
        return ((String)headers.nextElement()).replaceFirst("Bearer ", "");
    }

    protected PublicUser getUsuarioByJWT(HttpServletRequest request) {
        String bearerToken = this.getToken(request);
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        if (sessao != null) {
            PublicUser user = new PublicUser(sessao.getUsuario());
            return user;
        }
        logger.info(String.format("BearerToken '%s' n\u00e3o encontrado ou inv\u00e1lido. ", bearerToken));
        return null;
    }

    protected PublicUser getUsuarioByToken(String bearerToken) {
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        if (sessao != null) {
            PublicUser user = new PublicUser(sessao.getUsuario());
            return user;
        }
        logger.info(String.format("BearerToken '%s' n\u00e3o encontrado ou inv\u00e1lido. ", bearerToken));
        return null;
    }

    protected UsuarioSessao getSessaoUsuarioByToken(String bearerToken) {
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        if (sessao != null) {
            return sessao;
        }
        logger.info(String.format("BearerToken '%s' n\u00e3o encontrado ou inv\u00e1lido. ", bearerToken));
        return null;
    }

    public String getIpExterno(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (!StringUtils.hasText((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (!StringUtils.hasText((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((!StringUtils.hasText((String)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                ipAddress = inetAddress.getHostAddress();
            }
            catch (UnknownHostException uheExc) {
                logger.error("UHExc", (Throwable)uheExc);
            }
        }
        if (StringUtils.hasText((String)ipAddress) && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    protected Map<String, Object> decodeTokenBody(String jwtToken) {
        if (jwtToken == null || jwtToken.isEmpty()) {
            return null;
        }
        String[] split_string = jwtToken.split("\\.");
        String base64EncodedBody = split_string[1];
        Base64 base64Url = new Base64(true);
        String body = new String(base64Url.decode(base64EncodedBody));
        HashMap<String, Object> map = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        try {
            map = (Map)mapper.readValue(body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return map;
        }
        catch (JsonParseException jspExc) {
            logger.debug("jspExc", (Throwable)jspExc);
            return null;
        }
        catch (JsonMappingException jmeExc) {
            logger.debug("jmeExc", (Throwable)jmeExc);
            return null;
        }
        catch (IOException ioExc) {
            logger.debug("ioExc", (Throwable)ioExc);
            return null;
        }
    }
}

