/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.DestinatarioMailVO;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailExterno;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoStatusEmail;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SenderMailHelper {
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private GedService gedService;
    private Logger logger = LoggerFactory.getLogger(SenderMailHelper.class);

    public Boolean execute(Map<String, Object> refMail, Integer idEmpresa, Integer idEmail, String assunto, String conteudo, List<DestinatarioMailVO> destinatarios, List<File> anexos, Integer idUsuario) throws SendFailedException, MessagingException, UnsupportedEncodingException {
        if (refMail == null || refMail.isEmpty()) {
            return false;
        }
        if (destinatarios == null || destinatarios.isEmpty()) {
            this.logger.error("Email sem destinat\u00e1rios v\u00e1lidos. email.pk= {},{}, cancelado.", (Object)idEmpresa, (Object)idEmail);
            this.coreService.updateMailCancel(idEmpresa, idEmail, "Destinat\u00e1rios inv\u00e1lidos.", idUsuario);
            return false;
        }
        boolean debugMsg = false;
        String hostName = "smtp.office365.com";
        Object rawRef = refMail.get("EMAIL.SMTPHOST_CRP");
        if (rawRef != null) {
            hostName = rawRef.toString();
        }
        if ((rawRef = refMail.get("EMAIL.DEBUG_MSG")) != null) {
            debugMsg = Boolean.valueOf("EMAIL.DEBUG_MSG");
        }
        Integer smtpPort = null;
        rawRef = refMail.get("EMAIL.SMTPPORT_CRP");
        if (rawRef != null) {
            smtpPort = Integer.valueOf(rawRef.toString());
        }
        String userName = null;
        rawRef = refMail.get("EMAIL.USERNAME_CRP");
        if (rawRef != null) {
            userName = rawRef.toString();
        }
        String userPawd = null;
        rawRef = refMail.get("EMAIL.PASSWORD_CRP");
        if (rawRef != null) {
            userPawd = rawRef.toString();
        }
        String userAcct = null;
        rawRef = refMail.get("EMAIL.USERACCT_CRP");
        if (rawRef != null) {
            userAcct = rawRef.toString();
        }
        if (userAcct == null) {
            this.logger.error("Email usu\u00e1rio nulo, iterando pr\u00f3ximo...");
            return false;
        }
        String userLabel = null;
        rawRef = refMail.get("EMAIL.USERLABEL_CRP");
        if (rawRef != null) {
            userLabel = rawRef.toString();
        }
        Properties mailProps = new Properties();
        mailProps.put("mail.smtp.host", hostName);
        mailProps.put("mail.smtp.port", smtpPort);
        if (smtpPort == 465) {
            mailProps.setProperty("mail.smtp.ssl.enable", "true");
        }
        mailProps.put("mail.smtp.connectiontimeout", "5000");
        mailProps.put("mail.smtp.timeout", "15000");
        mailProps.put("mail.smtp.writetimeout", "15000");
        rawRef = refMail.get("EMAIL.STARTTLS_CRP");
        if (rawRef != null) {
            this.logger.trace("Usando StartTLS para enviar emails");
            mailProps.put("mail.smtp.starttls.enable", "true");
            mailProps.put("mail.smtp.ssl.protocols", "TLSv1.2");
        }
        if ((rawRef = refMail.get(TipoRefCode.EMAIL_SSLTRUST_CRP.getRefName())) != null) {
            mailProps.put("mail.smtp.ssl.trust", rawRef.toString());
        }
        if (debugMsg) {
            mailProps.put("mail.debug", "true");
            mailProps.put("mail.smtp.debug", "true");
            mailProps.put("mail.debug.auth", "true");
        }
        Session session = null;
        if (userName != null && userPawd != null) {
            String userNameRo = userName;
            String passwdRo = userPawd;
            mailProps.put("mail.smtp.auth", (Object)true);
            session = Session.getInstance((Properties)mailProps, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            session = Session.getInstance((Properties)mailProps);
        }
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(userAcct, userLabel));
        message.setSubject(assunto);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(conteudo, "UTF-8", "html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)mimeBodyPart);
        message.setContent((Multipart)multipart);
        ArrayList<InternetAddress> listTo = new ArrayList<InternetAddress>();
        ArrayList<InternetAddress> listCc = new ArrayList<InternetAddress>();
        for (DestinatarioMailVO row : destinatarios) {
            if (row.getTipo() == null || row.getEmail() == null || row.getNome() == null) continue;
            if (row.getTipo().equals(TipoDestinatario.EMAIL_TO.getCode())) {
                listTo.add(new InternetAddress(row.getEmail(), row.getNome()));
                continue;
            }
            if (!row.getTipo().equals(TipoDestinatario.EMAIL_CC.getCode())) continue;
            listCc.add(new InternetAddress(row.getEmail(), row.getNome()));
        }
        InternetAddress[] addrs = null;
        if (listTo != null && listTo.size() > 0) {
            addrs = new InternetAddress[listTo.size()];
            message.setRecipients(Message.RecipientType.TO, (Address[])listTo.toArray(addrs));
        }
        if (listCc != null && listCc.size() > 0) {
            addrs = new InternetAddress[listCc.size()];
            message.setRecipients(Message.RecipientType.CC, (Address[])listCc.toArray(addrs));
        }
        if (anexos != null && anexos.size() > 0) {
            Integer tamanhoMaximo = (Integer)this.coreService.getRefValueByName(null, TipoRefCode.INFRA_EMAIL_TAMANHO_MAXIMO_ANEXO);
            for (File anexo : anexos) {
                try {
                    long fileSize = Files.size(anexo.toPath());
                    if (fileSize > 0L && fileSize / 1024L > (long)tamanhoMaximo.intValue()) {
                        this.logger.error("Tamanho m\u00e1ximo permitido '{} kb' para o anexo foi ultrapassado, anexo ignorado.", (Object)tamanhoMaximo);
                        continue;
                    }
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    attachmentPart.attachFile(anexo);
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
                catch (IOException ioExc) {
                    this.logger.error("IOExc", (Throwable)ioExc);
                    return false;
                }
                catch (MessagingException msgExc) {
                    this.logger.error("MsgExc", (Throwable)msgExc);
                    return false;
                }
            }
        }
        Transport.send((Message)message);
        return true;
    }

    public Boolean sendMails(String usuario) {
        Map refEnvioMails = this.coreService.findRefCodesMapValues(null, "INFRA.ENVIAR_EMAIL");
        Map refMailConfig = this.coreService.findRefCodesMapValues(null, "EMAIL");
        List emails = this.coreService.findEmails(null, null, null, null, TipoStatusEmail.PENDENTE, Integer.valueOf(25), null);
        if (emails == null) {
            return true;
        }
        ArrayList<DestinatarioMailVO> destinatarios = new ArrayList<DestinatarioMailVO>();
        this.logger.debug("Emails \u00e0 enviar={}", (Object)emails.size());
        for (Email email : emails) {
            String errorMsg;
            List rowsExterno;
            if (email == null) {
                this.logger.error("Email nulo, iterando pr\u00f3ximo...");
                continue;
            }
            Integer idEmpresa = email.getId().getIdEmpresa();
            Integer idEmail = email.getId().getIdEmail();
            Object envioMail = refEnvioMails.get("INFRA.ENVIAR_EMAIL_" + email.getOrigem());
            if (envioMail == null || Boolean.valueOf(envioMail.equals(false)).booleanValue()) {
                this.logger.error("Envio de emails desligado para Origem={}, iterando pr\u00f3ximo...", (Object)email.getOrigem());
                continue;
            }
            destinatarios.clear();
            List rows = this.coreService.findDestinatariosByEmail(email.getId().getIdEmail(), email.getId().getIdEmpresa());
            if (rows != null && !rows.isEmpty()) {
                for (Object row : rows) {
                    String tipo = row.getTipo();
                    String usrMail = row.getUsuarioDestino().getEmail();
                    String usrNome = row.getUsuarioDestino().getNome();
                    if (tipo == null || usrMail == null || usrNome == null) continue;
                    destinatarios.add(new DestinatarioMailVO(tipo.toString(), usrMail.toString(), usrNome.toString()));
                }
            }
            if ((rowsExterno = this.coreService.findDestinatariosExternosByEmail(email.getId().getIdEmail(), email.getId().getIdEmpresa())) != null && !rowsExterno.isEmpty()) {
                Object row;
                row = rowsExterno.iterator();
                while (row.hasNext()) {
                    EmailExterno row2 = (EmailExterno)row.next();
                    String[] tipo = row2.getTipo();
                    String usrMail = row2.getEmail();
                    if (tipo == null || usrMail == null) continue;
                    destinatarios.add(new DestinatarioMailVO(tipo.toString(), usrMail.toString(), usrMail.toString()));
                }
            }
            ArrayList<File> anexosUUid = new ArrayList<File>();
            if (email.getAnexos() != null && !email.getAnexos().isEmpty()) {
                String[] anexosRaw;
                for (String anx : anexosRaw = email.getAnexos().split(";")) {
                    Integer anxId;
                    Anexo anexo;
                    if (anx == null || anx.trim().isEmpty() || (anexo = this.gedService.getAnexoById(idEmpresa, anxId = Integer.valueOf(anx))) == null) continue;
                    anexosUUid.add(this.gedService.getFileByUUID(idEmpresa, anexo.getUuid(), null));
                }
            }
            try {
                PublicUser user = this.segurancaService.getUsuarioByLogin(usuario);
                if (!this.execute(refMailConfig, idEmpresa, idEmail, email.getAssunto(), email.getCorpoEmail().getConteudo(), destinatarios, anexosUUid, user.getId()).booleanValue()) continue;
                this.coreService.updateEnvioMail(email.getId().getIdEmpresa(), email.getId().getIdEmail(), LocalDateTime.now(), TipoStatusEmail.ENVIADO);
            }
            catch (SendFailedException emlExc) {
                this.logger.error("emlExc", (Throwable)emlExc);
                errorMsg = emlExc.getMessage();
                if (errorMsg != null && errorMsg.length() > 200) {
                    errorMsg = errorMsg.substring(0, 200);
                }
                this.coreService.updateMailError(idEmpresa, idEmail, errorMsg);
            }
            catch (MessagingException emlExc) {
                this.logger.error("emlExc", (Throwable)emlExc);
                errorMsg = emlExc.getMessage();
                if (errorMsg != null && errorMsg.length() > 200) {
                    errorMsg = errorMsg.substring(0, 200);
                }
                this.coreService.updateMailError(idEmpresa, idEmail, errorMsg);
            }
            catch (UnsupportedEncodingException uexc) {
                this.logger.error("Uexc", (Throwable)uexc);
                errorMsg = uexc.getMessage();
                if (errorMsg != null && errorMsg.length() > 200) {
                    errorMsg = errorMsg.substring(0, 200);
                }
                this.coreService.updateMailError(idEmpresa, idEmail, errorMsg);
            }
            catch (Exception exc) {
                this.logger.error("Exc", (Throwable)exc);
                errorMsg = exc.getMessage();
                if (errorMsg != null && errorMsg.length() > 200) {
                    errorMsg = errorMsg.substring(0, 200);
                }
                this.coreService.updateMailError(idEmpresa, idEmail, errorMsg);
            }
        }
        return true;
    }
}

