/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.ativos.Monitoracao;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoEps;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoSinalizacaoHorizontal;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoSinalizacaoVertical;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoTerrapleno;
import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geo.MapaKmlData;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.CoordenadaMapaVO;
import br.com.oti.gesconsys.beans.shared.Obra;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoSigaco;
import br.com.oti.gesconsys.business.services.AtivoService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.LaboratorioService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.business.services.SigacoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.lab.beans.Ensaio;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.Coordenada;
import br.com.oti.gesconsys.utils.GeoUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@RestController
@Tag(description="REST Services para Mapas", name="shared")
@RequestMapping(value={"/api/mapas"})
public class MapasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(MapasRestServices.class);
    @Autowired
    private AtivoService ativoService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private LaboratorioService laboratorioService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private SigacoService sigacoService;

    @GetMapping(value={"/{empresa}/{modulo}/{item}"})
    @Operation(summary="Retorna o mapa conforme Modulo e item")
    @ResponseBody
    public ResponseEntity<List<CoordenadaMapaVO>> fillMapa(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="item") String item, HttpServletRequest request) {
        logger.debug("FillMapa(emp={}, mld={}, ite={})...", new Object[]{empresa, modulo, item});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            ArrayList<String> empresas = new ArrayList<String>();
            String[] empresasArray = request.getParameterValues("empresas");
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresas.add(emp);
                }
            } else {
                empresas.add(empresa);
            }
            List mapa = this.fillCoordenadas(empresas, modulo, item, request);
            return ResponseEntity.ok().body((Object)mapa);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private List<CoordenadaMapaVO> fillCoordenadas(List<String> empresas, String modulo, String item, HttpServletRequest request) {
        ArrayList<CoordenadaMapaVO> coordenadas;
        block62: {
            ArrayList<Integer> empresasInt;
            block63: {
                block61: {
                    coordenadas = new ArrayList<CoordenadaMapaVO>();
                    List empresasDB = this.cadastroService.findEmpresas(null, null);
                    empresasInt = new ArrayList<Integer>();
                    block6: for (Empresa empDB : empresasDB) {
                        for (String emp : empresas) {
                            if (!emp.equals(empDB.getSigla())) continue;
                            empresasInt.add(empDB.getId());
                            continue block6;
                        }
                    }
                    if (modulo.equals(TipoModulo.LABORATORIO.getSigla())) {
                        return this.fillCoordenadasEnsaios(empresas, request);
                    }
                    if (!modulo.equals(TipoModulo.CADASTROS.getSigla())) break block61;
                    if (!item.equalsIgnoreCase("OBRA")) break block62;
                    Integer tipoObra = null;
                    Integer obra = null;
                    ArrayList<String> statusObra = null;
                    String parm = request.getParameter("tipoObra");
                    if (parm != null) {
                        tipoObra = Integer.valueOf(parm);
                    }
                    if ((parm = request.getParameter("obra")) != null) {
                        obra = Integer.valueOf(parm);
                    }
                    if ((parm = request.getParameter("status")) != null) {
                        statusObra = new ArrayList<String>();
                        statusObra.add(parm);
                    }
                    Boolean northern = null;
                    List obras = this.cadastroService.findObras((Integer)empresasInt.get(0), null, null, null, tipoObra, statusObra, null);
                    for (Obra obr : obras) {
                        Double coordY;
                        Double coordX;
                        String zonaCode;
                        Integer zonaNbr;
                        if (obr.getCoordenadaNorte() == null || obr.getCoordenadaLeste() == null) continue;
                        Coordenada latLng = null;
                        Coordenada latLngFim = null;
                        if (obr.getZonaGeografica() != null && !obr.getZonaGeografica().isEmpty()) {
                            try {
                                zonaNbr = Integer.valueOf(obr.getZonaGeografica().replaceAll("[A-Za-z]", ""));
                                zonaCode = obr.getZonaGeografica().replaceAll("[0-9]", "").toUpperCase();
                                coordX = Double.valueOf(obr.getCoordenadaLeste().replaceAll("[A-Za-z]", ""));
                                coordY = Double.valueOf(obr.getCoordenadaNorte().replaceAll("[A-Za-z]", ""));
                                latLng = GeoUtils.utmToLatLng((Double)coordX, (Double)coordY, (Integer)zonaNbr, (String)zonaCode, northern);
                                if (latLng == null) {
                                    continue;
                                }
                            }
                            catch (NumberFormatException nmfExc) {
                                latLng = null;
                            }
                            catch (RuntimeException runExc) {
                                latLng = null;
                            }
                        }
                        if (latLng == null) continue;
                        if (obr.getZonaGeograficaFinal() != null && !obr.getZonaGeograficaFinal().isEmpty() && obr.getCoordenadaNorteFinal() != null && obr.getCoordenadaLesteFinal() != null) {
                            try {
                                zonaNbr = Integer.valueOf(obr.getZonaGeograficaFinal().replaceAll("[A-Za-z]", ""));
                                zonaCode = obr.getZonaGeografica().replaceAll("[0-9]", "").toUpperCase();
                                coordX = Double.valueOf(obr.getCoordenadaLesteFinal().replaceAll("[A-Za-z]", ""));
                                coordY = Double.valueOf(obr.getCoordenadaNorteFinal().replaceAll("[A-Za-z]", ""));
                                latLngFim = GeoUtils.utmToLatLng((Double)coordX, (Double)coordY, (Integer)zonaNbr, (String)zonaCode, northern);
                            }
                            catch (NumberFormatException nmfExc) {
                                latLngFim = null;
                            }
                            catch (RuntimeException runExc) {
                                latLng = null;
                            }
                        }
                        CoordenadaMapaVO itemMapa = new CoordenadaMapaVO(obr.getDescricao(), item, latLng.getLatitude(), latLng.getLongitude(), latLngFim != null ? latLngFim.getLatitude() : null, latLngFim != null ? latLngFim.getLongitude() : null);
                        Map infoMap = itemMapa.getInformacao();
                        infoMap.put("idObra", obr.getId());
                        if (obr.getTipoObra() != null) {
                            infoMap.put("tipo", obr.getTipoObra().getDescricao());
                        }
                        infoMap.put("datInicial", obr.getDatInicial());
                        infoMap.put("datFinal", obr.getDatFinal());
                        infoMap.put("status", obr.getStatus());
                        coordenadas.add(itemMapa);
                        coordenadas.add(itemMapa);
                    }
                    break block62;
                }
                if (!modulo.equals(TipoModulo.ATIVOS.getSigla())) break block63;
                if (!item.equalsIgnoreCase("CADASTRO")) break block62;
                String tipoAtivoTxt = null;
                Integer idRodovia = null;
                Integer idCategAtivo = null;
                ArrayList<Integer> ciclos = null;
                String situacao = null;
                String pista = null;
                String sentido = null;
                String lado = null;
                BigDecimal kmInicial = null;
                BigDecimal kmFinal = null;
                String monitInspe = "M";
                String peliculaNorma = null;
                String corNorma = null;
                String param = request.getParameter("tipoAtivo");
                if (param != null) {
                    tipoAtivoTxt = param;
                }
                if (tipoAtivoTxt == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Tipo de Ativo n\u00e3o informado.");
                }
                String[] params = request.getParameterValues("ciclos");
                if (params != null && params.length > 0) {
                    ciclos = new ArrayList<Integer>();
                    for (String iteParm : params) {
                        ciclos.add(Integer.valueOf(iteParm));
                    }
                }
                if ((param = request.getParameter("idRodovia")) != null) {
                    idRodovia = Integer.valueOf(param);
                }
                if ((param = request.getParameter("categoria")) != null) {
                    idCategAtivo = Integer.valueOf(param);
                }
                situacao = request.getParameter("situacao");
                param = request.getParameter("pista");
                if (param != null) {
                    pista = param;
                }
                if ((param = request.getParameter("sentido")) != null) {
                    sentido = param;
                }
                if ((param = request.getParameter("lado")) != null) {
                    lado = param;
                }
                if ((param = request.getParameter("kmInicial")) != null) {
                    kmInicial = new BigDecimal(param);
                }
                if ((param = request.getParameter("kmFinal")) != null) {
                    kmFinal = new BigDecimal(param);
                }
                if ((param = request.getParameter("monitoracaoInspecao")) != null) {
                    monitInspe = param;
                }
                if ((param = request.getParameter("corNorma")) != null) {
                    corNorma = param;
                }
                if ((param = request.getParameter("peliculaNorma")) != null) {
                    peliculaNorma = param;
                }
                Map reqParams = request.getParameterMap();
                HashMap<String, String> paramsAtivos = new HashMap<String, String>();
                for (String paramKey : reqParams.keySet()) {
                    String[] paramValues = (String[])reqParams.get(paramKey);
                    if (paramValues.length <= 0) continue;
                    String paramValue = paramValues[0];
                    paramsAtivos.put(paramKey, paramValue);
                }
                TipoAtivo tipoAtivo = TipoAtivo.fromCode((String)tipoAtivoTxt);
                ArrayList<Integer> rodovias = new ArrayList<Integer>();
                if (idRodovia != null) {
                    rodovias.add(idRodovia);
                }
                List monitoracoes = this.ativoService.findMonitoracoes(empresas, tipoAtivo, monitInspe, ciclos, rodovias, idCategAtivo, situacao, pista, lado, sentido, kmInicial, kmFinal, paramsAtivos);
                for (Monitoracao monit : monitoracoes) {
                    CoordenadaMapaVO map = new CoordenadaMapaVO(monit.getItemAtivo().getDescricao(), item, monit.getLatitude(), monit.getLongitude(), monit.getKmInicial(), monit.getKmFinal());
                    if (monit.getRodovia() != null) {
                        map.getInformacao().put("rodovia", monit.getRodovia().getDescricao());
                    }
                    map.getInformacao().put("kmInicial", monit.getKmInicial());
                    map.getInformacao().put("kmFinal", monit.getKmFinal());
                    map.getInformacao().put("tipoAtivo", monit.getTipoAtivo());
                    map.getInformacao().put("cicloMonitoracao", monit.getCiclo());
                    map.getInformacao().put("idMonitoracao", monit.getId().getIdMonitoracao());
                    map.getInformacao().put("dataMonitoracao", monit.getDatMonitoracao());
                    if (monit.getTipoAtivo().equals(TipoAtivo.SINALIZACAO_VERTICAL.getSigla())) {
                        situacaoTxt = ((MonitoracaoSinalizacaoVertical)monit).getResultadoGeral();
                        if (situacaoTxt == null) {
                            situacaoTxt = "X";
                        }
                        map.getInformacao().put("estadoConservacao", Character.valueOf(situacaoTxt.toUpperCase().charAt(0)));
                    } else if (monit.getTipoAtivo().equals(TipoAtivo.SINALIZACAO_HORIZONTAL.getSigla())) {
                        situacaoTxt = ((MonitoracaoSinalizacaoHorizontal)monit).getResultadoGeral();
                        if (situacaoTxt == null) {
                            situacaoTxt = "X";
                        }
                        map.getInformacao().put("estadoConservacao", Character.valueOf(situacaoTxt.toUpperCase().charAt(0)));
                    } else if (monit.getTipoAtivo().equals(TipoAtivo.EQUIPAMENTOS_PROTECAO_SEGURANCA.getSigla())) {
                        situacaoTxt = ((MonitoracaoEps)monit).getAparenciaGeral();
                        if (situacaoTxt == null) {
                            situacaoTxt = "X";
                        }
                        map.getInformacao().put("estadoConservacao", Character.valueOf(situacaoTxt.toUpperCase().charAt(0)));
                    } else if (monit.getTipoAtivo().equals(TipoAtivo.TERRAPLENOS.getSigla())) {
                        MonitoracaoTerrapleno monitTec = (MonitoracaoTerrapleno)monit;
                        map.getInformacao().put("nivel", monitTec.getNivel());
                        map.getInformacao().put("material", monitTec.getMaterial());
                        map.getInformacao().put("ambiente", monit.getAmbiente());
                        map.getInformacao().put("observacao", monit.getObservacao());
                        map.getInformacao().put("diagnostico", monitTec.getDiagnostico());
                        map.getInformacao().put("ocorrencia", monitTec.getOcorrencia());
                        map.getInformacao().put("estadoConservacao", monit.getEstadoConservacao());
                    } else {
                        map.getInformacao().put("estadoConservacao", monit.getEstadoConservacao());
                    }
                    coordenadas.add(map);
                }
                break block62;
            }
            if (modulo.equals(TipoModulo.SIGACO.getSigla()) && item.equalsIgnoreCase("MONIT")) {
                PublicUser user;
                String[] params;
                String subsistema = null;
                ArrayList<Integer> rodovias = null;
                Double kmIni = null;
                Double kmFim = null;
                Integer faixa = null;
                String sentido = null;
                Integer idCategoria = null;
                Integer idFase = null;
                String situacao = null;
                Integer seqImportacao = null;
                String param = request.getParameter("subsistema");
                if (param != null) {
                    subsistema = param;
                }
                if (subsistema == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Subsistema n\u00e3o foi informado.");
                }
                param = request.getParameter("idFase");
                if (param != null) {
                    idFase = Integer.valueOf(param);
                }
                if ((params = request.getParameterValues("rodovias")) != null && params.length > 0) {
                    rodovias = new ArrayList<Integer>();
                    for (String iteParm : params) {
                        rodovias.add(Integer.valueOf(iteParm));
                    }
                }
                if ((param = request.getParameter("faixa")) != null) {
                    faixa = Integer.valueOf(param);
                }
                sentido = request.getParameter("sentido");
                param = request.getParameter("idTipoElemento");
                if (param != null) {
                    idCategoria = Integer.valueOf(param);
                }
                ArrayList<String> categoriasDesc = new ArrayList<String>();
                ArrayList<Integer> categoriasId = new ArrayList<Integer>();
                params = request.getParameterValues("categorias");
                if (params != null && params.length > 0) {
                    for (String iteParm : params) {
                        if (iteParm.matches("^[+-]?\\d+$")) {
                            categoriasId.add(Integer.parseInt(iteParm.trim()));
                            continue;
                        }
                        categoriasDesc.add(iteParm.trim());
                    }
                }
                situacao = request.getParameter("situacao");
                String tipoAcesso = request.getParameter("tipoAcesso");
                String estadoConservacao = request.getParameter("estadoConservacao");
                Integer statusImportacao = null;
                param = request.getParameter("statusImportacao");
                if (param != null) {
                    statusImportacao = Integer.valueOf(param);
                }
                Empresa empresa = this.cadastroService.getEmpresaById((Integer)empresasInt.get(0));
                PublicUser usuario = this.getUsuarioByJWT(request);
                if (usuario != null && (user = this.segurancaService.getUsuarioByLogin(usuario.getLogin())).getPoderConcedente() != null && empresa.getIdPoderConcedente() != null && user.getExterno() != null && user.getExterno().equals(true)) {
                    statusImportacao = 2;
                }
                TipoAtivo tipoAtivo = TipoAtivo.fromCode((String)subsistema);
                HashMap extParams = new HashMap();
                List monitoracoes = this.sigacoService.findMonitoracoes(empresa.getSigla(), tipoAtivo, idCategoria, categoriasDesc, categoriasId, List.of(idFase), rodovias, kmIni, kmFim, faixa, sentido, situacao, null, null, null, null, tipoAcesso, seqImportacao, statusImportacao, extParams);
                for (MonitoracaoSigaco monit : monitoracoes) {
                    if (monit.getCoordenadaXIni() != null && monit.getCoordenadaYIni() != null && monit.getCoordenadaXIni().intValue() == 0 && monit.getCoordenadaYIni().intValue() == 0) continue;
                    CoordenadaMapaVO map = new CoordenadaMapaVO(monit.getElemento().getDesNome(), item, monit.getLatitude(), monit.getLongitude(), monit.getKmInicial(), monit.getKmFinal());
                    if (monit.getRodovia() != null) {
                        map.getInformacao().put("rodovia", monit.getRodovia().getDescricao());
                    }
                    map.getInformacao().put("kmInicial", monit.getKmInicial());
                    map.getInformacao().put("kmFinal", monit.getKmFinal());
                    map.getInformacao().put("faseMonitoracao", monit.getFase().getDescricao());
                    map.getInformacao().put("idMonitoracao", monit.getId().getIdMonitoracao());
                    map.getInformacao().put("estadoConservacao", monit.getEstadoConservacao());
                    coordenadas.add(map);
                }
            }
        }
        return coordenadas;
    }

    private String makeKmlAtivos(String empresa, String modulo, String item, HttpServletRequest request) {
        StringBuilder outKml = new StringBuilder();
        outKml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        outKml.append("<kml xmlns=\"http://earth.google.com/kml/2.1\">");
        outKml.append("  <Document>\r\n");
        logger.debug("makeKmlAtivos(emp={}, mld={}, ite={})...", new Object[]{empresa, modulo, item});
        ArrayList<String> empresas = new ArrayList<String>();
        String[] empresasArray = request.getParameterValues("empresas");
        if (empresasArray != null && empresasArray.length > 0) {
            for (String emp : empresasArray) {
                empresas.add(emp);
            }
        } else {
            empresas.add(empresa);
        }
        List coordenadas = this.fillCoordenadas(empresas, modulo, item, request);
        for (CoordenadaMapaVO coordenada : coordenadas) {
            if (coordenada.getLatitude() == null || coordenada.getLongitude() == null) continue;
            outKml.append("    <Placemark>\r\n");
            outKml.append("      <name>").append(coordenada.getDescricao()).append("</name>\r\n");
            outKml.append("      <Point>\r\n");
            outKml.append("        <coordinates>");
            outKml.append(coordenada.getLongitude()).append(",").append(coordenada.getLatitude()).append(",0");
            outKml.append("</coordinates>\r\n");
            outKml.append("      </Point>\r\n");
            outKml.append("    </Placemark>\r\n");
        }
        outKml.append("  </Document>\r\n");
        outKml.append("</kml>\r\n");
        return outKml.toString();
    }

    @GetMapping(path={"/{empresa}/kmlData"})
    @Operation(summary="Retorna o KML armazenado, da tabela de Mapas")
    public ResponseEntity<String> fillKmlMap(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List kmlData = this.cadastroService.findKmlData(emp.getId(), null);
            if (kmlData != null && kmlData.size() > 0) {
                return new ResponseEntity((Object)((MapaKmlData)kmlData.get(0)).getKmlData(), HttpStatus.CREATED);
            }
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 dados de KML.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/kmlData"}, consumes={"multipart/form-data"})
    @Operation(summary="Insere o KML na tabela de Mapa")
    public ResponseEntity<String> createKmlMap(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("createKmlMap({},{})", (Object)empresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
            }
            Map formData = request.getParameterMap();
            String nome = null;
            if (formData.containsKey("nome")) {
                nome = ((String[])formData.get("nome"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            Map filesMap = multipartReq.getFileMap();
            String tmpDir = System.getProperty("java.io.tmpdir");
            byte[] buffer = new byte[1024];
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName={}", (Object)fileName);
                    ZipInputStream zis = new ZipInputStream(fileReq.getInputStream());
                    ZipEntry zipEntry = zis.getNextEntry();
                    while (zipEntry != null) {
                        int len;
                        File destFile = new File(tmpDir, zipEntry.getName());
                        FileOutputStream fos = new FileOutputStream(destFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        if (zipEntry.getName().toLowerCase().contains("kml")) {
                            List<String> kmlLines = Files.readAllLines(destFile.toPath());
                            StringBuilder kmlContent = new StringBuilder();
                            for (String line : kmlLines) {
                                kmlContent.append(line.trim());
                            }
                            if (nome == null || nome.isEmpty()) {
                                nome = fileName;
                            }
                            MapaKmlData mapaKml = new MapaKmlData();
                            mapaKml.setIdEmpresa(emp.getId());
                            mapaKml.setDescricao(nome);
                            mapaKml.setKmlData(kmlContent.toString());
                            this.cadastroService.saveKmlData(mapaKml, usuario.getLogin());
                        }
                        zipEntry = zis.getNextEntry();
                    }
                    zis.close();
                }
            }
            String response = "ok";
            return new ResponseEntity((Object)response, HttpStatus.CREATED);
        }
        catch (IOException ioExc) {
            logger.error("IOExc.createAnexo", (Throwable)ioExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public Object extractKmlInfo(InputStream kmlStream) throws IOException, SAXException {
        try {
            logger.debug("bytes to read={}", (Object)kmlStream.available());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(kmlStream);
            document.getDocumentElement().normalize();
            Element root = document.getDocumentElement();
            logger.debug("root.nodeName={}, root.child={}", (Object)root.getNodeName(), (Object)root.getChildNodes());
            return root;
        }
        catch (ParserConfigurationException pcfExc) {
            logger.error("extractKmlInfo", (Throwable)pcfExc);
            throw new BusinessException(pcfExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/kmzData/{modulo}/{item}"})
    @Operation(summary="Baixa o KMZ do Mapa")
    public ResponseEntity<byte[]> retrieveKmlInOldFormat(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="item") String item, HttpServletRequest request) {
        String kmlFileContent = this.makeKmlAtivos(empresa, modulo, item, request);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=\"mapaKmz.kmz\"");
        headers.add("Content-Type", "application/vnd.google-earth.kmz");
        byte[] bytes = this.renderAsKmz(kmlFileContent, "mapa.kml");
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] renderAsKmz(String kmlFileContent, String zipEntryName) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipStream = new ZipOutputStream(outStream);
        try {
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            zipStream.putNextEntry(zipEntry);
            zipStream.write(kmlFileContent.getBytes());
        }
        catch (IOException e) {
            logger.error("Error while zipping kml file content : " + e.getMessage());
        }
        finally {
            try {
                zipStream.closeEntry();
                zipStream.close();
            }
            catch (IOException e) {
                logger.error("Error while closing zipped stream : " + e.getMessage());
            }
        }
        return outStream.toByteArray();
    }

    private List<CoordenadaMapaVO> fillCoordenadasEnsaios(List<String> empresas, HttpServletRequest request) {
        LocalDate datIniLdt = null;
        LocalDate datFimLdt = null;
        String datInicial = request.getParameter("dataInicial");
        String datFinal = request.getParameter("dataFinal");
        DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
        if (datInicial != null && !datInicial.isEmpty()) {
            try {
                datIniLdt = LocalDate.parse(datInicial, dateFmt);
            }
            catch (DateTimeParseException dteExc) {
                datIniLdt = null;
            }
        }
        if (datFinal != null && !datFinal.isEmpty()) {
            try {
                datFimLdt = LocalDate.parse(datFinal, dateFmt);
            }
            catch (DateTimeParseException dteExc) {
                datFimLdt = null;
            }
        }
        List ensaios = this.laboratorioService.findEnsaios(empresas, datIniLdt, datFimLdt, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        for (Ensaio ens : ensaios) {
            Double kmVal;
            String[] kmTxt;
            CoordenadaMapaVO coord = new CoordenadaMapaVO();
            coord.setData(ens.getDatEnsaio());
            coord.setTitulo(ens.getNumero());
            coord.setObservacao(ens.getObservacao());
            if (ens.getRodovia() != null) {
                coord.setRodovia(ens.getRodovia().getDescricao());
            }
            if (ens.getLatitudeInicial() != null) {
                coord.setLatitude(Double.valueOf(ens.getLatitudeInicial().doubleValue()));
            }
            if (ens.getLongitudeInicial() != null) {
                coord.setLongitude(Double.valueOf(ens.getLongitudeInicial().doubleValue()));
            }
            if (ens.getKmInicial() != null) {
                kmTxt = ens.getKmInicial().split("\\+");
                kmVal = 0.0;
                try {
                    kmVal = Double.valueOf(kmTxt[0].trim());
                    if (kmTxt.length > 1 && kmTxt[1] != null) {
                        kmVal = kmVal + Double.valueOf(kmTxt[1]) / 1000.0;
                    }
                }
                catch (NumberFormatException nmfExc) {
                    kmVal = null;
                }
                coord.setKmInicial(kmVal);
            }
            if (ens.getKmFinal() != null) {
                kmTxt = ens.getKmFinal().split("\\+");
                kmVal = 0.0;
                try {
                    kmVal = kmVal + Double.valueOf(kmTxt[0].trim());
                    if (kmTxt.length > 1 && kmTxt[1] != null) {
                        kmVal = kmVal + Double.valueOf(kmTxt[1]) / 1000.0;
                    }
                }
                catch (NumberFormatException nmfExc) {
                    kmVal = null;
                }
                coord.setKmFinal(kmVal);
            }
            coord.setObservacao(ens.getObservacao());
            coord.getInformacao().put("tipoEnsaio", ens.getTipo());
            coord.getInformacao().put("tipoLancamento", ens.getTipoLancamento().equals("A") ? "Auditor" : "Empreiteira");
            coordenadas.add(coord);
        }
        return coordenadas;
    }
}

