/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.TipoEmpresa;
import br.com.oti.gesconsys.beans.seguranca.CreateUserVO;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para registros", name="register")
@RequestMapping(value={"/api/register"})
public class RegistroUsuarioRestServices {
    private static Logger logger = LoggerFactory.getLogger(RegistroUsuarioRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping
    @Operation(summary="Efetua o registro de novo usu\u00e1rio, para m\u00f3dulos ou programas que necessitem do registro pr\u00e9vio")
    @ResponseBody
    public ResponseEntity<Boolean> registerUser(HttpServletRequest request, @RequestBody CreateUserVO usuario) {
        logger.debug("Executando registerUser(tipo={}, idEmp={})...", (Object)usuario.getTipo(), (Object)usuario.getIdEmpresa());
        try {
            String originHeader;
            if (usuario.getIdEmpresa() == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empresa do usu\u00e1rio n\u00e3o foi informada.");
            }
            if (usuario.getTipo() == null || usuario.getTipo().isEmpty()) {
                usuario.setTipo(TipoUsuario.ACESSO_NORMAL.getCode());
            }
            if (usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) {
                if (usuario.getSubtipo() == null || usuario.getSubtipo().isEmpty()) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio informar se acesso Demanda ou Faixa de dom\u00ednio.");
                }
            } else {
                if (usuario.getPassword() == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Senha n\u00e3o informada.");
                }
                if (usuario.getConfirmPassword() == null) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Senha de confirma\u00e7\u00e3o n\u00e3o informada.");
                }
                if (!usuario.getPassword().equals(usuario.getConfirmPassword())) {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Senha e confirma\u00e7\u00e3o da senha n\u00e3o s\u00e3o iguais, verifique.");
                }
            }
            if ((originHeader = request.getHeader("Origin")) == null) {
                originHeader = request.getHeader("origin");
            }
            Boolean created = this.segurancaService.registraUsuario(usuario.getIdEmpresa(), usuario.getLogin(), usuario.getNome(), usuario.getEmail(), usuario.getPassword(), usuario.getEndereco(), usuario.getCidade(), usuario.getUf(), usuario.getTipo(), usuario.getSubtipo(), usuario.getContrato(), usuario.getPerfil(), originHeader);
            return new ResponseEntity((Object)created, HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createUser", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/confirm"})
    @Operation(summary="Confirma o registro de um usu\u00e1rio feito previamente, em conjunto com suas senhas, se informadas")
    public ResponseEntity<Boolean> confirmRegister(@RequestBody CreateUserVO payload) {
        String userId = payload.getLogin();
        if (userId == null) {
            userId = payload.getNome();
        }
        logger.debug("Executando confirmRegister(id={})...", (Object)userId);
        if (userId == null || userId.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio n\u00e3o foram informados corretamente.");
        }
        try {
            String decoded = new EncodeDecodeURL().decode(userId);
            if (decoded == null || decoded.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio s\u00e3o inv\u00e1lidos.");
            }
            Integer idUsuario = Integer.valueOf(decoded);
            Usuario user = this.segurancaService.getUsuarioById(idUsuario);
            if (user == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Registro de usu\u00e1rio n\u00e3o encontrado.");
            }
            Boolean result = true;
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            if (perfil.getBloqueado() != null && perfil.getBloqueado().equals(1)) {
                result = this.segurancaService.desbloqueiaUsuario(user.getLogin());
            }
            if (result.booleanValue() && payload != null && payload.getPassword() != null) {
                result = this.segurancaService.alterarSenha(user.getId(), payload.getPassword(), payload.getConfirmPassword());
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createUser", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/empresas"})
    @Operation(summary="Lista todas as concession\u00e1rias para a tela de registro de usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<Empresa>> findEmpresasDisponiveis(HttpServletRequest request) {
        logger.debug("Executando findEmpresas()...");
        try {
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            List rows = this.cadastroService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            for (Empresa row : rows) {
                Empresa emp = new Empresa();
                emp.setNomeFantasia(row.getNomeFantasia());
                emp.setSigla(row.getSigla());
                emp.setRazaoSocial(row.getRazaoSocial());
                empresas.add(emp);
            }
            return new ResponseEntity(empresas, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findEmpresas", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

