/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.conserva;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para conserva\u00e7\u00e3o", name="conservacao")
@RequestMapping(value={"/api/conservacao"})
public class ConservacaoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ConservacaoRestServices.class);
    private static SimpleDateFormat sdfData = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private ConservaService conservaService;
    @Autowired
    private CadastroService cadastroService;

    @GetMapping(value={"/dashboard/{empresa}/{tipo}"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getCountRealizadosByPeriodo(@PathVariable(value="empresa") String empresa, @PathVariable(value="tipo") String tipo, HttpServletRequest request) throws ParseException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String datFim;
            int fim;
            String datIni;
            int inicio;
            logger.debug("getCount()");
            Empresa emp = new Empresa();
            Date dataInicial = new Date();
            Date dataFinal = new Date();
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            Date sysDate = new Date(System.currentTimeMillis());
            Calendar calDate = Calendar.getInstance();
            calDate.setTime(sysDate);
            if (tipo.equals("A")) {
                inicio = calDate.getMinimum(6);
                datIni = sdfData.format(new Date((long)inicio * 1000L));
                dataInicial = sdfData.parse(datIni);
                fim = calDate.getMaximum(6);
                datFim = sdfData.format(new Date((long)fim * 1000L));
                dataFinal = sdfData.parse(datFim);
            }
            if (tipo.equals("M")) {
                inicio = calDate.getMinimum(5);
                datIni = sdfData.format(new Date((long)inicio * 1000L));
                dataInicial = sdfData.parse(datIni);
                fim = calDate.getMaximum(5);
                datFim = sdfData.format(new Date((long)fim * 1000L));
                dataFinal = sdfData.parse(datFim);
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Object[] item : this.conservaService.countRealizadoByPeriodo(emp.getId(), dataInicial, dataFinal)) {
                result.put(item[0].toString(), item[1]);
            }
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRealizadoByPeriodo", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

