/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.conserva.Previsto;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.beans.PrevistoJson;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para previstos - conserva\u00e7\u00e3o", name="previstos")
@RequestMapping(value={"/api/previstos"})
public class PrevistoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(PrevistoRestServices.class);
    private static SimpleDateFormat sdfDataReq = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private ConservaService conservaService;

    @GetMapping(value={"{idEmpresa}"})
    @ResponseBody
    public List<PrevistoJson> findPrevistos(@PathVariable(value="idEmpresa") Integer idEmpresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (idEmpresa == null) {
            return null;
        }
        Date datInicial = null;
        Date datFinal = null;
        String parmVal = null;
        parmVal = request.getParameter("datInicial");
        if (parmVal != null) {
            try {
                datInicial = sdfDataReq.parse(parmVal);
            }
            catch (ParseException pseExc) {
                logger.error("pseExc", (Throwable)pseExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Par\u00e2metro: Data inicial n\u00e3o informada.");
            }
        }
        if ((parmVal = request.getParameter("datFinal")) != null) {
            try {
                datFinal = sdfDataReq.parse(parmVal);
            }
            catch (ParseException pseExc) {
                logger.error("pseExc", (Throwable)pseExc);
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Par\u00e2metro: Data final n\u00e3o informada.");
            }
        }
        logger.debug("Iniciando carga dos previstos...");
        ArrayList<PrevistoJson> prevs = new ArrayList<PrevistoJson>();
        for (Previsto previstoLoop : this.conservaService.findPrevistos(idEmpresa, datInicial, datFinal, null)) {
            PrevistoJson previstoJson = new PrevistoJson(previstoLoop);
            prevs.add(previstoJson);
        }
        logger.debug("Finalizando carga dos previstos...");
        return prevs;
    }

    @GetMapping(value={"/{idEmpresa}/{idPrevisto}"})
    public ResponseEntity<Previsto> getPrevistoById(@PathVariable(name="idEmpresa") Integer idEmpresa, @PathVariable(name="idPrevisto") Integer idPrevisto, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getPrevistoById({}, {}", (Object)idEmpresa, (Object)idPrevisto);
            return new ResponseEntity((Object)this.conservaService.getPrevistoById(idEmpresa, idPrevisto), HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPrevistoById", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @ResponseBody
    public ResponseEntity<Previsto> savePrevisto(@RequestBody PrevistoJson previsto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("savePrevisto({})", (Object)previsto);
            Integer idPrevisto = null;
            return new ResponseEntity((Object)this.conservaService.registrarPrevisto(previsto.getIdEmpresa(), idPrevisto, usuario.getLogin(), previsto.getIdServico(), previsto.getDescricaoEquipe(), previsto.getSiglaRodovia(), previsto.getDescricao(), previsto.getDataInicial(), previsto.getDataFinal(), previsto.getKmInicial() != null ? new BigDecimal(previsto.getKmInicial().toString()) : null, previsto.getKmFinal() != null ? new BigDecimal(previsto.getKmFinal().toString()) : null, previsto.getObservacaoEquipe(), previsto.getObservacaoAdicional()), HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePrevisto", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEmpresa}/{idPrevisto}"})
    @ResponseBody
    public ResponseEntity<Boolean> deletePrevisto(@PathVariable(value="idEmpresa") Integer idEmpresa, @PathVariable(value="idPrevisto") Integer idPrevisto, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePrevisto({},{})", (Object)idEmpresa, (Object)idPrevisto);
            Boolean deleted = false;
            this.conservaService.deletePrevisto(idEmpresa, idPrevisto);
            deleted = true;
            return new ResponseEntity((Object)deleted, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteServico", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

