/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.conserva.Contrato;
import br.com.oti.gesconsys.beans.conserva.ContratoServico;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para contratos", name="contratos")
@RequestMapping(value={"/api/contratos"})
public class ContratosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ContratosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private ConservaService conservaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista os contratos de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<Contrato>> findContratos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={})...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List contratos = this.conservaService.findContratos(emp.getId(), null, null, null, null);
            for (Contrato ctr : contratos) {
                ctr.setDatHorCadastro(null);
                ctr.setDatHorAlteracao(null);
                ctr.setDatHorAlteracao(null);
                ctr.setIdUsuarioIns(null);
                ctr.setIdUsuarioUpd(null);
                ctr.getGestor().setDatHorAlteracao(null);
                ctr.getGestor().setDatHorCadastro(null);
                ctr.getGestor().setGrupos(null);
                ctr.getGestor().setDatHorUltimoLogin(null);
                ctr.getGestor().setCargo(null);
                ctr.getGestor().setIdPoderConcedente(null);
                ctr.getGestor().setIdUsuarioIns(null);
                ctr.getGestor().setIdUsuarioUpd(null);
                ctr.getGestor().setSessionUUID(null);
                ctr.getGestor().setSubTipo(null);
                ctr.getGestor().setTipo(null);
                ctr.getCoordenador().setDatHorAlteracao(null);
                ctr.getCoordenador().setDatHorCadastro(null);
                ctr.getCoordenador().setGrupos(null);
                ctr.getCoordenador().setDatHorUltimoLogin(null);
                ctr.getCoordenador().setCargo(null);
                ctr.getCoordenador().setIdPoderConcedente(null);
                ctr.getCoordenador().setIdUsuarioIns(null);
                ctr.getCoordenador().setIdUsuarioUpd(null);
                ctr.getCoordenador().setSessionUUID(null);
                ctr.getCoordenador().setSubTipo(null);
                ctr.getCoordenador().setTipo(null);
                ctr.getGerente().setDatHorAlteracao(null);
                ctr.getGerente().setDatHorCadastro(null);
                ctr.getGerente().setGrupos(null);
                ctr.getGerente().setDatHorUltimoLogin(null);
                ctr.getGerente().setCargo(null);
                ctr.getGerente().setIdPoderConcedente(null);
                ctr.getGerente().setIdUsuarioIns(null);
                ctr.getGerente().setIdUsuarioUpd(null);
                ctr.getGerente().setSessionUUID(null);
                ctr.getGerente().setSubTipo(null);
                ctr.getGerente().setTipo(null);
                ctr.getDiretor1().setDatHorAlteracao(null);
                ctr.getDiretor1().setDatHorCadastro(null);
                ctr.getDiretor1().setGrupos(null);
                ctr.getDiretor1().setDatHorUltimoLogin(null);
                ctr.getDiretor1().setCargo(null);
                ctr.getDiretor1().setIdPoderConcedente(null);
                ctr.getDiretor1().setIdUsuarioIns(null);
                ctr.getDiretor1().setIdUsuarioUpd(null);
                ctr.getDiretor1().setSessionUUID(null);
                ctr.getDiretor1().setSubTipo(null);
                ctr.getDiretor1().setTipo(null);
                ctr.getDiretor2().setDatHorAlteracao(null);
                ctr.getDiretor2().setDatHorCadastro(null);
                ctr.getDiretor2().setGrupos(null);
                ctr.getDiretor2().setDatHorUltimoLogin(null);
                ctr.getDiretor2().setCargo(null);
                ctr.getDiretor2().setIdPoderConcedente(null);
                ctr.getDiretor2().setIdUsuarioIns(null);
                ctr.getDiretor2().setIdUsuarioUpd(null);
                ctr.getDiretor2().setSessionUUID(null);
                ctr.getDiretor2().setSubTipo(null);
                ctr.getDiretor2().setTipo(null);
                for (ContratoServico svc : ctr.getServicos()) {
                    svc.getServico().setParametros(null);
                    svc.setDatHorAlteracao(null);
                    svc.setDatHorCadastro(null);
                    svc.setIdUsuarioIns(null);
                    svc.setIdUsuarioUpd(null);
                }
            }
            return new ResponseEntity((Object)contratos, HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findContratos", (Throwable)bizExc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findContratos", (Throwable)exc);
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

