/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.beans.geral.Empresa;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.security.SecretKeyBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Key;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.json.JsonMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TokenAuthenticationService {
    private static Logger logger = LoggerFactory.getLogger(TokenAuthenticationService.class);
    static final long EXPIRATION_TIME_TOKEN = 36000000L;
    static final long EXPIRATION_TIME_REFRESH = 172800000L;
    static final SecretKey SECRET = (SecretKey)((SecretKeyBuilder)Jwts.SIG.HS512.key()).build();
    static final String TOKEN_PREFIX = "Bearer";
    static final String HEADER_STRING = "Authorization";

    static String addAuthentication(HttpServletResponse response, String username, List<Empresa> empresas, String tipoDemanda) throws IOException {
        String jwt = TokenAuthenticationService.createToken((String)username);
        LinkedHashMap<String, Object> tokenData = new LinkedHashMap<String, Object>();
        tokenData.put("token", jwt);
        tokenData.put("refresh_token", TokenAuthenticationService.createRefreshToken((String)username));
        if (empresas != null && !empresas.isEmpty()) {
            tokenData.put("empresas", empresas);
        }
        tokenData.put("tipo", tipoDemanda);
        response.addHeader("Authorization", "Bearer " + jwt);
        response.setContentType("application/json;charset=UTF-8");
        try {
            JsonMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL))).changeDefaultPropertyInclusion(incl -> incl.withContentInclusion(JsonInclude.Include.NON_NULL))).build();
            String responseData = mapper.writeValueAsString(tokenData);
            response.getWriter().write(responseData);
        }
        catch (JacksonException jsonExc) {
            logger.error("jsonExc:", (Throwable)jsonExc);
            response.getWriter().write(jsonExc.getMessage());
        }
        response.getWriter().flush();
        response.getWriter().close();
        return jwt;
    }

    public static String createToken(String userName) {
        String jwt = Jwts.builder().subject(userName).expiration(new Date(System.currentTimeMillis() + 36000000L)).signWith(SignatureAlgorithm.HS512, (Key)SECRET).compact();
        return jwt;
    }

    static String createRefreshToken(String userName) {
        String jwt = Jwts.builder().subject(userName).expiration(new Date(System.currentTimeMillis() + 172800000L)).signWith(SignatureAlgorithm.HS512, (Key)SECRET).compact();
        return jwt;
    }

    static Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token != null && token.contains("Bearer")) {
            try {
                String user = ((Claims)Jwts.parser().verifyWith(SECRET).build().parseSignedClaims((CharSequence)token.replace("Bearer", "").trim()).getPayload()).getSubject();
                if (user != null) {
                    return new UsernamePasswordAuthenticationToken((Object)user, null, Collections.emptyList());
                }
            }
            catch (SignatureException sigExc) {
                return null;
            }
            catch (ExpiredJwtException sigExc) {
                logger.debug("token expirado: {}", (Object)token);
                return null;
            }
        }
        return null;
    }
}

