/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.spring.security.TokenAuthenticationService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class ExternalSAMLTokenFilter
extends OncePerRequestFilter {
    private static final List<String> urlMapping = List.of("/api/sso/tokenSaml2");
    private final RequestMatcher matcher = this.createRequestMatcher();

    private RequestMatcher createRequestMatcher() {
        LinkedList matchers = new LinkedList();
        urlMapping.forEach(url -> matchers.add(PathPatternRequestMatcher.pathPattern((String)url)));
        return new OrRequestMatcher(matchers);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean match = this.matcher.matches(request);
        if (!match) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String microservice = request.getHeader("X-FROM-MICROSERVICE");
        if (microservice != null && microservice.equals("SSO-SAML2")) {
            SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
            HttpSessionSecurityContextRepository secCtxRepo = new HttpSessionSecurityContextRepository();
            Authentication auth = TokenAuthenticationService.getAuthentication((HttpServletRequest)request);
            if (auth != null) {
                SecurityContext context = securityContextHolderStrategy.getContext();
                context.setAuthentication(auth);
                securityContextHolderStrategy.setContext(context);
                secCtxRepo.saveContext(context, request, response);
            }
        }
    }
}

