/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EquipeResponsavel;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.shared.Equipe;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.geral.EquipeDAO;
import br.com.oti.gesconsys.business.dao.geral.EquipeResponsavelDAO;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioEmpresaDAO;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailDiarioUsuarioHelper {
    @Autowired
    private CoreService coreService;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private EquipeDAO equipeDAO;
    @Autowired
    private EquipeResponsavelDAO equipeResponsavelDAO;
    @Autowired
    private UsuarioEmpresaDAO usuarioEmpresaDAO;

    public Boolean execute() {
        String webAppCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_WEBAPP_CONTEXT);
        if (webAppCtx == null || webAppCtx.isEmpty()) {
            throw new BusinessException("Application Context URL n\u00e3o informada.");
        }
        String apiUrl = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_API_CONTEXT);
        if (apiUrl == null || apiUrl.isEmpty()) {
            throw new BusinessException("API Context URL n\u00e3o informada.");
        }
        String userApi = (String)this.coreService.getRefValueByName(null, TipoRefCode.SCHEDULER_USUARIO_API);
        if (userApi == null || userApi.isEmpty()) {
            throw new BusinessException("Usu\u00e1rio API [Scheduler] n\u00e3o foi informado.");
        }
        List empresas = this.empresaDAO.findAll("", null);
        HashMap<String, List> tplData = new HashMap<String, List>();
        HashMap<Integer, ArrayList<Usuario>> gestoresMap = new HashMap<Integer, ArrayList<Usuario>>();
        for (Empresa empresa : empresas) {
            tplData.clear();
            Integer idEmpresa = empresa.getId();
            List usuariosEmpresa = this.usuarioEmpresaDAO.findUsuariosByEmpresasAndGrupos(List.of(idEmpresa), null, null, null, Boolean.valueOf(false), Boolean.valueOf(true), null);
            if (usuariosEmpresa == null || usuariosEmpresa.isEmpty()) continue;
            List equipes = this.equipeDAO.findAll(idEmpresa, null, null, null, Boolean.valueOf(false));
            for (Equipe eqp : equipes) {
                if (eqp.getIdGestorContrato() == null || eqp.getContrato() == null || eqp.getContrato().isEmpty()) continue;
                List usuariosEquipe = this.equipeResponsavelDAO.findAllResponsaveis(eqp.getId());
                block2: for (EquipeResponsavel usrEqp : usuariosEquipe) {
                    for (UsuarioEmpresa usrEmp : usuariosEmpresa) {
                        if (!usrEqp.getResponsavel().getId().equals(usrEmp.getId().getIdUsuario())) continue;
                        ArrayList<Usuario> gestores = (ArrayList<Usuario>)gestoresMap.get(eqp.getIdGestorContrato());
                        if (gestores == null) {
                            gestores = new ArrayList<Usuario>();
                            gestoresMap.put(eqp.getIdGestorContrato(), gestores);
                        }
                        gestores.add(usrEqp.getResponsavel());
                        continue block2;
                    }
                }
            }
            SimpleDateFormat sdfDatas = new SimpleDateFormat("dd/MM");
            String data = sdfDatas.format(LocalDateTime.now());
            for (Integer idGestor : gestoresMap.keySet()) {
                List usuarios = (List)gestoresMap.get(idGestor);
                tplData.put("usuarios", usuarios);
                String emailContent = this.coreService.processTemplate(idEmpresa, "resumoDiarioRegistroUsuariosEquipes.tpl", tplData);
                Email email = new Email();
                email.getId().setIdEmpresa(idEmpresa);
                email.setAssunto(String.format("Resumo di\u00e1rio registro %s - %s", empresa.getSigla(), data));
                email.setOrigem(TipoModulo.SEGURANCA.getSigla());
                email.setStatus(Integer.valueOf(0));
                EmailDestinatario destinatario = new EmailDestinatario(idEmpresa, idGestor, TipoDestinatario.EMAIL_TO);
                email.setDestinatarios(new ArrayList());
                email.getDestinatarios().add(destinatario);
                this.coreService.saveEmail(email, emailContent);
            }
        }
        return true;
    }
}

