/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.shared.EmailDiarioVO;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioEmpresaDAO;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.dao.seguranca.UsuarioAreaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import jakarta.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailDiarioLicencaHelper {
    private Logger logger = LoggerFactory.getLogger(EmailDiarioLicencaHelper.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private UsuarioEmpresaDAO usuarioEmpresaDAO;
    @Autowired
    private UsuarioAreaDAO usuarioAreaDAO;
    private Integer countEmails;
    private Map<Integer, List<EmailDiarioVO>> resumoAreas;

    @PostConstruct
    private void init() {
        this.countEmails = 0;
    }

    public Boolean execute() {
        String webAppCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_WEBAPP_CONTEXT);
        if (webAppCtx == null || webAppCtx.isEmpty()) {
            throw new BusinessException("Application Context URL n\u00e3o informada.");
        }
        this.resumoAreas = new HashMap();
        ArrayList<Integer> usuariosCache = new ArrayList<Integer>();
        List dataLicencas = null;
        ArrayList<UsuarioEmpresa> usersEmpresa = new ArrayList<UsuarioEmpresa>();
        HashMap tplData = new HashMap();
        SimpleDateFormat sdfDatas = new SimpleDateFormat("dd/MM");
        String data = sdfDatas.format(LocalDateTime.now());
        List empresas = this.empresaDAO.findAll("", null);
        ArrayList<Integer> empsId = new ArrayList<Integer>();
        ArrayList<String> usersValidate = new ArrayList<String>();
        for (Empresa empresa : empresas) {
            Object usrEmp22;
            usuariosCache.clear();
            usersEmpresa.clear();
            empsId.clear();
            empsId.add(empresa.getId());
            for (Object usrEmp22 : this.usuarioEmpresaDAO.findUsuariosByEmpresasAndGrupos(empsId, null, null, null, Boolean.valueOf(false), null, null)) {
                usersEmpresa.add((UsuarioEmpresa)usrEmp22);
                String keyUser = String.format("%d::%d", usrEmp22.getId().getIdEmpresa(), usrEmp22.getId().getIdUsuario());
                if (usersValidate.contains(keyUser)) continue;
                usersValidate.add(keyUser);
            }
            List usuariosAreas = this.usuarioAreaDAO.findUsuariosAreaByEmpresa(empresa.getId(), null, null, Boolean.valueOf(false));
            usrEmp22 = usuariosAreas.iterator();
            while (usrEmp22.hasNext()) {
                UsuarioArea usuarioArea = (UsuarioArea)usrEmp22.next();
                String modulos = usuarioArea.getModulos();
                if (modulos != null) {
                    if (!modulos.contains(TipoModulo.MEIO_AMBIENTE.getSigla())) continue;
                    usuariosCache.add(usuarioArea.getId().getIdUsuario());
                    continue;
                }
                usuariosCache.add(usuarioArea.getId().getIdUsuario());
            }
            List usrMailsEmp = this.empresaDAO.findUsuariosEmailByEmpresa(empresa.getId(), "L");
            LocalDate sysDate = LocalDate.now();
            ArrayList<Integer> empresasId = new ArrayList<Integer>();
            empresasId.add(empresa.getId());
            dataLicencas = this.licencaService.findLicencas(empresasId, null, null, null, null, null, null, null, null, null);
            if (dataLicencas != null && !dataLicencas.isEmpty()) {
                for (Licenca licenca : dataLicencas) {
                    if (licenca.getIdArea() == null) continue;
                    ArrayList<EmailDiarioVO> dataAreas = (ArrayList<EmailDiarioVO>)this.resumoAreas.get(licenca.getIdArea());
                    if (dataAreas == null) {
                        dataAreas = new ArrayList<EmailDiarioVO>();
                    }
                    if (licenca.getStatus() == null) continue;
                    String statusTxt = licenca.getStatus().getDescricao();
                    if ((statusTxt.toLowerCase().contains("vigente") || statusTxt.toLowerCase().contains("andamento")) && (licenca.getDataVencimento() == null || licenca.getDataVencimento().isBefore(sysDate))) {
                        dataAreas.add(this.generateLicencaMail(licenca, webAppCtx));
                    }
                    this.resumoAreas.put(licenca.getIdArea(), dataAreas);
                }
                this.logger.debug("licencas.count={}", (Object)dataLicencas.size());
            }
            this.logger.debug("Processando usu\u00e1rios, empresa '{}'", (Object)empresa.getSigla());
            for (Integer idUsuario : usuariosCache) {
                UsuarioEmpresa usuarioEmp = null;
                for (UsuarioEmpresa usuarioEmpresa : usersEmpresa) {
                    if (!usuarioEmpresa.getId().getIdUsuario().equals(idUsuario)) continue;
                    usuarioEmp = usuarioEmpresa;
                    break;
                }
                if (usuarioEmp == null) {
                    this.logger.debug("Usu\u00e1rio '{}' inativo, ignorado no email di\u00e1rio.", (Object)idUsuario);
                    continue;
                }
                tplData.clear();
                ArrayList areasLst = new ArrayList();
                for (UsuarioArea usuarioArea : usuariosAreas) {
                    List dataAreas;
                    if (!usuarioArea.getId().getIdUsuario().equals(idUsuario) || (dataAreas = (List)this.resumoAreas.get(usuarioArea.getId().getIdArea())) == null || dataAreas.isEmpty()) continue;
                    areasLst.addAll(dataAreas);
                }
                if (areasLst.size() > 0) {
                    tplData.put("licencas", areasLst);
                }
                String string = this.coreService.processTemplate(empresa.getId(), "resumoDiarioLicencas.tpl", tplData);
                Integer countCrit = areasLst.size();
                if (areasLst.size() <= 0) continue;
                Email email = new Email();
                email.getId().setIdEmpresa(empresa.getId());
                StringBuilder assuntoTxt = new StringBuilder();
                assuntoTxt.append("Di\u00e1rio licen\u00e7as ");
                assuntoTxt.append(usuarioEmp.getEmpresa().getSigla());
                assuntoTxt.append(" (").append(data).append(")");
                assuntoTxt.append(" - ");
                if (countCrit > 0) {
                    assuntoTxt.append(" Vencidas: ").append(countCrit);
                }
                email.setAssunto(assuntoTxt.toString());
                email.setOrigem(TipoModulo.MEIO_AMBIENTE.getSigla());
                email.setStatus(Integer.valueOf(0));
                EmailDestinatario destinatario = new EmailDestinatario(empresa.getId(), idUsuario, TipoDestinatario.EMAIL_TO);
                email.setDestinatarios(new ArrayList());
                email.getDestinatarios().add(destinatario);
                this.coreService.saveEmail(email, string);
                Integer n = this.countEmails;
                this.countEmails = this.countEmails + 1;
            }
        }
        return true;
    }

    private void processUsuario(Integer idUsuario, Licenca correspondencia, Map<Integer, List<EmailDiarioVO>> resumo, List<Integer> usuarios, List<String> usersValidate, String contextPath) {
        String keyUser;
        if (idUsuario == null || correspondencia == null) {
            return;
        }
        if (usersValidate != null && !usersValidate.contains(keyUser = String.format("%d::%d", correspondencia.getIdEmpresa(), idUsuario))) {
            return;
        }
        List<EmailDiarioVO> dadosUsuarios = resumo.get(idUsuario);
        if (dadosUsuarios == null) {
            dadosUsuarios = new ArrayList<EmailDiarioVO>();
            resumo.put(idUsuario, dadosUsuarios);
        }
        Boolean foundLicenca = false;
        for (EmailDiarioVO itemMail : dadosUsuarios) {
            if (!itemMail.getIdEmpresa().equals(correspondencia.getIdEmpresa()) || !itemMail.getIdLicenca().equals(correspondencia.getId())) continue;
            foundLicenca = true;
            break;
        }
        if (!foundLicenca.booleanValue()) {
            EmailDiarioVO correspMail = this.generateLicencaMail(correspondencia, contextPath);
            dadosUsuarios.add(correspMail);
        }
        if (!usuarios.contains(idUsuario)) {
            usuarios.add(idUsuario);
        }
    }

    private EmailDiarioVO generateLicencaMail(Licenca corresp, String contextPath) {
        EmailDiarioVO correspMail = new EmailDiarioVO();
        correspMail.setIdEmpresa(corresp.getIdEmpresa());
        correspMail.setIdLicenca(corresp.getId());
        correspMail.setNroLicenca(corresp.getNroLicenca());
        correspMail.setDescricao(corresp.getDescricao());
        LocalDate datVecto = corresp.getDataVencimento();
        if (datVecto != null) {
            correspMail.setDataVencimento(datVecto);
        }
        if (corresp.getEmpresa() != null) {
            correspMail.setSiglaEmpresa(corresp.getEmpresa().getSigla());
        }
        if (corresp.getArea() != null) {
            correspMail.setArea(corresp.getArea().getSigla());
        }
        StringBuilder outLink = new StringBuilder();
        outLink.append("/pages/correspondencias/correspondenciaEdit.faces");
        outLink.append("?idEmpresa=").append(correspMail.getIdEmpresa());
        outLink.append("&idCorrespondencia=").append(correspMail.getIdCorrespondencia());
        String encodedURL = new EncodeDecodeURL().encode(outLink.toString());
        outLink = new StringBuilder();
        outLink.append(contextPath);
        outLink.append("/forwardUrl?fwId=").append(encodedURL);
        correspMail.setExternalUrl(outLink.toString());
        return correspMail;
    }

    public Integer getCountEmails() {
        return this.countEmails == null ? 0 : this.countEmails;
    }
}

