/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.core.IndiceHistorico;
import br.com.oti.gesconsys.beans.core.IndiceReajuste;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para \u00edndice de reajustes", name="indiceReajustes")
@RequestMapping(value={"/api/indicesReajuste"})
public class IndiceReajustesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(IndiceReajustesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/indicadores"})
    @Operation(summary="Retorna uma listagem com o \u00edndice de reajuste, conforme filtro")
    @ResponseBody
    public ResponseEntity<List<IndiceReajuste>> findIndicesReajuste(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findIndicesReajuste({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            String[] status = request.getParameterValues("status");
            ArrayList<String> statusList = new ArrayList<String>();
            if (status != null) {
                statusList.addAll(Arrays.asList(status));
            }
            return new ResponseEntity((Object)this.coreService.findIndicesReajuste(search, emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findIndicesReajuste", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/indicadores/{idIndice}"})
    @Operation(summary="Retorna os dados do \u00edndice de reajuste solicitado")
    public ResponseEntity<IndiceReajuste> getIndiceReajusteById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIndice") Integer idIndice, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getIndiceReajusteById({}, {})", new Object[]{usuario.getLogin(), empresa, idIndice});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.getIndiceReajusteById(idIndice), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getIndiceReajusteById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/indicadores"})
    @Operation(summary="Atualiza os dados de \u00cdndice de reajuste")
    public ResponseEntity<IndiceReajuste> saveIndiceReajuste(@PathVariable(name="empresa") String empresa, @RequestBody IndiceReajuste indice, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveIndiceReajuste({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.saveIndiceReajuste(indice, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveIndiceReajuste", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/indicadores/{idIndice}"})
    @Operation(summary="Exclui o \u00edndice de reajuste, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteIndiceReajuste(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIndice") Integer idIndice, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteIndice({})", (Object)usuario.getLogin(), (Object)idIndice);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.deleteIndiceReajuste(idIndice), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteIndiceReajuste", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/historicosIndice"})
    @Operation(summary="Retorna uma listagem com o hist\u00f3rico do \u00edndice de reajuste, conforme filtro")
    public ResponseEntity<List<IndiceHistorico>> findIndicesHistorico(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findIndicesHistorico({})", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            String[] status = request.getParameterValues("status");
            ArrayList<String> statusList = new ArrayList<String>();
            if (status != null) {
                statusList.addAll(Arrays.asList(status));
            }
            return new ResponseEntity((Object)this.coreService.findIndicesHistorico(search), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findIndicesHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/historicosIndice/{idIndice}"})
    @Operation(summary="Retorna os dados do hist\u00f3ricos do \u00edndice de reajuste solicitado")
    public ResponseEntity<IndiceHistorico> getIndiceHistoricoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIndice") Integer idIndice, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getIndiceHistoricoById({}, {})", new Object[]{usuario.getLogin(), empresa, idIndice});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.getIndiceHistoricoById(idIndice), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getIndiceHistoricoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/historicosIndice"})
    @Operation(summary="Atualiza os dados de hist\u00f3rico do \u00edndice de reajuste")
    public ResponseEntity<IndiceHistorico> saveIndiceHistorico(@PathVariable(name="empresa") String empresa, @RequestBody IndiceHistorico indice, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveIndiceHistorico({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.saveIndiceHistorico(indice, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveIndiceHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/historicosIndice/{idIndice}"})
    @Operation(summary="Exclui o hist\u00f3ricos do \u00edndice de reajuste, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteIndiceHistorico(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIndice") Integer idIndice, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteIndiceHistorico({})", (Object)usuario.getLogin(), (Object)idIndice);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "INDICES_REAJUSTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"INDICES_REAJUSTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.coreService.deleteIndiceHistorico(idIndice), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteIndiceHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

