/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.seguranca.TipoEventoAuditoria;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSessao;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Logout", name="auth")
@RequestMapping(value={"/api/auth/logout"})
public class LogoutRestServices
extends BaseRestService {
    @Autowired
    private SegurancaService segurancaService;
    private static Logger logger = LoggerFactory.getLogger(LogoutRestServices.class);

    @PostMapping
    @Operation(summary="Executa o logout do usu\u00e1rio previamente autenticado")
    public Boolean logout(HttpServletRequest request) {
        String token = this.getToken(request);
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(token);
        if (sessao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Sess\u00e3o do usu\u00e1rio n\u00e3o foi encontrada.");
        }
        logger.debug("Executando logout REST ({})", (Object)sessao.getUsuario().getLogin());
        Integer idUsuario = sessao.getId().getIdUsuario();
        this.segurancaService.registraLogoutSessao(idUsuario, sessao.getId().getSequencia());
        String ipExterno = this.getIpExterno(request);
        this.segurancaService.registraAuditoria(null, String.format("Logout  com sucesso, usu\u00e1rio '%s'", sessao.getUsuario().getLogin()), idUsuario, TipoEventoAuditoria.EVENTO_LOGOUT.getCode(), ipExterno);
        return true;
    }
}

