/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.notificacoes;

import br.com.oti.gesconsys.beans.core.DicionarioPropertyVO;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.notificacao.ResumoGeralTroVO;
import br.com.oti.gesconsys.beans.notificacao.ResumoNotificacaoVO;
import br.com.oti.gesconsys.beans.notificacoes.Notificacao;
import br.com.oti.gesconsys.beans.notificacoes.NotificacaoPK;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.NotificacaoAnexo;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.NotificacaoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.reports.notificacoes.ConsultaNotificacoesExcel;
import br.com.oti.gesconsys.reports.notificacoes.RelatorioTROPdf;
import br.com.oti.gesconsys.reports.notificacoes.TermoRegistroOcorrenciaExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.notificacoes.NotificacoesRestServices;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DatabindException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import tools.jackson.databind.json.JsonMapper;

@RestController
@Tag(description="REST Services para notifica\u00e7\u00f5es", name="notificacoes")
@RequestMapping(value={"/api/notificacoes"})
public class NotificacoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(NotificacoesRestServices.class);
    private static DateTimeFormatter dataFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private NotificacaoService notificacaoService;
    @Autowired
    private JsonMapper jsonMapper;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta as notifica\u00e7\u00f5es, de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<List<Notificacao>> findNotificacoes(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="dataInicial", required=false) String dataInicial, @RequestParam(name="dataFinal", required=false) String dataFinal, @RequestParam(name="tipo", required=false) Integer tipo, @RequestParam(name="rodovias", required=false) List<Integer> rodovias) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={},search={})...", (Object)empresa, (Object)search);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            LocalDate datIniUtil = null;
            LocalDate datFimUtil = null;
            if (dataInicial != null) {
                datIniUtil = LocalDate.parse(dataInicial, dataFmt);
            }
            if (dataFinal != null) {
                datFimUtil = LocalDate.parse(dataFinal, dataFmt);
            }
            ArrayList<Integer> tiposNotificacao = null;
            if (tipo != null) {
                tiposNotificacao = new ArrayList<Integer>();
                tiposNotificacao.add(tipo);
            }
            List notificacoes = this.notificacaoService.findNotificacoes(empresasInt, search, tiposNotificacao, null, null, datIniUtil, datFimUtil, null, null, null, null, null, null, null, null, null, rodovias, null, null);
            return new ResponseEntity((Object)notificacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacao"})
    @Operation(summary="Efetua o download das notifica\u00e7\u00f5es em Excel")
    public ResponseEntity<byte[]> exportaNotificacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="dataInicial", required=false) String dataInicial, @RequestParam(name="dataFinal", required=false) String dataFinal, @RequestParam(name="rodovias", required=false) List<Integer> rodovias) {
        logger.debug("Exportando excel, notifica\u00e7\u00f5es (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            List notificacoes;
            byte[] bytes;
            ArrayList<DicionarioPropertyVO> prefsCampos = new ArrayList<DicionarioPropertyVO>();
            prefsCampos.add(new DicionarioPropertyVO("\u00c1rea", "area", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Respons\u00e1vel", "responsavel", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Subtipo", "subtipo", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Entidade", "entidade", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Setor", "setor", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Documento", "nroDocumento", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Assunto", "assunto", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Data", "data", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Prazo Of\u00edcio", "prazoOficio", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("Data Final Protocolo", "datFinalProtocolo", "Dados", null));
            prefsCampos.add(new DicionarioPropertyVO("N\u00ba Carta", "nroMinuta", "Dados", "A"));
            prefsCampos.add(new DicionarioPropertyVO("Data Resposta", "datResposta", "Resposta", "E"));
            prefsCampos.add(new DicionarioPropertyVO("N\u00ba Protocolo", "nroProtocolo", "Resposta", "E"));
            prefsCampos.add(new DicionarioPropertyVO("Status Notifica\u00e7\u00e3o", "notificacaoStatus", "Notifica\u00e7\u00e3o", null));
            prefsCampos.add(new DicionarioPropertyVO("Grupo Notifica\u00e7\u00e3o", "notificacaoGrupo", "Notifica\u00e7\u00e3o", null));
            prefsCampos.add(new DicionarioPropertyVO("N\u00edvel Notifica\u00e7\u00e3o", "notificacaoNivel", "Notifica\u00e7\u00e3o", null));
            prefsCampos.add(new DicionarioPropertyVO("Valor Notifica\u00e7\u00e3o", "valorNotificacao", "Notifica\u00e7\u00e3o", null));
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            LocalDate datIniUtil = null;
            LocalDate datFimUtil = null;
            if (dataInicial != null) {
                datIniUtil = LocalDate.parse(dataInicial, dataFmt);
            }
            if (dataFinal != null) {
                datFimUtil = LocalDate.parse(dataFinal, dataFmt);
            }
            if ((bytes = new ConsultaNotificacoesExcel().executeXLS(notificacoes = this.notificacaoService.findNotificacoes(empresasInt, search, null, null, null, datIniUtil, datFimUtil, null, null, null, null, null, null, null, null, null, null, null, null))) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"notificacoes.xlsx\"");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            return new ResponseEntity((Object)bytes, headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/resumo"})
    @Operation(summary="Retorna o resumo de Categorias e Trechos, de acordo com os filtros definidos")
    @ResponseBody
    public ResponseEntity<ResumoNotificacaoVO> findResumo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="ano", required=false) List<Integer> anos, @RequestParam(name="mes", required=false) Integer mes, @RequestParam(name="area", required=false) String area) {
        logger.debug("API search (empresa={}, anos={}, mes={}, area={})...", new Object[]{empresa, anos, mes, area});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            List tiposNotificacao = null;
            ResumoNotificacaoVO notifCache = this.notificacaoService.findResumoNotificacoes(empresasInt, search, tiposNotificacao, anos, mes, area);
            return new ResponseEntity((Object)notifCache, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idNotificacao}/RTRO"})
    @Operation(summary="Efetua o download da TRO de notifica\u00e7\u00f5es")
    public ResponseEntity<byte[]> exportaTRO(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idNotificacao") Integer idNotificacao) throws IOException {
        logger.debug("Exportando excel, TRO notifica\u00e7\u00f5es (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            Notificacao notificacao;
            String formato = "XLS";
            if (request.getParameter("formato") != null) {
                formato = request.getParameter("formato");
            }
            if ((notificacao = this.notificacaoService.getNotificacaoById(emp.getId(), idNotificacao, usuario.getLogin())) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("TRO '%d' n\u00e3o encontrada.", idNotificacao));
            }
            List rodoviasNotificacao = this.notificacaoService.findNotificacoesRodovia(notificacao.getId().getIdEmpresa(), notificacao.getId().getIdNotificacao());
            List planosAcao = this.notificacaoService.findPlanosAcao(notificacao.getId().getIdEmpresa(), notificacao.getId().getIdNotificacao());
            List imagens = this.notificacaoService.findAnexos(notificacao.getId().getIdEmpresa(), notificacao.getId().getIdNotificacao());
            byte[] bytes = null;
            if (formato.equalsIgnoreCase("xls")) {
                bytes = new TermoRegistroOcorrenciaExcel(this.coreService, this.cadastroService, this.gedService).executeXLS(rodoviasNotificacao, notificacao, planosAcao, imagens);
            } else if (formato.equalsIgnoreCase("pdf")) {
                bytes = new RelatorioTROPdf(this.coreService, this.cadastroService, this.gedService).executePDF(rodoviasNotificacao, notificacao, planosAcao, imagens, null);
            }
            if (bytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            if (formato.equalsIgnoreCase("xls")) {
                headers.add("Content-Disposition", "attachment; filename=\"rTro.xlsx\"");
                headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            } else {
                headers.add("Content-Disposition", "attachment; filename=\"rTro.pdf\"");
                headers.add("Content-Type", "application/pdf");
            }
            return new ResponseEntity((Object)bytes, headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/TROS/recebidos"})
    @Operation(summary="Retorna a lista de TROS recebidos")
    public ResponseEntity<Map<String, List<ResumoGeralTroVO>>> findTrosRecebidos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        logger.debug("executando Search...");
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Integer anoTro = null;
            Integer mesTro = null;
            if (request.getParameter("anoTro") != null) {
                anoTro = Integer.valueOf(request.getParameter("anoTro"));
            }
            if (request.getParameter("mesTro") != null) {
                mesTro = Integer.valueOf(request.getParameter("mesTro"));
            }
            ArrayList<Integer> anosTro = null;
            if (anoTro != null) {
                anosTro = new ArrayList<Integer>();
                anosTro.add(anoTro);
            }
            List rows = this.notificacaoService.findResumosTro(emp.getId(), anosTro, mesTro, usuario.getId());
            HashMap resumoTroVO = new HashMap();
            ArrayList<String> gruposTrecho = new ArrayList<String>();
            String grupoTrecho = null;
            for (ResumoGeralTroVO row : rows) {
                if (row.getGrupoTrecho() != null && !row.getGrupoTrecho().equals(grupoTrecho)) {
                    grupoTrecho = row.getGrupoTrecho();
                    gruposTrecho.add(grupoTrecho);
                    resumoTroVO.put(grupoTrecho, new ArrayList());
                }
                if (grupoTrecho == null) continue;
                ((List)resumoTroVO.get(grupoTrecho)).add(row);
            }
            return new ResponseEntity(resumoTroVO, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/TROS/totalizadorKm"})
    @Operation(summary="Retorna a lista de km total TROS")
    public ResponseEntity<Map<String, List<ResumoGeralTroVO>>> findTrosTotais(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        logger.debug("executando Search...");
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            ArrayList<Integer> categorias = null;
            Integer kmIni = null;
            Integer kmFim = null;
            String[] listCategorias = null;
            if (request.getParameterValues("categorias") != null && (listCategorias = request.getParameterValues("categorias")) != null) {
                categorias = new ArrayList<Integer>();
                for (String itemCat : listCategorias) {
                    categorias.add(Integer.valueOf(itemCat));
                }
            }
            if (request.getParameter("kmIni") != null) {
                kmIni = Integer.valueOf(request.getParameter("kmIni"));
            }
            if (request.getParameter("kmFim") != null) {
                kmFim = Integer.valueOf(request.getParameter("kmFim"));
            }
            List rows = this.notificacaoService.findRelatorioTotalizadorKm(emp.getId(), kmIni, kmFim, usuario.getId(), categorias);
            HashMap resumoTroVO = new HashMap();
            ArrayList<String> gruposTrecho = new ArrayList<String>();
            String grupoTrecho = null;
            for (ResumoGeralTroVO row : rows) {
                if (row.getGrupoTrecho() != null && !row.getGrupoTrecho().equals(grupoTrecho)) {
                    grupoTrecho = row.getGrupoTrecho();
                    gruposTrecho.add(grupoTrecho);
                    resumoTroVO.put(grupoTrecho, new ArrayList());
                }
                if (grupoTrecho == null) continue;
                ((List)resumoTroVO.get(grupoTrecho)).add(row);
            }
            return new ResponseEntity(resumoTroVO, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idNotificacao}"})
    @Operation(summary="Retorna dados da notifica\u00e7\u00e3o, de acordo com a Empresa e ID da notifica\u00e7\u00e3o")
    @ResponseBody
    public ResponseEntity<Notificacao> getNotificacaoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idNotificacao") Integer idNotificacao) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - API getNotificacaoById... {}, {}", new Object[]{usuario.getLogin(), empresa, idNotificacao});
        try {
            List rodovias;
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Notificacao notificacao = this.notificacaoService.getNotificacaoById(emp.getId(), idNotificacao, usuario.getLogin());
            if (notificacao == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Notifica\u00e7\u00e3o n\u00e3o encontrada.");
            }
            if (usuario.getPoderConcedente() != null && usuario.getPoderConcedente().equals(true)) {
                this.notificacaoService.criarHistorico(emp.getId(), idNotificacao, "Acesso Ag\u00eancia", null, usuario.getId());
            }
            if ((rodovias = this.notificacaoService.findNotificacoesRodovia(emp.getId(), idNotificacao)) != null) {
                for (Object rdv : rodovias) {
                    rdv.setNotificacao(null);
                }
            }
            notificacao.setRodovias(rodovias);
            List anexos = this.notificacaoService.findAnexos(emp.getId(), idNotificacao);
            if (anexos != null) {
                if (notificacao.getAnexos() == null) {
                    notificacao.setAnexos(new ArrayList());
                }
                for (NotificacaoAnexo anx : anexos) {
                    if (anx.getTipoAnexo() == null || !anx.getTipoAnexo().equals("ANX")) continue;
                    notificacao.getAnexos().add(anx);
                }
                1 anexosComparator = new /* Unavailable Anonymous Inner Class!! */;
                Collections.sort(notificacao.getAnexos(), anexosComparator);
            }
            return new ResponseEntity((Object)notificacao, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getNotificacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getNotificacaoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/registrar"})
    @Operation(summary="Salva a notifica\u00e7\u00e3o, de acordo com a Empresa e ID da notifica\u00e7\u00e3o + Payload")
    @ResponseBody
    public ResponseEntity<NotificacaoPK> registrarNotificacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API registrarNotificacao...{}", (Object)empresa);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String sessionId = request.getParameter("sessionId");
            Map formData = request.getParameterMap();
            Notificacao notificacao = (Notificacao)this.jsonMapper.readValue(((String[])formData.get("notificacao"))[0], Notificacao.class);
            if (notificacao.getId() == null) {
                notificacao.setId(new NotificacaoPK());
            }
            NotificacaoPK notPK = this.notificacaoService.saveNotificacao(notificacao, usuario.getId(), request.getLocalAddr(), sessionId);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap filesMap = multipartReq.getMultiFileMap();
            MultipartFile fileMap = null;
            if (filesMap != null) {
                for (String keySet : filesMap.keySet()) {
                    List filesList = (List)filesMap.get((Object)keySet);
                    if (filesList == null || filesList.size() <= 0) continue;
                    fileMap = (MultipartFile)filesList.get(0);
                    break;
                }
            }
            if (fileMap != null) {
                NotificacaoAnexo anexo = new NotificacaoAnexo();
                anexo.getId().setIdEmpresa(emp.getId());
                anexo.getId().setIdNotificacao(notPK.getIdNotificacao());
                anexo.setDatHorCadastro(LocalDateTime.now());
                anexo.setIdUsuarioIns(usuario.getId());
                String nomeAnexo = fileMap.getOriginalFilename();
                if (nomeAnexo.length() > 80) {
                    nomeAnexo = nomeAnexo.substring(nomeAnexo.length() - 80, nomeAnexo.length());
                }
                UploadedFileInfo fileInfo = new UploadedFileInfo(fileMap.getOriginalFilename(), fileMap.getContentType(), Long.valueOf(fileMap.getSize()), fileMap.getInputStream());
                this.notificacaoService.registraUploadAnexo(anexo, fileInfo, notificacao.getIdArea(), usuario.getId());
                this.notificacaoService.saveAnexo(anexo, notificacao, usuario.getId());
            }
            return new ResponseEntity((Object)notPK, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarNotificacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (DatabindException jsmExc) {
            logger.error("JsmExc.registrarNotificacao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JacksonException jspExc) {
            logger.error("JspExc.registrarNotificacao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("IoExc.registrarNotificacao", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idNotificacao}/notificacoes"})
    @Operation(summary="Deleta a refer\u00eancia de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteNotificacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idNotificacao") Integer idNotificacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteNotificacao({}, {})", (Object)empresa, (Object)idNotificacao);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            this.notificacaoService.deleteNotificacao(emp.getId(), idNotificacao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteNotificacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

