/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.core;

import br.com.oti.gesconsys.beans.geral.Calendario;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.PoderConcedente;
import br.com.oti.gesconsys.beans.geral.UnidadeMedida;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Fornecedor;
import br.com.oti.gesconsys.beans.shared.Tema;
import br.com.oti.gesconsys.beans.shared.TipoDocumento;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services Cadastros, relacionados as estruturas de tabelas do sistema", name="cadastros")
@RequestMapping(value={"/api/cadastros"})
public class CadastrosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CoreService coreService;

    @GetMapping(value={"/poderesConcedentes"})
    @Operation(summary="Lista os Poderes Concedentes cadastrados .")
    public ResponseEntity<List<PoderConcedente>> findPoderesConcedentes(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            Object tipoAtivo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("{} - findPoderesConcedentes({}, {})", new Object[]{usuario.getLogin(), search, tipoAtivo});
            List rows = this.cadastroService.findPoderConcedente(search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPoderesConcedentes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/poderesConcedentes/{idPoderConcedente}"})
    @Operation(summary="Busca o poder concedente conforme seu ID.")
    public ResponseEntity<PoderConcedente> getPoderConcedenteById(@PathVariable(name="idPoderConcedente") Integer idPoderConcedente, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getPoderConcedenteById({})", (Object)usuario.getLogin(), (Object)idPoderConcedente);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getPoderConcedenteById(idPoderConcedente));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCategoriaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/poderesConcedentes"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do Poder Concedente.")
    public ResponseEntity<PoderConcedente> savePoderConcedente(@RequestBody PoderConcedente poderConcedente, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PoderConcedente poderDB = this.cadastroService.savePoderConcedente(poderConcedente, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)poderDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePoderConcedente", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/poderesConcedentes/{idPoderConcedente}"})
    @Operation(summary="Deleta o poder concedente de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePoderConcedente(@PathVariable(name="idPoderConcedente") Integer idPoderConcedente, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deletePoderConcedente({})", (Object)usuario.getLogin(), (Object)idPoderConcedente);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "PODER_CONCEDENTE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"PODER_CONCEDENTE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deletePoderConcedente(idPoderConcedente);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePoderConcedente", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/temas"})
    @Operation(summary="Lista os temas cadastrados.")
    public ResponseEntity<List<Tema>> findTemas(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findUnidades({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List rows = this.cadastroService.findTemas(search, empresaDB.getId());
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTemas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/temas/{idTema}"})
    @Operation(summary="Busca o tema conforme seu identificador.")
    public ResponseEntity<Tema> getTemaById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTema") Integer idTema, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getUnidadeById({}, {})", new Object[]{usuario.getLogin(), empresa, idTema});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getTemaById(idTema));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTemaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/temas"})
    @Operation(summary="Salva o tema relacionado.")
    public ResponseEntity<Tema> saveTema(@PathVariable(name="empresa") String empresa, @RequestBody Tema tema, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveTema({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Tema temaDB = this.cadastroService.saveTema(tema, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)temaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTema", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/temas/{idTema}"})
    @Operation(summary="Deleta o tema de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTema(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTema") Integer idTema, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteTema({})", (Object)usuario.getLogin(), (Object)idTema);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TEMAS_TAGS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TEMAS_TAGS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.cadastroService.deleteTema(idTema);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTema", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposDocumentos"})
    @Operation(summary="Lista os tipos de documentos cadastrados .")
    public ResponseEntity<List<TipoDocumento>> findTiposDocumentos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findUnidades({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List rows = this.cadastroService.findTiposDocumentos(emp.getId(), search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposDocumentos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tiposDocumentos/{idTipoDocumento}"})
    @Operation(summary="Busca o Tipo de documento conforme seu identificador.")
    public ResponseEntity<TipoDocumento> getTipoDocumentoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDocumento") Integer idTipoDocumento, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getUnidadeById({}, {})", new Object[]{usuario.getLogin(), empresa, idTipoDocumento});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getTipoDocumentoById(empresaDB.getId(), idTipoDocumento));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoDocumentoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/tiposDocumentos"})
    @Operation(summary="Salva o Tipo de documento relacionado.")
    public ResponseEntity<TipoDocumento> saveTipoDocumento(@PathVariable(name="empresa") String empresa, @RequestBody TipoDocumento tipoDocto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveTipoDocumento({})", (Object)usuario.getLogin(), (Object)empresa);
            TipoDocumento tipoDB = this.cadastroService.saveTipoDocumento(tipoDocto, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)tipoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/tiposDocumentos/{idTipoDocumento}"})
    @Operation(summary="Deleta o tema de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoDocumento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipoDocumento") Integer idTipoDocumento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteTipoDocumento({})", (Object)usuario.getLogin(), (Object)idTipoDocumento);
            return new ResponseEntity((Object)this.cadastroService.deleteTipoDocumento(empresaDB.getId(), idTipoDocumento), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores"})
    @Operation(summary="Lista os fornecedores cadastrados.")
    public ResponseEntity<List<Fornecedor>> findFornecedores(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} -  findFornecedores({})...", (Object)usuario.getLogin(), (Object)empresa);
            String search = null;
            String modulo = null;
            if (request.getParameter("modulo") != null) {
                modulo = request.getParameter("modulo");
            }
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List rows = this.cadastroService.findFornecedores(search, modulo);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFornecedores", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores/{idFornecedor}"})
    @Operation(summary="Busca o fornecedor conforme seu ID.")
    public ResponseEntity<Fornecedor> getFornecedorById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFornecedor") Integer idFornecedor) {
        try {
            logger.debug("getFornecedorById({}, {})", (Object)empresa, (Object)idFornecedor);
            return ResponseEntity.ok().body((Object)this.cadastroService.getFornecedorById(idFornecedor));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFornecedorById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fornecedores"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do fornecedor.")
    public ResponseEntity<Fornecedor> saveFornecedor(@PathVariable(name="empresa") String empresa, @RequestBody Fornecedor fornecedor, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
            }
            Fornecedor fornecedorDB = this.cadastroService.saveFornecedor(fornecedor, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)fornecedorDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFornecedor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/fornecedores/{idFornecedor}"})
    @Operation(summary="Deleta o fornecedor conforme seu ID.")
    public ResponseEntity<Boolean> deleteFornecedor(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFornecedor") Integer idFornecedor, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("deleteFornecedor({}, {})", (Object)empresa, (Object)idFornecedor);
            this.cadastroService.deleteFornecedor(idFornecedor);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFornecedor", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/unidadesMedida"})
    public ResponseEntity<List<UnidadeMedida>> findUnidades(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findUnidades({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "UNIDADES_MEDIDA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"UNIDADES_MEDIDA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.cadastroService.findUnidades(searchTxt), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findUnidades", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/unidadesMedida/{idUnidade}"})
    public ResponseEntity<UnidadeMedida> getUnidadeById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idUnidade") Integer idUnidade, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getUnidadeById({}, {})", new Object[]{usuario.getLogin(), empresa, idUnidade});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "UNIDADES_MEDIDA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"UNIDADES_MEDIDA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.getUnidadeById(idUnidade), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUnidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/unidadesMedida"})
    public ResponseEntity<UnidadeMedida> saveUnidade(@PathVariable(name="empresa") String empresa, @RequestBody UnidadeMedida unidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveUnidade({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "UNIDADES_MEDIDA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"UNIDADES_MEDIDA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PublicUser userData = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.cadastroService.saveUnidade(unidade, userData.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUnidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/unidadesMedida/{idUnidade}"})
    public ResponseEntity<Boolean> deleteUnidade(@PathVariable(name="empresa") String empresa, @PathVariable(name="idUnidade") Integer idUnidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteUnidade({})", (Object)usuario.getLogin(), (Object)idUnidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "UNIDADES_MEDIDA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"UNIDADES_MEDIDA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteUnidade(idUnidade), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteUnidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/calendarios"})
    @Operation(summary="Lista os calend\u00e1rios da empresa a partir de uma data inicial.")
    public ResponseEntity<List<Calendario>> findCalendarios(@PathVariable(name="empresa") String empresa, @RequestParam(name="dataInicial", required=false) String dataInicialStr, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findCalendarios({}, {})", new Object[]{usuario.getLogin(), empresa, dataInicialStr});
        try {
            LocalDate dataInicial = dataInicialStr != null ? LocalDate.parse(dataInicialStr) : LocalDate.now();
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List calendarios = this.coreService.findCalendarios(emp.getId(), dataInicial);
            return ResponseEntity.ok().body((Object)calendarios);
        }
        catch (BusinessException bizExc) {
            logger.error("BusinessException ao buscar calend\u00e1rios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Erro inesperado ao buscar calend\u00e1rios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao buscar calend\u00e1rios.");
        }
    }

    @GetMapping(value={"/{empresa}/calendarios/intervalo"})
    @Operation(summary="Lista os calend\u00e1rios da empresa entre uma data inicial e uma data final.")
    public ResponseEntity<List<Calendario>> findCalendarioByIntervalo(@PathVariable(name="empresa") String empresa, @RequestParam(name="dataIni", required=false) String dataIniStr, @RequestParam(name="dataFim", required=false) String dataFimStr, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findCalendarioByIntervalo({}, {}, {})", new Object[]{usuario.getLogin(), empresa, dataIniStr, dataFimStr});
        try {
            LocalDate dataIni = dataIniStr != null ? LocalDate.parse(dataIniStr) : LocalDate.now();
            LocalDate dataFim = dataFimStr != null ? LocalDate.parse(dataFimStr) : LocalDate.now();
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            List calendarios = this.coreService.findCalendarioByIntervalo(emp.getId(), dataIni, dataFim);
            return ResponseEntity.ok().body((Object)calendarios);
        }
        catch (BusinessException bizExc) {
            logger.error("BusinessException ao buscar calend\u00e1rios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Erro inesperado ao buscar calend\u00e1rios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao buscar calend\u00e1rios.");
        }
    }

    @PostMapping(value={"/{empresa}/calendarios"})
    @Operation(summary="Salva um novo calend\u00e1rio para a empresa e atualiza os dias \u00fateis.")
    public ResponseEntity<Void> saveCalendario(@PathVariable(name="empresa") String empresa, @RequestBody Calendario calendario, HttpServletRequest httpRequest) {
        PublicUser usuario = this.getUsuarioByJWT(httpRequest);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando saveCalendario para a empresa {}", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (!calendario.getId().getIdEmpresa().equals(empresaDB.getId())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Calend\u00e1rio n\u00e3o pertence \u00e0 empresa informada.");
            }
            this.coreService.saveCalendario(calendario);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        catch (BusinessException bizExc) {
            logger.error("BusinessException ao salvar calend\u00e1rio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Erro inesperado ao salvar calend\u00e1rio", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao salvar calend\u00e1rio.");
        }
    }

    @PostMapping(value={"/{empresa}/calendarios/gerar"})
    @Operation(summary="Gera o calend\u00e1rio para a empresa no intervalo de anos informado.")
    public ResponseEntity<Void> gerarCalendario(@PathVariable(name="empresa") String empresa, @RequestParam(name="anoIni") Integer anoIni, @RequestParam(name="anoFim") Integer anoFim, HttpServletRequest httpRequest) {
        PublicUser usuario = this.getUsuarioByJWT(httpRequest);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando gerarCalendario para a empresa {}, de {} at\u00e9 {}", new Object[]{usuario.getLogin(), empresa, anoIni, anoFim});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.coreService.gerarCalendario(empresaDB.getId(), anoIni, anoFim);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        catch (BusinessException bizExc) {
            logger.error("Erro de neg\u00f3cio ao gerar calend\u00e1rio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Erro inesperado ao gerar calend\u00e1rio", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao gerar calend\u00e1rio.");
        }
    }
}

