/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.geral.TipoFluxoCaixa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.PleitoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services Cadastros Pleitos, relacionados as estruturas de tabelas do sistema", name="cadastrosPleitos")
@RequestMapping(value={"/api/cadastrosPleitos"})
public class CadastrosPleitosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosPleitosRestServices.class);
    @Autowired
    private PleitoService pleitoService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping(value={"/fluxosCaixa"})
    @Operation(summary="Salva as informa\u00e7\u00f5es do tipo fluxo de caixa.")
    public ResponseEntity<TipoFluxoCaixa> postFluxoCaixa(@RequestBody TipoFluxoCaixa fluxoCaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoFluxoCaixa poderDB = this.pleitoService.saveTipoFluxoCaixa(fluxoCaixa, Integer.valueOf(1));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)poderDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFluxoCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/fluxosCaixa"})
    @Operation(summary="Atualliza as informa\u00e7\u00f5es do tipo fluxo de caixa.")
    public ResponseEntity<TipoFluxoCaixa> updateFluxoCaixa(@RequestBody TipoFluxoCaixa fluxoCaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoFluxoCaixa poderDB = this.pleitoService.saveTipoFluxoCaixa(fluxoCaixa, Integer.valueOf(1));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)poderDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateFluxoCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fluxosCaixa"})
    @Operation(summary="Lista os tipos de fluxo de caixa cadastrados .")
    public ResponseEntity<List<TipoFluxoCaixa>> findFluxosCaixa(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            String tipoAtivo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("tipoAtivo") != null) {
                tipoAtivo = request.getParameter("tipoAtivo");
            }
            logger.debug("{} - findFluxosCaixa({}, {})", new Object[]{usuario.getLogin(), search, tipoAtivo});
            List rows = this.pleitoService.findTiposFluxosCaixa(search);
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFluxosCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fluxosCaixa/{idTipofluxoCaixa}"})
    @Operation(summary="Busca o fluxo caixa conforme seu ID.")
    public ResponseEntity<TipoFluxoCaixa> getFluxoCaixaById(@PathVariable Integer idTipofluxoCaixa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getFluxoCaixaById({})", (Object)usuario.getLogin(), (Object)idTipofluxoCaixa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.pleitoService.getTipoFluxoCaixaById(idTipofluxoCaixa));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFluxoCaixaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fluxosCaixa/{idTipoFluxoCaixa}"})
    @Operation(summary="Deleta o fluxo de caixa de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteFluxoCaixa(@PathVariable Integer idTipoFluxoCaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteFluxoCaixa({})", (Object)usuario.getLogin(), (Object)idTipoFluxoCaixa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "TIPOS_FLUXO_CAIXA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"TIPOS_FLUXO_CAIXA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            this.pleitoService.deleteTipoFluxoCaixa(idTipoFluxoCaixa);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFluxoCaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

