/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.seguranca.CreateUserVO;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para reset de usu\u00e1rios", name="reset")
@RequestMapping(value={"/api/reset"})
public class ResetPasswordRestServices {
    private static Logger logger = LoggerFactory.getLogger(ResetPasswordRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping(value={"/demandas/{tipoDemanda}"})
    @Operation(summary="Reseta a senha do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<String> resetPasswordDemandas(@PathVariable(name="tipoDemanda") String tipoDemanda, @RequestBody CreateUserVO usuario) {
        logger.debug("Executando resetPassword(tipoDemanda={}, usr={})...", (Object)tipoDemanda, (Object)(usuario != null ? usuario.getLogin() : ""));
        if (usuario == null || usuario.getLogin() == null || usuario.getLogin().isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Login ou dados do usu\u00e1rio inv\u00e1lidos.");
        }
        try {
            Usuario userReset = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
            if (userReset == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Usu\u00e1rio n\u00e3o foi encontrado.");
            }
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(userReset.getId());
            if (perfil.isInativoFlag().booleanValue()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio est\u00e1 com acesso Inativo, imposs\u00edvel prosseguir.");
            }
            List empresas = this.segurancaService.findEmpresasByUsuario(userReset.getId());
            if (empresas == null || empresas.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 empresas associadas com o usu\u00e1rio");
            }
            String demandaCtx = "";
            if (tipoDemanda.equals("DEM")) {
                demandaCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_SISDEMANDA_CONTEXT);
                if (demandaCtx == null || demandaCtx.isEmpty()) {
                    throw new BusinessException("Sisdemanda URL contexto n\u00e3o informado.");
                }
            } else if (tipoDemanda.equals("FXD")) {
                demandaCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_FAIXADOMINIO_CONTEXT);
                if (demandaCtx == null || demandaCtx.isEmpty()) {
                    throw new BusinessException("Faixa dom\u00ednio, URL contexto n\u00e3o informado.");
                }
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo de demanda inv\u00e1lida.");
            }
            HashMap<String, Object> tplData = new HashMap<String, Object>();
            tplData.put("usuario", userReset);
            String encodedURL = new EncodeDecodeURL().encode(userReset.getId().toString());
            StringBuilder outLink = new StringBuilder();
            outLink.append(demandaCtx);
            outLink.append("/resetConfirm/").append(encodedURL);
            tplData.put("externalLink", outLink.toString());
            Integer idEmpresa = ((UsuarioEmpresa)empresas.get(0)).getId().getIdEmpresa();
            String emailContent = this.coreService.processTemplate(idEmpresa, "resetPassword.tpl", tplData);
            Email mail = new Email();
            mail.getId().setIdEmpresa(idEmpresa);
            mail.setAssunto("Reset de Senha - " + (tipoDemanda.equals("DEM") ? "SisDemanda" : "Faixa dom\u00ednio"));
            mail.setOrigem(TipoModulo.DEMANDAS.getSigla());
            EmailDestinatario destinatario = new EmailDestinatario(idEmpresa, userReset.getId(), TipoDestinatario.EMAIL_TO);
            mail.setDestinatarios(new ArrayList());
            mail.getDestinatarios().add(destinatario);
            this.coreService.saveEmail(mail, emailContent);
            return new ResponseEntity((Object)"Solicita\u00e7\u00e3o de reset processada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.resetPasswordDemandas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.resetPasswordDemandas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/confirm/{userId}"})
    @Operation(summary="Efetua a confirma\u00e7\u00e3o de um reset de senha")
    public ResponseEntity<String> confirmResetPassword(@PathVariable(name="userId") String userId, @RequestBody CreateUserVO payloadReset) {
        logger.debug("Executando confirmRegister(id={})...", (Object)userId);
        if (userId == null || userId.isEmpty() || payloadReset == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio n\u00e3o foram informados corretamente.");
        }
        try {
            String decoded = new EncodeDecodeURL().decode(userId);
            if (decoded == null || decoded.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio s\u00e3o inv\u00e1lidos.");
            }
            Integer idUsuario = Integer.valueOf(decoded);
            Usuario user = this.segurancaService.getUsuarioById(idUsuario);
            if (user == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Registro de usu\u00e1rio n\u00e3o encontrado.");
            }
            if (this.segurancaService.resetPassword(user.getLogin(), payloadReset.getPassword(), payloadReset.getConfirmPassword()).booleanValue()) {
                return new ResponseEntity((Object)"Reset da senha realizado com sucesso.", (HttpStatusCode)HttpStatus.OK);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Imposs\u00edvel reiniciar a senha.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUserInfo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getUserInfo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

