/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioGrupoDAO;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioPerfilDAO;
import br.com.oti.gesconsys.dao.seguranca.UsuarioDAO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    private UsuarioDAO usuarioDAO;
    @Autowired
    private UsuarioPerfilDAO usuarioPerfilDAO;
    @Autowired
    private UsuarioGrupoDAO usuarioGrupoDAO;

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        Usuario user = this.usuarioDAO.getByLogin(userName);
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + userName);
        }
        UsuarioPerfil perfil = this.usuarioPerfilDAO.getExtensaoPerfilByIdUsuario(user.getId());
        boolean enabled = true;
        boolean accountNonExpired = true;
        boolean credentialsNonExpired = true;
        boolean accountNonLocked = true;
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        List perfis = this.usuarioGrupoDAO.findUsuarioGruposByUsuario(user.getId());
        for (UsuarioGrupo grupo : perfis) {
            authorities.add(new SimpleGrantedAuthority(grupo.getGrupoAcesso().getDescricao()));
        }
        if (authorities.isEmpty()) {
            throw new UsernameNotFoundException("User without authorities");
        }
        return new User(user.getLogin(), perfil.getSenha(), enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }
}

