/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.spring.security.CorsFilter;
import br.com.oti.gesconsys.spring.security.CustomAuthenticationFilter;
import br.com.oti.gesconsys.spring.security.CustomAuthenticationProvider;
import br.com.oti.gesconsys.spring.security.CustomPageAuthenticationFailureHandler;
import br.com.oti.gesconsys.spring.security.CustomRestAuthenticationFailureHandler;
import br.com.oti.gesconsys.spring.security.JWTAuthenticationFilter;
import br.com.oti.gesconsys.spring.security.JwtLoginFilter;
import br.com.oti.gesconsys.spring.security.RestAuthenticationEntryPoint;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
@ComponentScan(value={"br.com.oti.gesconsys"})
public class SecurityConfig {
    @Autowired
    private AuthenticationSuccessHandler authSuccessHandler;
    @Autowired
    private CustomAuthenticationProvider customAuthProvider;
    @Autowired
    private RestAuthenticationEntryPoint restAuthenticationEntryPoint;
    @Autowired
    private CustomRestAuthenticationFailureHandler restAuthenticationFailureHandler;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @Bean
    AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.customAuthProvider);
    }

    @Bean
    CustomAuthenticationFilter apiAuthenticationFilter(AuthenticationManager authenticationManager) throws Exception {
        CustomAuthenticationFilter filter = new CustomAuthenticationFilter();
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler(this.authSuccessHandler);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.restAuthenticationFailureHandler);
        return filter;
    }

    @Bean
    CustomAuthenticationFilter formAuthenticationFilter(AuthenticationManager authenticationManager) throws Exception {
        CustomAuthenticationFilter filter = new CustomAuthenticationFilter();
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler(this.authSuccessHandler);
        return filter;
    }

    private static CorsConfigurationSource corsConfigSource() {
        CorsConfiguration corsConfig = new CorsConfiguration();
        corsConfig.setAllowedOriginPatterns(List.of("*"));
        corsConfig.setAllowedMethods(List.of("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"));
        corsConfig.setAllowedHeaders(List.of("Authorization", "Cache-Control", "Content-Type"));
        corsConfig.setExposedHeaders(List.of("Authorization"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfig);
        return source;
    }

    @Bean
    @Order(value=2)
    SecurityFilterChain apiFilterChain(HttpSecurity http) throws Exception {
        String[] allowedList = new String[]{"/api/ping", "/api/assinaturas/**", "/api/downloads/**", "/api/core/refCodes/empresaAutenticacao", "/api/empresas/all", "/api/reset/**", "/api/register/**", "/api/v1/register/**", "/api/v1/reset/**", "api/v1/downloads/{empresa}/anexos/{modulo}/{uuid}", "api/v1/downloads/logomarcas", "/api/ambiental/analises/**", "/sso/**", "/api/correspondencias/analises/**", "/api/correspondencias/downloads/minutas/**", "/api/v1/demandas/public/**", "/api/v1/empresas/{empresa}", "/api/v1/mapas/**"};
        http.securityMatcher(new String[]{"/api/**"}).csrf(csrfCfg -> csrfCfg.disable()).cors(corsCfg -> corsCfg.configurationSource(SecurityConfig.corsConfigSource())).addFilterBefore((Filter)this.apiAuthenticationFilter(this.authenticationManager((AuthenticationConfiguration)http.getSharedObject(AuthenticationConfiguration.class))), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new JwtLoginFilter(this.authenticationManager((AuthenticationConfiguration)http.getSharedObject(AuthenticationConfiguration.class)), this.cadastroService, this.coreService, this.segurancaService), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new JWTAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).sessionManagement(sessionCfg -> sessionCfg.sessionFixation(sessionFix -> sessionFix.none())).exceptionHandling(excCfg -> excCfg.authenticationEntryPoint((AuthenticationEntryPoint)this.restAuthenticationEntryPoint)).authorizeHttpRequests(httpCfg -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpCfg.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll().requestMatchers(allowedList)).permitAll().anyRequest()).authenticated());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=3)
    SecurityFilterChain formLoginFilterChain(HttpSecurity http) throws Exception {
        http.csrf(csrf -> csrf.disable());
        http.cors(corsCfg -> corsCfg.configurationSource(SecurityConfig.corsConfigSource()));
        HttpSessionSecurityContextRepository secCtxRepo = new HttpSessionSecurityContextRepository();
        http.addFilterBefore((Filter)this.formAuthenticationFilter(this.authenticationManager((AuthenticationConfiguration)http.getSharedObject(AuthenticationConfiguration.class))), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new CorsFilter(), UsernamePasswordAuthenticationFilter.class);
        http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll().requestMatchers(new String[]{"/viewFile/**", "/swagger-resources/**", "/swagger-ui/**", "/swagger-ui.html", "/v3/api-docs/**", "/webjars/**", "/pages/redirect.xhtml", "/jakarta.faces.resource/**", "/mapsKmlData/**", "/register/**", "v1/register/**", "/reset/**", "/forwardUrl/**", "/captcha", "/saml/**", "/sso/***", "/login/saml2/sso/**", "/pages/verificarAssinatura.*", "/pages/login.xhtml"})).permitAll().anyRequest()).authenticated()).headers(head -> head.frameOptions(frame -> frame.sameOrigin())).formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)login.loginPage("/pages/login.xhtml").permitAll()).failureForwardUrl("/pages/login.xhtml?error=true").failureUrl("/pages/login.xhtml?error=true")).successHandler(this.authSuccessHandler)).failureHandler((AuthenticationFailureHandler)new CustomPageAuthenticationFailureHandler())).sessionManagement(sessionCfg -> sessionCfg.sessionFixation(sessionFix -> sessionFix.none())).securityContext(ctx -> ctx.securityContextRepository((SecurityContextRepository)secCtxRepo)).logout(logout -> logout.logoutSuccessUrl("/pages/login.xhtml").invalidateHttpSession(true).deleteCookies(new String[]{"JSESSIONID"}));
        return (SecurityFilterChain)http.build();
    }
}

