/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import br.com.oti.gesconsys.actions.core.CoreMBean;
import br.com.oti.gesconsys.beans.core.UsuarioPreferencia;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.AuthLogin;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.spring.security.TokenAuthenticationService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSuccessHandlerImpl
extends SavedRequestAwareAuthenticationSuccessHandler {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationSuccessHandlerImpl.class);
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private CoreMBean coreMBean;
    private String error;

    public AuthenticationSuccessHandlerImpl() {
        this.setUseReferer(true);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (!this.postLogin(authentication).booleanValue()) {
            request.getSession().invalidate();
            if (this.error != null && !this.error.isEmpty()) {
                request.getSession().setAttribute("errorMsg", (Object)this.error);
            }
            response.sendRedirect(request.getContextPath() + "/pages/login.xhtml");
        } else {
            SavedRequest savedRequest = (SavedRequest)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST");
            String params = this.getTargetUrlParameter();
            if (params == null || params.isEmpty()) {
                if (savedRequest == null) {
                    response.sendRedirect(request.getContextPath() + "/pages/redirect.xhtml");
                } else {
                    String redirUrl = savedRequest.getRedirectUrl();
                    if (redirUrl.contains("login.faces") || redirUrl.contains("login.xhtml")) {
                        response.sendRedirect(request.getContextPath() + "/pages/redirect.xhtml");
                    } else {
                        super.onAuthenticationSuccess(request, response, authentication);
                    }
                }
            } else {
                super.onAuthenticationSuccess(request, response, authentication);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean postLogin(Authentication authentication) {
        try {
            if (authentication == null) {
                return false;
            }
            String userName = null;
            userName = authentication instanceof User ? ((User)authentication).getUsername() : (authentication instanceof AuthLogin ? ((AuthLogin)authentication).getUserName() : (authentication.getPrincipal() instanceof AuthLogin ? ((AuthLogin)authentication.getPrincipal()).getUserName() : (authentication instanceof UsernamePasswordAuthenticationToken ? ((UsernamePasswordAuthenticationToken)authentication).getPrincipal().toString() : ((AuthLogin)authentication.getPrincipal()).getUserName())));
            if (userName == null) {
                authentication.setAuthenticated(false);
                return false;
            }
            Usuario usuario = this.segurancaService.getUsuarioByLoginOrMail(userName);
            if (usuario != null) return this.makeLogin(authentication, usuario);
            if (userName.contains("@")) {
                String[] userLogin = userName.split("@");
                if (userLogin.length > 0) {
                    usuario = this.segurancaService.getUsuarioByLoginOrMail(userLogin[0].trim());
                    if (usuario != null) return this.makeLogin(authentication, usuario);
                    authentication.setAuthenticated(false);
                    logger.error("Usu\u00e1rio n\u00e3o encontrado no Gesconsys (split @): {}", (Object)userLogin[0]);
                    return false;
                }
                authentication.setAuthenticated(false);
                logger.error("Usu\u00e1rio n\u00e3o encontrado no Gesconsys (split sem @): {}", (Object)userName);
                return false;
            }
            authentication.setAuthenticated(false);
            logger.error("Usu\u00e1rio n\u00e3o encontrado no Gesconsys: {}", (Object)userName);
            return false;
        }
        catch (BusinessException bizExc) {
            authentication.setAuthenticated(false);
            logger.error("BizExc:", (Throwable)bizExc);
            return false;
        }
    }

    public Boolean makeLogin(Authentication authentication, Usuario usuario) {
        try {
            if (usuario == null) {
                authentication.setAuthenticated(false);
                return false;
            }
            if (usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) {
                authentication.setAuthenticated(false);
                this.error = "Este perfil de Usu\u00e1rio n\u00e3o permite este tipo de autentica\u00e7\u00e3o.";
                throw new BusinessException(this.error);
            }
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(usuario.getId());
            if (perfil == null) {
                authentication.setAuthenticated(false);
                return false;
            }
            List empresasUsuario = this.segurancaService.findEmpresasByUsuario(perfil.getIdUsuario());
            if (empresasUsuario == null || empresasUsuario.isEmpty()) {
                authentication.setAuthenticated(false);
                this.error = "Usu\u00e1rio n\u00e3o est\u00e1 associado a nenhuma empresa.";
                throw new BusinessException(this.error);
            }
            Integer selEmpresa = null;
            UsuarioPreferencia pref = this.coreService.getPreferenciaByTipo(usuario.getId(), "ULTIMA_EMPRESA_LOGADA", null);
            selEmpresa = pref != null ? pref.getIdEmpresa() : ((UsuarioEmpresa)empresasUsuario.get(0)).getId().getIdEmpresa();
            Empresa empresa = this.coreService.getEmpresaById(selEmpresa);
            if (empresa == null) {
                authentication.setAuthenticated(false);
                this.error = "Empresa informada n\u00e3o foi encontrada.";
                throw new BusinessException(this.error);
            }
            for (UsuarioEmpresa empUser : empresasUsuario) {
                if (!empUser.getId().getIdEmpresa().equals(selEmpresa)) continue;
                this.coreMBean.setEmpresaUser(empUser);
                break;
            }
            String tokenJwt = TokenAuthenticationService.createToken((String)usuario.getNome());
            this.coreMBean.makeLogin(perfil, tokenJwt, empresasUsuario);
            List usrArea = this.segurancaService.findAreasByUsuario(perfil.getIdUsuario(), null);
            ArrayList<Integer> areas = new ArrayList<Integer>();
            if (usrArea != null) {
                for (UsuarioArea areaUsr : usrArea) {
                    areas.add(areaUsr.getId().getIdArea());
                }
            }
            this.coreMBean.setAreas(areas);
            return true;
        }
        catch (BusinessException bizExc) {
            authentication.setAuthenticated(false);
            logger.error("BizExc:", (Throwable)bizExc);
            return false;
        }
    }

    protected boolean hasRole(Authentication authCtx, String role) {
        for (GrantedAuthority auth : authCtx.getAuthorities()) {
            if (!role.equals(auth.getAuthority())) continue;
            return true;
        }
        return false;
    }
}

