/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.config;

import br.com.oti.gesconsys.Exceptions.DefaultError;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.Collections;
import java.util.List;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
@OpenAPIDefinition(info=@Info(title="Gesconsys", description="Documenta\u00e7\u00e3o da API para o Sistema de Gest\u00e3o da Concess\u00e3o", version="v1"))
@SecuritySchemes(value={@SecurityScheme(name="bearerAuth", type=SecuritySchemeType.HTTP, scheme="bearer", bearerFormat="JWT", description="Autentica\u00e7\u00e3o JWT usando esquema Bearer.")})
public class OpenAPIConfig {
    public static final String UNSECURED_TAG = "security.open";

    @Bean
    public OpenApiCustomizer openApiCustomizer() {
        return arg_0 -> this.configureErrors(arg_0);
    }

    private OpenAPI configureErrors(OpenAPI openApi) {
        ResolvedSchema errResSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(DefaultError.class));
        Content content = new Content().addMediaType("application/json", new MediaType().schema(errResSchema.schema));
        openApi.getPaths().values().forEach(pathItem -> pathItem.readOperations().forEach(operation -> operation.getResponses().addApiResponse(String.valueOf(HttpStatus.BAD_REQUEST.value()), new ApiResponse().description("Requisi\u00e7\u00e3o inv\u00e1lida ou par\u00e2metros incorretos.").content(content)).addApiResponse(String.valueOf(HttpStatus.UNAUTHORIZED.value()), new ApiResponse().description("Acesso n\u00e3o autorizado.").content(content)).addApiResponse(String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), new ApiResponse().description("Erro interno no servidor.").content(content))));
        return openApi;
    }

    @Bean
    public OperationCustomizer customize() {
        return (operation, handlerMethod) -> {
            List tags = operation.getTags();
            if (tags != null && tags.contains(UNSECURED_TAG)) {
                tags.remove(UNSECURED_TAG);
                operation.setTags(tags);
                return operation;
            }
            SecurityRequirement securityRequirement = new SecurityRequirement();
            securityRequirement.addList("bearerAuth");
            operation.setSecurity(Collections.singletonList(securityRequirement));
            return operation;
        };
    }

    @Bean
    public OpenApiCustomizer versionedTagsCustomizer() {
        return openApi -> openApi.getPaths().forEach((path, pathItem) -> pathItem.readOperations().forEach(operation -> {
            if (path.contains("/api/v1/")) {
                operation.setTags(List.of("demandas (v1)"));
            }
        }));
    }
}

