/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring;

import br.com.oti.gesconsys.servlets.ForwardServlet;
import br.com.oti.gesconsys.servlets.ImageCaptchaServlet;
import br.com.oti.gesconsys.servlets.MapsKmlDataServlet;
import br.com.oti.gesconsys.servlets.PdfReportServlet;
import br.com.oti.gesconsys.servlets.ViewFileServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServletConfig
implements ServletContextInitializer {
    private Logger logger = LoggerFactory.getLogger(ServletConfig.class);

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.registerServlet(servletContext);
    }

    private void registerServlet(ServletContext servletContext) {
        this.logger.debug("Registering ViewFileServlet");
        ServletRegistration.Dynamic serviceServlet = servletContext.addServlet("ViewFileServlet", (Servlet)new ViewFileServlet());
        serviceServlet.addMapping(new String[]{"/viewFile/*"});
        serviceServlet.setAsyncSupported(true);
        serviceServlet.setLoadOnStartup(2);
        this.logger.debug("Registering PdfReportServlet");
        serviceServlet = servletContext.addServlet("PdfReportServlet", (Servlet)new PdfReportServlet());
        serviceServlet.addMapping(new String[]{"/report.pdf"});
        serviceServlet.setAsyncSupported(true);
        serviceServlet.setLoadOnStartup(3);
        this.logger.debug("Registering ForwardServlet");
        serviceServlet = servletContext.addServlet("ForwardServlet", (Servlet)new ForwardServlet());
        serviceServlet.addMapping(new String[]{"/forwardUrl"});
        serviceServlet.setAsyncSupported(true);
        serviceServlet.setLoadOnStartup(4);
        this.logger.debug("Registering ImageCaptchaServlet");
        serviceServlet = servletContext.addServlet("ImageCaptchaServlet", (Servlet)new ImageCaptchaServlet());
        serviceServlet.addMapping(new String[]{"/captcha"});
        serviceServlet.setAsyncSupported(true);
        serviceServlet.setLoadOnStartup(5);
        this.logger.debug("Registering MapsKmlDataServlet");
        serviceServlet = servletContext.addServlet("MapsKmlDataServlet", (Servlet)new MapsKmlDataServlet());
        serviceServlet.addMapping(new String[]{"/mapsKmlData"});
        serviceServlet.setAsyncSupported(true);
        serviceServlet.setLoadOnStartup(6);
    }
}

