/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.core.mail.UsuarioEmailEmpresa;
import br.com.oti.gesconsys.beans.correspondencia.Correspondencia;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaResponsavel;
import br.com.oti.gesconsys.beans.correspondencia.TipoStatusCorrespondencia;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.shared.EmailDiarioVO;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioEmpresaDAO;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.dao.seguranca.UsuarioAreaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import jakarta.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailDiarioCorrespondenciaHelper {
    private Logger logger = LoggerFactory.getLogger(EmailDiarioCorrespondenciaHelper.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private UsuarioEmpresaDAO usuarioEmpresaDAO;
    @Autowired
    private UsuarioAreaDAO usuarioAreaDAO;
    private Integer countEmails;
    private Map<Integer, List<EmailDiarioVO>> resumoAreas;

    @PostConstruct
    private void init() {
        this.countEmails = 0;
    }

    public Boolean execute() {
        String webAppCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_WEBAPP_CONTEXT);
        if (webAppCtx == null || webAppCtx.isEmpty()) {
            throw new BusinessException("Application Context URL n\u00e3o informada.");
        }
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(TipoStatusCorrespondencia.ANDAMENTO.getCode());
        this.resumoAreas = new HashMap();
        HashMap resumoCriticos = new HashMap();
        HashMap resumoImportantes = new HashMap();
        HashMap resumoAprovadores = new HashMap();
        ArrayList<Integer> usuariosCache = new ArrayList<Integer>();
        List dataCorresp = null;
        ArrayList<UsuarioEmpresa> usersEmpresa = new ArrayList<UsuarioEmpresa>();
        HashMap<String, List> tplData = new HashMap<String, List>();
        SimpleDateFormat sdfDatas = new SimpleDateFormat("dd/MM");
        String data = sdfDatas.format(new Date(System.currentTimeMillis()));
        List empresas = this.empresaDAO.findAll("", null);
        ArrayList<Integer> empsId = new ArrayList<Integer>();
        ArrayList<String> usersValidate = new ArrayList<String>();
        for (Empresa empresa : empresas) {
            List responsaveis;
            Object usrEmp2;
            usuariosCache.clear();
            usersEmpresa.clear();
            empsId.clear();
            empsId.add(empresa.getId());
            for (Object usrEmp2 : this.usuarioEmpresaDAO.findUsuariosByEmpresasAndGrupos(empsId, null, null, null, Boolean.valueOf(false), null, null)) {
                usersEmpresa.add((UsuarioEmpresa)usrEmp2);
                String keyUser = String.format("%d::%d", usrEmp2.getId().getIdEmpresa(), usrEmp2.getId().getIdUsuario());
                if (usersValidate.contains(keyUser)) continue;
                usersValidate.add(keyUser);
            }
            List usuariosAreas = this.usuarioAreaDAO.findUsuariosAreaByEmpresa(empresa.getId(), null, null, Boolean.valueOf(false));
            usrEmp2 = usuariosAreas.iterator();
            while (usrEmp2.hasNext()) {
                Integer idUsuario;
                UsuarioArea usuarioArea = (UsuarioArea)usrEmp2.next();
                String modulos = usuarioArea.getModulos();
                if (modulos == null || !modulos.contains(TipoModulo.CORRESPONDENCIAS.getSigla()) || usuariosCache.contains(idUsuario = usuarioArea.getId().getIdUsuario())) continue;
                usuariosCache.add(idUsuario);
            }
            List usrMailsEmp = this.empresaDAO.findUsuariosEmailByEmpresa(empresa.getId(), "C");
            List usrMailsEmpResumo = this.cadastroService.findUsuariosEmailByEmpresa(empresa.getId(), "RESUMO_DIARIO_CRP");
            dataCorresp = this.correspondenciaService.findCorrespondenciasByStatus(empresa.getId(), status, null);
            if (dataCorresp != null && !dataCorresp.isEmpty()) {
                for (Correspondencia corresp : dataCorresp) {
                    if (corresp.getIdArea() == null) continue;
                    Object dataAreas = (ArrayList<EmailDiarioVO>)this.resumoAreas.get(corresp.getIdArea());
                    if (dataAreas == null) {
                        dataAreas = new ArrayList<EmailDiarioVO>();
                    }
                    if (corresp.getPrazo().equals(7)) {
                        dataAreas.add(this.generateCorrespMail(corresp, webAppCtx));
                    } else if (corresp.getPrazo().compareTo(3) <= 0) {
                        dataAreas.add(this.generateCorrespMail(corresp, webAppCtx));
                    }
                    this.resumoAreas.put(corresp.getIdArea(), dataAreas);
                }
                for (Correspondencia corresp : dataCorresp) {
                    if (corresp.getPrazo().equals(7)) {
                        this.processUsuario(empresa.getId(), corresp.getIdUsuarioResposta(), corresp, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                        this.processUsuario(empresa.getId(), corresp.getIdResponsavelArea(), corresp, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                        if (usrMailsEmpResumo == null || usrMailsEmpResumo.isEmpty()) continue;
                        for (UsuarioEmailEmpresa usrMail : usrMailsEmpResumo) {
                            this.processUsuario(empresa.getId(), usrMail.getId().getIdUsuario(), corresp, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                        }
                        continue;
                    }
                    if (corresp.getPrazo().compareTo(3) > 0) continue;
                    this.processUsuario(empresa.getId(), corresp.getIdUsuarioResposta(), corresp, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                    this.processUsuario(empresa.getId(), corresp.getIdResponsavelArea(), corresp, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                    if (usrMailsEmpResumo != null && !usrMailsEmpResumo.isEmpty()) {
                        for (UsuarioEmailEmpresa usrMail : usrMailsEmpResumo) {
                            this.processUsuario(empresa.getId(), usrMail.getId().getIdUsuario(), corresp, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                        }
                    }
                    if (usrMailsEmp == null || usrMailsEmp.isEmpty()) continue;
                    for (UsuarioEmailEmpresa usrMail : usrMailsEmp) {
                        this.processUsuario(empresa.getId(), usrMail.getId().getIdUsuario(), corresp, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                    }
                }
                this.logger.debug("correspondencias.count={}", (Object)dataCorresp.size());
            }
            if ((responsaveis = this.correspondenciaService.findResponsaveisByCorrespondencia(List.of(empresa.getId()), null, null)) != null && !responsaveis.isEmpty()) {
                for (CorrespondenciaResponsavel resp : responsaveis) {
                    this.processUsuario(empresa.getId(), resp.getIdResponsavel(), resp.getCorrespondencia(), resumoAprovadores, usuariosCache, usersValidate, webAppCtx);
                }
            }
            this.logger.debug("Processando usu\u00e1rios, empresa '{}'", (Object)empresa.getSigla());
            for (Integer idUsuario : usuariosCache) {
                List aprovadoresLst;
                List importantesLst;
                UsuarioEmailEmpresa usrMail;
                UsuarioEmpresa usuarioEmp = null;
                usrMail = usersEmpresa.iterator();
                while (usrMail.hasNext()) {
                    UsuarioEmpresa usrEmpresa = (UsuarioEmpresa)usrMail.next();
                    if (!usrEmpresa.getId().getIdUsuario().equals(idUsuario)) continue;
                    usuarioEmp = usrEmpresa;
                    break;
                }
                if (usuarioEmp == null) {
                    this.logger.debug("Usu\u00e1rio '{}' inativo, ignorado no email di\u00e1rio.", (Object)idUsuario);
                    continue;
                }
                String emlKey = empresa.getId() + ":" + idUsuario;
                tplData.clear();
                List criticasLst = (List)resumoCriticos.get(emlKey);
                if (criticasLst != null && criticasLst.size() > 0) {
                    tplData.put("criticas", criticasLst);
                }
                if ((importantesLst = (List)resumoImportantes.get(emlKey)) != null && importantesLst.size() > 0) {
                    tplData.put("importantes", importantesLst);
                }
                if ((aprovadoresLst = (List)resumoAprovadores.get(emlKey)) != null && aprovadoresLst.size() > 0) {
                    tplData.put("aprovadores", aprovadoresLst);
                }
                ArrayList areasLst = new ArrayList();
                for (UsuarioArea usuarioArea : usuariosAreas) {
                    List dataAreas;
                    if (!usuarioArea.getId().getIdUsuario().equals(idUsuario) || (dataAreas = (List)this.resumoAreas.get(usuarioArea.getId().getIdArea())) == null || dataAreas.isEmpty()) continue;
                    areasLst.addAll(dataAreas);
                }
                if (areasLst.size() > 0) {
                    tplData.put("pendenciasAreas", areasLst);
                }
                String emailContent = this.coreService.processTemplate(empresa.getId(), "resumoDiarioCorresp.tpl", tplData);
                Integer countCrit = 0;
                Integer countImpo = 0;
                Integer countApro = 0;
                Integer idEmpresa = null;
                if (criticasLst != null && !criticasLst.isEmpty()) {
                    idEmpresa = ((EmailDiarioVO)criticasLst.get(0)).getIdEmpresa();
                    countCrit = criticasLst.size();
                } else if (importantesLst != null && !importantesLst.isEmpty()) {
                    idEmpresa = ((EmailDiarioVO)importantesLst.get(0)).getIdEmpresa();
                    countImpo = importantesLst.size();
                } else if (aprovadoresLst != null && !aprovadoresLst.isEmpty()) {
                    idEmpresa = ((EmailDiarioVO)aprovadoresLst.get(0)).getIdEmpresa();
                    countApro = aprovadoresLst.size();
                }
                if (idEmpresa == null || countCrit <= 0 && countImpo <= 0 && countApro <= 0) continue;
                Email email = new Email();
                email.getId().setIdEmpresa(idEmpresa);
                StringBuilder assuntoTxt = new StringBuilder();
                assuntoTxt.append("Di\u00e1rio correspond\u00eancias ");
                assuntoTxt.append(usuarioEmp.getEmpresa().getSigla());
                assuntoTxt.append(" (").append(data).append(")");
                assuntoTxt.append(" - ");
                if (countCrit > 0) {
                    assuntoTxt.append(" Cr\u00edticas: ").append(countCrit);
                }
                if (countImpo > 0) {
                    assuntoTxt.append(" Importantes: ").append(countImpo);
                }
                if (countApro > 0) {
                    assuntoTxt.append(" Aprova\u00e7\u00e3o: ").append(countApro);
                }
                email.setAssunto(assuntoTxt.toString());
                email.setOrigem(TipoModulo.CORRESPONDENCIAS.getSigla());
                email.setStatus(Integer.valueOf(0));
                EmailDestinatario destinatario = new EmailDestinatario(idEmpresa, idUsuario, TipoDestinatario.EMAIL_TO);
                email.setDestinatarios(new ArrayList());
                email.getDestinatarios().add(destinatario);
                this.coreService.saveEmail(email, emailContent);
                Integer n = this.countEmails;
                this.countEmails = this.countEmails + 1;
            }
        }
        return true;
    }

    private void processUsuario(Integer idEmpresa, Integer idUsuario, Correspondencia correspondencia, Map<String, List<EmailDiarioVO>> resumo, List<Integer> usuarios, List<String> usersValidate, String contextPath) {
        String keyUser;
        if (idUsuario == null || correspondencia == null) {
            return;
        }
        if (usersValidate != null && !usersValidate.contains(keyUser = String.format("%d::%d", correspondencia.getId().getIdEmpresa(), idUsuario))) {
            return;
        }
        String emailKey = idEmpresa + ":" + idUsuario;
        List<EmailDiarioVO> dadosUsuarios = resumo.get(emailKey);
        if (dadosUsuarios == null) {
            dadosUsuarios = new ArrayList<EmailDiarioVO>();
            resumo.put(emailKey, dadosUsuarios);
        }
        Boolean foundCorresp = false;
        for (EmailDiarioVO itemMail : dadosUsuarios) {
            if (!itemMail.getIdEmpresa().equals(correspondencia.getId().getIdEmpresa()) || !itemMail.getIdCorrespondencia().equals(correspondencia.getId().getIdCorrespondencia())) continue;
            foundCorresp = true;
            break;
        }
        if (!foundCorresp.booleanValue()) {
            EmailDiarioVO correspMail = this.generateCorrespMail(correspondencia, contextPath);
            dadosUsuarios.add(correspMail);
        }
        if (!usuarios.contains(idUsuario)) {
            usuarios.add(idUsuario);
        }
    }

    private EmailDiarioVO generateCorrespMail(Correspondencia corresp, String contextPath) {
        EmailDiarioVO correspMail = new EmailDiarioVO(corresp.getId().getIdEmpresa(), corresp.getId().getIdCorrespondencia(), corresp.getAssunto(), corresp.getPrazo(), corresp.getEmpresa(), corresp.getArea(), corresp.getResponsavel(), corresp.getEntidade());
        StringBuilder outLink = new StringBuilder();
        outLink.append("/pages/correspondencias/correspondenciaEdit.faces");
        outLink.append("?idEmpresa=").append(correspMail.getIdEmpresa());
        outLink.append("&idCorrespondencia=").append(correspMail.getIdCorrespondencia());
        String encodedURL = new EncodeDecodeURL().encode(outLink.toString());
        outLink = new StringBuilder();
        outLink.append(contextPath);
        outLink.append("/forwardUrl?fwId=").append(encodedURL);
        correspMail.setExternalUrl(outLink.toString());
        return correspMail;
    }

    public Integer getCountEmails() {
        return this.countEmails == null ? 0 : this.countEmails;
    }
}

