/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.TipoEmpresa;
import br.com.oti.gesconsys.beans.seguranca.CreateUserVO;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.VinculoEmpresaVO;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import br.com.oti.gesconsys.rest.seguranca.RegistroUsuarioRestServices;
import br.com.oti.gesconsys.utils.RegExpUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para registros", name="register")
@RequestMapping(value={"/api/v1/register"})
public class RegistroUsuarioRestServicesV1 {
    private static Logger logger = LoggerFactory.getLogger(RegistroUsuarioRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping
    @Operation(summary="Efetua o registro de novo usu\u00e1rio, para m\u00f3dulos ou programas que necessitem do registro pr\u00e9vio")
    @ResponseBody
    public ResponseEntity<?> registerUser(HttpServletRequest request, @RequestBody CreateUserVO usuario) {
        logger.debug("Executando registerUser(tipo={}, idEmp={})...", (Object)usuario.getTipo(), (Object)usuario.getIdEmpresa());
        try {
            String originHeader;
            Empresa empresaAtual = this.resolveEmpresaByRequest(request, usuario.getIdEmpresa(), null);
            if (empresaAtual != null) {
                usuario.setIdEmpresa(empresaAtual.getId());
            }
            if (usuario.getIdEmpresa() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa do usu\u00e1rio n\u00e3o foi informada.");
            }
            if (usuario.getTipo() == null || usuario.getTipo().isEmpty()) {
                usuario.setTipo(TipoUsuario.ACESSO_NORMAL.getCode());
            }
            if (usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || usuario.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) {
                if (usuario.getSubtipo() == null || usuario.getSubtipo().isEmpty()) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio informar se acesso Demanda ou Faixa de dom\u00ednio.");
                }
            } else {
                if (usuario.getPassword() == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Senha n\u00e3o informada.");
                }
                if (usuario.getConfirmPassword() == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Senha de confirma\u00e7\u00e3o n\u00e3o informada.");
                }
                if (!usuario.getPassword().equals(usuario.getConfirmPassword())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Senha e confirma\u00e7\u00e3o da senha n\u00e3o s\u00e3o iguais, verifique.");
                }
            }
            if ((originHeader = request.getHeader("Origin")) == null) {
                originHeader = request.getHeader("origin");
            }
            boolean validateEmail = true;
            Usuario usuarioLoginExistente = this.localizarUsuarioPorLogin(usuario.getLogin());
            if (usuarioLoginExistente != null) {
                return this.tratarUsuarioExistente(usuarioLoginExistente, usuario.getIdEmpresa());
            }
            Usuario usuarioEmailExistente = this.segurancaService.getUsuarioByEmail(usuario.getEmail());
            if (usuarioEmailExistente != null) {
                return this.tratarUsuarioExistente(usuarioEmailExistente, usuario.getIdEmpresa());
            }
            Boolean created = this.segurancaService.registraUsuario(usuario.getIdEmpresa(), usuario.getLogin(), usuario.getNome(), usuario.getEmail(), usuario.getPassword(), usuario.getEndereco(), usuario.getCidade(), usuario.getUf(), usuario.getTipo(), usuario.getSubtipo(), usuario.getContrato(), usuario.getPerfil(), originHeader, Boolean.valueOf(validateEmail));
            return new ResponseEntity((Object)created, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createUser", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/confirm"})
    @Operation(summary="Confirma o registro de um usu\u00e1rio feito previamente, em conjunto com suas senhas, se informadas")
    public ResponseEntity<Boolean> confirmRegister(@RequestBody CreateUserVO payload) {
        String userId = payload.getLogin();
        if (userId == null) {
            userId = payload.getNome();
        }
        logger.debug("Executando confirmRegister(id={})...", (Object)userId);
        if (userId == null || userId.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio n\u00e3o foram informados corretamente.");
        }
        try {
            String decoded = new EncodeDecodeURL().decode(userId);
            if (decoded == null || decoded.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados da confirma\u00e7\u00e3o do usu\u00e1rio s\u00e3o inv\u00e1lidos.");
            }
            Integer idUsuario = Integer.valueOf(decoded);
            Usuario user = this.segurancaService.getUsuarioById(idUsuario);
            if (user == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Registro de usu\u00e1rio n\u00e3o encontrado.");
            }
            Boolean result = true;
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            if (perfil.getBloqueado() != null && perfil.getBloqueado().equals(1)) {
                result = this.segurancaService.desbloqueiaUsuario(user.getLogin());
            }
            if (result.booleanValue() && payload != null && payload.getPassword() != null) {
                result = this.segurancaService.alterarSenha(user.getId(), payload.getPassword(), payload.getConfirmPassword());
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createUser", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/vincular-empresa"})
    @Operation(summary="Vincula um usu\u00e1rio existente a outra empresa")
    public ResponseEntity<Boolean> vincularEmpresa(HttpServletRequest request, @RequestBody VinculoEmpresaVO payload) {
        if (payload == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Dados de vincula\u00e7\u00e3o n\u00e3o informados.");
        }
        if ((payload.getEmail() == null || payload.getEmail().isEmpty()) && (payload.getCpf() == null || payload.getCpf().isEmpty())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Informe o e-mail ou CPF para vincula\u00e7\u00e3o.");
        }
        Empresa empresaDestino = this.resolveEmpresaByRequest(request, payload.getIdEmpresa(), null);
        if (empresaDestino == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o identificada para vincula\u00e7\u00e3o.");
        }
        Usuario usuario = null;
        if (payload.getEmail() != null && !payload.getEmail().isEmpty()) {
            usuario = this.segurancaService.getUsuarioByEmail(payload.getEmail());
        }
        if (usuario == null && payload.getCpf() != null && !payload.getCpf().isEmpty()) {
            String cpf = RegExpUtil.onlyNumbers((String)payload.getCpf());
            usuario = this.segurancaService.getUsuarioByLoginOrMail(cpf);
        }
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado para vincula\u00e7\u00e3o.");
        }
        UsuarioEmpresa jaVinculado = this.segurancaService.getUsuarioEmpresaById(empresaDestino.getId(), usuario.getId());
        if (jaVinculado == null) {
            this.segurancaService.associarUsuarioEmpresaExistente(usuario.getId(), empresaDestino.getId());
        }
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/empresas"})
    @Operation(summary="Lista todas as concession\u00e1rias para a tela de registro de usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<Empresa>> findEmpresasDisponiveis(HttpServletRequest request) {
        logger.debug("Executando findEmpresas()...");
        try {
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            List rows = this.coreService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            for (Empresa row : rows) {
                Empresa emp = new Empresa();
                emp.setNomeFantasia(row.getNomeFantasia());
                emp.setSigla(row.getSigla());
                emp.setRazaoSocial(row.getRazaoSocial());
                empresas.add(emp);
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findEmpresas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private ResponseEntity<?> tratarUsuarioExistente(Usuario usuarioExistente, Integer idEmpresaDestino) {
        List empresasUsuario = this.segurancaService.findEmpresasByUsuario(usuarioExistente.getId());
        boolean jaAssociado = empresasUsuario.stream().anyMatch(emp -> emp.getId().getIdEmpresa().equals(idEmpresaDestino));
        if (jaAssociado) {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("erro", "usuario_existente_empresa");
            body.put("mensagem", "Usu\u00e1rio j\u00e1 cadastrado para esta empresa.");
            return new ResponseEntity(body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("erro", "usuario_existente");
        body.put("mensagem", "Conta j\u00e1 existente");
        body.put("usuarioId", usuarioExistente.getId());
        body.put("empresas", empresasUsuario.stream().map(emp -> {
            HashMap<String, Object> resumo = new HashMap<String, Object>();
            resumo.put("id", emp.getId().getIdEmpresa());
            if (emp.getEmpresa() != null) {
                resumo.put("sigla", emp.getEmpresa().getSigla());
                resumo.put("nome", emp.getEmpresa().getNomeFantasia());
            }
            return resumo;
        }).collect(Collectors.toList()));
        return new ResponseEntity(body, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    private Usuario localizarUsuarioPorLogin(String login) {
        if (login == null || login.isEmpty()) {
            return null;
        }
        String loginSanitizado = RegExpUtil.onlyNumbers((String)login);
        Usuario usuario = this.segurancaService.getUsuarioByLoginOrMail(loginSanitizado);
        if (usuario == null) {
            usuario = this.segurancaService.getUsuarioByLoginOrMail(login);
        }
        return usuario;
    }

    private Empresa resolveEmpresaByRequest(HttpServletRequest request, Integer idEmpresaPayload, String siglaPayload) {
        String host = request.getHeader("X-Domain-Host");
        if (host == null || host.isEmpty()) {
            host = request.getHeader("Origin");
        }
        if (host == null || host.isEmpty()) {
            host = request.getServerName();
        }
        if (host != null && !host.isEmpty()) {
            String parsedHost = host;
            try {
                if (parsedHost.contains("://")) {
                    parsedHost = new URI(parsedHost).getHost();
                }
            }
            catch (URISyntaxException ex) {
                logger.debug("N\u00e3o foi poss\u00edvel interpretar o host '{}': {}", (Object)host, (Object)ex.getMessage());
            }
            Empresa dominio = this.coreService.getEmpresaByDomain(parsedHost);
            if (dominio != null) {
                return dominio;
            }
        }
        if (idEmpresaPayload != null) {
            try {
                return this.coreService.getEmpresaById(idEmpresaPayload);
            }
            catch (BusinessException bizExc) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
            }
        }
        if (siglaPayload != null && !siglaPayload.isEmpty()) {
            try {
                return this.coreService.getEmpresaBySigla(siglaPayload);
            }
            catch (BusinessException bizExc) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
            }
        }
        return null;
    }
}

