/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Tema;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.RelacoesInstitucionaisRestServices;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Tema", name="tema")
@RequestMapping(value={"/api/tema"})
public class TemaRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RelacoesInstitucionaisRestServices.class);
    private static DateTimeFormatter sdfDataReq = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    @Autowired
    CadastroService cadastroService;

    @GetMapping(value={"/{idEmpresa}/{subTema}"})
    @Operation(summary="Busca os temas de acordo com a empresa e indicador de subtema")
    public ResponseEntity<List<Tema>> getTemas(@PathVariable(name="idEmpresa") Integer idEmpresa, @PathVariable(name="subTema") Boolean subTema, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getTema (empresa={})...");
        try {
            List<Tema> tema = this.cadastroService.findTemas(null, idEmpresa);
            if (tema == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Temas n\u00e3o encontrado.");
            }
            if (tema != null) {
                List<Tema> subTemaFilter = tema.stream().filter(t -> t.getIdTemaPai() != null).toList();
                if (subTema.booleanValue()) {
                    tema = subTemaFilter;
                } else {
                    tema.removeAll(subTemaFilter);
                }
            }
            return new ResponseEntity((Object)tema, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getReuniao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getReuniao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

