/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.actions.correspondencia.RelatorioTerceirosExcel;
import br.com.oti.gesconsys.beans.core.KeyValue;
import br.com.oti.gesconsys.beans.correspondencia.Correspondencia;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaMobileVO;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaPK;
import br.com.oti.gesconsys.beans.correspondencia.ResumoGeralCorrespondenciaVO;
import br.com.oti.gesconsys.beans.correspondencia.TipoStatusCorrespondencia;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.obrigacao.TipoStatusLancamentoObrigacao;
import br.com.oti.gesconsys.beans.pleito.PleitoResumoVO;
import br.com.oti.gesconsys.beans.pleito.ResumoGeralPleitoVO;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.RelatorioObrigacoesVO;
import br.com.oti.gesconsys.beans.shared.RelatorioPendenciasVO;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.business.services.PleitoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para relat\u00f3rios", name="relatorios")
@RequestMapping(value={"/api/relatorios"})
public class RelatoriosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RelatoriosRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private PleitoService pleitoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/analise/{empresa}/{tipo}"})
    @Operation(summary="Retorna os tipos de relat\u00f3rios de an\u00e1lise reequilibrio")
    @ResponseBody
    public ResponseEntity<List<KeyValue>> findAnalisePleitos(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipo") Integer tipo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findAnalisePleitos({}, {})...", (Object)empresa, (Object)tipo);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> selectedEmp = new ArrayList<Integer>();
            selectedEmp.add(emp.getId());
            List pleitos = this.pleitoService.findAnalisePleitos(selectedEmp, tipo, null);
            ArrayList<KeyValue> analise = new ArrayList<KeyValue>();
            for (PleitoResumoVO plt : pleitos) {
                if (tipo.equals(1)) {
                    analise.add(new KeyValue((Object)plt.getDescricao(), plt.getValPleitoBaseAnterior()));
                }
                if (tipo.equals(2)) {
                    analise.add(new KeyValue((Object)plt.getStatusPleito(), plt.getQtdPleitos()));
                }
                if (tipo.equals(3)) {
                    analise.add(new KeyValue((Object)plt.getTipoDesequilibrio(), plt.getQtdPleitos()));
                }
                if (!tipo.equals(4)) continue;
                analise.add(new KeyValue((Object)plt.getTipoDesequilibrio(), plt.getValAprovadoBaseAnterior()));
            }
            return new ResponseEntity(analise, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnalisePleitos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findAnalisePleitos", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/pendencias/{empresa}"})
    @Operation(summary="Retorna as pend\u00eancias de correspond\u00eancias por empresa")
    @ResponseBody
    public ResponseEntity<RelatorioPendenciasVO> findPendenciasCorrespondencias(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        ArrayList<String> areasColumns = new ArrayList<String>();
        List responsaveis = new ArrayList();
        ArrayList<CorrespondenciaPK> correspKey = new ArrayList<CorrespondenciaPK>();
        LinkedHashMap<String, Object> countCorresp = new LinkedHashMap<String, Object>();
        ArrayList<KeyValue> totaisAreas = new ArrayList<KeyValue>();
        LinkedHashMap<String, Object> totalCorresp = new LinkedHashMap<String, Object>();
        List correspondencias = new ArrayList();
        try {
            ArrayList<Integer> status = new ArrayList<Integer>();
            status.add(TipoStatusCorrespondencia.ANDAMENTO.getCode());
            correspondencias = this.correspondenciaService.findCorrespondencias(emps, null, null, null, null, null, status, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, null);
            areasColumns = new ArrayList();
            for (Object correspArea : correspondencias) {
                correspKey.add(correspArea.getId());
                if (correspArea.getArea() == null || correspArea.getArea().getSigla() == null) continue;
                if (!areasColumns.contains(correspArea.getArea().getSigla())) {
                    areasColumns.add(correspArea.getArea().getSigla());
                }
                StringBuilder keyStatArea = new StringBuilder();
                keyStatArea.append(correspArea.getArea().getSigla()).append("::");
                keyStatArea.append(correspArea.getStatusAprovacaoDesc());
                Object count = (Integer)countCorresp.get(keyStatArea.toString());
                if (count == null) {
                    count = 0;
                }
                Object object = count;
                count = (Integer)count + 1;
                countCorresp.put(keyStatArea.toString(), count);
                keyStatArea = new StringBuilder();
                keyStatArea.append("TOT_AREA").append("::");
                keyStatArea.append(correspArea.getStatusAprovacaoDesc());
                count = (Integer)countCorresp.get(keyStatArea.toString());
                if (count == null) {
                    count = 0;
                }
                object = count;
                count = (Integer)count + 1;
                countCorresp.put(keyStatArea.toString(), count);
                keyStatArea = new StringBuilder();
                keyStatArea.append(correspArea.getArea().getSigla()).append("::");
                keyStatArea.append("Total");
                count = (Integer)totalCorresp.get(keyStatArea.toString());
                if (count == null) {
                    count = 0;
                }
                object = count;
                count = (Integer)count + 1;
                totalCorresp.put(keyStatArea.toString(), count);
            }
            responsaveis = this.correspondenciaService.findResponsaveisByCorrespondencia(List.of(emp.getId()), null, null);
            LinkedHashMap<String, Integer> mapRespo = new LinkedHashMap<String, Integer>();
            for (Object resp : responsaveis) {
                if (!correspKey.contains(resp.getCorrespondencia().getId())) continue;
                StringBuilder keyResp = new StringBuilder();
                keyResp.append(resp.getCorrespondencia().getArea().getSigla()).append("::");
                keyResp.append("Aguardando aprova\u00e7\u00e3o - ");
                keyResp.append(resp.getResponsavel().getNome());
                Integer countResp = (Integer)mapRespo.get(keyResp.toString());
                if (countResp == null) {
                    countResp = 0;
                }
                countResp = countResp + 1;
                mapRespo.put(keyResp.toString(), countResp);
                keyResp = new StringBuilder();
                keyResp.append("TOT_AREA").append("::");
                keyResp.append("Aguardando aprova\u00e7\u00e3o - ");
                keyResp.append(resp.getResponsavel().getNome());
                countResp = (Integer)mapRespo.get(keyResp.toString());
                if (countResp == null) {
                    countResp = 0;
                }
                countResp = countResp + 1;
                mapRespo.put(keyResp.toString(), countResp);
                keyResp = new StringBuilder();
                keyResp.append(resp.getCorrespondencia().getArea().getSigla()).append("::");
                keyResp.append("Total");
                countResp = (Integer)totalCorresp.get(keyResp.toString());
                if (countResp == null) {
                    countResp = 0;
                }
                totalCorresp.put(keyResp.toString(), countResp);
            }
            countCorresp.putAll(mapRespo);
            logger.debug("Total.Corresp={}", totalCorresp);
            if (totalCorresp != null) {
                Object countTotal = 0;
                for (String keyTotal : totalCorresp.keySet()) {
                    if (totalCorresp.get(keyTotal) == null) continue;
                    countTotal = (Integer)countTotal + (Integer)totalCorresp.get(keyTotal);
                }
                totalCorresp.put("TOT_AREA::Total", countTotal);
            }
            countCorresp.putAll(totalCorresp);
            for (String keyMap : countCorresp.keySet()) {
                ArrayList<KeyValue> areasRow;
                String[] keys = keyMap.split("::");
                if (keys == null || keys.length != 2) continue;
                Integer countMap = (Integer)countCorresp.get(keyMap);
                String siglaArea = keys[0];
                String statusDesc = keys[1];
                Boolean found = false;
                for (KeyValue statusAreas : totaisAreas) {
                    if (!statusAreas.getKey().equals(statusDesc)) continue;
                    areasRow = (ArrayList<KeyValue>)statusAreas.getRawValue();
                    for (KeyValue item : areasRow) {
                        Integer countArea;
                        if (!item.getKey().equals(siglaArea) || (countArea = (Integer)item.getRawValue()) == null) continue;
                        Integer n = countArea;
                        countArea = countArea + 1;
                    }
                    if (!found.booleanValue()) {
                        areasRow.add(new KeyValue((Object)siglaArea, countMap));
                    }
                    found = true;
                }
                if (found.booleanValue()) continue;
                KeyValue keyVal = new KeyValue();
                keyVal.setKey((Object)statusDesc);
                areasRow = new ArrayList<KeyValue>();
                areasRow.add(new KeyValue((Object)siglaArea, countMap));
                keyVal.setValue(areasRow);
                totaisAreas.add(keyVal);
            }
            RelatorioPendenciasVO pendencias = new RelatorioPendenciasVO(areasColumns, new ArrayList(), totaisAreas);
            for (Object count : totalCorresp.keySet()) {
                pendencias.getTotalStatus().add(new KeyValue(count, (Integer)totalCorresp.get(count)));
            }
            pendencias.setTotais(totaisAreas);
            return new ResponseEntity((Object)pendencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPendencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPendencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/resumo/{empresa}/{ano}"})
    @Operation(summary="Retorna o resumo de correspond\u00eancias por empresa")
    @ResponseBody
    public ResponseEntity<ResumoGeralCorrespondenciaVO> findResumoCorrespondencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="ano") Integer ano, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            ResumoGeralCorrespondenciaVO resumo = new ResumoGeralCorrespondenciaVO();
            resumo = this.correspondenciaService.findResumoCorrespondencias(usr.getId(), ano, null, empresa, null, null, null, null, null, null, Boolean.valueOf(true), null);
            return new ResponseEntity((Object)resumo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResumo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findResumo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/obrigacoes/{empresa}"})
    @Operation(summary="Retorna o resumo das obriga\u00e7\u00f5es por empresa")
    @ResponseBody
    public ResponseEntity<List<RelatorioObrigacoesVO>> findRelatorioObrigacoes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> selectedEmp = new ArrayList<Integer>();
            selectedEmp.add(emp.getId());
            ArrayList<RelatorioObrigacoesVO> resumo = new ArrayList<RelatorioObrigacoesVO>();
            List obrigacoesCache = this.obrigacaoService.findLancamentosByFiltro(selectedEmp, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true));
            int countPendentes = 0;
            int countEncerrados = 0;
            int countArea = 0;
            RelatorioObrigacoesVO rel = new RelatorioObrigacoesVO(countEncerrados, countEncerrados, new ArrayList(), new ArrayList());
            LinkedHashMap<String, Integer> mapPendente = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> mapEncerrado = new LinkedHashMap<String, Integer>();
            for (ObrigacaoLancamento lcto : obrigacoesCache) {
                Integer n;
                Integer count;
                EmpresaArea area = lcto.getObrigacao().getArea();
                if (lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PENDENTE.getCode()) || lcto.getStatus().equals(TipoStatusLancamentoObrigacao.INTEGRADO.getCode())) {
                    ++countPendentes;
                    if (area != null) {
                        count = (Integer)mapPendente.get(area.getSigla());
                        if (count == null) {
                            count = 1;
                        } else {
                            n = count;
                            count = count + 1;
                        }
                        countArea = count;
                    }
                    mapPendente.put(area.getSigla(), countArea);
                    continue;
                }
                if (!lcto.getStatus().equals(TipoStatusLancamentoObrigacao.PROTOCOLADO.getCode()) && !lcto.getStatus().equals(TipoStatusLancamentoObrigacao.ENCERRADO.getCode())) continue;
                ++countEncerrados;
                if (area != null) {
                    count = (Integer)mapEncerrado.get(area.getSigla());
                    if (count == null) {
                        count = 1;
                    } else {
                        n = count;
                        count = count + 1;
                    }
                    countArea = count;
                }
                mapEncerrado.put(area.getSigla(), countArea);
            }
            for (String areaPendente : mapPendente.keySet()) {
                rel.getAreaPendentes().add(new KeyValue((Object)areaPendente, (Integer)mapPendente.get(areaPendente)));
            }
            for (String areaEncerrado : mapEncerrado.keySet()) {
                rel.getAreaEncerrados().add(new KeyValue((Object)areaEncerrado, (Integer)mapEncerrado.get(areaEncerrado)));
            }
            rel.setCountEncerrados(countEncerrados);
            rel.setCountPendentes(countPendentes);
            resumo.add(rel);
            return new ResponseEntity(resumo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObr", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findObr", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/pleitos/{empresa}"})
    @Operation(summary="Retorna o resumo dos pleitos por empresa")
    @ResponseBody
    public ResponseEntity<List<ResumoGeralPleitoVO>> getResumoPleito(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<ResumoGeralPleitoVO> resumo = new ArrayList<ResumoGeralPleitoVO>();
            ResumoGeralPleitoVO resumoPleito = this.pleitoService.findResumoGeralPleito(emp.getId(), Boolean.valueOf(true));
            resumo.add(resumoPleito);
            return new ResponseEntity(resumo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResumoPleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findResumoPleito", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/terceiros"})
    @Operation(summary="Retorna as pend\u00eancias de correspond\u00eancias por empresa")
    @ResponseBody
    public ResponseEntity<List<Correspondencia>> findRelatoriosTerceiros(@PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="areas", required=false) List<Integer> areas, @RequestParam(name="empresas", required=false) List<Integer> empresas, @RequestParam(name="dataInicial", required=false) LocalDate dataInicial, @RequestParam(name="dataFinal", required=false) LocalDate dataFinal, @RequestParam(name="ignoreEntidades", required=false) List<Integer> ignoreEntidades, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        List correspondencias = new ArrayList();
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (empresas != null) {
            emps.addAll(empresas);
        }
        try {
            correspondencias = this.correspondenciaService.findRelatorioTerceiros(emps, search, dataInicial, dataFinal, areas, ignoreEntidades);
            return new ResponseEntity(correspondencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPendencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPendencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcelTerceiros"})
    @Operation(summary="Efetua o download do relat\u00f3rio de terceiros em Excel")
    public ResponseEntity<byte[]> exportaRelatorioTerceirosExcel(@PathVariable(name="empresa") String empresa, @RequestBody CorrespondenciaMobileVO filtro, HttpServletRequest request) {
        logger.debug("Exportando excel, exportaRelatorioTerceirosExcel (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtro == null) {
            filtro = new CorrespondenciaMobileVO();
        }
        if (filtro.getEmpresas() == null) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
        } else {
            emps.addAll(filtro.getEmpresas());
        }
        try {
            List correspondencias = this.correspondenciaService.findRelatorioTerceiros(emps, filtro.getSearch(), filtro.getDataInicial(), filtro.getDataFinal(), filtro.getAreas(), filtro.getIgnoreEntidades());
            byte[] bytes = new RelatorioTerceirosExcel().executeXLS(correspondencias);
            if (bytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"Relat\u00f3rio de Terceiros.xlsx\"");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

