/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.demanda.DemandaAnexo;
import br.com.oti.gesconsys.beans.demanda.DemandaHistorico;
import br.com.oti.gesconsys.beans.demanda.DemandaResponsavel;
import br.com.oti.gesconsys.beans.demanda.FaleConosco;
import br.com.oti.gesconsys.beans.demanda.IndicePriorizacao;
import br.com.oti.gesconsys.beans.demanda.PerguntaFrequente;
import br.com.oti.gesconsys.beans.demanda.PesoPriorizacao;
import br.com.oti.gesconsys.beans.demanda.TipoAcessoHistorico;
import br.com.oti.gesconsys.beans.demanda.TipoDemanda;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.Trecho;
import br.com.oti.gesconsys.beans.geral.TrechoSegmento;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.shared.Demanda;
import br.com.oti.gesconsys.beans.shared.DemandaArea;
import br.com.oti.gesconsys.beans.shared.DemandaObjetivo;
import br.com.oti.gesconsys.beans.shared.DemandaStatus;
import br.com.oti.gesconsys.beans.shared.DemandaTipo;
import br.com.oti.gesconsys.beans.shared.TipoFaixa;
import br.com.oti.gesconsys.beans.shared.TipoStatusDemanda;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.DemandaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para demandas (API Padr\u00e3o)", name="demandas")
@RequestMapping(value={"/api/demandas"})
public class DemandasRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(DemandasRestServices.class);
    private static final DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.[SSSSSSSSS][SSSSSSSS][SSSSSSS][SSSSSS][SSSSS][SSSS][SSS][SS][S]][X]");
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private DemandaService demandaService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta as demandas de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> findDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="titulo", defaultValue="") String titulo, @RequestParam(name="tipo", defaultValue="0") Integer tipo, @RequestParam(name="area", defaultValue="0") Integer area, @RequestParam(name="objetivo", defaultValue="0") Integer objetivo, @RequestParam(name="cidade", defaultValue="0") Integer cidade, @RequestParam(name="trecho", defaultValue="0") Integer trecho, @RequestParam(name="status", defaultValue="0") Integer status, @RequestParam(name="publica", defaultValue="-1") Integer publica) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findDemandas(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (area == 0) {
                area = null;
            }
            if (tipo == 0) {
                tipo = null;
            }
            if (objetivo == 0) {
                objetivo = null;
            }
            if (cidade == 0) {
                cidade = null;
            }
            if (trecho == 0) {
                trecho = null;
            }
            if (status == 0) {
                status = null;
            }
            Integer publicaParm = null;
            if (publica != -1) {
                publicaParm = publica;
            }
            ArrayList<Integer> empIds = new ArrayList<Integer>();
            empIds.add(empresaDB.getId());
            List demandas = null;
            ArrayList<Integer> statusList = null;
            if (status != null) {
                statusList = new ArrayList<Integer>();
                statusList.add(status);
            }
            ArrayList<Integer> areasList = null;
            if (area != null) {
                areasList = new ArrayList<Integer>();
                areasList.add(area);
            }
            ArrayList<Integer> tiposList = null;
            if (tipo != null) {
                tiposList = new ArrayList<Integer>();
                tiposList.add(tipo);
            }
            ArrayList<Integer> objetivosList = null;
            if (objetivo != null) {
                objetivosList = new ArrayList<Integer>();
                objetivosList.add(objetivo);
            }
            ArrayList<Integer> cidadesList = null;
            if (cidade != null) {
                cidadesList = new ArrayList<Integer>();
                cidadesList.add(cidade);
            }
            Integer grupo = TipoDemanda.DEMANDA.getCode();
            Usuario userData = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
            if (!userData.getTipo().equals(TipoUsuario.ACESSO_NORMAL.getCode())) {
                ArrayList<Character> statusCodes = new ArrayList<Character>();
                statusCodes.add(TipoStatusDemanda.ANDAMENTO.getCode());
                statusCodes.add(TipoStatusDemanda.APROVADA.getCode());
                demandas = this.demandaService.findDemandas(empIds, titulo, null, null, null, statusCodes, "stat.descricao, tipo.descricao, area.descricao, dem.titulo ", areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, grupo, publicaParm, Boolean.valueOf(true));
                Integer idUserDemanda = userData.getId();
                statusCodes.clear();
                statusCodes.add(TipoStatusDemanda.PENDENTE.getCode());
                List demandasUsr = this.demandaService.findDemandas(empIds, titulo, idUserDemanda, null, null, statusCodes, "stat.descricao, tipo.descricao, area.descricao, dem.titulo ", areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, grupo, publicaParm, Boolean.valueOf(false));
                if (demandasUsr != null && !demandasUsr.isEmpty()) {
                    demandas.addAll(0, demandasUsr);
                }
            } else {
                demandas = this.demandaService.findDemandas(empIds, titulo, null, null, null, null, "stat.descricao, tipo.descricao, area.descricao, dem.titulo ", areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, grupo, publicaParm, Boolean.valueOf(true));
            }
            HashMap<String, List<Object>> mapData = new HashMap<String, List<Object>>();
            HashMap<Integer, Rodovia> mapRodovias = new HashMap<Integer, Rodovia>();
            ArrayList<DemandaStatus> statusInfo = new ArrayList<DemandaStatus>();
            for (Object demanda : demandas) {
                if (!statusInfo.contains(demanda.getStatusInfo())) {
                    statusInfo.add(demanda.getStatusInfo());
                }
                demanda.getTrecho().setRodovia(null);
                EmpresaArea areaDem = demanda.getAreaEmpresa();
                if (areaDem != null) {
                    areaDem.setResponsavel(null);
                }
                if (demanda.getIdRodovia() == null) continue;
                mapRodovias.put(demanda.getIdRodovia(), demanda.getRodovia());
            }
            if (statusInfo.isEmpty()) {
                DemandaStatus statusItem = new DemandaStatus();
                statusItem.setId(Integer.valueOf(0));
                statusItem.setDescricao("Em Avalia\u00e7\u00e3o");
                statusInfo.add(statusItem);
            }
            ArrayList coordenadas = new ArrayList();
            for (Integer idRodovia : mapRodovias.keySet()) {
                List coordRodov = this.cadastroService.findCoordenadas(idRodovia, null, null);
                coordenadas.addAll(coordRodov);
            }
            mapData.put("status", statusInfo);
            mapData.put("demandas", demandas);
            List rodovias = mapRodovias.values().stream().collect(Collectors.toList());
            mapData.put("rodovias", rodovias);
            mapData.put("coordenadas", coordenadas);
            return new ResponseEntity(mapData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDemandas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/areas"})
    @Operation(summary="Consulta as \u00e1reas da demanda conforme Empresa (Sigla)")
    @ResponseBody
    public ResponseEntity<List<DemandaArea>> findAreasDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findAreas...");
        try {
            Empresa empresaDB;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List areas = this.demandaService.findAreas(empresaDB.getId(), search);
            return new ResponseEntity((Object)areas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/respons\u00e1veis/{idDemanda}"})
    @Operation(summary="Consulta os respons\u00e1veis da demanda conforme Empresa (Sigla) e id da demanda")
    @ResponseBody
    public ResponseEntity<List<DemandaResponsavel>> findResponsaveisDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idDemanda") Integer idDemanda) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findResponsaveis...");
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List responsaveis = this.demandaService.findByDemanda(empresaDB.getId(), idDemanda);
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResponsaveis", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/rodovias"})
    @Operation(summary="Consulta as rodovias de acordo com a empresa (Sigla)")
    @ResponseBody
    public ResponseEntity<List<Rodovia>> findRodoviasDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findRodovias(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List rodovias = this.cadastroService.findRodovias(null, empresaDB.getId(), null);
            return new ResponseEntity((Object)rodovias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/status"})
    @Operation(summary="Consulta os status da demanda de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<List<DemandaStatus>> findStatusDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findStatus(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List status = this.demandaService.findStatus(empresaDB.getId(), search);
            return new ResponseEntity((Object)status, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatus", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tipos"})
    @Operation(summary="Consulta os tipos da demanda de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<List<DemandaTipo>> findTiposDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findTipos(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List tipos = this.demandaService.findTipos(empresaDB.getId(), null, search);
            return new ResponseEntity((Object)tipos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/tipos/{idTipo}"})
    @Operation(summary="Carrega as informa\u00e7\u00f5es do Tipo da demanda e demais dados, como Arquivos.")
    @ResponseBody
    public ResponseEntity<DemandaTipo> getTipoDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idTipo") Integer idTipo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getTipoDemanda(emp={}, id={})...", new Object[]{usuario.getLogin(), empresa, idTipo});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            DemandaTipo tipo = this.demandaService.getTipoById(idTipo);
            return new ResponseEntity((Object)tipo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dados"})
    @Operation(summary="Consulta dados gerais da demanda de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> findDadosGeraisDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findDados(emp={})...", (Object)empresa);
        try {
            List status;
            List tipos;
            List objetivos;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List areas = this.demandaService.findAreas(empresaDB.getId(), null);
            if (areas != null) {
                for (DemandaArea area : areas) {
                    area.setDatHorCadastro(null);
                    area.setIdUsuarioIns(null);
                    area.setDatHorAlteracao(null);
                    area.setIdUsuarioUpd(null);
                }
            }
            List rodovias = this.cadastroService.findRodovias(null, empresaDB.getId(), null);
            List trechosRodovias = this.cadastroService.findTrechosByRodovias(rodovias);
            ArrayList<Trecho> trechos = new ArrayList<Trecho>();
            if (trechosRodovias != null) {
                for (Trecho trecho : trechosRodovias) {
                    trecho.setDatHorCadastro(null);
                    trecho.setIdUsuarioIns(null);
                    trecho.setDatHorAlteracao(null);
                    trecho.setIdUsuarioUpd(null);
                    trechos.add(trecho);
                }
            }
            List cidadesDemanda = this.cadastroService.findCidadesTrechoByEmpresa(rodovias);
            ArrayList<Object> cidades = new ArrayList<Object>();
            if (cidadesDemanda != null) {
                for (Object cidDem : cidadesDemanda) {
                    cidDem.setDatHorCadastro(null);
                    cidDem.setIdUsuarioIns(null);
                    cidDem.setDatHorAlteracao(null);
                    cidDem.setIdUsuarioUpd(null);
                    cidades.add(cidDem);
                }
            }
            if ((objetivos = this.demandaService.findObjetivos(empresaDB.getId(), null, Integer.valueOf(1))) != null) {
                for (Object obj : objetivos) {
                    obj.setDatHorCadastro(null);
                    obj.setIdUsuarioIns(null);
                    obj.setDatHorAlteracao(null);
                    obj.setIdUsuarioUpd(null);
                }
                Collections.sort(objetivos, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ((tipos = this.demandaService.findTipos(empresaDB.getId(), null, null)) != null) {
                for (Object tipo : tipos) {
                    tipo.setDatHorCadastro(null);
                    tipo.setIdUsuarioIns(null);
                    tipo.setDatHorAlteracao(null);
                    tipo.setIdUsuarioUpd(null);
                    if (tipo.getObjetivo() == null) continue;
                    DemandaObjetivo obj = tipo.getObjetivo();
                    obj.setDatHorCadastro(null);
                    obj.setIdUsuarioIns(null);
                    obj.setDatHorAlteracao(null);
                    obj.setIdUsuarioUpd(null);
                }
            }
            if ((status = this.demandaService.findStatus(empresaDB.getId(), null)) != null) {
                for (DemandaStatus statusItem : status) {
                    statusItem.setDatHorCadastro(null);
                    statusItem.setIdUsuarioIns(null);
                    statusItem.setDatHorAlteracao(null);
                    statusItem.setIdUsuarioUpd(null);
                }
            }
            HashMap<String, List> values = new HashMap<String, List>();
            values.put("areas", areas);
            values.put("cidades", cidades);
            values.put("rodovias", rodovias);
            values.put("trechos", trechos);
            values.put("tipos", tipos);
            values.put("status", status);
            values.put("objetivos", objetivos);
            return new ResponseEntity(values, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/objetivos"})
    @Operation(summary="Consulta os tipos da objetivos de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<List<DemandaObjetivo>> findObjetivosDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findObjetivosDemanda(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List objetivos = this.demandaService.findObjetivos(empresaDB.getId(), search, null);
            return new ResponseEntity((Object)objetivos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObjetivosDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}"})
    @Operation(summary="Cria uma nova demanda de acordo com os dados base e upload dos anexos")
    @ResponseBody
    public ResponseEntity<Demanda> createDemanda(@PathVariable(name="empresa") String empresa, @RequestParam(name="files", required=false) MultipartFile[] files, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB;
            ArrayList<String> tiposAnexo = new ArrayList<String>();
            Demanda demanda = new Demanda();
            Map formData = request.getParameterMap();
            String[] rawParam = (String[])formData.get("titulo");
            if (rawParam != null) {
                demanda.setTitulo(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("tipo")) != null) {
                demanda.setIdTipo(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("area")) != null) {
                demanda.setIdAreaDemanda(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("objetivo")) != null) {
                demanda.setIdObjetivo(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("cidade")) != null) {
                demanda.setIdCidade(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("trecho")) != null) {
                demanda.setIdTrecho(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("sentido")) != null && rawParam[0] != null && !rawParam[0].isEmpty()) {
                demanda.setSentido(Character.valueOf(rawParam[0].charAt(0)));
            }
            if ((rawParam = (String[])formData.get("local")) != null) {
                demanda.setLocal(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("alca")) != null) {
                demanda.setNomenclaturaAlca(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("faixa")) != null) {
                demanda.setFaixa(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("datHorSolicitacao")) != null) {
                demanda.setDatHorSolicitacao(LocalDateTime.parse(rawParam[0], dataHoraFmt));
            }
            DecimalFormat nmfKm = new DecimalFormat("", new DecimalFormatSymbols(Locale.ENGLISH));
            nmfKm.setParseBigDecimal(true);
            rawParam = (String[])formData.get("kmInicial");
            if (rawParam != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                try {
                    demanda.setKmInicial((BigDecimal)nmfKm.parse(rawParam[0]));
                }
                catch (NumberFormatException nmfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "KM Inicial com formato inv\u00e1lido.");
                }
            }
            if ((rawParam = (String[])formData.get("kmFinal")) != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                try {
                    demanda.setKmFinal((BigDecimal)nmfKm.parse(rawParam[0]));
                }
                catch (NumberFormatException nmfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "KM Final com formato inv\u00e1lido.");
                }
            }
            if ((rawParam = (String[])formData.get("observacoes")) != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                demanda.setObservacoes(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("tiposAnexo")) != null && rawParam.length > 0) {
                for (String rawItem : rawParam) {
                    tiposAnexo.add(rawItem);
                }
            }
            if ((rawParam = (String[])formData.get("grupo")) != null) {
                demanda.setGrupo(Integer.valueOf(rawParam[0]));
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            demanda.getId().setIdEmpresa(empresaDB.getId());
            Demanda saved = this.demandaService.createDemanda(demanda, usuario.getLogin(), files, tiposAnexo);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (ParseException parExc) {
            logger.error("ParExc.createDemanda", (Throwable)parExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro formatando Data/KM:" + parExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idDemanda}"})
    @Operation(summary="Carrega a demanda de acordo com os identificadores da empresa e demanda")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idDemanda") Integer idDemanda) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando getDemanda(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String param = request.getParameter("versao");
            Integer versao = null;
            if (param != null) {
                versao = Integer.valueOf(param);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            Demanda demanda = this.demandaService.getDemandaById(idDemanda, empresaDB.getId(), versao);
            data.put("demanda", demanda);
            data.put("historicos", this.loadHistoricosDemanda(empresaDB.getId(), idDemanda, usr));
            if (demanda != null) {
                int faixaInt = 1;
                try {
                    faixaInt = Integer.valueOf(demanda.getFaixa());
                }
                catch (NumberFormatException nmfExc1) {
                    TipoFaixa faixaCode = TipoFaixa.fromText((String)demanda.getFaixa());
                    if (faixaCode != null) {
                        try {
                            faixaInt = Integer.valueOf(faixaCode.getCode());
                        }
                        catch (NumberFormatException nmfExc2) {
                            faixaInt = 1;
                        }
                    }
                    faixaInt = 1;
                }
                List segtos = this.cadastroService.findSegmentosByTrecho(demanda.getIdTrecho(), Integer.valueOf(faixaInt), demanda.getKmInicial(), demanda.getKmFinal());
                if (segtos != null && !segtos.isEmpty()) {
                    TrechoSegmento segto = (TrechoSegmento)segtos.get(0);
                    segto.setDatHorCadastro(null);
                    segto.setIdUsuarioIns(null);
                    segto.setDatHorAlteracao(null);
                    segto.setIdUsuarioUpd(null);
                    data.put("segmento", segtos.get(0));
                }
                if (demanda.getIdCidade() != null) {
                    Cidade cidade = this.cadastroService.getCidadeById(demanda.getIdCidade());
                    cidade.setDatHorCadastro(null);
                    cidade.setIdUsuarioIns(null);
                    cidade.setDatHorAlteracao(null);
                    cidade.setIdUsuarioUpd(null);
                    data.put("cidade", cidade);
                }
            }
            return new ResponseEntity(data, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idDemanda}/publicar"})
    @Operation(summary="Inclui o hist\u00f3rico e/ou anexos enviados na Demanda informada")
    @ResponseBody
    public ResponseEntity<List<DemandaHistorico>> adicionarHistorico(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idDemanda") Integer idDemanda, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando adicionarHistorico(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map formData = request.getParameterMap();
            String comentario = null;
            String[] rawParam = (String[])formData.get("comentario");
            if (rawParam != null) {
                comentario = rawParam[0];
            }
            String tipoAnexo = null;
            rawParam = (String[])formData.get("tipoAnexo");
            if (rawParam != null) {
                tipoAnexo = rawParam[0];
            }
            if (this.demandaService.createHistorico(empresaDB.getId(), idDemanda, comentario, usuario.getLogin(), file, tipoAnexo) != null) {
                Usuario user = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
                return new ResponseEntity((Object)this.loadHistoricosDemanda(empresaDB.getId(), idDemanda, user), (HttpStatusCode)HttpStatus.OK);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Hist\u00f3rico n\u00e3o p\u00f4de ser publicado.");
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.adicionarHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private List<DemandaHistorico> loadHistoricosDemanda(Integer idEmpresa, Integer idDemanda, Usuario user) {
        List historicos = this.demandaService.findHistoricos(idDemanda, idEmpresa, TipoAcessoHistorico.INTERNO);
        ArrayList<DemandaHistorico> histData = new ArrayList<DemandaHistorico>();
        if (historicos != null && !historicos.isEmpty()) {
            for (DemandaHistorico hist : historicos) {
                boolean flag = false;
                Character tipoAcessoHist = hist.getTipoAcesso();
                if (user.getTipo().equals(TipoUsuario.ACESSO_NORMAL.getCode())) {
                    flag = true;
                } else if (user.getTipo().equals(TipoUsuario.ACESSO_EXTERNO.getCode())) {
                    if (tipoAcessoHist.equals(TipoAcessoHistorico.INTERNO.getCode())) {
                        flag = hist.getIdUsuarioHistorico().equals(user.getId());
                    } else if (tipoAcessoHist.equals(TipoAcessoHistorico.EXTERNO.getCode()) || tipoAcessoHist.equals(TipoAcessoHistorico.PUBLICO.getCode())) {
                        flag = true;
                    }
                } else if (user.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || user.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) {
                    if (tipoAcessoHist.equals(TipoAcessoHistorico.INTERNO.getCode())) {
                        flag = hist.getIdUsuarioHistorico().equals(user.getId());
                    } else if (tipoAcessoHist.equals(TipoAcessoHistorico.PUBLICO.getCode())) {
                        flag = true;
                    }
                }
                if (!flag) continue;
                histData.add(hist);
            }
        }
        return histData;
    }

    @GetMapping(value={"/{empresa}/indices"})
    @Operation(summary="Consulta os \u00edndices de prioriza\u00e7\u00e3o de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<List<IndicePriorizacao>> findIndicesPriorizacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findStatus(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List indices = this.demandaService.findIndices(empresaDB.getId(), search);
            return new ResponseEntity((Object)indices, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatus", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/pesosPriorizacao"})
    @Operation(summary="Consulta os pesos de prioriza\u00e7\u00e3o de acordo com a empresa (sigla) ")
    @ResponseBody
    public ResponseEntity<List<PesoPriorizacao>> findPesosPriorizacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findStatus(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String tipo = null;
            if (request.getParameter("tipo") != null) {
                tipo = request.getParameter("tipo");
            }
            List pesos = this.demandaService.findPesos(empresaDB.getId(), tipo);
            return new ResponseEntity((Object)pesos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPesosPriorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/areas"})
    @Operation(summary="Salva a \u00e1rea da demanda a partir de seu payload")
    public ResponseEntity<DemandaArea> saveDemandaArea(@RequestBody DemandaArea demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaArea({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveArea(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDemandaArea", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/responsaveis"})
    @Operation(summary="Salva o respons\u00e1vel da demanda a partir de seu payload")
    public ResponseEntity<DemandaResponsavel> saveDemandaResponsavel(@RequestBody DemandaResponsavel demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaArea({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveDemandaResponsavel(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDemandaResponsavel", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/objetivos"})
    @Operation(summary="Salva o objetivo da demanda a partir de seu payload")
    public ResponseEntity<DemandaObjetivo> saveDemandaObjetivo(@RequestBody DemandaObjetivo demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaObjetivo({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveObjetivo(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDemandaObjetivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tipos"})
    @Operation(summary="Salva o tipo da demanda a partir de seu payload")
    public ResponseEntity<DemandaTipo> saveDemandaTipo(@RequestBody DemandaTipo demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaTipo({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveTipo(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDemandaTipo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/status"})
    @Operation(summary="Salva o status da demanda a partir de seu payload")
    public ResponseEntity<DemandaStatus> saveStatusDemanda(@RequestBody DemandaStatus demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaTipo({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveStatus(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveStatusDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/indices"})
    @Operation(summary="Salva o indice da demanda a partir de seu payload")
    public ResponseEntity<IndicePriorizacao> saveIndicePriorizacaoDemanda(@RequestBody IndicePriorizacao demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveDemandaTipo({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.saveIndice(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveIndicePriorizacaoDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/pesosPriorizacao"})
    @Operation(summary="Salva o peso de prioriza\u00e7\u00e3o da demanda a partir de seu payload")
    public ResponseEntity<PesoPriorizacao> savePesosPriorizacao(@RequestBody PesoPriorizacao demanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("savePesosPriorizacao({})", (Object)demanda);
            return new ResponseEntity((Object)this.demandaService.savePeso(demanda, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePesosPriorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/areas/{idArea}"})
    @Operation(summary="Deleta a \u00e1rea da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteAreaDemanda(@PathVariable(name="idArea") Integer idArea, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteAreaDemanda({})", (Object)idArea);
            this.demandaService.deleteArea(idArea);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/objetivos/{idObjetivo}"})
    @Operation(summary="Deleta o objetivo da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteObjetivoDemanda(@PathVariable(name="idObjetivo") Integer idObjetivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteObjetivoDemanda({})", (Object)idObjetivo);
            this.demandaService.deleteObjetivo(idObjetivo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteObjetivoDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/status/{idStatus}"})
    @Operation(summary="Deleta o status da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteStatusDemanda(@PathVariable(name="idStatus") Integer idStatus, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteStatusDemanda({})", (Object)idStatus);
            this.demandaService.deleteStatus(idStatus);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteStatusDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/responsaveis/{idDemanda}/{sequencia}/{idResponsavel}"})
    @Operation(summary="Deleta o respons\u00e1vel da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteResponsavelDemanda(@PathVariable(name="empresa") String empresa, @PathVariable(name="idDemanda") Integer idDemanda, @PathVariable(name="sequencia") Integer sequencia, @PathVariable(name="idResponsavel") Integer idResponsavel, @PathVariable(name="versao") Integer versao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteResponsavelDemanda({})", (Object)idResponsavel);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.demandaService.deleteDemandaResponsavel(empresaDB.getId(), idDemanda, sequencia, idResponsavel, versao);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteResponsavelDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tipos/{idTipo}"})
    @Operation(summary="Deleta o tipo da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteTipoDemanda(@PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteTipoDemanda({})", (Object)idTipo);
            this.demandaService.deleteTipo(idTipo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/pesosPriorizacao/{idPeso}"})
    @Operation(summary="Deleta o peso prioriza\u00e7\u00e3o da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deletePesoPriorizacao(@PathVariable(name="idPeso") Integer idPeso, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePesoPriorizacao({})", (Object)idPeso);
            this.demandaService.deletePeso(idPeso);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePesoPriorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/indices/{idIndice}"})
    @Operation(summary="Deleta o \u00edndice prioriza\u00e7\u00e3o da demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteIndicePriorizacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIndice") Integer idIndice, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteIndicePriorizacao({})", (Object)idIndice);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.demandaService.deleteIndice(idIndice, empresaDB.getId());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteIndicePriorizacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/demandas/{idDemanda}"})
    @Operation(summary="Deleta a demanda de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteDemanda(@PathVariable(name="empresa") String empresa, @PathVariable(name="idDemanda") Integer idDemanda, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteDemanda({})", (Object)idDemanda);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.demandaService.deleteDemanda(idDemanda, empresaDB.getId(), usr.getId(), request.getRemoteAddr());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/perguntasFrequentes"})
    @Operation(summary="Consulta as perguntas frequentes de acordo com a empresa")
    @ResponseBody
    public ResponseEntity<List<PerguntaFrequente>> findPerguntasFrequentes(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findStatus(emp={})...", (Object)empresa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List pergunta = this.demandaService.findPerguntasFrequentes(empresaDB.getId(), search);
            return new ResponseEntity((Object)pergunta, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findStatus", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/faleConosco"})
    @Operation(summary="Salva o formul\u00e1rio de Fale Conosco de acordo com seu payload")
    public ResponseEntity<FaleConosco> saveFaleConosco(@RequestBody FaleConosco faleConosco, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveFaleConosco({})", (Object)faleConosco);
            return new ResponseEntity((Object)this.demandaService.saveFaleConosco(faleConosco, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFaleConosco", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idDemanda}/anexos"})
    @Operation(summary="Lista os anexos da Demanda")
    @ResponseBody
    public ResponseEntity<List<DemandaAnexo>> findAnexos(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idDemanda) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findAnexos(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List anexos = this.demandaService.findAnexos(empresaDB.getId(), idDemanda);
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idDemanda}/anexos/comprovantes"})
    @Operation(summary="Inclui o comprovante na Demanda informada")
    @ResponseBody
    public ResponseEntity<String> adicionarComprovante(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idDemanda, @RequestParam(required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando adicionarComprovante(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try (InputStream istream = file.getInputStream();){
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), istream);
            String guid = this.demandaService.saveAnexo(empresaDB.getId(), idDemanda, "CMP", usuario.getLogin(), fileInfo);
            if (guid == null) throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Comprovante n\u00e3o p\u00f4de ser inserido.");
            if (guid.isEmpty()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Comprovante n\u00e3o p\u00f4de ser inserido.");
            ResponseEntity responseEntity = new ResponseEntity((Object)guid, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.adicionarComprovante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("bizExc.adicionarComprovante", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }
}

