<!DOCTYPE HTML>
<html lang="pt-BR">
    <head>
            <meta charset="UTF-8"/>
    <style>
        @font-face {
            font-family:"Aptos Display";
        }
        @font-face {
            font-family:Aptos;
        }
        font-family:"Aptos",sans-serif;
    </style>
    </head>
    <body>
    	<#if (proximoAprovador)??>
    		Prezado(a) ${proximoAprovador.responsavel.nome},<br/><br/>
    	<#else>
	        <#if (gestorAreaResposta)??>
    	    Prezado(a) ${gestorAreaResposta.nome},<br/><br/>
        	<#elseif (correspondencia.responsavelArea)??>
        	Prezado ${correspondencia.responsavelArea.nome},<br/><br/>
        	</#if>
        </#if>

		<table>
        <tr>
            <td>
            	<#if (novoAprovador)?? || (proximoAprovador)??>
            	Há pendência(s) de aprovação na correspondência:
            	<#else>
            	Houve mudanças no fluxo de aprovação:
            	</#if>
            	<br/><br/>
            </td>
        </tr>
        </table>

        <table border="1px solid gray" style="border-collapse: collapse; width: 600px;">
			<tr><th colspan="2" style="background-color:#ececec;">Correspondência</th></tr>
			
            <#if (empresa.sigla)??>
            <tr>
                <td style="font-weight:bold;">Empresa:</td>
                <td>${empresa.sigla}</td>
            </tr>
            </#if>

            <tr>
                <td style="font-weight:bold;">Área responsável:</td>
                <td>
                    ${(areaResposta.sigla)!''}
                    <#if (areaResposta.sigla)??> - </#if>
                    ${(areaResposta.descricao)!''}&nbsp;
                    <#if (correspondencia.responsavel)??> - ${correspondencia.responsavel.nome!}</#if>
                </td>
            </tr>

           <#if correspondencia.datRecebimento??>
           <tr>
                <td style="font-weight:bold;">
                    <#if correspondencia.tipoCorrespondencia.classe == "COR">
                    Data de recebimento:
                    <#else>
                    Data de envio:
                    </#if>
                </td>
                <td>${correspondencia.datRecebimento.format("dd/MM/yyyy")}</td>
            </tr>
            </#if>
            
            <#if (correspondencia.entidade.nome)??>
            <tr>
                <td style="font-weight:bold;">Entidade/remetente:</td>
                <td>${correspondencia.entidade.nome}</td>
            </tr>
            </#if>
            
            <#if correspondencia.processoInterno??>
            <tr>
                <td style="font-weight:bold;">Processo interno:</td>
                <td>${correspondencia.processoInterno.nroProcessoInterno!'.'} - <#if (correspondencia.processoInterno.tema)??>${correspondencia.processoInterno.tema.descricao!'.'}</#if></td>
            </tr>
            </#if>

            <#if correspondencia.observacao??>
            <tr>
                <td style="font-weight:bold;">Descrição:</td>
                <td>${correspondencia.observacao}</td>
            </tr>
            </#if>

            <#if externalLink??>
            <tr>
                <td style="font-weight:bold;">Link:</td>
                <td>
                    <a href="${externalLink}">${correspondencia.id.idCorrespondencia?string("000000")}</a>
			</tr>
            </#if>

            <#if correspondencia.prazoInterno??>
            <tr>
                <td style="font-weight:bold;">Prazo interno:</td>
                <td>${correspondencia.prazoInterno} dias</td>
            </tr>
            </#if>

            <#if correspondencia.prazoOficio??>
            <tr>
                <td style="font-weight:bold;">Prazo fatal:</td>
                <td>${correspondencia.prazoOficio} dias ${correspondencia.datFinalProtocolo.format("dd/MM/yyyy")}</td>
            </tr>
            </#if>

			<#if correspondencia.datFinalProtocolo??>
            <tr>
                <td style="font-weight:bold;">Data fatal:</td>
                <td>${correspondencia.datFinalProtocolo.format("dd/MM/yyyy")}</td>
            </tr>
            </#if>

            <#if correspondencia.descricaoHistorico??>
            <tr>
                <td style="font-weight:bold;">Descrição documento:</td>
                <td>${correspondencia.descricaoHistorico}</td>
            </tr>
            </#if>

            <#if correspondencia.observacaoResposta??>
            <tr>
                <td style="font-weidht: bold;">Observação resposta:</td>
                <td>${correspondencia.observacaoResposta}</td>
            </tr>
            </#if>
            
	        <#if revisoes??>
	        <tr>
	            <td style="font-weight:bold;">Encaminhamentos:</td>
	            <td>&nbsp;</td>
	        </tr>
	        <tr>
	            <td>&nbsp;</td>
	            <#list revisoes as revisao>
	                <td>
	                    <span>${revisao.usuario.nome}: ${revisao.descricao}</span>
	                    <br/>
	                </td>
	            </#list>
	        </tr>
	        </#if>
		</table>
		
		<br/>

		<table border="1px solid gray" style="border-collapse: collapse; width: 600px;">
			<tr><th colspan="2" style="background-color:#ececec;">Fluxo de Aprovação</th></tr>
			
			<#if (novoAprovador)??>
            <tr>
            	<td style="font-weight:bold;">Novo aprovador:</td>
            	<td>${novoAprovador.responsavel.nome}</td>
            </tr>
            </#if>
			
            <#if (proximoAprovador)??>
            <tr>
            	<td style="font-weight:bold;">Próximo aprovador:</td>
            	<td>${proximoAprovador.responsavel.nome}</td>
            </tr>
            </#if>

            <#if (ultimoAprovador)??>
            <tr>
            	<td style="font-weight:bold;">Última ação:</td>
            	<#if (ultimoAprovador.status == 1)??>
            	<td>${ultimoAprovador.responsavel.nome}, aprovado em ${ultimoAprovador.datHorAprovacao.format("dd/MM/yyyy HH:mm")}</td>
            	<#else>
            	<td>${ultimoAprovador.responsavel.nome}, reprovado em ${ultimoAprovador.datHorAprovacao.format("dd/MM/yyyy HH:mm")}</td>
            	</#if>
            </tr>
            </#if>
            
            <#if (descricaoAprovaReprova)?? >
            <tr>
            	<td style="font-weight:bold;">Descrição ação:</td>
            	<td>${descricaoAprovaReprova}</td>
            </tr>
            </#if>
		</table>

        <br />Atenciosamente,<br/>

        <br/><br/>
        <p style="font-size: 11px; color: #848484">
            E-mail gerado automaticamente, nao o responda
            <br/>
            Data/Hora: ${sysDate?datetime}
        </p>
    </body>
</html>