/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class CustomAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static Logger LOG = LoggerFactory.getLogger(CustomAuthenticationFilter.class);

    public CustomAuthenticationFilter() {
        this.logger.debug((Object)"Iniciando CustomAuthenticationFilter...");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        UsernamePasswordAuthenticationToken authRequest = this.getAuthRequest(request);
        this.setDetails(request, authRequest);
        Authentication authObj = this.getAuthenticationManager().authenticate((Authentication)authRequest);
        return authObj;
    }

    private UsernamePasswordAuthenticationToken getAuthRequest(HttpServletRequest request) {
        String userName = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String domainLdap = request.getParameter("domain");
        if (domainLdap != null && !domainLdap.isEmpty()) {
            request.getSession().setAttribute("domainAD", (Object)domainLdap);
        }
        LOG.debug("auth user,pass,domain={},{},{}", new Object[]{userName, password, domainLdap});
        return new UsernamePasswordAuthenticationToken((Object)userName, (Object)password);
    }
}

