/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.demanda.DemandaAnexo;
import br.com.oti.gesconsys.beans.demanda.DemandaHistorico;
import br.com.oti.gesconsys.beans.demanda.TipoAcessoHistorico;
import br.com.oti.gesconsys.beans.demanda.TipoDemanda;
import br.com.oti.gesconsys.beans.geral.Cidade;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.Trecho;
import br.com.oti.gesconsys.beans.geral.TrechoSegmento;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.TipoUsuario;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.shared.Demanda;
import br.com.oti.gesconsys.beans.shared.DemandaArea;
import br.com.oti.gesconsys.beans.shared.DemandaObjetivo;
import br.com.oti.gesconsys.beans.shared.DemandaStatus;
import br.com.oti.gesconsys.beans.shared.DemandaTipo;
import br.com.oti.gesconsys.beans.shared.TipoFaixa;
import br.com.oti.gesconsys.beans.shared.TipoStatusDemanda;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.DemandaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para faixas de dom\u00ednio", name="faixasDominio")
@RequestMapping(value={"/api/faixasDominio"})
public class FaixasDominioRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(FaixasDominioRestServices.class);
    private static final DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.[SSSSSSSSS][SSSSSSSS][SSSSSSS][SSSSSS][SSSSS][SSSS][SSS][SS][S]][X]");
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private DemandaService demandaService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Carrega as informa\u00e7\u00f5es das Faixas de Dom\u00ednio de acordo com o filtro.")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> findDemandas(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="titulo", defaultValue="") String titulo, @RequestParam(name="tipo", defaultValue="0") Integer tipo, @RequestParam(name="area", defaultValue="0") Integer area, @RequestParam(name="objetivo", defaultValue="0") Integer objetivo, @RequestParam(name="cidade", defaultValue="0") Integer cidade, @RequestParam(name="trecho", defaultValue="0") Integer trecho, @RequestParam(name="status", defaultValue="0") Integer status, @RequestParam(name="publica", defaultValue="-1") Integer publica) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findFaixasDominio(emp={})...", (Object)empresa);
        try {
            Usuario userData;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (area == 0) {
                area = null;
            }
            if (tipo == 0) {
                tipo = null;
            }
            if (objetivo == 0) {
                objetivo = null;
            }
            if (cidade == 0) {
                cidade = null;
            }
            if (trecho == 0) {
                trecho = null;
            }
            if (status == 0) {
                status = null;
            }
            Integer grupo = TipoDemanda.FAIXA_DOMINIO.getCode();
            Integer publicaParm = null;
            if (publica != -1) {
                publicaParm = publica;
            }
            ArrayList<Integer> empIds = new ArrayList<Integer>();
            empIds.add(empresaDB.getId());
            List demandas = null;
            ArrayList<Integer> statusList = null;
            if (status != null) {
                statusList = new ArrayList<Integer>();
                statusList.add(status);
            }
            ArrayList<Integer> areasList = null;
            if (area != null) {
                areasList = new ArrayList<Integer>();
                areasList.add(area);
            }
            ArrayList<Integer> tiposList = null;
            if (tipo != null) {
                tiposList = new ArrayList<Integer>();
                tiposList.add(tipo);
            }
            ArrayList<Integer> objetivosList = null;
            if (objetivo != null) {
                objetivosList = new ArrayList<Integer>();
                objetivosList.add(objetivo);
            }
            ArrayList<Integer> cidadesList = null;
            if (cidade != null) {
                cidadesList = new ArrayList<Integer>();
                cidadesList.add(cidade);
            }
            if (!(userData = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin())).getTipo().equals(TipoUsuario.ACESSO_NORMAL.getCode())) {
                ArrayList<Character> statusCodes = new ArrayList<Character>();
                statusCodes.add(TipoStatusDemanda.PENDENTE.getCode());
                statusCodes.add(TipoStatusDemanda.ANDAMENTO.getCode());
                statusCodes.add(TipoStatusDemanda.APROVADA.getCode());
                statusCodes.add(TipoStatusDemanda.ENCERRADA.getCode());
                statusCodes.add(TipoStatusDemanda.EXECUTADA.getCode());
                Integer idUserDemanda = userData.getId();
                demandas = this.demandaService.findDemandas(empIds, titulo, idUserDemanda, null, null, statusCodes, "stat.descricao, tipo.descricao, area.descricao, dem.titulo ", areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, grupo, publicaParm, Boolean.valueOf(false));
            } else {
                demandas = this.demandaService.findDemandas(empIds, titulo, null, null, null, null, "stat.descricao, tipo.descricao, area.descricao, dem.titulo ", areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, grupo, publicaParm, Boolean.valueOf(true));
            }
            HashMap<String, List<Object>> mapData = new HashMap<String, List<Object>>();
            HashMap<Integer, Rodovia> mapRodovias = new HashMap<Integer, Rodovia>();
            ArrayList<DemandaStatus> statusInfo = new ArrayList<DemandaStatus>();
            for (Object demanda : demandas) {
                if (!statusInfo.contains(demanda.getStatusInfo())) {
                    statusInfo.add(demanda.getStatusInfo());
                }
                demanda.getTrecho().setRodovia(null);
                EmpresaArea areaDem = demanda.getAreaEmpresa();
                if (areaDem != null) {
                    areaDem.setResponsavel(null);
                }
                if (demanda.getIdRodovia() == null) continue;
                mapRodovias.put(demanda.getIdRodovia(), demanda.getRodovia());
            }
            if (statusInfo.isEmpty()) {
                DemandaStatus statusItem = new DemandaStatus();
                statusItem.setId(Integer.valueOf(0));
                statusItem.setDescricao("Em Avalia\u00e7\u00e3o");
                statusInfo.add(statusItem);
            }
            ArrayList coordenadas = new ArrayList();
            for (Integer idRodovia : mapRodovias.keySet()) {
                List coordRodov = this.cadastroService.findCoordenadas(idRodovia, null, null);
                coordenadas.addAll(coordRodov);
            }
            mapData.put("status", statusInfo);
            mapData.put("demandas", demandas);
            List rodovias = mapRodovias.values().stream().collect(Collectors.toList());
            mapData.put("rodovias", rodovias);
            mapData.put("coordenadas", coordenadas);
            return new ResponseEntity(mapData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFaxiasDominio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idFaixa}"})
    @Operation(summary="Carrega as informa\u00e7\u00f5es da Faixa de Dom\u00ednio de acordo com os identificadores de Empresa e Demanda.")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFaixa") Integer idFaixa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("Executando getFaixa(emp={},idFaixa={})...", (Object)empresa, (Object)idFaixa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Integer versao = null;
            HashMap<String, Object> data = new HashMap<String, Object>();
            Demanda demanda = this.demandaService.getDemandaById(idFaixa, empresaDB.getId(), versao);
            data.put("demanda", demanda);
            data.put("historicos", this.loadHistoricosDemanda(empresaDB.getId(), idFaixa, usr));
            if (demanda != null) {
                int faixaInt = 1;
                try {
                    faixaInt = Integer.valueOf(demanda.getFaixa());
                }
                catch (NumberFormatException nmfExc1) {
                    TipoFaixa faixaCode = TipoFaixa.fromText((String)demanda.getFaixa());
                    if (faixaCode != null) {
                        try {
                            faixaInt = Integer.valueOf(faixaCode.getCode());
                        }
                        catch (NumberFormatException nmfExc2) {
                            faixaInt = 1;
                        }
                    }
                    faixaInt = 1;
                }
                List segtos = this.cadastroService.findSegmentosByTrecho(demanda.getIdTrecho(), Integer.valueOf(faixaInt), demanda.getKmInicial(), demanda.getKmFinal());
                if (segtos != null && !segtos.isEmpty()) {
                    TrechoSegmento segto = (TrechoSegmento)segtos.get(0);
                    segto.setDatHorCadastro(null);
                    segto.setIdUsuarioIns(null);
                    segto.setDatHorAlteracao(null);
                    segto.setIdUsuarioUpd(null);
                    data.put("segmento", segtos.get(0));
                }
                if (demanda.getIdCidade() != null) {
                    Cidade cidade = this.cadastroService.getCidadeById(demanda.getIdCidade());
                    cidade.setDatHorCadastro(null);
                    cidade.setIdUsuarioIns(null);
                    cidade.setDatHorAlteracao(null);
                    cidade.setIdUsuarioUpd(null);
                    data.put("cidade", cidade);
                }
            }
            return new ResponseEntity(data, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}"})
    @Operation(summary="Cria uma nova Faixa de Dom\u00ednio de acordo com os dados e anexos inseridos.")
    @ResponseBody
    public ResponseEntity<Demanda> createDemanda(@PathVariable(name="empresa") String empresa, @RequestParam(name="files", required=false) MultipartFile[] files, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Demanda demanda = new Demanda();
            Map formData = request.getParameterMap();
            String[] rawParam = (String[])formData.get("titulo");
            if (rawParam != null) {
                demanda.setTitulo(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("tipo")) != null) {
                demanda.setIdTipo(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("area")) != null) {
                demanda.setIdAreaDemanda(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("objetivo")) != null) {
                demanda.setIdObjetivo(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("cidade")) != null) {
                demanda.setIdCidade(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("trecho")) != null) {
                demanda.setIdTrecho(Integer.valueOf(rawParam[0]));
            }
            if ((rawParam = (String[])formData.get("sentido")) != null && rawParam[0] != null && !rawParam[0].isEmpty()) {
                demanda.setSentido(Character.valueOf(rawParam[0].charAt(0)));
            }
            if ((rawParam = (String[])formData.get("local")) != null) {
                demanda.setLocal(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("alca")) != null) {
                demanda.setNomenclaturaAlca(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("faixa")) != null) {
                demanda.setFaixa(rawParam[0]);
            }
            if ((rawParam = (String[])formData.get("datHorSolicitacao")) != null) {
                demanda.setDatHorSolicitacao(LocalDateTime.parse(rawParam[0], dataHoraFmt));
            }
            NumberFormat nmfKm = NumberFormat.getNumberInstance();
            rawParam = (String[])formData.get("kmInicial");
            if (rawParam != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                try {
                    demanda.setKmInicial(BigDecimal.valueOf(nmfKm.parse(rawParam[0]).doubleValue()));
                }
                catch (NumberFormatException nmfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "KM Inicial com formato inv\u00e1lido.");
                }
            }
            if ((rawParam = (String[])formData.get("kmFinal")) != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                try {
                    demanda.setKmFinal(BigDecimal.valueOf(nmfKm.parse(rawParam[0]).doubleValue()));
                }
                catch (NumberFormatException nmfExc) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "KM Final com formato inv\u00e1lido.");
                }
            }
            if ((rawParam = (String[])formData.get("observacoes")) != null && rawParam.length > 0 && rawParam[0] != null && !rawParam[0].isEmpty()) {
                demanda.setObservacoes(rawParam[0]);
            }
            rawParam = (String[])formData.get("tiposArquivos");
            ArrayList<Integer> tiposArquivos = new ArrayList<Integer>();
            if (rawParam != null && rawParam.length > 0) {
                for (String rawItem : rawParam) {
                    tiposArquivos.add(Integer.valueOf(rawItem));
                }
            }
            demanda.setGrupo(TipoDemanda.FAIXA_DOMINIO.getCode());
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            demanda.getId().setIdEmpresa(empresaDB.getId());
            Demanda saved = this.demandaService.createFaixaDominio(demanda, usuario.getLogin(), files, tiposArquivos);
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createFaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (ParseException parExc) {
            logger.error("ParExc.createFaixa", (Throwable)parExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro formatando Data/KM:" + parExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/faixasDominio/{idFaixa}"})
    @Operation(summary="Exclui a Faixa de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteDemanda(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFaixa") Integer idFaixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteFaixa({})", (Object)idFaixa);
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.demandaService.deleteDemanda(idFaixa, empresaDB.getId(), usr.getId(), request.getRemoteAddr());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dados"})
    @Operation(summary="Consulta dados gerais da Faixa de acordo com a Empresa.")
    public ResponseEntity<Map<String, Object>> findDadosGeraisDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findDadosGeraisFaixa({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            List status;
            List tipos;
            List objetivos;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List areas = this.demandaService.findAreas(empresaDB.getId(), null);
            if (areas != null) {
                for (DemandaArea area : areas) {
                    area.setDatHorCadastro(null);
                    area.setIdUsuarioIns(null);
                    area.setDatHorAlteracao(null);
                    area.setIdUsuarioUpd(null);
                }
            }
            List rodovias = this.cadastroService.findRodovias(null, empresaDB.getId(), null);
            List trechosRodovias = this.cadastroService.findTrechosByRodovias(rodovias);
            ArrayList<Trecho> trechos = new ArrayList<Trecho>();
            if (trechosRodovias != null) {
                for (Trecho trecho : trechosRodovias) {
                    trecho.setDatHorCadastro(null);
                    trecho.setIdUsuarioIns(null);
                    trecho.setDatHorAlteracao(null);
                    trecho.setIdUsuarioUpd(null);
                    trechos.add(trecho);
                }
            }
            List cidadesDemanda = this.cadastroService.findCidadesTrechoByEmpresa(rodovias);
            ArrayList<Object> cidades = new ArrayList<Object>();
            if (cidadesDemanda != null) {
                for (Object cidDem : cidadesDemanda) {
                    cidDem.setDatHorCadastro(null);
                    cidDem.setIdUsuarioIns(null);
                    cidDem.setDatHorAlteracao(null);
                    cidDem.setIdUsuarioUpd(null);
                    cidades.add(cidDem);
                }
            }
            if ((objetivos = this.demandaService.findObjetivos(empresaDB.getId(), null, null)) != null) {
                objetivos.removeIf(obj -> obj.getGrupo() != 2);
                for (Object obj2 : objetivos) {
                    obj2.setDatHorCadastro(null);
                    obj2.setIdUsuarioIns(null);
                    obj2.setDatHorAlteracao(null);
                    obj2.setIdUsuarioUpd(null);
                }
                Collections.sort(objetivos, new /* Unavailable Anonymous Inner Class!! */);
            }
            if ((tipos = this.demandaService.findTipos(empresaDB.getId(), null, null)) != null) {
                tipos.removeIf(tipo -> tipo.getObjetivo() == null || tipo.getObjetivo().getGrupo() != 2);
                for (DemandaTipo tipo2 : tipos) {
                    tipo2.setDatHorCadastro(null);
                    tipo2.setIdUsuarioIns(null);
                    tipo2.setDatHorAlteracao(null);
                    tipo2.setIdUsuarioUpd(null);
                    if (tipo2.getObjetivo() == null) continue;
                    DemandaObjetivo obj3 = tipo2.getObjetivo();
                    obj3.setDatHorCadastro(null);
                    obj3.setIdUsuarioIns(null);
                    obj3.setDatHorAlteracao(null);
                    obj3.setIdUsuarioUpd(null);
                }
            }
            if ((status = this.demandaService.findStatus(empresaDB.getId(), null)) != null) {
                for (DemandaStatus statusItem : status) {
                    statusItem.setDatHorCadastro(null);
                    statusItem.setIdUsuarioIns(null);
                    statusItem.setDatHorAlteracao(null);
                    statusItem.setIdUsuarioUpd(null);
                }
            }
            HashMap<String, List> values = new HashMap<String, List>();
            values.put("areas", areas);
            values.put("cidades", cidades);
            values.put("rodovias", rodovias);
            values.put("trechos", trechos);
            values.put("tipos", tipos);
            values.put("status", status);
            values.put("objetivos", objetivos);
            return new ResponseEntity(values, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/objetivos"})
    @Operation(summary="Consulta os Objetivos de Faixa de acordo com a Empresa.")
    public ResponseEntity<List<DemandaObjetivo>> findObjetivosDemanda(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("({}) - Iniciando findObjetivosFaixa({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa empresaDB;
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if ((empresaDB = this.coreService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Integer grupo = TipoDemanda.FAIXA_DOMINIO.getCode();
            List objetivos = this.demandaService.findObjetivos(empresaDB.getId(), search, grupo);
            return new ResponseEntity((Object)objetivos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObjetivosDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/objetivos/{idObjetivo}"})
    @Operation(summary="Carrega as informa\u00e7\u00f5es do Objetivo da Faixa.")
    public ResponseEntity<DemandaObjetivo> getObjetivoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idObjetivo") Integer idObjetivo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getFaixaObjetivo({}, {})", new Object[]{usuario.getLogin(), empresa, idObjetivo});
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            DemandaObjetivo obj = this.demandaService.getObjetivoById(idObjetivo);
            return new ResponseEntity((Object)obj, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFaixaDemanda", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/objetivos"})
    @Operation(summary="Salva o Objetivo de Faixa de acordo com os dados inseridos.")
    public ResponseEntity<DemandaObjetivo> saveDemandaObjetivo(@PathVariable(name="empresa") String empresa, @RequestBody DemandaObjetivo faixa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("({}) - saveFaixaObjetivo({})", (Object)usuario.getLogin(), (Object)empresa);
            faixa.setGrupo(TipoDemanda.FAIXA_DOMINIO.getCode());
            return new ResponseEntity((Object)this.demandaService.saveObjetivo(faixa, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFaixaObjetivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/objetivos/{idObjetivo}"})
    @Operation(summary="Deleta o objetivo da Faixa de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteObjetivoDemanda(@PathVariable(name="empresa") String empresa, @PathVariable(name="idObjetivo") Integer idObjetivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("{} - deleteObjetivoFaixa({})", (Object)usuario.getLogin(), (Object)idObjetivo);
            this.demandaService.deleteObjetivo(idObjetivo);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteObjetivoFaixa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idFaixa}/publicar"})
    @Operation(summary="Inclui o hist\u00f3rico e/ou anexos enviados no ID da Faixa dom\u00ednio informada")
    @ResponseBody
    public ResponseEntity<List<DemandaHistorico>> adicionarHistorico(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idFaixa, @RequestParam(name="files", required=false) MultipartFile[] files) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando adicionarHistorico(emp={},idFaixa={})...", (Object)empresa, (Object)idFaixa);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map formData = request.getParameterMap();
            String comentario = null;
            String[] rawParam = (String[])formData.get("comentario");
            if (rawParam != null) {
                comentario = rawParam[0];
            }
            rawParam = (String[])formData.get("tiposArquivos");
            ArrayList<Integer> tiposArquivos = new ArrayList<Integer>();
            if (rawParam != null && rawParam.length > 0) {
                for (String rawItem : rawParam) {
                    tiposArquivos.add(Integer.valueOf(rawItem));
                }
            }
            if (this.demandaService.createHistorico(empresaDB.getId(), idFaixa, comentario, usuario.getLogin(), files, tiposArquivos) != null) {
                Usuario user = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
                return new ResponseEntity((Object)this.loadHistoricosDemanda(empresaDB.getId(), idFaixa, user), (HttpStatusCode)HttpStatus.OK);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Hist\u00f3rico n\u00e3o p\u00f4de ser publicado.");
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.adicionarHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private List<DemandaHistorico> loadHistoricosDemanda(Integer idEmpresa, Integer idFaixa, Usuario user) {
        List historicos = this.demandaService.findHistoricos(idFaixa, idEmpresa, TipoAcessoHistorico.INTERNO);
        ArrayList<DemandaHistorico> histData = new ArrayList<DemandaHistorico>();
        if (historicos != null && !historicos.isEmpty()) {
            for (DemandaHistorico hist : historicos) {
                boolean flag = false;
                Character tipoAcessoHist = hist.getTipoAcesso();
                if (user.getTipo().equals(TipoUsuario.ACESSO_NORMAL.getCode())) {
                    flag = true;
                } else if (user.getTipo().equals(TipoUsuario.ACESSO_EXTERNO.getCode())) {
                    if (tipoAcessoHist.equals(TipoAcessoHistorico.INTERNO.getCode())) {
                        flag = hist.getIdUsuarioHistorico().equals(user.getId());
                    } else if (tipoAcessoHist.equals(TipoAcessoHistorico.EXTERNO.getCode()) || tipoAcessoHist.equals(TipoAcessoHistorico.PUBLICO.getCode())) {
                        flag = true;
                    }
                } else if (user.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PRIVADA.getCode()) || user.getTipo().equals(TipoUsuario.ACESSO_DEMANDA_PUBLICA.getCode())) {
                    if (tipoAcessoHist.equals(TipoAcessoHistorico.INTERNO.getCode())) {
                        flag = hist.getIdUsuarioHistorico().equals(user.getId());
                    } else if (tipoAcessoHist.equals(TipoAcessoHistorico.PUBLICO.getCode())) {
                        flag = true;
                    }
                }
                if (!flag) continue;
                histData.add(hist);
            }
        }
        return histData;
    }

    @GetMapping(value={"/{empresa}/{idDemanda}/anexos"})
    @Operation(summary="Lista os anexos da Demanda")
    @ResponseBody
    public ResponseEntity<List<DemandaAnexo>> findAnexos(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idDemanda) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando findAnexos(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try {
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List anexos = this.demandaService.findAnexos(empresaDB.getId(), idDemanda);
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idDemanda}/anexos/comprovantes"})
    @Operation(summary="Inclui o comprovante na Demanda informada")
    @ResponseBody
    public ResponseEntity<String> adicionarComprovante(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idDemanda, @RequestParam(required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando adicionarComprovante(emp={},idDemanda={})...", (Object)empresa, (Object)idDemanda);
        try (InputStream istream = file.getInputStream();){
            String guid;
            Empresa empresaDB = this.coreService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), istream);
            String tipo = request.getParameter("tipo");
            if (tipo == null || tipo.isEmpty()) {
                tipo = "CP1";
            }
            if ((guid = this.demandaService.saveAnexo(empresaDB.getId(), idDemanda, tipo, usuario.getLogin(), fileInfo)) == null) throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Comprovante n\u00e3o p\u00f4de ser inserido.");
            if (guid.isEmpty()) throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Comprovante n\u00e3o p\u00f4de ser inserido.");
            ResponseEntity responseEntity = new ResponseEntity((Object)guid, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.adicionarComprovante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("bizExc.adicionarComprovante", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }
}

