/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.correspondencia.Correspondencia;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaAnexo;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaDestinatario;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaHistorico;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaMobileVO;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaNumero;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaPK;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaProrrogacao;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaReferencia;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaRelacao;
import br.com.oti.gesconsys.beans.correspondencia.CorrespondenciaResponsavel;
import br.com.oti.gesconsys.beans.correspondencia.FiltroCorrespondenciaVO;
import br.com.oti.gesconsys.beans.correspondencia.TipoAnexoCorrespondencia;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.ged.AnexoConteudo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Entidade;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.ged.business.GedService;
import br.com.oti.gesconsys.reports.corresp.RelatorioRetoffExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para correspond\u00eancias", name="correspondencias")
@RequestMapping(value={"/api/correspondencias"})
public class CorrespondenciasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CorrespondenciasRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta as correspond\u00eancias, de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<Page<Correspondencia>> findCorrespondencias(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="tipoCorrespondencia", required=false) String classeDocumento, @RequestParam(name="processo", required=false) String processo, @RequestParam(name="protocolo", required=false) String protocolo, @RequestParam(name="documento", required=false) String documento, @RequestParam(name="pleito", required=false) Integer idPleito, @RequestParam(name="usuario", required=false) String nomeUsuario, @RequestParam(name="status", required=false) Integer[] status, @RequestParam(name="entidade", required=false) String entidade, @RequestParam(name="nroCartaIdCorresp", required=false) String nroCartaIdCorresp, @RequestParam(name="protocoloInterno", required=false) String protocoloInterno, @RequestParam(name="idTema", required=false) Integer idTema) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={},search={})...", (Object)empresa, (Object)search);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            ArrayList<Integer> statusCorresp = null;
            Entidade ent = new Entidade();
            Map params = request.getParameterMap();
            LocalDate dataInicial = null;
            if (params.containsKey("dataInicial")) {
                dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
            }
            LocalDate dataFinal = null;
            if (params.containsKey("dataFinal")) {
                dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
            }
            if (status != null) {
                statusCorresp = new ArrayList<Integer>();
                for (Integer item : status) {
                    statusCorresp.add(item);
                }
            }
            if (entidade != null) {
                ent = this.cadastroService.getEntidadeByNome(entidade);
            }
            boolean tipoData = false;
            Integer idObra = null;
            List prazos = null;
            Integer idFornecedor = null;
            Integer pageNbr = 0;
            if (params.containsKey("pageNumber")) {
                pageNbr = Integer.valueOf(((String[])params.get("pageNumber"))[0]);
            }
            Integer pageSize = 15;
            if (params.containsKey("pageSize")) {
                pageSize = Integer.valueOf(((String[])params.get("pageSize"))[0]);
            }
            int offset = pageNbr * pageSize;
            String sortFields = null;
            if (params.containsKey("sortFields")) {
                sortFields = ((String[])params.get("sortFields"))[0];
            }
            Page correspDB = this.correspondenciaService.findCorrespondenciasFullText(empresasInt, search, null, classeDocumento, null, processo, idPleito, statusCorresp, null, dataInicial, dataFinal, prazos, Integer.valueOf(0), nroCartaIdCorresp, nomeUsuario, null, null, null, ent.getId(), Boolean.valueOf(false), idObra, null, null, null, documento, protocolo, protocoloInterno, idTema, idFornecedor, Integer.valueOf(offset), pageSize, sortFields);
            for (Correspondencia crp : correspDB) {
                if (crp.getIdSetor() != null) {
                    crp.setSetor(this.cadastroService.getSetorEntidade(crp.getIdSetor()));
                    crp.getSetor().setIdUsuarioUpd(null);
                    crp.getSetor().setIdUsuarioIns(null);
                    crp.getSetor().setIdResponsavelPadrao(null);
                    crp.getSetor().setDatHorCadastro(null);
                    crp.getSetor().setDatHorAlteracao(null);
                    crp.getSetor().setEntidade(null);
                }
                if (crp.getIdResponsavelArea() != null) {
                    crp.setResponsavelArea(this.segurancaService.getUsuarioById(crp.getIdResponsavelArea()));
                    crp.getResponsavelArea().setTipo(null);
                    crp.getResponsavelArea().setCargo(null);
                    crp.getResponsavelArea().setDatHorAlteracao(null);
                    crp.getResponsavelArea().setDatHorCadastro(null);
                    crp.getResponsavelArea().setDatHorUltimoLogin(null);
                    crp.getResponsavelArea().setEmail(null);
                    crp.getResponsavelArea().setGrupos(null);
                    crp.getResponsavelArea().setId(null);
                    crp.getResponsavelArea().setIdPoderConcedente(null);
                    crp.getResponsavelArea().setIdUsuarioUpd(null);
                    crp.getResponsavelArea().setSubTipo(null);
                }
                if (crp.getIdResponsavelSetor() != null && crp.getIdSetor() != null) {
                    crp.setResponsavelSetor(this.cadastroService.getSetorEntidadeBySeq(crp.getIdSetor(), crp.getIdResponsavelSetor()));
                    crp.getResponsavelSetor().setDatHorAlteracao(null);
                    crp.getResponsavelSetor().setDatHorCadastro(null);
                    crp.getResponsavelSetor().setEmail(null);
                    crp.getResponsavelSetor().setId(null);
                    crp.getResponsavelSetor().setIdUsuarioUpd(null);
                    crp.getResponsavelSetor().setIdUsuarioIns(null);
                    crp.getResponsavelSetor().setSetor(null);
                }
                if (crp.getIdTipoCorrespondencia() != null) {
                    crp.setTipoCorrespondencia(this.cadastroService.getTipoDocumentoById(crp.getId().getIdEmpresa(), crp.getIdTipoCorrespondencia()));
                    crp.getTipoCorrespondencia().setConfiguracaoCampos(null);
                    crp.getTipoCorrespondencia().setDatHorAlteracao(null);
                    crp.getTipoCorrespondencia().setDatHorCadastro(null);
                    crp.getTipoCorrespondencia().setEntidade(null);
                    crp.getTipoCorrespondencia().setHashCor(null);
                    crp.getTipoCorrespondencia().setIdEntidade(null);
                    crp.getTipoCorrespondencia().setIdNotificacaoGrupo(null);
                    crp.getTipoCorrespondencia().setIdTipoDocumentoPai(null);
                    crp.getTipoCorrespondencia().setIdUsuarioIns(null);
                    crp.getTipoCorrespondencia().setIdUsuarioUpd(null);
                    crp.getTipoCorrespondencia().setModulos(null);
                    crp.getTipoCorrespondencia().setTipoDocumento(null);
                }
                if (crp.getIdUsuarioResposta() != null) {
                    crp.setResponsavel(this.segurancaService.getUsuarioById(crp.getIdUsuarioResposta()));
                    crp.getResponsavel().setTipo(null);
                    crp.getResponsavel().setCargo(null);
                    crp.getResponsavel().setDatHorAlteracao(null);
                    crp.getResponsavel().setDatHorCadastro(null);
                    crp.getResponsavel().setDatHorUltimoLogin(null);
                    crp.getResponsavel().setEmail(null);
                    crp.getResponsavel().setGrupos(null);
                    crp.getResponsavel().setId(null);
                    crp.getResponsavel().setIdPoderConcedente(null);
                    crp.getResponsavel().setIdUsuarioUpd(null);
                    crp.getResponsavel().setSubTipo(null);
                }
                if (crp.getIdRespAprovacaoCarta() != null) {
                    crp.setResponsavelAprovacaoCarta(this.segurancaService.getUsuarioById(crp.getIdRespAprovacaoCarta()));
                    crp.getResponsavelAprovacaoCarta().setTipo(null);
                    crp.getResponsavelAprovacaoCarta().setCargo(null);
                    crp.getResponsavelAprovacaoCarta().setDatHorAlteracao(null);
                    crp.getResponsavelAprovacaoCarta().setDatHorCadastro(null);
                    crp.getResponsavelAprovacaoCarta().setDatHorUltimoLogin(null);
                    crp.getResponsavelAprovacaoCarta().setEmail(null);
                    crp.getResponsavelAprovacaoCarta().setGrupos(null);
                    crp.getResponsavelAprovacaoCarta().setId(null);
                    crp.getResponsavelAprovacaoCarta().setIdPoderConcedente(null);
                    crp.getResponsavelAprovacaoCarta().setIdUsuarioUpd(null);
                    crp.getResponsavelAprovacaoCarta().setSubTipo(null);
                }
                if (crp.getIdEntidade() == null) continue;
                crp.setEntidade(this.cadastroService.getEntidadeById(crp.getIdEntidade()));
                crp.getEntidade().setBairro(null);
                crp.getEntidade().setCep(null);
                crp.getEntidade().setClassificacao(null);
                crp.getEntidade().setComplementoEndereco(null);
                crp.getEntidade().setDatHorAlteracao(null);
                crp.getEntidade().setDatHorCadastro(null);
                crp.getEntidade().setEmpresasEntidade(null);
                crp.getEntidade().setEndereco(null);
                crp.getEntidade().setIdCidade(null);
                crp.getEntidade().setSetores(null);
                crp.getEntidade().setNumeroEndereco(null);
                crp.getEntidade().setIdUsuarioUpd(null);
                crp.getEntidade().setIdUsuarioIns(null);
            }
            return new ResponseEntity((Object)correspDB, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCorrespondencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCorrespondencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}"})
    @Operation(summary="Retorna dados da correspond\u00eancia, de acordo com a Empresa e ID da Correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<CorrespondenciaMobileVO> getCorrespondencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getCorrespondencia... {}, {}", (Object)empresa, (Object)idCorrespondencia);
        try {
            List destinatarios;
            List historicos;
            List responsaveis;
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Correspondencia corresp = this.correspondenciaService.getCorrespondenciaById(idCorrespondencia, emp.getId());
            if (corresp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Correspond\u00eancia n\u00e3o encontrada.");
            }
            List anexos = this.correspondenciaService.findAnexos(idCorrespondencia, emp.getId());
            if (anexos != null) {
                corresp.setAnexos(anexos);
            }
            if ((responsaveis = this.correspondenciaService.findResponsaveis(idCorrespondencia, emp.getId())) != null) {
                corresp.setResponsaveis(responsaveis);
                for (CorrespondenciaResponsavel crr : responsaveis) {
                    crr.setAnexo(null);
                    crr.setCorrespondencia(null);
                }
            }
            if ((historicos = this.correspondenciaService.findHistoricos(idCorrespondencia, emp.getId())) != null) {
                corresp.setHistoricos(historicos);
            }
            if ((destinatarios = this.correspondenciaService.findDestinatarios(emp.getId(), idCorrespondencia)) != null) {
                corresp.setDestinatarios(destinatarios);
            }
            CorrespondenciaMobileVO correspVO = CorrespondenciaMobileVO.fromCorrespondencia((Correspondencia)corresp);
            return new ResponseEntity((Object)correspVO, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getCorrespondencia", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/registrar"})
    @Operation(summary="Salva a correspond\u00eancia, de acordo com a Empresa e ID da Correspond\u00eancia + Payload")
    @ResponseBody
    public ResponseEntity<CorrespondenciaPK> registrarCorrespondencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API registrarCorrespondencia...{}", (Object)empresa);
        try {
            Correspondencia correspondencia;
            String destinatariosTxt;
            String sessionId = request.getParameter("sessionId");
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            List destinatarios = null;
            if (formData.containsKey("destinatarios") && (destinatariosTxt = ((String[])formData.get("destinatarios"))[0]).length() > 0) {
                destinatarios = (List)mapper.readValue(destinatariosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            if ((correspondencia = (Correspondencia)mapper.readValue(((String[])formData.get("correspondencia"))[0], Correspondencia.class)).getId() == null) {
                correspondencia.setId(new CorrespondenciaPK());
            }
            List obrigacoes = null;
            List anexos = null;
            CorrespondenciaPK correspPK = this.correspondenciaService.createCorrespondencia(correspondencia, obrigacoes, anexos, destinatarios, usuario.getLogin(), request.getRemoteAddr(), sessionId);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap filesMap = multipartReq.getMultiFileMap();
            MultipartFile fileMap = null;
            if (filesMap != null) {
                for (String keySet : filesMap.keySet()) {
                    List filesList = (List)filesMap.get((Object)keySet);
                    if (filesList == null || filesList.size() <= 0) continue;
                    fileMap = (MultipartFile)filesList.get(0);
                    break;
                }
            }
            if (fileMap != null) {
                CorrespondenciaAnexo anexo = new CorrespondenciaAnexo();
                anexo.setTipoAnexo(TipoAnexoCorrespondencia.TIPO_OFICIO.getCode());
                anexo.getId().setIdEmpresa(correspPK.getIdEmpresa());
                anexo.getId().setIdCorrespondencia(correspPK.getIdCorrespondencia());
                anexo.setDatHorCadastro(LocalDateTime.now());
                anexo.setIdUsuarioIns(usuario.getId());
                String nomeAnexo = fileMap.getOriginalFilename();
                if (nomeAnexo.length() > 80) {
                    nomeAnexo = nomeAnexo.substring(nomeAnexo.length() - 80, nomeAnexo.length());
                }
                UploadedFileInfo fileInfo = new UploadedFileInfo(fileMap.getOriginalFilename(), fileMap.getContentType(), Long.valueOf(fileMap.getSize()), fileMap.getInputStream());
                this.correspondenciaService.registraUploadAnexo(anexo, fileInfo, correspondencia.getIdArea(), usuario.getId());
                this.correspondenciaService.saveAnexo(anexo, correspondencia, usuario.getId());
            }
            return new ResponseEntity((Object)correspPK, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarCorrespondencia", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarCorrespondencia", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("IoExc.registrarCorrespondencia", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/aprovar"})
    @Operation(summary="Executa a aprova\u00e7\u00e3o da correspond\u00eancia, de acordo com o Identificador da Empresa e Correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<String> aprovarCorrespondencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("API aprovarCorrespondencia...{}, {}", (Object)empresa, (Object)idCorrespondencia);
        try {
            String requestAddr = request.getRemoteAddr();
            if (requestAddr == null) {
                requestAddr = "127.0.0.1";
            }
            String motivo = null;
            Integer seqAnexo = null;
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.correspondenciaService.aprovarCorrespondencia(emp.getId(), idCorrespondencia, usr.getId(), motivo, seqAnexo, requestAddr);
            return new ResponseEntity((Object)"Correspond\u00eancia aprovada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/integracao/{empresa}/{sistema}/{chaveIntegracao}"})
    @Operation(summary="Consulta as correspond\u00eancias que sejam do tipo Integra\u00e7\u00e3o Externa e do sistema definido")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaMobileVO>> searchIntegracoes(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="sistema") String sistema, @PathVariable(name="chaveIntegracao") String chaveIntegracao, @RequestParam(name="search", required=false) String search, @RequestParam(name="dataInicial", required=false) Date dataInicial, @RequestParam(name="dataFinal", required=false) Date dataFinal, @RequestParam(name="tipoCorrespondencia", required=false) String classeDocumento, @RequestParam(name="usuario", required=false) String nomeUsuario, @RequestParam(name="status", required=false) Integer status) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API searchIntegracoes (empresa={}, sistema={}, search={})...", new Object[]{empresa, sistema, search});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa '%s' n\u00e3o encontrada", empresa));
            }
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            ArrayList<Integer> statusCorresp = null;
            if (status != null) {
                statusCorresp = new ArrayList<Integer>();
                statusCorresp.add(status);
            }
            boolean tipoData = false;
            List correspDB = this.correspondenciaService.findIntegracoesCorrespondencias(empresasInt, sistema, chaveIntegracao, search, classeDocumento, statusCorresp, dataInicial, dataFinal, Integer.valueOf(0), nomeUsuario);
            ArrayList<CorrespondenciaMobileVO> correspsVO = new ArrayList<CorrespondenciaMobileVO>();
            for (Correspondencia corresp : correspDB) {
                correspsVO.add(CorrespondenciaMobileVO.fromCorrespondencia((Correspondencia)corresp));
            }
            return new ResponseEntity(correspsVO, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/resumo"})
    @Operation(summary="Consulta as correspond\u00eancias que sejam do tipo Integra\u00e7\u00e3o Externa e do sistema definido")
    @ResponseBody
    public ResponseEntity<List<String>> resumoPeriodos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="ano") Integer ano) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API resumoPeriodos (empresa={}, ano={})...", (Object)empresa, (Object)ano);
        try {
            List resumo = this.correspondenciaService.findResumoPeriodos(empresa, ano);
            return new ResponseEntity((Object)resumo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("resumoPeriodos.resumoPeriodos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.resumoPeriodos", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/referencias"})
    @Operation(summary="Consulta a \u00e1rvore das refer\u00eancias da correspond\u00eancias")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaReferencia>> findReferencias(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findReferencias (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List referencias = this.correspondenciaService.findReferenciasByCorrespondencia(emp.getId(), idCorrespondencia);
            return new ResponseEntity((Object)referencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.findReferencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findReferencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/referenciasCruzadas"})
    @Operation(summary="Consulta as refer\u00eancias cruzadas de correspond\u00eancias")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaReferencia>> findReferenciasCruzadas(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API resumoPeriodos (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List referencias = this.correspondenciaService.findReferenciasCruzadas(emp.getId(), idCorrespondencia);
            return new ResponseEntity((Object)referencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findReferencias.findReferenciasCruzadas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findReferenciasCruzadas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/referencias"})
    @Operation(summary="Salva a refer\u00eancia de correspond\u00eancia")
    public ResponseEntity<Boolean> saveRefer\u00eancias(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody Correspondencia referencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveRefer\u00eancias({}, {})", (Object)empresa, (Object)referencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.associarCorrespondencia(emp.getId(), idCorrespondencia, referencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRefer\u00eancias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/referencias/{sequencia}"})
    @Operation(summary="Deleta a refer\u00eancia de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteReferencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteReferencia({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            this.correspondenciaService.deleteReferencia(idCorrespondencia, emp.getId(), sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteReferencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/{idCondicionante}/relacoesCondicionante"})
    @Operation(summary="Consulta as rela\u00e7\u00f5es de condicionante relacionadas \u00e0 correspond\u00eancias")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaRelacao>> findRelacoesCondicionante(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idCondicionante") Integer idCondicionante) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API relacoesCondicionante (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List relacoes = this.correspondenciaService.findRelacoesByCondicionante(emp.getId(), idCorrespondencia, idCondicionante);
            return new ResponseEntity((Object)relacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findRelacoesCondicionante.findRelacoesCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findRelacoesCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/{idLicenca}/relacoesLicenca"})
    @Operation(summary="Consulta as rela\u00e7\u00f5es de licen\u00e7as relacionadas \u00e0 correspond\u00eancias")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaRelacao>> findRelacoesLicenca(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idLicenca") Integer idLicenca) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findRelacoesLicenca (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List relacoes = this.correspondenciaService.findRelacoesByLicenca(emp.getId(), idCorrespondencia, idLicenca);
            return new ResponseEntity((Object)relacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findRelacoesLicenca.findRelacoesLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findRelacoesLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/relacoes"})
    @Operation(summary="Lista as rela\u00e7\u00f5es da Correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaRelacao>> findRelacoes(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findRelacoes (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List relacoes = this.correspondenciaService.findRelacoesByCorrespondencia(emp.getId(), idCorrespondencia);
            return new ResponseEntity((Object)relacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findRelacoesCorrespondencia.findRelacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findRelacoes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/relacoes/{sequencia}"})
    @Operation(summary="Busca a rela\u00e7\u00e3o de correspond\u00eancia conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<CorrespondenciaRelacao> getRelacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getRelacao (empresa={}, idCorrespondencia={})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaRelacao relacoes = this.correspondenciaService.getRelacaoById(emp.getId(), idCorrespondencia, sequencia);
            return new ResponseEntity((Object)relacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findRelacoesLicenca.getRelacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getRelacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/relacoes"})
    @Operation(summary="Salva a rela\u00e7\u00e3o de correspond\u00eancia")
    public ResponseEntity<CorrespondenciaRelacao> saveRelacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaRelacao relacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveRelacoes({})", (Object)relacao);
            return new ResponseEntity((Object)this.correspondenciaService.saveRelacao(relacao, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRelacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/relacoes/{sequencia}"})
    @Operation(summary="Deleta a rela\u00e7\u00e3o de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteRelacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteRelacao({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            this.correspondenciaService.deleteRelacao(emp.getId(), idCorrespondencia, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRelacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/{idModeloNumeracao}/numerosMinuta"})
    @Operation(summary="Salva a o n\u00famero minuta de correspond\u00eancia")
    public ResponseEntity<String> saveNumeroMinuta(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idModeloNumeracao") Integer idModeloNumeracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveNumeroMinuta({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            Integer idArea = null;
            if (request.getParameter("idArea") != null) {
                idArea = Integer.valueOf(request.getParameter("idArea"));
            }
            return new ResponseEntity((Object)this.correspondenciaService.saveNumeroMinuta(idCorrespondencia, emp.getId(), usr.getId(), idModeloNumeracao, idArea), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveNumeroMinuta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/numerosMinuta"})
    @Operation(summary="Deleta o n\u00famero de minuta de acordo com seu ID.")
    public ResponseEntity<Correspondencia> removeNumeroMinuta(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteRelacao({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            String ipExterno = this.getIpExterno(request);
            return new ResponseEntity((Object)this.correspondenciaService.removeNumeroMinuta(idCorrespondencia, emp.getId(), usr.getId(), ipExterno), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.removeNumeroMinuta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/{idModeloNumeracao}/numerosProtocoloInterno"})
    @Operation(summary="Salva a o n\u00famero de protocolo interno de correspond\u00eancia")
    public ResponseEntity<CorrespondenciaNumero> saveNumeroProtocoloInterno(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idModeloNumeracao") Integer idModeloNumeracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveNumeroMinuta({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            Integer idArea = null;
            return new ResponseEntity((Object)this.correspondenciaService.gerarNumeroProtocoloInterno(idCorrespondencia, emp.getId(), usr.getId(), idModeloNumeracao, idArea), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveNumeroProtocoloInterno", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/numerosProtocoloInterno"})
    @Operation(summary="Deleta o n\u00famero de protocolo interno de acordo com seu ID.")
    public ResponseEntity<Correspondencia> removeNumeroProtocoloInterno(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("deleteRelacao({}, {})", (Object)empresa, (Object)idCorrespondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.removeNumeroProtocoloInterno(idCorrespondencia, emp.getId(), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.removeNumeroProtocoloInterno", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/{status}/reabrirAprovacao"})
    @Operation(summary="Reabre a aprova\u00e7\u00e3o da correspond\u00eancia")
    public ResponseEntity<Boolean> reabrirAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaResponsavel responsavel, @PathVariable(name="status") Integer status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("reabrirAprovacao({}, {})", (Object)empresa, (Object)responsavel);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            String ipExterno = this.getIpExterno(request);
            return new ResponseEntity((Object)this.correspondenciaService.reabrirAprovacao(responsavel, status, ipExterno), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reabrirAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/{status}/reabrirCorrespondencia"})
    @Operation(summary="Reabre correspond\u00eancia")
    public ResponseEntity<Boolean> reabrirCorrespondencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody Correspondencia correspondencia, @PathVariable(name="status") Integer status, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("reabrirCorrespondencia({}, {})", (Object)empresa, (Object)correspondencia);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            String ipExterno = this.getIpExterno(request);
            return new ResponseEntity((Object)this.correspondenciaService.executeReabertura(correspondencia, status, ipExterno), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reabrirCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/destinatarios"})
    @Operation(summary="Busca os destinat\u00e1rios conforme o identificador da correspond\u00eancia.")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaDestinatario>> findDestinatarios(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findDestinatarios (empresa={}, {})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List destinatarios = this.correspondenciaService.findDestinatarios(emp.getId(), idCorrespondencia);
            return new ResponseEntity((Object)destinatarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findDestinatarios.findDestinatarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findDestinatarios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/{tipo}/destinatarios"})
    @Operation(summary="Busca os destinat\u00e1rios conforme o identificador da correspond\u00eancia e do tipo.")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaDestinatario>> findDestinatariosByTipo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="tipo") Integer tipo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findDestinatariosByTipo (empresa={}, {})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List destinatarios = this.correspondenciaService.findDestinatariosByTipo(emp.getId(), idCorrespondencia, tipo);
            return new ResponseEntity((Object)destinatarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findDestinatariosByTipo.findDestinatariosByTipo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findDestinatariosByTipo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/destinatarios"})
    @Operation(summary="Salva os destinat\u00e1rios da correspond\u00eancia")
    public ResponseEntity<List<CorrespondenciaDestinatario>> saveDestinatarios(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody List<CorrespondenciaDestinatario> destinatarios, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveDestinatarios(sz={})", (Object)usuario.getLogin(), (Object)destinatarios.size());
            return new ResponseEntity((Object)this.correspondenciaService.saveDestinatarios(destinatarios, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveDestinatarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/destinatarios/{sequencia}"})
    @Operation(summary="Busca o destinat\u00e1rio conforme seu identificador.")
    @ResponseBody
    public ResponseEntity<CorrespondenciaDestinatario> getDestinatarioById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API getDestinatarioById (idCorrespondencia={}, {}, {}", new Object[]{idCorrespondencia, empresa, sequencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaDestinatario destinatario = this.correspondenciaService.getDestinatarioById(emp.getId(), idCorrespondencia, sequencia);
            return new ResponseEntity((Object)destinatario, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getDestinatarioById.getDestinatarioById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getDestinatarioById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/anexos"})
    @Operation(summary="Retorna os anexos da Correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaAnexo>> findAnexos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findAnexos({}, {})", new Object[]{usuario.getLogin(), empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List anexosCorresp = this.correspondenciaService.findAnexos(idCorrespondencia, emp.getId());
            for (CorrespondenciaAnexo anexo : anexosCorresp) {
                anexo.setEmpresa(this.coreService.makeSafeEmpresa(anexo.getEmpresa()));
                anexo.setUsuario(this.segurancaService.makeSafeUsuario(anexo.getUsuario()));
                anexo.getAnexo().setUsuario(this.segurancaService.makeSafeUsuario(anexo.getUsuario()));
            }
            return new ResponseEntity((Object)anexosCorresp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getDestinatarioById.findAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findAnexos", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/anexos/{sequencia}"})
    @Operation(summary="Retorna o anexo da Correspond\u00eancia conforme sua sequ\u00eancia.")
    @ResponseBody
    public ResponseEntity<CorrespondenciaAnexo> getAnexoById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getAnexoById({}, {})", new Object[]{usuario.getLogin(), empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaAnexo anexo = this.correspondenciaService.getAnexoBySeq(idCorrespondencia, idCorrespondencia, sequencia);
            return new ResponseEntity((Object)anexo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getAnexoById.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getAnexoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/{idResponsavel}/{tipo}/anexosResponsavel"})
    @Operation(summary="Retorna o anexo da Correspond\u00eancia conforme seu respons\u00e1vel")
    @ResponseBody
    public ResponseEntity<CorrespondenciaAnexo> getAnexoByResponsavel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idResponsavel") Integer idResponsavel, @PathVariable(name="tipo") String tipo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getAnexoByResponsavel({}, {})", new Object[]{usuario.getLogin(), empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaAnexo anexo = this.correspondenciaService.getAnexoByResponsavel(idCorrespondencia, emp.getId(), idResponsavel, tipo);
            return new ResponseEntity((Object)anexo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getAnexoByResponsavel.getAnexoByResponsavel", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getAnexoById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/{tipo}/anexosTipo/{sequencia}"})
    @Operation(summary="Retorna o anexo da Correspond\u00eancia conforme seu tipo")
    @ResponseBody
    public ResponseEntity<CorrespondenciaAnexo> getAnexoByTipo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="tipo") String tipo, @PathVariable(name="sequencia") Integer sequencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getAnexoByTipo({}, {})", new Object[]{usuario.getLogin(), empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaAnexo anexo = this.correspondenciaService.getAnexoByTipo(idCorrespondencia, emp.getId(), tipo, sequencia);
            return new ResponseEntity((Object)anexo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getAnexoByTipo.getAnexoByTipo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getAnexoByTipo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAssinatura}/anexosAssinatura"})
    @Operation(summary="Retorna o anexo da Correspond\u00eancia conforme sua assinatura")
    @ResponseBody
    public ResponseEntity<CorrespondenciaAnexo> getAnexoByAssinatura(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idAssinatura") Integer idAssinatura) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - getAnexoByAssinatura({}, {})", new Object[]{usuario.getLogin(), empresa, idAssinatura});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaAnexo anexo = this.correspondenciaService.getAnexoCorrespondenciaByAssinatura(idAssinatura, emp.getId());
            return new ResponseEntity((Object)anexo, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getAnexoByAssinatura.getAnexoByAssinatura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getAnexoByAssinatura", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idCorrespondencia}/anexos/{tipoAnexo}"})
    @Operation(summary="Salva o anexo de correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<CorrespondenciaAnexo> saveAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="tipoAnexo") String tipoAnexo, @RequestParam(name="file", required=false) MultipartFile file, HttpServletRequest request) throws BusinessException, IOException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
        }
        try {
            logger.debug("saveAnexos(emp={}, idCorresp={})", (Object)empresa, (Object)idCorrespondencia);
            String descricao = null;
            String hierarquia = null;
            String moduloItem = null;
            Correspondencia correspondencia = this.correspondenciaService.getCorrespondenciaById(idCorrespondencia, emp.getId());
            if (request.getParameter("descricao") != null) {
                descricao = request.getParameter("descricao");
            }
            if (descricao == null) {
                descricao = "Anexos das Correspond\u00eancias";
            }
            if (request.getParameter("hierarquia") != null) {
                hierarquia = request.getParameter("hierarquia");
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            moduloItem = TipoAnexoCorrespondencia.fromString((String)tipoAnexo).getSigla();
            Anexo anxGed = this.gedService.createAnexo(emp.getId(), "CRP", moduloItem, descricao, hierarquia, null, null, fileInfo, usr.getId(), LocalDateTime.now(), null, Integer.valueOf(1));
            CorrespondenciaAnexo anexo = new CorrespondenciaAnexo();
            anexo.getId().setIdEmpresa(emp.getId());
            anexo.setIdAnexo(anxGed.getId().getIdAnexo());
            anexo.setTipoAnexo(tipoAnexo);
            anexo.setAnexo(anxGed);
            return new ResponseEntity((Object)this.correspondenciaService.saveAnexo(anexo, correspondencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/anexos/{sequencia}"})
    @Operation(summary="Deleta o anexo de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteAnexo({}, {}, {})", new Object[]{sequencia, empresa, idCorrespondencia});
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            this.correspondenciaService.removeAnexo(idCorrespondencia, emp.getId(), sequencia, usuario.getId(), request.getLocalAddr());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/historicoAtividades"})
    @Operation(summary="Retorna o hist\u00f3rico da Correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaHistorico>> findHistoricos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findHistoricos({}, {})", new Object[]{usuario.getLogin(), empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List historicos = this.correspondenciaService.findHistoricos(idCorrespondencia, emp.getId());
            for (CorrespondenciaHistorico hist : historicos) {
                hist.setUsuario(this.segurancaService.makeSafeUsuario(hist.getUsuario()));
            }
            return new ResponseEntity((Object)historicos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("getDestinatarioById.findHistoricos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findHistoricos", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/destinatarios/{sequencia}"})
    @Operation(summary="Deleta o destinat\u00e1rio de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteDestinatario(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteDestinatario({}, {}, {})", new Object[]{sequencia, empresa, idCorrespondencia});
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            this.correspondenciaService.removeDestinatario(emp.getId(), idCorrespondencia, sequencia);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteDestinatario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/executePostagem"})
    @Operation(summary="Executa a postagem da correspond\u00eancia")
    public ResponseEntity<Boolean> executePostagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("executePostagem({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.executePostagem(emp.getId(), idCorrespondencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.executePostagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/prorrogarPrazo/{seqPrazo}"})
    @Operation(summary="Executa a prorroga\u00e7\u00e3o de correspond\u00eancia")
    public ResponseEntity<Boolean> prorrogarPrazo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaProrrogacao correspondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("prorrogarPrazo({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.prorrogarPrazo(emp.getId(), idCorrespondencia, correspondencia.getTipo(), correspondencia.getDias(), correspondencia.getData(), correspondencia.getMotivo(), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.prorrogarPrazo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/aprovarProrrogacaoPrazo/{aprovarReprovar}"})
    @Operation(summary="Executa a prorroga\u00e7\u00e3o de correspond\u00eancia")
    public ResponseEntity<Boolean> aprovarProrrogacaoPrazo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="aprovarReprovar") Boolean aprovarReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("aprovarProrrogacaoPrazo({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            String motivoAprovarReprovar = request.getParameter("motivoAprovarReprovar");
            return new ResponseEntity((Object)this.correspondenciaService.aprovarProrrogacaoPrazo(emp.getId(), idCorrespondencia, aprovarReprovar, motivoAprovarReprovar, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.aprovarProrrogacaoPrazo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/modificarFluxoAprovacao"})
    @Operation(summary="Modifica o fluxo de aprova\u00e7\u00e3o relacionado \u00e0 correspond\u00eancia")
    public ResponseEntity<Boolean> modificarFluxoAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("modificarFluxoAprovacao({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.modificarFluxoAprovacao(emp.getId(), idCorrespondencia, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.modificarFluxoAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/revisarCorrespondencia"})
    @Operation(summary="Revisa a correspond\u00eancia.")
    public ResponseEntity<Boolean> revisarCorrespondencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("revisarCorrespondencia({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.revisarCorrespondencia(emp.getId(), idCorrespondencia, usr.getId(), request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.revisarCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/reprovarCorrespondencia"})
    @Operation(summary="Reprova a correspond\u00eancia.")
    public ResponseEntity<Boolean> reprovarCorrespondencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("reprovarCorrespondencia({}, {})", (Object)idCorrespondencia, (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            Map params = request.getParameterMap();
            String motivo = request.getParameter("motivo");
            Integer seqAnexo = null;
            if (params.containsKey("seqAnexo")) {
                seqAnexo = Integer.valueOf(((String[])params.get("seqAnexo"))[0]);
            }
            return new ResponseEntity((Object)this.correspondenciaService.reprovarCorrespondencia(emp.getId(), idCorrespondencia, motivo, usr.getId(), seqAnexo, request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reprovarCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/cancelarAprovacao"})
    @Operation(summary="Cancela a aprova\u00e7\u00e3o do respons\u00e1vel da correspond\u00eancia.")
    @ResponseBody
    public ResponseEntity<Boolean> cancelarAprovacaoCorrespondencia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaResponsavel correspondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API cancelarAprovacaoCorrespondencia...{}", (Object)empresa);
        try {
            return new ResponseEntity((Object)this.correspondenciaService.cancelarAprovacaoCorrespondencia(correspondencia), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.cancelarAprovacaoCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/executeProtocolar"})
    @Operation(summary="Executa o protocolo da correspond\u00eancia")
    public ResponseEntity<Boolean> executeProtocolar(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody Correspondencia correspondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("executeProtocolar({})", (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.executeProtocolar(correspondencia, usr.getId(), request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.executeProtocolar", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/executeEncerrar"})
    @Operation(summary="Executa o encerramento da correspond\u00eancia")
    public ResponseEntity<Boolean> executeEncerrar(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody Correspondencia correspondencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("executeProtocolar({})", (Object)empresa);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            return new ResponseEntity((Object)this.correspondenciaService.executeEncerrar(correspondencia, usr.getId(), request.getLocalAddr()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.executeEncerrar", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/tiposProtocolo"})
    @Operation(summary="Salva o tipo de protocolo relacionado \u00e0 correspond\u00eancia")
    public ResponseEntity<Boolean> saveTipoProtocolo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaMobileVO filtro, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveTipoProtocolo({}, {})", (Object)empresa, (Object)idCorrespondencia);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.correspondenciaService.saveTipoProtocolo(emp.getId(), idCorrespondencia, filtro.getIdTipoProtocolo(), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoProtocolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/tiposCorrespondencia"})
    @Operation(summary="Salva o tipo de correspond\u00eancia relacionado \u00e0 correspond\u00eancia")
    public ResponseEntity<Boolean> saveTipoCorrespondencia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaMobileVO filtro, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveTipoProtocolo({}, {})", (Object)empresa, (Object)idCorrespondencia);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.correspondenciaService.saveCorrespondenciaTipo(idCorrespondencia, emp.getId(), filtro.getTipoCorrespondencia().getId().getIdTipoDocumento(), usr.getId(), request.getLocalAddr(), request.getRequestedSessionId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoCorrespondencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCorrespondencia}/responsaveisAprovacao"})
    @Operation(summary="Busca os respons\u00e1veis de aprova\u00e7\u00e3o conforme o identificador da correspond\u00eancia.")
    @ResponseBody
    public ResponseEntity<List<CorrespondenciaResponsavel>> findResponsaveisAprovacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findResponsaveisAprovacao (empresa={}, {})...", (Object)empresa, (Object)idCorrespondencia);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List responsaveis = this.correspondenciaService.findResponsaveis(idCorrespondencia, emp.getId());
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findDestinatarios.findResponsaveisAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findResponsaveisAprovacao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/responsaveisAprovacao"})
    @Operation(summary="Salva os respons\u00e1veis de aprova\u00e7\u00e3o da correspond\u00eancia")
    public ResponseEntity<CorrespondenciaResponsavel> saveResponsaveisAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @RequestBody CorrespondenciaResponsavel responsavel, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveResponsaveisAprovacao({}, {})", (Object)empresa, (Object)responsavel);
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            Correspondencia correspondencia = this.correspondenciaService.getCorrespondenciaById(responsavel.getId().getIdCorrespondencia(), emp.getId());
            return new ResponseEntity((Object)this.correspondenciaService.saveResponsavel(correspondencia, responsavel, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveResponsaveisAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idCorrespondencia}/responsaveisAprovacao/{sequencia}"})
    @Operation(summary="Deleta o respons\u00e1vel de aprova\u00e7\u00e3o de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteResponsavelAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteDestinatario({}, {}, {})", new Object[]{empresa, idCorrespondencia, sequencia});
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            CorrespondenciaResponsavel responsavel = this.correspondenciaService.getResponsavelById(emp.getId(), idCorrespondencia, sequencia);
            if (responsavel == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Respons\u00e1vel n\u00e3o encontrado", new Object[0]));
            }
            this.correspondenciaService.deleteResponsavel(emp.getId(), idCorrespondencia, sequencia, usuario.getId(), responsavel.getResponsavel().getNome());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteResponsavelAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCorrespondencia}/responsavelResposta/{idUsuarioResposta}"})
    @Operation(summary="Salva o respons\u00e1vel da resposta na correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<Boolean> saveResponsavelResposta(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCorrespondencia") Integer idCorrespondencia, @PathVariable(name="idUsuarioResposta") Integer idUsuarioResposta) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Integer idAreaResposta = null;
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        logger.debug("API saveResponsavelResposta...{}, {}, {}", new Object[]{empresa, idCorrespondencia, idUsuarioResposta});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            this.correspondenciaService.saveResponsavelResposta(emp.getId(), idCorrespondencia, idAreaResposta, idUsuarioResposta, usr.getId());
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveResponsavelResposta", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/resumos"})
    @Operation(summary="Salva o respons\u00e1vel da resposta na correspond\u00eancia")
    @ResponseBody
    public ResponseEntity<Integer> fillResumoCorrespondencias(HttpServletRequest request) {
        logger.debug("API fillResumoCorrespondencias..");
        try {
            return new ResponseEntity((Object)this.correspondenciaService.fillResumoCorrespondencias(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.fillResumoCorrespondencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download do relat\u00f3rio em Excel")
    public ResponseEntity<StreamingResponseBody> exportaCorrespExcel(@PathVariable(name="empresa") String empresa, @RequestBody FiltroCorrespondenciaVO filtroCorresp, HttpServletRequest request) {
        logger.debug("Exportando excel, corresp (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.coreService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroCorresp == null) {
            filtroCorresp = new FiltroCorrespondenciaVO();
        }
        ArrayList<Integer> selectedEmp = new ArrayList<Integer>();
        selectedEmp.add(emp.getId());
        String search = null;
        String param = request.getParameter("search");
        if (param != null && !param.isEmpty()) {
            search = param;
        }
        List<Integer> statusConcluidas = List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5));
        LocalDate dataInicial = filtroCorresp.getDatInicial();
        LocalDate dataFinal = filtroCorresp.getDatFinal();
        try {
            List corresp = this.correspondenciaService.findCorrespondencias(selectedEmp, search, null, null, null, null, statusConcluidas, null, dataInicial, dataFinal, null, null, null, null, null, null, null, null, null, null, null, null, Integer.valueOf(1));
            FiltroCorrespondenciaVO finalFiltroCorresp = filtroCorresp;
            StreamingResponseBody responseBody = response -> response.write(new RelatorioRetoffExcel().executeXLS(corresp, finalFiltroCorresp.getDatInicial(), finalFiltroCorresp.getDatFinal()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"Relat\u00f3rio de Correspond\u00eancias RETOFF.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/anexos/metadata"})
    @Operation(summary="Atualiza os metadados processados previamente (Tika)")
    @ResponseBody
    public ResponseEntity<Integer> findAnexos(@RequestBody AnexoConteudo conteudo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.correspondenciaService.updateMetadata(conteudo.getId().getIdEmpresa(), conteudo.getId().getIdAnexo()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/downloads/minutas/{empresa}/{idCorrespondencia}"})
    @Operation(summary="Retorna os anexos da Correspond\u00c3\u00aancia conforme seu n\u00c3\u00bamero, no formato SiglaEmpresa + ID (Ex: OTISW 24120001). Ser\u00c3\u00a1 retornado a minuta, se houver, ou of\u00c3\u00adcio se n\u00c3\u00a3o tiver minuta ou o protocolo de entrada , sen\u00c3\u00a3o tiver oficio ou anexo gen\u00c3\u00a9rico se n\u00c3\u00a3o tiver nenhum outro. ")
    @ResponseBody
    public ResponseEntity<Object> getAnexoMinutaByNumero(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idCorrespondencia) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        logger.debug("{} - getAnexosByNumero({}, {})", new Object[]{usuario != null ? usuario.getLogin() : "guest", empresa, idCorrespondencia});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00c3\u00a3o foi encontrada.", empresa));
            }
            List anexos = this.correspondenciaService.findAnexos(idCorrespondencia, emp.getId());
            HashMap<String, Anexo> anexosMap = new HashMap<String, Anexo>();
            for (CorrespondenciaAnexo anexo : anexos) {
                if (anexosMap.containsKey(anexo.getTipoAnexo())) continue;
                anexosMap.put(anexo.getTipoAnexo(), anexo.getAnexo());
            }
            Anexo anexoGed = null;
            if (anexosMap.containsKey(TipoAnexoCorrespondencia.TIPO_CARTA_RESPOSTA.getCode())) {
                anexoGed = (Anexo)anexosMap.get(TipoAnexoCorrespondencia.TIPO_CARTA_RESPOSTA.getCode());
            } else if (anexosMap.containsKey(TipoAnexoCorrespondencia.TIPO_OFICIO.getCode())) {
                anexoGed = (Anexo)anexosMap.get(TipoAnexoCorrespondencia.TIPO_OFICIO.getCode());
            } else if (anexosMap.containsKey(TipoAnexoCorrespondencia.TIPO_PROTOCOLO_ENTRADA.getCode())) {
                anexoGed = (Anexo)anexosMap.get(TipoAnexoCorrespondencia.TIPO_PROTOCOLO_ENTRADA.getCode());
            } else if (anexosMap.containsKey(TipoAnexoCorrespondencia.TIPO_ANEXO.getCode())) {
                anexoGed = (Anexo)anexosMap.get(TipoAnexoCorrespondencia.TIPO_ANEXO.getCode());
            }
            if (anexoGed != null) {
                UploadedFileInfo gedFileInfo = this.gedService.getFileInfoByUuid(emp.getId(), anexoGed.getUuid(), Boolean.valueOf(false));
                if (gedFileInfo == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Anexo n\u00c3\u00a3o foi encontrado no reposit\u00c3\u00b3rio.");
                }
                byte[] bytes = this.gedService.getFileBytesByUUID(emp.getId(), anexoGed.getUuid(), null);
                if (bytes == null || bytes.length == 0) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo encontrado, mas conte\u00c3\u00bado vazio/corrompido.");
                }
                HttpHeaders headers = new HttpHeaders();
                headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                headers.add("Content-Type", gedFileInfo.getContentType());
                if (anexoGed.isUploadImage().booleanValue() || anexoGed.isUploadPdf().booleanValue()) {
                    headers.add("Content-Disposition", "inline");
                } else {
                    headers.add("Content-Disposition", "attachment; filename=\"" + gedFileInfo.getFileName() + "\"");
                }
                headers.add("Pragma", "no-cache");
                headers.add("Expires", "0");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(gedFileInfo.getSize().longValue()).body((Object)new ByteArrayResource(bytes));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Anexo do tipo minuta n\u00c3\u00a3o foi encontrado.");
        }
        catch (BusinessException bizExc) {
            logger.error("getAnexoByTipo.getAnexoMinutaByNumero", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.getAnexoMinutaByNumero", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/analises"})
    @Operation(summary="Consulta as correspond\u00c3\u00aancias, de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<Page<Correspondencia>> findAnalisesCorrespondencias(HttpServletRequest request, @RequestParam(name="empresas", required=false) List<String> empresas, @RequestParam(name="search", required=false) String search, @RequestParam(name="tipoCorrespondencia", required=false) String classeDocumento, @RequestParam(name="processo", required=false) String processo, @RequestParam(name="protocolo", required=false) String protocolo, @RequestParam(name="documento", required=false) String documento, @RequestParam(name="pleito", required=false) Integer idPleito, @RequestParam(name="usuario", required=false) String nomeUsuario, @RequestParam(name="status", required=false) Integer[] status, @RequestParam(name="entidade", required=false) String entidade, @RequestParam(name="nroCartaIdCorresp", required=false) String nroCartaIdCorresp, @RequestParam(name="protocoloInterno", required=false) String protocoloInterno, @RequestParam(name="idTema", required=false) Integer idTema) {
        logger.debug("API findAnalisesCorrespondencias (search={})...", (Object)search);
        try {
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            if (empresas != null && !empresas.isEmpty()) {
                for (String empItem : empresas) {
                    Empresa emp = this.coreService.getEmpresaBySigla(empItem);
                    if (emp == null) continue;
                    empresasInt.add(emp.getId());
                }
            }
            ArrayList<Integer> statusCorresp = null;
            Entidade ent = new Entidade();
            Map params = request.getParameterMap();
            LocalDate dataInicial = null;
            if (params.containsKey("dataInicial")) {
                dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
            }
            LocalDate dataFinal = null;
            if (params.containsKey("dataFinal")) {
                dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
            }
            if (status != null) {
                statusCorresp = new ArrayList<Integer>();
                for (Integer item : status) {
                    statusCorresp.add(item);
                }
            }
            if (entidade != null) {
                ent = this.cadastroService.getEntidadeByNome(entidade);
            }
            boolean tipoData = false;
            Integer idObra = null;
            List prazos = null;
            Integer idFornecedor = null;
            Integer pageNbr = 0;
            if (params.containsKey("pageNumber")) {
                pageNbr = Integer.valueOf(((String[])params.get("pageNumber"))[0]);
            }
            Integer pageSize = 15;
            if (params.containsKey("pageSize")) {
                pageSize = Integer.valueOf(((String[])params.get("pageSize"))[0]);
            }
            int offset = pageNbr * pageSize;
            String sortFields = null;
            Page correspDB = this.correspondenciaService.findCorrespondenciasFullText(empresasInt, search, null, classeDocumento, null, processo, idPleito, statusCorresp, null, dataInicial, dataFinal, prazos, Integer.valueOf(0), nroCartaIdCorresp, nomeUsuario, null, null, null, ent.getId(), Boolean.valueOf(false), idObra, null, null, null, documento, protocolo, protocoloInterno, idTema, idFornecedor, Integer.valueOf(offset), pageSize, sortFields);
            return new ResponseEntity((Object)correspDB, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCorrespondencias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findCorrespondencias", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

