/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.ObrigacaoContratual;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para obriga\u00e7\u00f5es", name="obrigacoes")
@RequestMapping(value={"/api/obrigacoes"})
public class ObrigacoesRestServices
extends BaseRestService {
    private static final Logger logger = LoggerFactory.getLogger(ObrigacoesRestServices.class);
    private static final DateTimeFormatter dataFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    private CoreService coreService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista as obriga\u00e7\u00f5es de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<ObrigacaoLancamento>> findObrigacoes(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API search (empresa={}, search={})...", (Object)empresa, (Object)search);
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            Integer idClassificacao = null;
            String parmTxt = request.getParameter("idClassificacao");
            if (parmTxt != null && !parmTxt.isEmpty()) {
                idClassificacao = Integer.valueOf(request.getParameter("idClassificacao"));
            }
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            parmTxt = request.getParameter("datInicial");
            if (parmTxt != null && !parmTxt.isEmpty()) {
                dataInicial = LocalDate.parse(parmTxt, dataFmt);
            }
            if ((parmTxt = request.getParameter("datFinal")) != null && !parmTxt.isEmpty()) {
                dataFinal = LocalDate.parse(parmTxt, dataFmt);
            }
            Integer status = null;
            parmTxt = request.getParameter("status");
            if (parmTxt != null && !parmTxt.isEmpty()) {
                status = Integer.valueOf(request.getParameter("status"));
            }
            String nroCarta = null;
            parmTxt = request.getParameter("nroCarta");
            if (parmTxt != null && !parmTxt.isEmpty()) {
                nroCarta = request.getParameter("nroCarta");
            }
            String respEntrega = null;
            parmTxt = request.getParameter("responsavelEntrega");
            if (parmTxt != null && !parmTxt.isEmpty()) {
                respEntrega = request.getParameter("responsavelEntrega");
            }
            List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, search, null, idClassificacao, status, null, null, dataInicial, dataFinal, null, nroCarta, respEntrega, Boolean.valueOf(true), Boolean.valueOf(true));
            for (ObrigacaoLancamento lcto : obrigacoesDB) {
                ObrigacaoContratual obriga = lcto.getObrigacao();
                ObrigacaoContratual obrigaBase = new ObrigacaoContratual();
                obrigaBase.setNome(obriga.getNome());
                obrigaBase.setPeriodicidade(obriga.getPeriodicidade());
                lcto.setObrigacao(obrigaBase);
            }
            return new ResponseEntity((Object)obrigacoesDB, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findObrigacoesContratuais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findObrigacoesContratuais", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}"})
    @Operation(summary="Exibe os detalhes do lan\u00e7amento da obriga\u00e7\u00e3o de acordo com a chave (Empresa, ID Obriga\u00e7\u00e3o e Sequencia)")
    @ResponseBody
    public ResponseEntity<ObrigacaoLancamento> getLancamentoObrigacao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idObrigacao") Integer idObrigacao, @PathVariable(name="seqLancamento") Integer seqLancamento) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - Executando getLancamentoObrigacao(emp={},idObrigacao={},seqLancamento={})...", new Object[]{usuario.getLogin(), empresa, idObrigacao, seqLancamento});
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            ObrigacaoLancamento obrigacaoLcto = this.obrigacaoService.getLancamentoById(emp.getId(), idObrigacao, seqLancamento);
            List responsaveis = this.obrigacaoService.findResponsaveisLancamento(emp.getId(), idObrigacao, seqLancamento);
            List anexos = this.obrigacaoService.findAnexos(emp.getId(), idObrigacao, seqLancamento);
            obrigacaoLcto.setResponsaveis(responsaveis);
            obrigacaoLcto.setAnexos(anexos);
            return new ResponseEntity((Object)obrigacaoLcto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Cria uma nova obriga\u00e7\u00e3o, com seus par\u00e2metros e/ou Anexos enviados")
    @ResponseBody
    public ResponseEntity<ObrigacaoContratual> createUpdateObrigacao(@PathVariable(name="empresa") String empresa, @RequestBody ObrigacaoContratual obrigacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            obrigacao.getId().setIdEmpresa(emp.getId());
            ObrigacaoContratual saved = this.obrigacaoService.save(obrigacao, null, null, usr.getId());
            return new ResponseEntity((Object)saved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idObrigacao}/lancamentos"})
    public ResponseEntity<ObrigacaoLancamento> saveLancamento(@PathVariable String empresa, @PathVariable Integer idObrigacao, @RequestBody ObrigacaoLancamento lancamento, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("{} - saveLancamento({})", (Object)usuario.getLogin(), (Object)empresa);
            ObrigacaoLancamento lcto = this.obrigacaoService.saveLancamento(lancamento, usuario.getId());
            return new ResponseEntity((Object)lcto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}"})
    @Operation(summary="Exclui uma obriga\u00e7\u00e3o atrav\u00e9s de seu identificador")
    public ResponseEntity<String> deleteObrigacao(@PathVariable String empresa, @PathVariable Integer idObrigacao) {
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            this.obrigacaoService.delete(emp.getId(), idObrigacao);
            return new ResponseEntity((Object)"Exclus\u00e3o realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idObrigacao}/lancamentos/{seqLancamento}"})
    @Operation(summary="Exclui o lan\u00e7amento de uma obriga\u00e7\u00e3o atrav\u00e9s de seu ID")
    public ResponseEntity<String> deleteLancamentoObrigacao(@PathVariable String empresa, @PathVariable Integer idObrigacao, @PathVariable Integer seqLancamento) {
        try {
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            this.obrigacaoService.deleteLancamento(emp.getId(), idObrigacao, seqLancamento);
            return new ResponseEntity((Object)"Exclus\u00e3o do lan\u00e7amento realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteLancamentoObrigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

