/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared.v1;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geo.MapaKmlData;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.TrechoSegmento;
import br.com.oti.gesconsys.beans.notificacoes.Notificacao;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.CoordenadaMapaVO;
import br.com.oti.gesconsys.beans.shared.Demanda;
import br.com.oti.gesconsys.beans.shared.NotificacaoRodovia;
import br.com.oti.gesconsys.beans.shared.Obra;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.demanda.DemandaDAO;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.DemandaService;
import br.com.oti.gesconsys.business.services.NotificacaoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.shared.MapasRestServices;
import br.com.oti.gesconsys.utils.Coordenada;
import br.com.oti.gesconsys.utils.GeoUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@RestController
@Tag(description="REST Services para Mapas", name="shared")
@RequestMapping(value={"/api/v1/mapas"})
public class MapasRestServicesV1
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(MapasRestServices.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private DemandaService demandaService;
    @Autowired
    private NotificacaoService notificacaoService;
    @Autowired
    private DemandaDAO demandaDAO;

    @GetMapping(value={"/{empresa}/{modulo}/{item}"})
    @Operation(summary="Retorna o mapa conforme Modulo e item")
    @ResponseBody
    public ResponseEntity<List<CoordenadaMapaVO>> fillMapa(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="item") String item, HttpServletRequest request) {
        logger.debug("FillMapa(emp={}, mld={}, ite={})...", new Object[]{empresa, modulo, item});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            ArrayList<String> empresas = new ArrayList<String>();
            String[] empresasArray = request.getParameterValues("empresas");
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresas.add(emp);
                }
            } else {
                empresas.add(empresa);
            }
            List mapa = this.fillCoordenadas(empresas, modulo, item, request);
            return ResponseEntity.ok().body((Object)mapa);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private List<CoordenadaMapaVO> fillCoordenadas(List<String> empresas, String modulo, String item, HttpServletRequest request) {
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        List empresasDB = this.coreService.findEmpresas(null, null);
        ArrayList<Integer> empresasInt = new ArrayList<Integer>();
        block6: for (Empresa empDB : empresasDB) {
            for (String emp : empresas) {
                if (!emp.equals(empDB.getSigla())) continue;
                empresasInt.add(empDB.getId());
                continue block6;
            }
        }
        if (modulo.equals(TipoModulo.DEMANDAS.getSigla())) {
            String titulo = request.getParameter("titulo");
            String tipoStr = request.getParameter("tipo");
            String areaStr = request.getParameter("area");
            String objetivoStr = request.getParameter("objetivo");
            String cidadeStr = request.getParameter("cidade");
            String trechoStr = request.getParameter("trecho");
            String statusStr = request.getParameter("status");
            String publicaStr = request.getParameter("publica");
            String dataInicialStr = request.getParameter("dataInicial");
            String dataFinalStr = request.getParameter("dataFinal");
            Integer tipo = tipoStr != null && !tipoStr.equals("0") ? Integer.valueOf(tipoStr) : null;
            Integer area = areaStr != null && !areaStr.equals("0") ? Integer.valueOf(areaStr) : null;
            Integer objetivo = objetivoStr != null && !objetivoStr.equals("0") ? Integer.valueOf(objetivoStr) : null;
            Integer cidade = cidadeStr != null && !cidadeStr.equals("0") ? Integer.valueOf(cidadeStr) : null;
            Integer trecho = trechoStr != null && !trechoStr.equals("0") ? Integer.valueOf(trechoStr) : null;
            Integer status = statusStr != null && !statusStr.equals("0") ? Integer.valueOf(statusStr) : null;
            Integer publica = publicaStr != null && !publicaStr.equals("-1") ? Integer.valueOf(publicaStr) : null;
            String param = request.getParameter("idDemanda");
            Integer idDemanda = null;
            if (param != null) {
                idDemanda = Integer.valueOf(param);
            }
            param = request.getParameter("versao");
            Integer versao = null;
            if (param != null) {
                versao = Integer.valueOf(param);
            }
            return this.fillCoordenadasDemandas(empresasInt, idDemanda, versao, titulo, tipo, area, objetivo, cidade, trecho, status, publica, dataInicialStr, dataFinalStr);
        }
        if (modulo.equals(TipoModulo.NOTIFICACOES.getSigla())) {
            return this.fillCoordenadasNotificacoes(empresasInt, request);
        }
        if (modulo.equals(TipoModulo.CADASTROS.getSigla()) && item.equalsIgnoreCase("OBRA")) {
            Integer tipoObra = null;
            Integer obra = null;
            ArrayList<String> statusObra = null;
            String parm = request.getParameter("tipoObra");
            if (parm != null) {
                tipoObra = Integer.valueOf(parm);
            }
            if ((parm = request.getParameter("obra")) != null) {
                obra = Integer.valueOf(parm);
            }
            if ((parm = request.getParameter("status")) != null) {
                statusObra = new ArrayList<String>();
                statusObra.add(parm);
            }
            Boolean northern = null;
            List obras = this.cadastroService.findObras((Integer)empresasInt.get(0), null, null, null, tipoObra, statusObra, null);
            for (Obra obr : obras) {
                Double coordY;
                Double coordX;
                String zonaCode;
                Integer zonaNbr;
                if (obr.getCoordenadaNorte() == null || obr.getCoordenadaLeste() == null) continue;
                Coordenada latLng = null;
                Coordenada latLngFim = null;
                if (obr.getZonaGeografica() != null && !obr.getZonaGeografica().isEmpty()) {
                    try {
                        zonaNbr = Integer.valueOf(obr.getZonaGeografica().replaceAll("[A-Za-z]", ""));
                        zonaCode = obr.getZonaGeografica().replaceAll("[0-9]", "").toUpperCase();
                        coordX = Double.valueOf(obr.getCoordenadaLeste().replaceAll("[A-Za-z]", ""));
                        coordY = Double.valueOf(obr.getCoordenadaNorte().replaceAll("[A-Za-z]", ""));
                        latLng = GeoUtils.utmToLatLng((Double)coordX, (Double)coordY, (Integer)zonaNbr, (String)zonaCode, northern);
                        if (latLng == null) {
                            continue;
                        }
                    }
                    catch (NumberFormatException nmfExc) {
                        latLng = null;
                    }
                    catch (RuntimeException runExc) {
                        latLng = null;
                    }
                }
                if (latLng == null) continue;
                if (obr.getZonaGeograficaFinal() != null && !obr.getZonaGeograficaFinal().isEmpty() && obr.getCoordenadaNorteFinal() != null && obr.getCoordenadaLesteFinal() != null) {
                    try {
                        zonaNbr = Integer.valueOf(obr.getZonaGeograficaFinal().replaceAll("[A-Za-z]", ""));
                        zonaCode = obr.getZonaGeografica().replaceAll("[0-9]", "").toUpperCase();
                        coordX = Double.valueOf(obr.getCoordenadaLesteFinal().replaceAll("[A-Za-z]", ""));
                        coordY = Double.valueOf(obr.getCoordenadaNorteFinal().replaceAll("[A-Za-z]", ""));
                        latLngFim = GeoUtils.utmToLatLng((Double)coordX, (Double)coordY, (Integer)zonaNbr, (String)zonaCode, northern);
                    }
                    catch (NumberFormatException nmfExc) {
                        latLngFim = null;
                    }
                    catch (RuntimeException runExc) {
                        latLng = null;
                    }
                }
                CoordenadaMapaVO itemMapa = new CoordenadaMapaVO(obr.getDescricao(), item, latLng.getLatitude(), latLng.getLongitude(), latLngFim != null ? latLngFim.getLatitude() : null, latLngFim != null ? latLngFim.getLongitude() : null);
                Map infoMap = itemMapa.getInformacao();
                infoMap.put("idObra", obr.getId());
                if (obr.getTipoObra() != null) {
                    infoMap.put("tipo", obr.getTipoObra().getDescricao());
                }
                infoMap.put("datInicial", obr.getDatInicial());
                infoMap.put("datFinal", obr.getDatFinal());
                infoMap.put("status", obr.getStatus());
                coordenadas.add(itemMapa);
                coordenadas.add(itemMapa);
            }
        }
        return coordenadas;
    }

    private String makeKmlAtivos(String empresa, String modulo, String item, HttpServletRequest request) {
        StringBuilder outKml = new StringBuilder();
        outKml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        outKml.append("<kml xmlns=\"http://earth.google.com/kml/2.1\">");
        outKml.append("  <Document>\r\n");
        logger.debug("makeKmlAtivos(emp={}, mld={}, ite={})...", new Object[]{empresa, modulo, item});
        ArrayList<String> empresas = new ArrayList<String>();
        String[] empresasArray = request.getParameterValues("empresas");
        if (empresasArray != null && empresasArray.length > 0) {
            for (String emp : empresasArray) {
                empresas.add(emp);
            }
        } else {
            empresas.add(empresa);
        }
        List coordenadas = this.fillCoordenadas(empresas, modulo, item, request);
        for (CoordenadaMapaVO coordenada : coordenadas) {
            if (coordenada.getLatitude() == null || coordenada.getLongitude() == null) continue;
            outKml.append("    <Placemark>\r\n");
            outKml.append("      <name>").append(coordenada.getDescricao()).append("</name>\r\n");
            outKml.append("      <Point>\r\n");
            outKml.append("        <coordinates>");
            outKml.append(coordenada.getLongitude()).append(",").append(coordenada.getLatitude()).append(",0");
            outKml.append("</coordinates>\r\n");
            outKml.append("      </Point>\r\n");
            outKml.append("    </Placemark>\r\n");
        }
        outKml.append("  </Document>\r\n");
        outKml.append("</kml>\r\n");
        return outKml.toString();
    }

    private String makeKmlDemandas(Integer idEmpresa, HttpServletRequest request) {
        Demanda demanda;
        String param = request.getParameter("idDemanda");
        Integer idDemanda = null;
        if (param != null) {
            idDemanda = Integer.valueOf(param);
        }
        if (idDemanda == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Demanda n\u00e3o informada.");
        }
        param = request.getParameter("versao");
        Integer versao = null;
        if (param != null) {
            versao = Integer.valueOf(param);
        }
        if ((demanda = this.demandaService.getDemandaById(idDemanda, idEmpresa, versao)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Demanda n\u00e3o foi encontrada.");
        }
        Integer faixa = 1;
        if (demanda.getFaixa() == null || demanda.getFaixa().equals("") || !demanda.getFaixa().equals("1") && !demanda.getFaixa().equals("2")) {
            faixa = 1;
        } else {
            if (demanda.getFaixa().equals("FAIXA_1")) {
                faixa = 1;
            } else if (demanda.getFaixa().equals("FAIXA_2")) {
                faixa = 2;
            } else if (demanda.getFaixa().equals("FAIXA_3")) {
                faixa = 3;
            } else if (demanda.getFaixa().equals("FAIXA_4")) {
                faixa = 4;
            }
            if (demanda.getFaixa().equals("FAIXA_5")) {
                faixa = 5;
            } else if (demanda.getFaixa().equals("FAIXA_6")) {
                faixa = 6;
            }
        }
        List segmentos = this.cadastroService.findSegmentosByTrecho(demanda.getIdTrecho(), faixa, demanda.getKmInicial(), demanda.getKmFinal());
        if (segmentos == null || segmentos.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 dados de Georreferenciamento para esta demanda.");
        }
        StringBuilder outKml = new StringBuilder();
        outKml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        outKml.append("<kml xmlns=\"http://earth.google.com/kml/2.1\">");
        outKml.append("  <Document>\r\n");
        outKml.append("    <Style id=\"blueLine\">\r\n");
        outKml.append("      <LineStyle>\r\n");
        outKml.append("        <color>ffff0000</color>\r\n");
        outKml.append("        <width>4</width>\r\n");
        outKml.append("      </LineStyle>\r\n");
        outKml.append("    </Style>\r\n");
        outKml.append("    <Placemark>\r\n");
        outKml.append("      <name>Extensao</name>\r\n");
        outKml.append("      <styleUrl>#blueLine</styleUrl>\r\n");
        outKml.append("      <LineString>\r\n");
        outKml.append("        <altitudeMode>relative</altitudeMode>\r\n");
        outKml.append("        <coordinates>");
        for (TrechoSegmento segmento : segmentos) {
            if (segmento.getNroLatitude() == null || segmento.getNroLongitude() == null) continue;
            outKml.append("\r\n");
            outKml.append(segmento.getNroLongitude()).append(",").append(segmento.getNroLatitude()).append(",0");
        }
        outKml.append("\r\n");
        outKml.append("        </coordinates>\r\n");
        outKml.append("      </LineString>\r\n");
        outKml.append("    </Placemark>\r\n");
        for (TrechoSegmento segmento : segmentos) {
            if (segmento.getNroLatitude() == null || segmento.getNroLongitude() == null) continue;
            outKml.append("    <Placemark>\r\n");
            outKml.append("      <name>").append(segmento.getKmInicial().toString()).append("</name>\r\n");
            outKml.append("      <Point>\r\n");
            outKml.append("        <coordinates>");
            outKml.append(segmento.getNroLongitude()).append(",").append(segmento.getNroLatitude()).append(",0");
            outKml.append("</coordinates>\r\n");
            outKml.append("      </Point>\r\n");
            outKml.append("    </Placemark>\r\n");
        }
        outKml.append("  </Document>\r\n");
        outKml.append("</kml>\r\n");
        return outKml.toString();
    }

    @GetMapping(path={"/{empresa}/kmlData"})
    @Operation(summary="Retorna o KML armazenado, da tabela de Mapas")
    public ResponseEntity<String> fillKmlMap(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List kmlData = this.cadastroService.findKmlData(emp.getId(), null);
            if (kmlData != null && kmlData.size() > 0) {
                return new ResponseEntity((Object)((MapaKmlData)kmlData.get(0)).getKmlData(), (HttpStatusCode)HttpStatus.CREATED);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 dados de KML.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/kmlData"}, consumes={"multipart/form-data"})
    @Operation(summary="Insere o KML na tabela de Mapa")
    public ResponseEntity<String> createKmlMap(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("createKmlMap({},{})", (Object)empresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
            }
            Map formData = request.getParameterMap();
            String nome = null;
            if (formData.containsKey("nome")) {
                nome = ((String[])formData.get("nome"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.coreService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            Map filesMap = multipartReq.getFileMap();
            String tmpDir = System.getProperty("java.io.tmpdir");
            byte[] buffer = new byte[1024];
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName={}", (Object)fileName);
                    ZipInputStream zis = new ZipInputStream(fileReq.getInputStream());
                    ZipEntry zipEntry = zis.getNextEntry();
                    while (zipEntry != null) {
                        int len;
                        File destFile = new File(tmpDir, zipEntry.getName());
                        FileOutputStream fos = new FileOutputStream(destFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        if (zipEntry.getName().toLowerCase().contains("kml")) {
                            List<String> kmlLines = Files.readAllLines(destFile.toPath());
                            StringBuilder kmlContent = new StringBuilder();
                            for (String line : kmlLines) {
                                kmlContent.append(line.trim());
                            }
                            if (nome == null || nome.isEmpty()) {
                                nome = fileName;
                            }
                            MapaKmlData mapaKml = new MapaKmlData();
                            mapaKml.setIdEmpresa(emp.getId());
                            mapaKml.setDescricao(nome);
                            mapaKml.setKmlData(kmlContent.toString());
                            this.cadastroService.saveKmlData(mapaKml, usuario.getLogin());
                        }
                        zipEntry = zis.getNextEntry();
                    }
                    zis.close();
                }
            }
            String response = "ok";
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (IOException ioExc) {
            logger.error("IOExc.createAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public Object extractKmlInfo(InputStream kmlStream) throws IOException, SAXException {
        try {
            logger.debug("bytes to read={}", (Object)kmlStream.available());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(kmlStream);
            document.getDocumentElement().normalize();
            Element root = document.getDocumentElement();
            logger.debug("root.nodeName={}, root.child={}", (Object)root.getNodeName(), (Object)root.getChildNodes());
            return root;
        }
        catch (ParserConfigurationException pcfExc) {
            logger.error("extractKmlInfo", (Throwable)pcfExc);
            throw new BusinessException(pcfExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/kmzData/{modulo}/{item}"})
    @Operation(summary="Baixa o KMZ do Mapa")
    public ResponseEntity<byte[]> retrieveKmlInOldFormat(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @PathVariable(name="item") String item, HttpServletRequest request) {
        String kmlFileContent = this.makeKmlAtivos(empresa, modulo, item, request);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=\"mapaKmz.kmz\"");
        headers.add("Content-Type", "application/vnd.google-earth.kmz");
        byte[] bytes = this.renderAsKmz(kmlFileContent, "mapa.kml");
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] renderAsKmz(String kmlFileContent, String zipEntryName) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipStream = new ZipOutputStream(outStream);
        try {
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            zipStream.putNextEntry(zipEntry);
            zipStream.write(kmlFileContent.getBytes());
        }
        catch (IOException e) {
            logger.error("Error while zipping kml file content : " + e.getMessage());
        }
        finally {
            try {
                zipStream.closeEntry();
                zipStream.close();
            }
            catch (IOException e) {
                logger.error("Error while closing zipped stream : " + e.getMessage());
            }
        }
        return outStream.toByteArray();
    }

    private List<CoordenadaMapaVO> fillCoordenadasDemandas(List<Integer> empresas, Integer idDemanda, Integer versao, String titulo, Integer tipo, Integer area, Integer objetivo, Integer cidade, Integer trecho, Integer status, Integer publica, String dataInicialStr, String dataFinalStr) {
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        if (idDemanda == null) {
            List<Integer> statusList = status != null ? Collections.singletonList(status) : null;
            List<Integer> areasList = area != null ? Collections.singletonList(area) : null;
            List<Integer> tiposList = tipo != null ? Collections.singletonList(tipo) : null;
            List<Integer> objetivosList = objetivo != null ? Collections.singletonList(objetivo) : null;
            List<Integer> cidadesList = cidade != null ? Collections.singletonList(cidade) : null;
            LocalDateTime dataInicial = null;
            LocalDateTime dataFinal = null;
            if (dataInicialStr != null && !dataInicialStr.isEmpty()) {
                try {
                    dataInicial = LocalDateTime.parse(dataInicialStr + " 00:00:00", DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
                }
                catch (DateTimeParseException e) {
                    logger.warn("Erro ao converter data inicial: {}", (Object)dataInicialStr);
                }
            }
            if (dataFinalStr != null && !dataFinalStr.isEmpty()) {
                try {
                    dataFinal = LocalDateTime.parse(dataFinalStr + " 23:59:59", DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
                }
                catch (DateTimeParseException e) {
                    logger.warn("Erro ao converter data final: {}", (Object)dataFinalStr);
                }
            }
            List demandas = this.demandaService.findDemandasWithDate(empresas, titulo, null, dataInicial, dataFinal, null, null, areasList, objetivosList, statusList, tiposList, cidadesList, null, trecho, null, null, publica, Boolean.valueOf(true));
            for (Demanda demanda : demandas) {
                if (demanda.getLatitudeInicial() == null || demanda.getLongitudeInicial() == null) {
                    Rodovia rodovia;
                    if (demanda.getIdRodovia() != null && (rodovia = this.cadastroService.getRodoviaById(demanda.getIdRodovia())) != null && rodovia.getLatitudeInicial() != null && rodovia.getLongitudeInicial() != null) {
                        demanda.setLatitudeInicial(rodovia.getLatitudeInicial());
                        demanda.setLongitudeInicial(rodovia.getLongitudeInicial());
                        demanda.setLatitudeFinal(rodovia.getLatitudeFinal());
                        demanda.setLongitudeFinal(rodovia.getLongitudeFinal());
                    }
                    if (demanda.getLatitudeInicial() == null || demanda.getLongitudeInicial() == null) continue;
                }
                CoordenadaMapaVO map = new CoordenadaMapaVO(demanda.getTitulo(), "DEM", demanda.getLatitudeInicial(), demanda.getLongitudeInicial(), demanda.getLatitudeFinal(), demanda.getLongitudeFinal());
                map.getInformacao().put("idDemanda", demanda.getId().getIdDemanda());
                map.getInformacao().put("idEmpresa", demanda.getId().getIdEmpresa());
                if (demanda.getRodovia() != null) {
                    map.setRodovia(demanda.getRodovia().getDescricao());
                }
                if (demanda.getKmInicial() != null) {
                    map.setKmInicial(Double.valueOf(demanda.getKmInicial().doubleValue()));
                }
                if (demanda.getKmFinal() != null) {
                    map.setKmFinal(Double.valueOf(demanda.getKmFinal().doubleValue()));
                }
                map.setObservacao(demanda.getObservacoes());
                if (demanda.getCidade() != null) {
                    map.getInformacao().put("cidade", demanda.getCidade().getDescricao());
                }
                coordenadas.add(map);
            }
        } else {
            List segmentos;
            Integer faixa;
            Demanda demanda = this.demandaService.getDemandaById(idDemanda, empresas.get(0), versao);
            if (demanda == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Demanda n\u00e3o foi encontrada.");
            }
            if ((demanda.getLatitudeInicial() == null || demanda.getLongitudeInicial() == null) && demanda.getIdTrecho() != null && demanda.getKmInicial() != null && demanda.getKmFinal() != null) {
                block44: {
                    faixa = 1;
                    if (demanda.getFaixa() != null && !demanda.getFaixa().equals("")) {
                        try {
                            faixa = Integer.parseInt(demanda.getFaixa());
                        }
                        catch (NumberFormatException e) {
                            if (demanda.getFaixa().equals("FAIXA_1")) {
                                faixa = 1;
                            }
                            if (demanda.getFaixa().equals("FAIXA_2")) {
                                faixa = 2;
                            }
                            if (demanda.getFaixa().equals("FAIXA_3")) {
                                faixa = 3;
                            }
                            if (demanda.getFaixa().equals("FAIXA_4")) {
                                faixa = 4;
                            }
                            if (demanda.getFaixa().equals("FAIXA_5")) {
                                faixa = 5;
                            }
                            if (!demanda.getFaixa().equals("FAIXA_6")) break block44;
                            faixa = 6;
                        }
                    }
                }
                if ((segmentos = this.cadastroService.findSegmentosByTrecho(demanda.getIdTrecho(), faixa, demanda.getKmInicial(), demanda.getKmFinal())) != null && !segmentos.isEmpty()) {
                    TrechoSegmento primeiroSegmento = (TrechoSegmento)segmentos.get(0);
                    TrechoSegmento ultimoSegmento = (TrechoSegmento)segmentos.get(segmentos.size() - 1);
                    if (primeiroSegmento.getNroLatitude() != null && primeiroSegmento.getNroLongitude() != null) {
                        demanda.setLatitudeInicial(primeiroSegmento.getNroLatitude());
                        demanda.setLongitudeInicial(primeiroSegmento.getNroLongitude());
                    }
                    if (ultimoSegmento.getNroLatitude() != null && ultimoSegmento.getNroLongitude() != null) {
                        demanda.setLatitudeFinal(ultimoSegmento.getNroLatitude());
                        demanda.setLongitudeFinal(ultimoSegmento.getNroLongitude());
                    }
                }
            }
            if (demanda.getLatitudeInicial() != null && demanda.getLongitudeInicial() != null) {
                CoordenadaMapaVO map = new CoordenadaMapaVO(demanda.getTitulo(), "DEM", demanda.getLatitudeInicial(), demanda.getLongitudeInicial(), demanda.getLatitudeFinal(), demanda.getLongitudeFinal());
                map.getInformacao().put("idDemanda", demanda.getId().getIdDemanda());
                map.getInformacao().put("idEmpresa", demanda.getId().getIdEmpresa());
                if (demanda.getRodovia() != null) {
                    map.setRodovia(demanda.getRodovia().getDescricao());
                }
                if (demanda.getKmInicial() != null) {
                    map.setKmInicial(Double.valueOf(demanda.getKmInicial().doubleValue()));
                }
                if (demanda.getKmFinal() != null) {
                    map.setKmFinal(Double.valueOf(demanda.getKmFinal().doubleValue()));
                }
                map.setObservacao(demanda.getObservacoes());
                if (demanda.getCidade() != null) {
                    map.getInformacao().put("cidade", demanda.getCidade().getDescricao());
                }
                coordenadas.add(map);
            } else {
                block45: {
                    faixa = 1;
                    if (demanda.getFaixa() != null && !demanda.getFaixa().equals("")) {
                        try {
                            faixa = Integer.parseInt(demanda.getFaixa());
                        }
                        catch (NumberFormatException e) {
                            if (demanda.getFaixa().equals("FAIXA_1")) {
                                faixa = 1;
                            }
                            if (demanda.getFaixa().equals("FAIXA_2")) {
                                faixa = 2;
                            }
                            if (demanda.getFaixa().equals("FAIXA_3")) {
                                faixa = 3;
                            }
                            if (demanda.getFaixa().equals("FAIXA_4")) {
                                faixa = 4;
                            }
                            if (demanda.getFaixa().equals("FAIXA_5")) {
                                faixa = 5;
                            }
                            if (!demanda.getFaixa().equals("FAIXA_6")) break block45;
                            faixa = 6;
                        }
                    }
                }
                if ((segmentos = this.cadastroService.findSegmentosByTrecho(demanda.getIdTrecho(), faixa, demanda.getKmInicial(), demanda.getKmFinal())) == null || segmentos.isEmpty()) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 dados de Georreferenciamento para esta demanda.");
                }
                for (TrechoSegmento segmento : segmentos) {
                    if (segmento.getNroLatitude() == null || segmento.getNroLongitude() == null) continue;
                    CoordenadaMapaVO map = new CoordenadaMapaVO(segmento.getTrecho().getDescricao(), "SEG", segmento.getNroLatitude(), segmento.getNroLongitude(), segmento.getKmInicial(), segmento.getKmFinal());
                    map.getInformacao().put("idDemanda", demanda.getId().getIdDemanda());
                    coordenadas.add(map);
                }
            }
        }
        return coordenadas;
    }

    private List<CoordenadaMapaVO> fillCoordenadasNotificacoes(List<Integer> empresas, HttpServletRequest request) {
        LocalDate datIniLdt = null;
        LocalDate datFimLdt = null;
        String datInicial = request.getParameter("dataInicial");
        String datFinal = request.getParameter("dataFinal");
        DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
        if (datInicial != null && !datInicial.isEmpty()) {
            try {
                datIniLdt = LocalDate.parse(datInicial, dateFmt);
            }
            catch (DateTimeParseException dteExc) {
                datIniLdt = null;
            }
        }
        if (datFinal != null && !datFinal.isEmpty()) {
            try {
                datFimLdt = LocalDate.parse(datFinal, dateFmt);
            }
            catch (DateTimeParseException dteExc) {
                datFimLdt = null;
            }
        }
        List notificacoes = this.notificacaoService.findNotificacoesRodovias(empresas, datIniLdt, datFimLdt);
        ArrayList<CoordenadaMapaVO> coordenadas = new ArrayList<CoordenadaMapaVO>();
        for (NotificacaoRodovia ntfRdv : notificacoes) {
            Notificacao notif = ntfRdv.getNotificacao();
            CoordenadaMapaVO coord = new CoordenadaMapaVO();
            coord.setData(notif.getDatRecebimento());
            coord.setTitulo(notif.getNroDocumento());
            coord.setDescricao(notif.getDescricao());
            Rodovia rodovia = ntfRdv.getRodovia();
            if (rodovia != null) {
                coord.setRodovia(notif.getDescricao());
            }
            if (ntfRdv.getLatitudeInicial() != null) {
                coord.setLatitude(Double.valueOf(ntfRdv.getLatitudeInicial().doubleValue()));
            }
            if (ntfRdv.getLongitudeInicial() != null) {
                coord.setLongitude(Double.valueOf(ntfRdv.getLongitudeInicial().doubleValue()));
            }
            if (ntfRdv.getKmInicial() != null) {
                coord.setKmInicial(Double.valueOf(ntfRdv.getKmInicial().doubleValue()));
            }
            if (ntfRdv.getKmFinal() != null) {
                coord.setKmFinal(Double.valueOf(ntfRdv.getKmFinal().doubleValue()));
            }
            coord.setObservacao(notif.getObservacao());
            Map info = coord.getInformacao();
            if (notif.getNroProcesso() != null) {
                info.put("nroProcesso", notif.getNroProcesso());
            }
            if (notif.getStatusNotificacao() != null) {
                info.put("fase", notif.getStatusNotificacao().getDescricao());
            }
            if (notif.getClasse() != null) {
                info.put("classe", notif.getClasse().getDescricao());
            }
            if (notif.getSubClasse() != null) {
                info.put("subClasse", notif.getSubClasse().getDescricao());
            }
            coordenadas.add(coord);
        }
        return coordenadas;
    }

    @GetMapping(value={"/localizacaoCoordenadas"})
    @Operation(summary="Usu\u00e1rio informa latitude/longitude, retorna cidade, rodovia, trecho, kmInicial, kmFinal, sentido")
    @ResponseBody
    public ResponseEntity<?> getLocalizacaoCoordenadas(@RequestParam(name="latitude", required=false) BigDecimal latitude, @RequestParam(name="longitude", required=false) BigDecimal longitude) {
        try {
            if (latitude == null || longitude == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Latitude e longitude devem ser informadas para a consulta.");
            }
            Object[] result = this.demandaDAO.getMapWithCoord(latitude, longitude);
            if (result == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Coordenada n\u00e3o encontrada ou n\u00e3o corresponde a nenhum trecho v\u00e1lido no sistema.");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("idRodovia", result[0]);
            map.put("idTrecho", result[1]);
            map.put("idCidade", result[2]);
            map.put("latitude", result[3]);
            map.put("longitude", result[4]);
            map.put("km", result[5]);
            map.put("kmInicial", result[6]);
            map.put("kmFinal", result[7]);
            map.put("sentido", result[8]);
            return ResponseEntity.ok(map);
        }
        catch (Exception e) {
            logger.error("Erro ao buscar localiza\u00e7\u00e3o por coordenadas", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao buscar localiza\u00e7\u00e3o: " + e.getMessage()));
        }
    }
}

