/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.RodoviaCoordenada;
import br.com.oti.gesconsys.beans.geral.RodoviaIndicador;
import br.com.oti.gesconsys.beans.geral.SubtrechoHomogeneo;
import br.com.oti.gesconsys.beans.geral.Trecho;
import br.com.oti.gesconsys.beans.geral.TrechoCidade;
import br.com.oti.gesconsys.beans.geral.TrechoGrupo;
import br.com.oti.gesconsys.beans.geral.TrechoSegmento;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.helper.ImportacaoRodoviaHelper;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;
import org.xml.sax.SAXException;

@RestController
@Tag(description="REST Services para rodovias", name="rodovias")
@RequestMapping(value={"/api/rodovias"})
public class RodoviasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(RodoviasRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private ImportacaoRodoviaHelper importacaoRodoviaHelper;

    @GetMapping(value={"/{empresa}/all"})
    public ResponseEntity<List<Rodovia>> findRodovias(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            Empresa empresaDB;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue() && !(permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS_LISTAGEM")).booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findRodovias(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if ((empresaDB = this.cadastroService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List rodovias = this.cadastroService.findRodovias(searchTxt, empresaDB.getId(), lastUpdate);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
            }
            return ResponseEntity.ok().body((Object)rodovias);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<List<Rodovia>> findRodoviasAll(HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findRodoviasAll()...", (Object)usuario.getLogin());
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            List rodovias = this.cadastroService.findRodovias(searchTxt, null, null);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
            }
            return ResponseEntity.ok().body((Object)rodovias);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodoviasAll", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idRodovia}"})
    public ResponseEntity<Rodovia> getRodoviaById(@PathVariable(name="idRodovia") Integer idRodovia, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando getRodoviaById()...", (Object)usuario.getLogin());
            return ResponseEntity.ok().body((Object)this.cadastroService.getRodoviaById(idRodovia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getRodoviaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    @Operation(summary="Salva a rodovia.")
    public ResponseEntity<Rodovia> saveRodovia(@PathVariable(name="empresa") String empresa, @RequestBody Rodovia rodovia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando saveRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            if (rodovia.getIdEmpresa() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            Rodovia rodoviaDB = new Rodovia();
            rodoviaDB = this.cadastroService.saveRodovia(rodovia, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)rodoviaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRodovia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idRodovia}"})
    public ResponseEntity<Boolean> deleteRodovia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idRodovia") Integer idRodovia, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando deleteRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            return new ResponseEntity((Object)this.cadastroService.deleteRodovia(idRodovia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteRodovia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/trechos/all"})
    @Operation(summary="Lista todos os trechos de rodovia")
    public ResponseEntity<List<Trecho>> findTrechos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findTrechos(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List trechos = this.cadastroService.findTrechos(null, emp.getId());
            if (trechos != null) {
                for (Trecho tre : trechos) {
                    Rodovia rdv = tre.getRodovia();
                    if (rdv != null) {
                        rdv.setId(null);
                        rdv.setDatHorCadastro(null);
                        rdv.setDatHorAlteracao(null);
                        rdv.setIdUsuarioIns(null);
                        rdv.setIdUsuarioUpd(null);
                    }
                    tre.setRodovia(rdv);
                    tre.setDatHorCadastro(null);
                    tre.setIdUsuarioIns(null);
                    tre.setDatHorAlteracao(null);
                    tre.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)trechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTrechos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{rodovia}/trechos"})
    @Operation(summary="Lista os trechos da rodovia informada.")
    public ResponseEntity<List<Trecho>> findTrechosByRodovia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="rodovia") String rodovia) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findTrechosByRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Rodovia rdv = this.cadastroService.getRodoviaByReferencia(empresaDB.getId(), rodovia);
            if (rdv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Rodovia '%s' n\u00e3o encontrada.", rodovia));
            }
            List trechos = this.cadastroService.findTrechos(rdv.getId(), empresaDB.getId());
            if (trechos != null) {
                for (Trecho tre : trechos) {
                    tre.setRodovia(null);
                    tre.setDatHorCadastro(null);
                    tre.setIdUsuarioIns(null);
                    tre.setDatHorAlteracao(null);
                    tre.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)trechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTrechosByRodovia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/trechos/{idTrecho}"})
    public ResponseEntity<Trecho> getTrechoById(@PathVariable(name="idTrecho") Integer idTrecho, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando getTrechoById()...", (Object)usuario.getLogin());
            return ResponseEntity.ok().body((Object)this.cadastroService.getTrechoById(idTrecho));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTrechoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/trechos"})
    @Operation(summary="Salva o trecho.")
    public ResponseEntity<Trecho> saveTrecho(@PathVariable String empresa, @RequestBody Trecho trecho, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando saveTrecho(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            if (trecho.getPista() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Pista n\u00e3o informada.");
            }
            trecho.setRodovia(null);
            Trecho trechoDB = this.cadastroService.saveTrecho(trecho, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)trechoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTrecho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{rodovia}/segmentos"})
    @Operation(summary="Lista os segmentos de rodovia.")
    public ResponseEntity<List<TrechoSegmento>> findSegmentosRodovia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="rodovia") String rodovia) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findSegmentosRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            List segtos = this.cadastroService.findSegmentosByRodovia(rodovia);
            for (TrechoSegmento segto : segtos) {
                Rodovia rdv;
                Trecho tre = segto.getTrecho();
                if (tre != null) {
                    tre.setRodovia(null);
                }
                if ((rdv = segto.getRodovia()) == null) continue;
                rdv.setEmpresa(null);
            }
            return ResponseEntity.ok().body((Object)segtos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{rodovia}/trechos/{idTrecho}/segmentos"})
    @Operation(summary="Lista os segmentos de trecho.")
    public ResponseEntity<List<TrechoSegmento>> findSegmentosTrecho(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="rodovia") String rodovia, @PathVariable(name="idTrecho") Integer idTrecho) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findSegmentosTrecho(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String faixaTxt = null;
            Integer faixa = null;
            BigDecimal kmInicial = null;
            BigDecimal kmFinal = null;
            if (params.containsKey("faixa")) {
                faixaTxt = request.getParameter("faixa");
                if (faixaTxt.equals("FAIXA_1")) {
                    faixa = 1;
                } else if (faixaTxt.equals("FAIXA_2")) {
                    faixa = 2;
                } else if (faixaTxt.equals("FAIXA_3")) {
                    faixa = 3;
                } else if (faixaTxt.equals("FAIXA_4")) {
                    faixa = 4;
                } else if (faixaTxt.equals("FAIXA_5")) {
                    faixa = 5;
                } else if (faixaTxt.equals("FAIXA_6")) {
                    faixa = 6;
                }
            }
            if (params.containsKey("kmInicial")) {
                kmInicial = new BigDecimal(request.getParameter("kmInicial"));
            }
            if (params.containsKey("kmFinal")) {
                kmFinal = new BigDecimal(request.getParameter("kmFinal"));
            }
            List segtos = this.cadastroService.findSegmentosByTrecho(idTrecho, faixa, kmInicial, kmFinal);
            for (TrechoSegmento segto : segtos) {
                Rodovia rdv;
                Trecho tre = segto.getTrecho();
                if (tre != null) {
                    tre.setRodovia(null);
                }
                if ((rdv = segto.getRodovia()) == null) continue;
                rdv.setEmpresa(null);
            }
            return ResponseEntity.ok().body((Object)segtos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{rodovia}/coordenadas"})
    public ResponseEntity<List<RodoviaCoordenada>> findCoordenadasRodovia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="rodovia") String rodovia) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findCoordenadasRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Rodovia rdv = this.cadastroService.getRodoviaByReferencia(empresaDB.getId(), rodovia);
            List segtos = this.cadastroService.findCoordenadas(rdv.getId(), null, null);
            return ResponseEntity.ok().body((Object)segtos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRodovias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/indicadores/refresh"})
    public ResponseEntity<String> refreshIndicadores(@RequestBody List<RodoviaIndicador> indicadores, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando refreshIndicadores()...", (Object)usuario.getLogin());
            List response = this.cadastroService.saveIndicadoresRodovia(indicadores, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)("Indicadores criados/atualizados:" + String.valueOf(response != null ? Integer.valueOf(response.size()) : "0")));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveRodovia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/sths"})
    @Operation(summary="Lista todos os Subtrechos Homog\u00eaneos da rodovia")
    public ResponseEntity<List<SubtrechoHomogeneo>> findSths(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findSths(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List subtrechos = this.cadastroService.findSubtrechos(null, emp.getId());
            if (subtrechos != null) {
                for (SubtrechoHomogeneo sth : subtrechos) {
                    Rodovia rdv = sth.getRodovia();
                    if (rdv != null) {
                        rdv.setId(null);
                        rdv.setDatHorCadastro(null);
                        rdv.setDatHorAlteracao(null);
                        rdv.setIdUsuarioIns(null);
                        rdv.setIdUsuarioUpd(null);
                    }
                    sth.setRodovia(rdv);
                    sth.setDatHorCadastro(null);
                    sth.setIdUsuarioIns(null);
                    sth.setDatHorAlteracao(null);
                    sth.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)subtrechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findSths", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/sths/{idSth}"})
    public ResponseEntity<SubtrechoHomogeneo> getSubtrechoById(@PathVariable(name="idSth") Integer idSth, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando getSubtrechoById()...", (Object)usuario.getLogin());
            return ResponseEntity.ok().body((Object)this.cadastroService.getSubtrechoById(idSth));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getSubtrechoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/sths"})
    @Operation(summary="Salva o subtrecho homog\u00eaneo")
    public ResponseEntity<SubtrechoHomogeneo> saveSubtrecho(@PathVariable(name="empresa") String empresa, @RequestBody SubtrechoHomogeneo sth, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando saveSubtrecho(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            SubtrechoHomogeneo trechoDB = this.cadastroService.saveSubtrecho(sth, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)trechoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveSubtrecho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/sths/{idSth}"})
    public ResponseEntity<Boolean> deleteSubtrecho(@PathVariable(name="empresa") String empresa, @PathVariable(name="idSth") Integer idSth, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando deleteSubtrecho(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            return new ResponseEntity((Object)this.cadastroService.deleteSubtrecho(idSth), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteSubtrecho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idTrecho}/cidades"})
    @Operation(summary="Lista as cidades do trecho informado.")
    public ResponseEntity<List<TrechoCidade>> findCidadesByTrecho(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idTrecho") Integer idTrecho) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findCidadesByTrecho(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List trechos = this.cadastroService.findCidadesByTrecho(idTrecho);
            if (trechos != null) {
                for (TrechoCidade tre : trechos) {
                    tre.setDatHorCadastro(null);
                    tre.setIdUsuarioIns(null);
                    tre.setDatHorAlteracao(null);
                    tre.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)trechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCidadesByTrecho", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{rodovia}/cidadesRodovia"})
    @Operation(summary="Lista as cidades da rodovia informada.")
    public ResponseEntity<List<TrechoCidade>> findCidadesByRodovia(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="rodovia") String rodovia) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findCidadesByRodovia(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Rodovia rdv = this.cadastroService.getRodoviaByReferencia(empresaDB.getId(), rodovia);
            if (rdv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Rodovia '%s' n\u00e3o encontrada.", rodovia));
            }
            List trechos = this.cadastroService.findCidadesByRodovia(rdv.getId());
            if (trechos != null) {
                for (TrechoCidade tre : trechos) {
                    tre.setDatHorCadastro(null);
                    tre.setIdUsuarioIns(null);
                    tre.setDatHorAlteracao(null);
                    tre.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)trechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCidadesByRodovia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/trechos/grupos"})
    @Operation(summary="Lista os grupos do trecho informada.")
    public ResponseEntity<List<TrechoGrupo>> findTrechosGrupos(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando findTrechosGrupos(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List trechos = this.cadastroService.findTrechosGrupos(empresaDB.getId());
            if (trechos != null) {
                for (TrechoGrupo tre : trechos) {
                    tre.setDatHorCadastro(null);
                    tre.setIdUsuarioIns(null);
                    tre.setDatHorAlteracao(null);
                    tre.setIdUsuarioUpd(null);
                }
            }
            return ResponseEntity.ok().body((Object)trechos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTrechosGrupos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/trechos/cidades"})
    @Operation(summary="Salva a cidade.")
    public ResponseEntity<TrechoCidade> saveTrechoCidade(@PathVariable(name="empresa") String empresa, @RequestBody TrechoCidade trecho, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando saveTrechoCidade(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TrechoCidade trechoDB = this.cadastroService.saveTrechoCidade(trecho, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)trechoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTrechoCidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/trechos/grupos"})
    @Operation(summary="Salva a cidade.")
    public ResponseEntity<TrechoGrupo> saveTrechoGrupo(@PathVariable(name="empresa") String empresa, @RequestBody TrechoGrupo trecho, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "RODOVIAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"RODOVIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - Iniciando saveTrechoGrupo(emp={})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TrechoGrupo trechoDB = this.cadastroService.saveTrechoGrupo(trecho, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)trechoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTrechoGrupo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Importa a rodovia em formato KMZ")
    public ResponseEntity<TrechoGrupo> importarCoordenadas(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - importarCoordenadas({})", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa empDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            if (user == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            Map filesMap = multipartReq.getFileMap();
            ArrayList coords = new ArrayList();
            for (String uploadFile : filesMap.keySet()) {
                List filesReq = multipartReq.getFiles(uploadFile);
                for (MultipartFile fileReq : filesReq) {
                    String fileName = fileReq.getOriginalFilename();
                    logger.debug("Upload original.fileName = {}", (Object)fileName);
                    this.importacaoRodoviaHelper.importarKmz(empDB.getId(), user.getId(), fileReq.getInputStream());
                }
            }
            ArrayList<RodoviaCoordenada> destCoords = new ArrayList<RodoviaCoordenada>();
            for (RodoviaCoordenada coord : coords) {
                if (coord.getId().getIdRodovia() == null || coord.getLatitude() == null || coord.getLongitude() == null) continue;
                destCoords.add(coord);
            }
            this.cadastroService.saveCoordenadasRodovias(empDB.getId(), destCoords, user.getId(), Boolean.valueOf(false));
            return null;
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
            return null;
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc", (Throwable)bizExc);
            return null;
        }
        catch (SAXException saxExc) {
            logger.error("BizExc", (Throwable)saxExc);
            return null;
        }
        catch (ParserConfigurationException pcfExc) {
            logger.error("ParserCfgExc", (Throwable)pcfExc);
            return null;
        }
    }
}

