/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Entidade;
import br.com.oti.gesconsys.beans.geral.SetorEntidade;
import br.com.oti.gesconsys.beans.geral.SetorEntidadeResponsavel;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.dto.geral.EntidadeDto;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para entidades", name="entidades")
@RequestMapping(value={"/api/entidades"})
public class EntidadesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(EntidadesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @ResponseBody
    @Operation(summary="Retorna as entidades da empresa informada")
    public ResponseEntity<List<EntidadeDto>> findEntidades(HttpServletRequest request, @PathVariable(value="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - Iniciando findEntidades...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String searchsTxt = null;
            if (request.getParameter("search") != null) {
                searchsTxt = request.getParameter("search");
            }
            Empresa emp = new Empresa();
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            List entidades = this.cadastroService.findEntidadesByEmpresa(emp.getId(), searchsTxt);
            return new ResponseEntity((Object)entidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEntidades", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEntidade}"})
    @Operation(summary="Carrega a entidade pelo seu identificador")
    public ResponseEntity<Entidade> getEntidadeById(@PathVariable(value="empresa") String empresa, @PathVariable(name="idEntidade") Integer idEntidade, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - getEntidadeById({})", (Object)usuario.getLogin(), (Object)idEntidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.getEntidadeById(idEntidade), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEntidadeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a entidade a partir de seu payload")
    public ResponseEntity<Entidade> saveEntidade(@RequestBody Entidade entidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)entidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEntidade(entidade, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idEntidade}"})
    @Operation(summary="Exclui a Entidade a partir de seu ID")
    public ResponseEntity<Boolean> deleteEntidade(@PathVariable(value="empresa") String empresa, @PathVariable(name="idEntidade") Integer idEntidade, @RequestParam(name="idSubstituta", required=false) Integer idSubstituta, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteEntidade({})", (Object)usuario.getLogin(), (Object)idEntidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEntidade(idEntidade, idSubstituta, empresa), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEntidade}/responsaveisSetores"})
    @ResponseBody
    @Operation(summary="Retorna os respons\u00e1veis dos setores na entidade informada, bem como o setor de cada um, ordenando por nome de setor o resultado.")
    public ResponseEntity<List<SetorEntidadeResponsavel>> findSetoresResponsaveisEntidade(HttpServletRequest request, @PathVariable(value="empresa") String empresa, @PathVariable(value="idEntidade") Integer idEntidade) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - Iniciando findSetoresResponsaveis...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Entidade entidade = this.cadastroService.getEntidadeById(idEntidade);
            if (entidade == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Entidade n\u00e3o foi encontrada.");
            }
            ArrayList responsaveis = new ArrayList();
            Map setoresResp = this.cadastroService.findResponsaveisSetor(idEntidade);
            if (setoresResp != null) {
                for (Integer keyRespSetor : setoresResp.keySet()) {
                    List respSetorItems = (List)setoresResp.get(keyRespSetor);
                    for (SetorEntidadeResponsavel respSetor : respSetorItems) {
                        respSetor.setIdUsuarioIns(null);
                        respSetor.setDatHorCadastro(null);
                        respSetor.setIdUsuarioUpd(null);
                        respSetor.setDatHorAlteracao(null);
                        respSetor.setIdEntidade(null);
                        if (respSetor.getSetor() == null) continue;
                        SetorEntidade setor = respSetor.getSetor();
                        setor.setIdEntidade(null);
                        setor.setIdResponsavelPadrao(null);
                        setor.setDatHorCadastro(null);
                        setor.setIdUsuarioIns(null);
                        setor.setDatHorAlteracao(null);
                        setor.setIdUsuarioUpd(null);
                        setor.setEntidade(null);
                    }
                    responsaveis.addAll(respSetorItems);
                }
            }
            return new ResponseEntity(responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findSetoresResponsaveis", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/responsaveisSetores"})
    @Operation(summary="Salva o respons\u00e1vel a partir de seu payload")
    public ResponseEntity<SetorEntidadeResponsavel> saveResponsavelEntidade(@RequestBody SetorEntidadeResponsavel entidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveEntidade({})", (Object)usuario.getLogin(), (Object)entidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            entidade.setSetor(null);
            return new ResponseEntity((Object)this.cadastroService.saveResponsavel(entidade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idSetor}/responsaveisSetores/{sequencia}"})
    @Operation(summary="Exclui o respons\u00e1vel Entidade a partir de seu ID")
    public ResponseEntity<Boolean> deleteResponsavelEntidade(@PathVariable(value="empresa") String empresa, @PathVariable(name="idSetor") Integer idSetor, @RequestParam(name="sequencia", required=false) Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteResponsavelEntidade({})", (Object)usuario.getLogin(), (Object)idSetor);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteResponsavel(idSetor, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteResponsavelEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEntidade}/setores"})
    @ResponseBody
    @Operation(summary="Retorna os setores na entidade informada.")
    public ResponseEntity<List<SetorEntidade>> findSetoresEntidade(HttpServletRequest request, @PathVariable(value="empresa") String empresa, @PathVariable(value="idEntidade") Integer idEntidade) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findSetoresEntidade...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Entidade entidade = this.cadastroService.getEntidadeById(idEntidade);
            if (entidade == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Entidade n\u00e3o foi encontrada.");
            }
            List setores = new ArrayList();
            setores = this.cadastroService.findSetoresByEntidade(entidade.getId());
            return new ResponseEntity(setores, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findSetoresEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/setores"})
    @Operation(summary="Salva o setor a partir de seu payload")
    public ResponseEntity<SetorEntidade> saveSetorEntidade(@RequestBody SetorEntidade entidade, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - saveSetorEntidade({})", (Object)usuario.getLogin(), (Object)entidade);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            entidade.setEntidade(null);
            return new ResponseEntity((Object)this.cadastroService.saveSetor(entidade, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idSetor}/setores"})
    @Operation(summary="Exclui o setor da Entidade a partir de seu ID")
    public ResponseEntity<Boolean> deleteSetorEntidade(@PathVariable(value="empresa") String empresa, @PathVariable(name="idSetor") Integer idSetor, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteSetorEntidade({})", (Object)usuario.getLogin(), (Object)idSetor);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ENTIDADES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ENTIDADES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteSetor(idSetor), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteSetorEntidade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

