/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.core.EmpresaLocal;
import br.com.oti.gesconsys.beans.core.mail.UsuarioEmailEmpresa;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EmpresaArea;
import br.com.oti.gesconsys.beans.geral.EmpresaAreaResponsavel;
import br.com.oti.gesconsys.beans.geral.EmpresaMobileVO;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para empresas", name="empresas")
@RequestMapping(value={"/api/empresas"})
public class EmpresasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(EmpresasRestServices.class);
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private CadastroService cadastroService;

    @GetMapping
    @Operation(summary="Lista as empresas do usu\u00e1rio/token")
    public ResponseEntity<List<Empresa>> findEmpresasUsuario(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("[{}] - findEmpresasUsuario()...", (Object)usuario.getLogin());
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            List empresasUsr = this.segurancaService.findEmpresasByUsuario(usr.getId());
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            if (empresasUsr != null) {
                for (UsuarioEmpresa usrEmp : empresasUsr) {
                    Empresa emp = new Empresa();
                    emp.setId(usrEmp.getId().getIdEmpresa());
                    emp.setTipoEmpresa(usrEmp.getEmpresa().getTipoEmpresa());
                    emp.setSigla(usrEmp.getEmpresa().getSigla());
                    emp.setIdHolding(usrEmp.getEmpresa().getIdHolding());
                    emp.setIdPoderConcedente(usrEmp.getEmpresa().getIdPoderConcedente());
                    emp.setNomeFantasia(usrEmp.getEmpresa().getNomeFantasia());
                    emp.setRazaoSocial(usrEmp.getEmpresa().getRazaoSocial());
                    emp.setEndereco(usrEmp.getEmpresa().getEndereco());
                    emp.setNumeroEndereco(usrEmp.getEmpresa().getNumeroEndereco());
                    empresas.add(emp);
                }
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEmpresasUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/all"})
    @Operation(summary="Lista as empresas do ambiente")
    public ResponseEntity<List<Empresa>> findTodasEmpresas(HttpServletRequest request) {
        logger.debug("Executando findTodasEmpresas...");
        String search = null;
        if (request.getParameter("search") != null) {
            search = request.getParameter("search");
        }
        try {
            List empresasLst = this.cadastroService.findEmpresas(search, null);
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            for (Empresa emp : empresasLst) {
                Empresa empObj = new Empresa();
                empObj.setId(emp.getId());
                empObj.setTipoEmpresa(emp.getTipoEmpresa());
                empObj.setSigla(emp.getSigla());
                empObj.setIdHolding(emp.getIdHolding());
                empObj.setNomeFantasia(emp.getNomeFantasia());
                empObj.setRazaoSocial(emp.getRazaoSocial());
                empObj.setEndereco(emp.getEndereco());
                empObj.setNumeroEndereco(emp.getNumeroEndereco());
                empObj.setDatInicioContrato(emp.getDatInicioContrato());
                empObj.setDatTerminoContrato(emp.getDatTerminoContrato());
                empresas.add(empObj);
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTodasEmpresas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findTodasEmpresas", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/info"})
    @Operation(summary="Informa\u00e7\u00f5es da empresa")
    public ResponseEntity<EmpresaMobileVO> getEmpresaInfo(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("API getEmpresaInfo, emp={}...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            EmpresaMobileVO empresaVO = EmpresaMobileVO.fromEmpresa((Empresa)emp);
            empresaVO.setEstruturas(new ArrayList());
            return new ResponseEntity((Object)empresaVO, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEmpresaInfo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getEmpresaInfo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Informa\u00e7\u00f5es detalhadas da empresa")
    public ResponseEntity<Empresa> getEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        logger.debug("API getEmpresa, emp={}...", (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)emp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/infos/{idEmpresa}"})
    @Operation(summary="Informa\u00e7\u00f5es detalhadas da empresa")
    public ResponseEntity<Empresa> findEmpresaById(HttpServletRequest request, @PathVariable(name="idEmpresa") Integer idEmpresa) {
        logger.debug("API findEmpresaById, emp={}...", (Object)idEmpresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaById(idEmpresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)emp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEmpresaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findEmpresaById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/areas"})
    @Operation(summary="Lista as \u00c1reas da empresa informada")
    public ResponseEntity<List<EmpresaArea>> findAreasEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findAreasEmpresa ({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List areas = this.cadastroService.findAreasByEmpresa(emp.getId(), Boolean.valueOf(false));
            return new ResponseEntity((Object)areas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreasEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findAreasEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/usuarios"})
    @Operation(summary="Lista os Usu\u00e1rios da empresa informada")
    public ResponseEntity<List<UsuarioEmpresa>> findUsuariosEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        try {
            logger.debug("findUsuariosEmpresa ({})", (Object)empresa);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List usuarios = this.segurancaService.findUsuariosByEmpresa(emp.getId(), null, null, null, Boolean.valueOf(false));
            if (usuarios != null) {
                for (UsuarioEmpresa usuario : usuarios) {
                    usuario.setEmpresa(null);
                    usuario.setUsuario(usuario.getUsuario().toPublico());
                    usuario.setIdUsuarioIns(null);
                    usuario.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findUsuariosEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findUsuariosEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/usuariosAreas"})
    @Operation(summary="Lista os Usu\u00e1rios da empresa informada. Pode ser filtrado por \u00e1rea (sigla)")
    public ResponseEntity<List<UsuarioArea>> findUsuariosAreasEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usr = this.getUsuarioByJWT(request);
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            List usuarios;
            logger.debug("{} - findAreasEmpresa({})", (Object)usr.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usr.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usr.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String area = request.getParameter("area");
            ArrayList<String> areasParam = null;
            if (area != null) {
                areasParam = new ArrayList<String>();
                areasParam.add(area);
            }
            if ((usuarios = this.segurancaService.findUsuariosAreaByEmpresa(emp.getId(), null, areasParam, Boolean.valueOf(false))) != null) {
                for (UsuarioArea usuario : usuarios) {
                    usuario.setEmpresa(null);
                    usuario.setUsuario(usuario.getUsuario().toPublico());
                    usuario.setIdUsuarioIns(null);
                    usuario.setDatHorCadastro(null);
                }
            }
            return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findUsuariosEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findUsuariosEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"{empresa}/locais"})
    @Operation(summary="Salva o local da empresa a partir de seu payload")
    public ResponseEntity<EmpresaLocal> saveLocalEmpresa(@PathVariable(name="empresa") String empresa, @RequestBody EmpresaLocal empresaLocal, HttpServletRequest request) throws BusinessException {
        Empresa empresaGet = this.cadastroService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveLocalEmpresa({})", (Object)usuario.getLogin(), (Object)empresaLocal.getSigla());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEmpresaLocal(empresaLocal, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveLocalEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/locais/{idLocal}"})
    @Operation(summary="Busca o local da empresa conforme seu ID.")
    public ResponseEntity<EmpresaLocal> getEmpresaLocalById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLocal") Integer idLocal, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaGet = this.cadastroService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        EmpresaLocal localget = this.cadastroService.getEmpresaLocalById(idLocal);
        if (localget == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Local n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} getEmpresaLocalById({},{})", new Object[]{usuario.getLogin(), empresa, idLocal});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.cadastroService.getEmpresaLocalById(idLocal));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEmpresaLocalById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/locais"})
    @Operation(summary="Lista os locais da empresa informada")
    public ResponseEntity<List<EmpresaLocal>> findLocaisEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            logger.debug("{} - findLocaisEmpresa({})", (Object)usuario.getLogin(), (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List locais = this.cadastroService.findLocaisByEmpresa(emp.getId());
            if (locais != null) {
                for (EmpresaLocal local : locais) {
                    local.setIdUsuarioIns(null);
                    local.setIdUsuarioUpd(null);
                    local.setDatHorCadastro(null);
                    local.setDatHorAlteracao(null);
                }
            }
            return new ResponseEntity((Object)locais, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findLocaisEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findLocaisEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/local/{idLocal}"})
    @Operation(summary="Exclui o local da empresa atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteEmpresaLocal(@PathVariable(name="empresa") String empresa, @PathVariable(name="idLocal") Integer idLocal, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa empresaGet = this.cadastroService.getEmpresaBySigla(empresa);
        if (empresaGet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        EmpresaLocal localget = this.cadastroService.getEmpresaLocalById(idLocal);
        if (localget == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Local n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteEmpresaLocal({},{})", new Object[]{usuario.getLogin(), idLocal, empresa});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEmpresaLocal(idLocal), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEmpresaLocal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a empresa a partir de seu payload")
    public ResponseEntity<Empresa> saveEmpresa(@RequestBody Empresa empresa, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveEmpresa({})", (Object)empresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEmpresa(empresa, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"{empresa}/areas"})
    @Operation(summary="Salva a \u00e1rea da empresa a partir de seu payload")
    public ResponseEntity<EmpresaArea> saveAreaEmpresa(@PathVariable(name="empresa") String empresa, @RequestBody EmpresaArea empresaArea, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveAreaEmpresa({})", (Object)usuario.getLogin(), (Object)empresaArea);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            return new ResponseEntity((Object)this.cadastroService.saveArea(empresaArea, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAreaEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/usuarios"})
    @Operation(summary="Salva o usu\u00e1rio da empresa a partir de seu payload")
    public ResponseEntity<UsuarioEmpresa> saveUsuarioEmpresa(@RequestBody UsuarioEmpresa usuarioEmpresa, HttpServletRequest request) throws BusinessException {
        try {
            logger.debug("saveAreaEmpresa({})", (Object)usuarioEmpresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.segurancaService.saveUsuarioEmpresa(usuarioEmpresa), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuarioEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/usuarios"})
    @Operation(summary="Salva uma lista de usu\u00e1rios \u00e0 empresa a partir de seu payload")
    public ResponseEntity<List<UsuarioEmpresa>> saveUsuariosEmpresa(@PathVariable(name="empresa") String empresa, @RequestBody List<UsuarioEmpresa> usuarioEmpresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        try {
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
            }
            logger.debug("usu\u00e1rio={}, saveUsuariosEmpresa({})", (Object)usuario.getLogin(), (Object)empresa);
            return new ResponseEntity((Object)this.segurancaService.saveUsuariosEmpresa(usuarioEmpresa, usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuariosEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}"})
    @Operation(summary="Exclui a empresa a partir de sua sigla")
    public ResponseEntity<Boolean> deleteEmpresa(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteEmpresa({})", (Object)empresa);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.cadastroService.deleteEmpresa(emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/areas/{idArea}"})
    @Operation(summary="Exclui a area a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAreaEmpresa(@PathVariable(name="empresa") String empresa, @PathVariable(name="idArea") Integer idArea, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteAreaEmpresa({})", (Object)usuario.getLogin(), (Object)idArea);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteArea(idArea), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"{empresa}/usuarios/{idUsuario}"})
    @Operation(summary="Exclui o usuario empresa a partir de seu identificador")
    public ResponseEntity<Boolean> deleteUsuarioEmpresa(@PathVariable(name="empresa") String empresa, @PathVariable(name="idUsuario") Integer idUsuario) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteUsuarioEmpresa({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.deleteEmpresasUsuario(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteUsuarioEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/responsaveisArea/{idArea}"})
    @Operation(summary="Consulta os respons\u00e1veis da \u00e1rea para sele\u00e7\u00e3o em correspond\u00eancia")
    public ResponseEntity<List<EmpresaAreaResponsavel>> findResponsaveisArea(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idArea") Integer idArea) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findResponsaveisArea ({},{})", new Object[]{usuario.getLogin(), empresa, idArea});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
            }
            List responsaveis = this.cadastroService.findResponsaveisByArea(emp.getId(), idArea);
            return new ResponseEntity((Object)responsaveis, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("findResponsaveisArea.findResponsaveisArea", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc.findResponsaveisArea", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/filiais/{idHolding}"})
    @Operation(summary="Lista as empresas filiais da Holding")
    public ResponseEntity<List<Empresa>> findFiliais(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idHolding") Integer idHolding) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("{} - findFiliais...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ArrayList<Empresa> filiais = this.cadastroService.findEmpresasByHolding(idHolding);
            String incluirHolding = request.getParameter("incluirHolding");
            if (incluirHolding != null && Boolean.valueOf(incluirHolding) == Boolean.TRUE) {
                Empresa holding = this.cadastroService.getEmpresaById(idHolding);
                if (filiais == null) {
                    filiais = new ArrayList<Empresa>();
                }
                filiais.add(holding);
            }
            ArrayList<Empresa> empresas = new ArrayList<Empresa>();
            if (filiais != null) {
                for (Empresa usrEmp : filiais) {
                    Empresa newEmp = new Empresa();
                    newEmp.setId(usrEmp.getId());
                    newEmp.setTipoEmpresa(usrEmp.getTipoEmpresa());
                    newEmp.setSigla(usrEmp.getSigla());
                    newEmp.setNomeFantasia(usrEmp.getNomeFantasia());
                    newEmp.setRazaoSocial(usrEmp.getRazaoSocial());
                    empresas.add(newEmp);
                }
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFiliais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/areas/{idArea}"})
    @Operation(summary="Busca \u00e1rea da empresa atrav\u00e9s de seu ID")
    public ResponseEntity<EmpresaArea> getEmpresaAreaById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idArea") Integer idArea, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa %s n\u00e3o encontrada.", empresa));
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EMPRESAS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EMPRESAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            EmpresaArea empresaArea = this.cadastroService.getAreaById(idArea);
            return ResponseEntity.ok().body((Object)empresaArea);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.getEmpresaAreaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"{empresa}/emails"})
    @Operation(summary="Grava e-mails de usuario da empresa")
    public ResponseEntity<UsuarioEmailEmpresa> saveUsuarioEmpresaEmail(@PathVariable(name="empresa") String empresa, @RequestBody UsuarioEmailEmpresa usuarioEmail, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        Empresa empresaGet = this.cadastroService.getEmpresaBySigla(empresa);
        try {
            if (empresaGet == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
            }
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("usuario={}, saveUsuarioEmpresaEmail = (empresa={}, usuarioEmail={}))", new Object[]{usuario.getLogin(), empresa, usuarioEmail.getUsuario()});
            return new ResponseEntity((Object)this.cadastroService.saveUsuarioEmpresaEmail(usuarioEmail), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuarioEmpresaEmail", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/emails/{idUsuario}"})
    @Operation(summary="Lista o e-mail do usuario da empresa de acordo com os identificadores")
    public ResponseEntity<UsuarioEmailEmpresa> getUsuarioEmailEmpresaById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idUsuario") Integer idUsuario) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        UsuarioEmailEmpresa email = this.cadastroService.getUsuarioEmpresaEmailById(emp.getId(), idUsuario);
        try {
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            if (email == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Empresa/E-mail n\u00e3o encontrado.");
            }
            logger.debug("usuario={}, API getUsuarioEmailEmpresaById (idEmpresa={}, idUsuario={})...", new Object[]{usuario.getLogin(), emp.getId(), idUsuario});
            return new ResponseEntity((Object)email, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUsuarioEmailEmpresaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getUsuarioEmailEmpresaById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/emails"})
    @Operation(summary="Lista os e-mails de usu\u00e1rios atrav\u00e9s do identificador da empresa")
    public ResponseEntity<List<UsuarioEmailEmpresa>> findUsuariosEmailByEmpresa(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        try {
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "E-mail n\u00e3o encontrado na Empresa.");
            }
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            logger.debug("usuario={}, API findUsuariosEmailByEmpresa (idEmpresa={})...", (Object)usuario.getLogin(), (Object)empresa);
            List emails = this.cadastroService.findUsuariosEmailByEmpresa(emp.getId(), null);
            return new ResponseEntity((Object)emails, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findUsuariosEmailByEmpresa", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findUsuariosEmailByEmpresa", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/emails/{idUsuario}"})
    @Operation(summary="Deleta o e-mail do usu\u00e1rio da empresa de acordo com seus identificadores.")
    public ResponseEntity<Boolean> deleteEmailUsuario(@PathVariable(name="empresa") String empresa, @PathVariable(name="idUsuario") Integer idUsuario, HttpServletRequest request) throws BusinessException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        PublicUser usuario = this.getUsuarioByJWT(request);
        UsuarioEmailEmpresa emailGet = this.cadastroService.getUsuarioEmpresaEmailById(emp.getId(), idUsuario);
        try {
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrado.");
            }
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            if (emailGet == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa/Usu\u00e1rio n\u00e3o encontrado.");
            }
            logger.debug("usuario={}, deleteEmailUsuario(idEmpresa={}, idUsuario={})", new Object[]{usuario.getLogin(), emp, idUsuario});
            this.cadastroService.deleteEmailUsuario(emp.getId(), idUsuario);
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEmailUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

