/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.seguranca;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.UsuarioPreferencia;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.ModuloAcesso;
import br.com.oti.gesconsys.beans.seguranca.PermissaoAcessoGrupo;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioAuditoria;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresaAreaVO;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.seguranca.UsuarioPerfil;
import br.com.oti.gesconsys.beans.seguranca.UsuarioSave;
import br.com.oti.gesconsys.beans.shared.Fornecedor;
import br.com.oti.gesconsys.beans.sso.UserAzureVO;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.seguranca.RelatorioUsuariosExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.MD5Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para usu\u00e1rios", name="usu\u00e1rios")
@RequestMapping(value={"/api/usuarios"})
public class UsuariosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(UsuariosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/info"})
    @Operation(summary="Informa\u00e7\u00f5es detalhadas do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> getUserInfo(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET UserInfo...");
        try {
            Fornecedor forn;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Usu\u00e1rio n\u00e3o est\u00e1 conectado.");
            }
            Usuario user = this.segurancaService.getUsuarioByLoginOrMail(pbUser.getLogin());
            ArrayList<GrupoAcessoUsuario> grupos = null;
            ArrayList<String> perfis = new ArrayList<String>();
            ArrayList<Empresa> empresas = null;
            UsuarioPerfil perfil = null;
            Boolean usuarioTerceiro = false;
            Boolean usuarioAdminAmb = false;
            if (user != null) {
                pbUser = new PublicUser(user);
                List gruposUsuario = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
                List empresasUsuario = this.segurancaService.findEmpresasByUsuario(user.getId());
                perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
                grupos = new ArrayList<GrupoAcessoUsuario>();
                if (gruposUsuario != null && !gruposUsuario.isEmpty()) {
                    for (UsuarioGrupo grupo : gruposUsuario) {
                        GrupoAcessoUsuario grp = grupo.getGrupoAcesso();
                        grp.setId(null);
                        grp.setDatHorCadastro(null);
                        grp.setIdUsuarioIns(null);
                        grupos.add(grp);
                    }
                }
                empresas = new ArrayList<Empresa>();
                if (empresasUsuario != null && !empresasUsuario.isEmpty()) {
                    block4: for (UsuarioEmpresa empUsr : empresasUsuario) {
                        Integer perfAdmAmb;
                        Integer perfilTerceiro2;
                        Empresa emp = new Empresa();
                        emp.setNomeFantasia(empUsr.getEmpresa().getNomeFantasia());
                        emp.setSigla(empUsr.getEmpresa().getSigla());
                        empresas.add(emp);
                        Integer idEmp = empUsr.getId().getIdEmpresa();
                        if (usuarioTerceiro.booleanValue()) continue;
                        Integer perfilTerceiro1 = (Integer)this.coreService.getRefValueByName(idEmp, TipoRefCode.LABORATORIO_PERFIL_TERCEIRO);
                        if (perfilTerceiro1 != null) {
                            for (UsuarioGrupo grupo : gruposUsuario) {
                                if (!grupo.getId().getIdGrupoUsuario().equals(perfilTerceiro1)) continue;
                                usuarioTerceiro = true;
                                if (perfis.contains(TipoRefCode.LABORATORIO_PERFIL_TERCEIRO.getRefName())) break;
                                perfis.add(TipoRefCode.LABORATORIO_PERFIL_TERCEIRO.getRefName());
                                break;
                            }
                        }
                        if (!usuarioTerceiro.booleanValue() && (perfilTerceiro2 = (Integer)this.coreService.getRefValueByName(idEmp, TipoRefCode.MEIO_AMBIENTE_PERFIL_TERCEIRO)) != null) {
                            for (UsuarioGrupo grupo : gruposUsuario) {
                                if (!grupo.getId().getIdGrupoUsuario().equals(perfilTerceiro2)) continue;
                                usuarioTerceiro = true;
                                if (perfis.contains(TipoRefCode.LABORATORIO_PERFIL_TERCEIRO.getRefName())) break;
                                perfis.add(TipoRefCode.LABORATORIO_PERFIL_TERCEIRO.getRefName());
                                break;
                            }
                        }
                        if (usuarioAdminAmb.booleanValue() || (perfAdmAmb = (Integer)this.coreService.getRefValueByName(idEmp, TipoRefCode.MEIO_AMBIENTE_PERFIL_ADMIN)) == null) continue;
                        for (UsuarioGrupo grupo : gruposUsuario) {
                            if (!grupo.getId().getIdGrupoUsuario().equals(perfAdmAmb)) continue;
                            usuarioAdminAmb = true;
                            if (perfis.contains(TipoRefCode.MEIO_AMBIENTE_PERFIL_ADMIN.getRefName())) continue block4;
                            perfis.add(TipoRefCode.MEIO_AMBIENTE_PERFIL_ADMIN.getRefName());
                            continue block4;
                        }
                    }
                }
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            result.put("nomeUsuario", user.getNome());
            result.put("login", user.getLogin());
            result.put("email", user.getEmail());
            if (perfil.isAdministradorFlag().booleanValue()) {
                result.put("isAdmin", perfil.isAdministradorFlag());
            }
            result.put("isExterno", user.isExterno());
            result.put("terceiro", usuarioTerceiro);
            result.put("ultimoAcesso", user.getDatHorUltimoLogin());
            result.put("refId", user.getId());
            result.put("cargo", user.getCargo());
            result.put("cpfCnpj", perfil.getCpfCnpj());
            result.put("matricula", perfil.getNroMatricula());
            result.put("endereco", perfil.getEndereco());
            result.put("cidade", perfil.getCidade());
            result.put("uf", perfil.getUf());
            result.put("localTrabalho", perfil.getLocalTrabalho());
            result.put("formacao", perfil.getFormacao());
            result.put("utilizacaoRodovia", perfil.getUtilizacaoRodovia());
            result.put("tipoVeiculo", perfil.getTipoVeiculo());
            if (perfil.getIdFornecedor() != null && (forn = this.cadastroService.getFornecedorById(perfil.getIdFornecedor())) != null) {
                result.put("fornecedor", forn.getFantasia());
            }
            Rodovia rodovia = null;
            if (perfil.getIdRodovia() != null && (rodovia = this.cadastroService.getRodoviaById(perfil.getIdRodovia())) != null) {
                rodovia.setEmpresa(null);
                rodovia.setDatHorCadastro(null);
                rodovia.setIdUsuarioIns(null);
                rodovia.setDatHorAlteracao(null);
                rodovia.setIdUsuarioUpd(null);
            }
            List rodovias = null;
            rodovias = this.cadastroService.findRodovias(null, null, null);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
                rdv.setDatHorCadastro(null);
                rdv.setIdUsuarioIns(null);
                rdv.setDatHorAlteracao(null);
                rdv.setIdUsuarioUpd(null);
            }
            result.put("rodovias", rodovias);
            result.put("rodovia", rodovia);
            result.put("grupos", grupos);
            result.put("empresas", empresas);
            result.put("perfis", perfis);
            return new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUserInfo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getUserInfo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/all"})
    @Operation(summary="Retorna todos os usu\u00e1rios cadastrados")
    @ResponseBody
    public ResponseEntity<List<Usuario>> getUsuarios(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET usuarios...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List usuarios = this.segurancaService.findUsuarios(search, Boolean.valueOf(false));
            return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUsuarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getUsuarios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/all"})
    @Operation(summary="Retorna os usu\u00e1rios associados com a empresa, atrav\u00e9s de filtro. Pode ser informado o termo de busca, para buscar por partes do nome do usu\u00e1rio.  Ainda, pode ser informado o nome do perfil de usu\u00e1rio ou perfil interno.")
    @ResponseBody
    public ResponseEntity<List<UsuarioEmpresaAreaVO>> findUsuariosEmpresa(@PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET usuariosByEmpresa...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            String[] perfisReq = request.getParameterValues("perfil");
            ArrayList<String> perfis = null;
            if (perfisReq != null && perfisReq.length > 0) {
                perfis = new ArrayList<String>();
                for (String perfil : perfisReq) {
                    GrupoAcessoUsuario perfilSupAmb;
                    if (perfil.equals("COORDENACAO_OBRAS")) {
                        GrupoAcessoUsuario perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.GERAL_PERFIL_COORDENACAO_OBRAS);
                        perfis.add(perfilCoord.getDescricao());
                        continue;
                    }
                    if (perfil.equals("SUPERVISAO_AMBIENTAL")) {
                        perfilSupAmb = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.MEIO_AMBIENTE_PERFIL_SUPERVISAO_AMBIENTAL);
                        perfis.add(perfilSupAmb.getDescricao());
                        continue;
                    }
                    if (perfil.equals("COORDENACAO_AMBIENTAL")) {
                        perfilSupAmb = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.MEIO_AMBIENTE_PERFIL_COORDENACAO_AMBIENTAL);
                        perfis.add(perfilSupAmb.getDescricao());
                        continue;
                    }
                    perfis.add(perfil);
                }
            }
            ArrayList<Integer> empsId = new ArrayList<Integer>();
            String[] empresasReq = request.getParameterValues("empresas");
            if (empresasReq != null && empresasReq.length > 0) {
                for (String empReq : empresasReq) {
                    empsId.add(Integer.valueOf(empReq.trim()));
                }
            } else {
                empsId.add(emp.getId());
            }
            String tipoUsuario = request.getParameter("tipo");
            String statusUsuario = request.getParameter("status");
            boolean inativosBool = statusUsuario != null && statusUsuario.equals("I");
            String bloqueados = request.getParameter("bloqueado");
            Boolean bloqueadosBool = null;
            if (bloqueados != null) {
                bloqueadosBool = bloqueados.equals("B");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empsId, search, perfis, tipoUsuario, Boolean.valueOf(inativosBool), bloqueadosBool, lastUpdate);
            ArrayList<UsuarioEmpresaAreaVO> usuarios = new ArrayList<UsuarioEmpresaAreaVO>();
            if (usuariosEmp != null) {
                for (UsuarioEmpresa usuEmp : usuariosEmp) {
                    UsuarioEmpresaAreaVO user = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                    if (usuarios.contains(user)) continue;
                    usuarios.add(user);
                }
            }
            return new ResponseEntity(usuarios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUsuarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getUsuarios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/info"})
    @Operation(summary="Grava as informa\u00e7\u00f5es detalhadas do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<PublicUser> postUsersInfo(HttpServletRequest request, @RequestBody UsuarioPerfil perfil) {
        logger.debug("API postUsersInfo...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usuario = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            Integer idUsuario = usuario.getId();
            String ipExterno = "0.0.0.0.0";
            Usuario saved = this.segurancaService.saveUsuarioInfo(perfil.getUsuario(), perfil, idUsuario, ipExterno);
            return new ResponseEntity((Object)new PublicUser(saved), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/usuario"})
    @Operation(summary="Salva o usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<UsuarioSave> saveUsuario(HttpServletRequest request, @RequestBody UsuarioSave save) {
        try {
            String rawSenha;
            UsuarioPerfil perfil;
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o informado.");
            }
            PublicUser usuario = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            logger.debug("API saveUsuario({}) ...", (Object)usr.getLogin());
            UsuarioPerfil perfilUser = this.segurancaService.getExtensaoPerfilByUsuario(usuario.getId());
            boolean adminUsr = false;
            if (perfilUser.getAdministradorBoolean() != null) {
                adminUsr = perfilUser.getAdministradorBoolean();
            }
            if (StringUtils.hasText((String)(perfil = save.getPerfil()).getSenha()) && !(rawSenha = perfil.getSenha()).matches("^[a-fA-F0-9]{32}$") && !rawSenha.matches("^[a-fA-F0-9]{40}$")) {
                perfil.setSenha(MD5Utils.transformToMD5((String)rawSenha));
            }
            if (save.getLogin() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Voc\u00ea n\u00e3o possui permiss\u00e3o para realizar esta a\u00e7\u00e3o.");
            }
            if (!adminUsr && save.getModulo() == null || save.getModulo() != null && !save.getModulo().equals(TipoModulo.MEIO_AMBIENTE.getSigla()) && !save.getLogin().equals(usuario.getLogin())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Voc\u00ea n\u00e3o possui permiss\u00e3o para realizar esta a\u00e7\u00e3o.");
            }
            UsuarioSave userSaved = this.segurancaService.saveUsuario(save.getUsuario(), save.getPerfil(), save.getGrupos(), save.getEmpresas(), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)userSaved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/grupos"})
    @Operation(summary="Lista os grupos de acesso associados com o usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<UsuarioGrupo>> findGruposAcessoByUsuario(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET gruposUsuario...");
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            List result = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
            for (UsuarioGrupo grp : result) {
                grp.setUsuario(null);
                grp.getId().setIdUsuario(null);
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
                GrupoAcessoUsuario gpu = grp.getGrupoAcesso();
                if (gpu == null) continue;
                gpu.setId(null);
                gpu.setDatHorCadastro(null);
                gpu.setIdUsuarioIns(null);
                gpu.setDatHorAlteracao(null);
                gpu.setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/grupos/all"})
    @Operation(summary="Lista todo os grupos de acesso")
    @ResponseBody
    public ResponseEntity<List<GrupoAcessoUsuario>> findGruposAcesso(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET gruposUsuario...");
        try {
            String modulo = request.getParameter("modulo");
            List result = this.segurancaService.findGruposAcessoUsuarios(null, modulo);
            for (GrupoAcessoUsuario grp : result) {
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
                grp.setDatHorAlteracao(null);
                grp.setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/areas"})
    @Operation(summary="Lista as \u00e1reas associadas com o usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<UsuarioArea>> getAreasUsuario(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET areasUsuario...");
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            List result = this.segurancaService.findAreasByUsuario(user.getId(), null);
            for (UsuarioArea area : result) {
                area.setEmpresa(null);
                area.setModulos(null);
                area.setUsuario(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAreasUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getAreasUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/gruposUsuario"})
    @Operation(summary="Grava os grupos do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<UsuarioGrupo>> postGruposUsuario(HttpServletRequest request, @RequestBody List<UsuarioGrupo> grupos) {
        logger.debug("API postGruposUsuario...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (grupos == null || grupos.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Grupos de usu\u00e1rio n\u00e3o encontrados.");
            }
            for (UsuarioGrupo grp : grupos) {
                this.segurancaService.saveGrupoUsuario(grp);
            }
            return new ResponseEntity(grupos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/empresas"})
    @Operation(summary="Lista as empresas associadas com o usu\u00e1rio atual")
    @ResponseBody
    public ResponseEntity<List<UsuarioEmpresa>> getEmpresasUsuario(HttpServletRequest request) {
        logger.debug("Executando UsuarioRestServices GET empresasUsuario...");
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            List result = this.segurancaService.findEmpresasByUsuario(user.getId());
            for (UsuarioEmpresa emp : result) {
                emp.setUsuario(null);
                emp.setDatHorCadastro(null);
                emp.setIdUsuarioIns(null);
                emp.setPerfil(null);
                emp.getEmpresa().setTipoEmpresa(null);
                emp.getEmpresa().setDatHorAlteracao(null);
                emp.getEmpresa().setDatHorCadastro(null);
                emp.getEmpresa().setCidade(null);
                emp.getEmpresa().setContrato(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/empresasUsuario"})
    @Operation(summary="Grava as empresas do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<UsuarioEmpresa>> postEmpresasUsuario(HttpServletRequest request, @RequestBody List<UsuarioEmpresa> empresas) {
        logger.debug("API postEmpresasUsuario...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (empresas == null || empresas.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresas de usu\u00e1rio n\u00e3o encontradas.");
            }
            for (UsuarioEmpresa emp : empresas) {
                this.segurancaService.saveEmpresaUsuario(emp);
            }
            return new ResponseEntity(empresas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idGrupoUsuario}/permissoes"})
    @Operation(summary="Informa\u00e7\u00f5es de permiss\u00f5es do grupo de usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<PermissaoAcessoGrupo>> getPermissoes(HttpServletRequest request, @PathVariable(name="idGrupoUsuario") Integer idGrupoUsuario) {
        logger.debug("Executando UsuarioRestServices GET permissoes...");
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            List result = this.segurancaService.findPermissoesByGrupo(idGrupoUsuario);
            for (PermissaoAcessoGrupo prm : result) {
                prm.setDatHorCadastro(null);
                prm.setIdUsuarioIns(null);
                prm.getGrupoAcessoUsuario().setDatHorAlteracao(null);
                prm.getGrupoAcessoUsuario().setDatHorCadastro(null);
                prm.getGrupoAcessoUsuario().setIdUsuarioIns(null);
                prm.getGrupoAcessoUsuario().setIdUsuarioUpd(null);
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            if (perfil.isAdministradorFlag().booleanValue()) {
                PermissaoAcessoGrupo permSeg = new PermissaoAcessoGrupo(idGrupoUsuario, Integer.valueOf(9999));
                permSeg.setModulo(new ModuloAcesso(Integer.valueOf(9999), "M\u00f3dulo seguran\u00e7a", "Acesso Seguran\u00e7a", TipoModulo.SEGURANCA.getSigla(), null, null));
                result.add(permSeg);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPermissoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getPermissoes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/permissoes"})
    @Operation(summary="Lista as permiss\u00f5es associadas com o usu\u00e1rio atual")
    @ResponseBody
    public ResponseEntity<List<ModuloAcesso>> findPermissoesByUsuario(HttpServletRequest request) {
        logger.debug("GET permissoesByUsuario...");
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            Set permissoesUser = this.segurancaService.findPermissoesByUsuario(user.getId());
            ArrayList<ModuloAcesso> permissoes = new ArrayList<ModuloAcesso>();
            for (ModuloAcesso permUsr : permissoesUser) {
                permUsr.setId(null);
                permUsr.setIdModuloPai(null);
                if (permUsr.getModuloPai() != null) {
                    permUsr.getModuloPai().setId(null);
                }
                permissoes.add(permUsr);
            }
            return new ResponseEntity(permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPermissoesByUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.findPermissoesByUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/permissoes/all"})
    @Operation(summary="Lista as permiss\u00f5es de acesso da empresa")
    @ResponseBody
    public ResponseEntity<List<ModuloAcesso>> findPermissoesAcesso(HttpServletRequest request) {
        try {
            PublicUser pbUser = this.getUsuarioByJWT(request);
            if (pbUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            logger.debug("GET findPermissoesAcesso({})...", (Object)pbUser.getLogin());
            List permissoes = this.segurancaService.findModulos();
            return new ResponseEntity((Object)permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPermissoesAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.findPermissoesAcesso", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/permissoesAcesso/{idGrupoUsuario}/{modulo}"})
    @Operation(summary="Grava as permiss\u00f5es do grupo de usu\u00e1rio e m\u00f3dulo")
    @ResponseBody
    public ResponseEntity<List<PermissaoAcessoGrupo>> postPermissoesAcesso(@PathVariable(name="idGrupoUsuario") Integer idGrupoUsuario, @PathVariable(name="modulo") String modulo, HttpServletRequest request, @RequestBody List<PermissaoAcessoGrupo> permissoes) {
        logger.debug("API postPermissoesAcesso...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (permissoes == null || permissoes.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Permiss\u00f5es de usu\u00e1rio n\u00e3o encontradas.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            this.segurancaService.savePermissoes(idGrupoUsuario, permissoes, modulo, user.getId());
            return new ResponseEntity(permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/auditorias"})
    @Operation(summary="Informa\u00e7\u00f5es de auditoria de usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<List<UsuarioAuditoria>> findAuditoria(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="dataInicial", required=false) Date dataInicial, @RequestParam(name="dataFinal", required=false) Date dataFinal, @RequestParam(name="tipo", required=false) Integer tipo) {
        logger.debug("Executando UsuarioRestServices GET getAuditoria...");
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            List result = this.segurancaService.findAuditoria(emp.getId(), null, dataInicial, dataFinal, null, null, null, tipo);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAuditoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exc.getAuditoria", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/auditoria"})
    @Operation(summary="Grava a auditoria do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<UsuarioAuditoria> postAuditoria(HttpServletRequest request, @RequestBody UsuarioAuditoria auditoria) {
        logger.debug("API postAuditoria...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            if (auditoria == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Auditoria de usu\u00e1rio n\u00e3o encontrada.");
            }
            this.segurancaService.registraAuditoria(auditoria.getIdEmpresa(), auditoria.getDescricao(), auditoria.getIdUsuario(), auditoria.getTipo(), auditoria.getIpAcesso());
            return new ResponseEntity((Object)auditoria, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/areas"})
    @Operation(summary="Grava a \u00e1rea do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<UsuarioArea> postAreaUsuario(HttpServletRequest request, @RequestBody UsuarioArea area) {
        logger.debug("API postAreasUsuario...");
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usu = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            if (area == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c1rea n\u00e3o encontrada.");
            }
            this.segurancaService.saveArea(area, usu.getId());
            return new ResponseEntity((Object)area, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAreaUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idUsuario}/deleteUsuario"})
    @Operation(summary="Exclui usu\u00e1rio a partir do identificador do usu\u00e1rio")
    public ResponseEntity<Boolean> deleteUsuario(@PathVariable(name="idUsuario") Integer idUsuario) throws BusinessException {
        try {
            logger.debug("deleteUsuario({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.deleteUsuario(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idUsuario}/deleteAreas"})
    @Operation(summary="Exclui areas a partir do identificador do usu\u00e1rio")
    public ResponseEntity<Boolean> deleteAreas(@PathVariable(name="idUsuario") Integer idUsuario) throws BusinessException {
        try {
            logger.debug("deleteArea({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.deleteAreasUsuario(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteArea", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idUsuario}/deleteEmpresas"})
    @Operation(summary="Exclui empresas a partir do identificador do usu\u00e1rio")
    public ResponseEntity<Boolean> deleteEmpresas(@PathVariable(name="idUsuario") Integer idUsuario) throws BusinessException {
        try {
            logger.debug("deleteEmpresas({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.deleteEmpresasUsuario(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEmpresas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idUsuario}/deleteGrupos"})
    @Operation(summary="Exclui grupos a partir do identificador do usu\u00e1rio")
    public ResponseEntity<Boolean> deleteGrupos(@PathVariable(name="idUsuario") Integer idUsuario) throws BusinessException {
        try {
            logger.debug("deleteGrupos({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.deleteGruposUsuario(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idUsuario}/usuario"})
    @Operation(summary="Carrega o usu\u00e1rio pelo seu identificador")
    public ResponseEntity<Usuario> getUsuarioById(@PathVariable(name="idUsuario") Integer usuario) {
        try {
            logger.debug("getUsuarioById({})", (Object)usuario);
            return new ResponseEntity((Object)this.segurancaService.getUsuarioById(usuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUsuarioById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idUsuario}/usuario/saved"})
    @Operation(summary="Carrega o usu\u00e1rio pelo seu identificador, retornando em uma \u00fanica chamada, seus grupos, empresas e perfil")
    public ResponseEntity<UsuarioSave> getUsuarioSavedById(@PathVariable(name="idUsuario") Integer idUsuario) {
        try {
            logger.debug("getUsuarioSavedById({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.getUsuarioSavedById(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getUsuarioSavedById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{usuario}/alterarSenha"})
    @Operation(summary="Executa a altera\u00e7\u00e3o da senha do usu\u00e1rio")
    @ResponseBody
    public ResponseEntity<UsuarioSave> alteraSenha(HttpServletRequest request, @RequestBody UsuarioSave save) {
        try {
            String rawSenha;
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o informado.");
            }
            PublicUser usuario = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            logger.debug("API saveUsuario({}) ...", (Object)usr.getLogin());
            UsuarioPerfil perfil = save.getPerfil();
            if (StringUtils.hasText((String)perfil.getSenha()) && !(rawSenha = perfil.getSenha()).matches("^[a-fA-F0-9]{32}$") && !rawSenha.matches("^[a-fA-F0-9]{40}$")) {
                perfil.setSenha(MD5Utils.transformToMD5((String)rawSenha));
            }
            UsuarioSave userSaved = this.segurancaService.saveUsuario(save.getUsuario(), save.getPerfil(), save.getGrupos(), save.getEmpresas(), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)userSaved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/preferencias/{nomePreferencia}"})
    @ResponseBody
    public ResponseEntity<List<UsuarioPreferencia>> findPreferenciasUsuario(HttpServletRequest request, @PathVariable(name="nomePreferencia") String nomePreferencia) {
        try {
            PublicUser usr = this.getUsuarioByJWT(request);
            if (usr == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o informado.");
            }
            PublicUser usuario = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            logger.debug("API findPreferenciasUsuario({}) ...", (Object)usr.getLogin());
            List userPrefs = this.coreService.findPreferenciasByTipo(usuario.getId(), "CONSULTA_CORRESPONDENCIA_PADRAO_ANDAMENTO", null);
            return new ResponseEntity((Object)userPrefs, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPreferenciasUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores/{idUsuario}"})
    @Operation(summary="Exibe o fornecedor de acordo com o usu\u00e1rio.")
    @ResponseBody
    public ResponseEntity<Fornecedor> getFornecedorByUsuario(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idUsuario") Integer idUsuario) {
        logger.debug("Executando getFornecedorByUsuario");
        try {
            logger.debug("getFornecedorByUsuario({}, {})", (Object)empresa, (Object)idUsuario);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Fornecedor usuario = this.segurancaService.getFornecedorByUsuario(idUsuario);
            return new ResponseEntity((Object)usuario, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFornecedorByUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getFornecedorByUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download do relat\u00f3rio em Excel")
    public ResponseEntity<StreamingResponseBody> exportaUsuariosExcel(@PathVariable(name="empresa") String empresa, @RequestBody UsuarioEmpresaAreaVO usuario, HttpServletRequest request) {
        logger.debug("Exportando excel, usuarios (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (usuario == null) {
            usuario = new UsuarioEmpresaAreaVO();
        }
        ArrayList<Integer> selectedEmp = new ArrayList<Integer>();
        selectedEmp.add(emp.getId());
        String search = null;
        String param = request.getParameter("search");
        if (param != null && !param.isEmpty()) {
            search = param;
        }
        String[] perfisReq = request.getParameterValues("perfil");
        ArrayList<String> perfis = null;
        if (perfisReq != null && perfisReq.length > 0) {
            perfis = new ArrayList<String>();
            for (String perfil : perfisReq) {
                GrupoAcessoUsuario perfilSupAmb;
                if (perfil.equals("COORDENACAO_OBRAS")) {
                    GrupoAcessoUsuario perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.GERAL_PERFIL_COORDENACAO_OBRAS);
                    perfis.add(perfilCoord.getDescricao());
                    continue;
                }
                if (perfil.equals("SUPERVISAO_AMBIENTAL")) {
                    perfilSupAmb = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.MEIO_AMBIENTE_PERFIL_SUPERVISAO_AMBIENTAL);
                    perfis.add(perfilSupAmb.getDescricao());
                    continue;
                }
                if (perfil.equals("COORDENACAO_AMBIENTAL")) {
                    perfilSupAmb = this.segurancaService.getGrupoUsuarioByRefCode(emp.getId(), TipoRefCode.MEIO_AMBIENTE_PERFIL_COORDENACAO_AMBIENTAL);
                    perfis.add(perfilSupAmb.getDescricao());
                    continue;
                }
                perfis.add(perfil);
            }
        }
        String tipoUsuario = request.getParameter("tipo");
        String statusUsuario = request.getParameter("status");
        boolean inativosBool = statusUsuario != null && statusUsuario.equals("I");
        String bloqueados = request.getParameter("bloqueados");
        Boolean bloqueadosBool = null;
        if (bloqueados != null) {
            bloqueadosBool = bloqueados.equals("B");
        }
        LocalDateTime lastUpdate = null;
        if (request.getParameter("lastUpdate") != null) {
            DateTimeFormatter dateFmt;
            try {
                lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
            }
            catch (DateTimeParseException dteExc) {
                lastUpdate = null;
            }
            if (lastUpdate == null) {
                try {
                    dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
            }
            if (lastUpdate == null) {
                try {
                    dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
            }
            logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
        }
        try {
            List user = this.segurancaService.findUsuariosByEmpresasAndGrupos(emps, search, perfis, tipoUsuario, Boolean.valueOf(inativosBool), bloqueadosBool, lastUpdate);
            StreamingResponseBody responseBody = response -> response.write(new RelatorioUsuariosExcel().executeXLS(user));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"Relat\u00f3rio de Usu\u00e1rios.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/informacoesSSO"})
    @Operation(summary="Atualiza os usu\u00e1rios enviados na lista conforme dados encaminhados")
    @ResponseBody
    public ResponseEntity<List<PublicUser>> updateInformacoesSSO(HttpServletRequest request, @RequestBody List<UserAzureVO> usuarios) {
        logger.debug("Executando updateInformacoesSSO");
        try {
            List processados = this.segurancaService.updateInformacoesSso(usuarios);
            return new ResponseEntity((Object)processados, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateInformacoesSSO", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.updateInformacoesSSO", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

